var lpbSC = 0;

var LINE_TO_RENDER_FIRST = 10;

var LINE_TO_RENDER_LAST = LINE_TO_RENDER_FIRST + 255;

var CANVAS_BYTES_PER_LINE = 4 * 672;
var CANVAS_INITIAL_NEG_ADDR = - FIRST_VISIBLE_LINE * CANVAS_BYTES_PER_LINE;
var CANVAS_LAST_ADDR = 2 * CANVAS_BYTES_PER_LINE - 1;

var doNotRender = 0; // if it's 1, LPBs etc are parsed but not rendered onto the screen! [can be used eg for frame skipping on slow machines/browsers]


function nickReset() {
	debug("NICK: resetting");
	vint = false;
	doNotRender = 0;
	port[0x80] = 0;
	port[0x81] = 0;
	port[0x82] = 0;
	port[0x83] = 0;
	pixelAddr = CANVAS_INITIAL_NEG_ADDR;
	nickReloadLPT();
}

function nickInit() {
	debug("NICK: initializing");
	/* generate Enterprise-128 palette in RGB color space */
	/* these tables are used to make LPIXEL mode 8 pixel byte into two 8 bit ones */
	lpixelDoubler1 = [];
	lpixelDoubler2 = [];
	palR = [];
	palG = [];
	palB = [];
	for (var i=0;i<256;i++) {
		lpixelDoubler1[i] =  (i & 128)       | ((i & 128) >> 1) | ((i & 64) >> 1) | ((i & 64) >> 2) | ((i & 32) >> 2) | ((i & 32) >> 3) | ((i & 16) >> 3) | ((i & 16) >> 4);
		lpixelDoubler2[i] = ((i &   8) << 4) | ((i &   8) << 3) | ((i &  4) << 3) | ((i &  4) << 2) | ((i &  2) << 2) | ((i &  2) << 1) | ((i &  1) << 1) |  (i &  1);
		palR[i] = Math.round((((i << 2) & 4) | ((i >> 2) & 2) | ((i >> 6) & 1)) * 255 / 7);
		palG[i] = Math.round((((i << 1) & 4) | ((i >> 3) & 2) | ((i >> 7) & 1)) * 255 / 7);
		palB[i] = Math.round((                 ((i >> 1) & 2) | ((i >> 5) & 1)) * 255 / 3);
	}
	doNotRender = 0;
	nickReset();
}


function renderSolidColorScanLine(c) {
	if (line < 0 || line > CANVAS_LAST_ADDR || doNotRender) return;
	var i, r = palR[c], g = palG[c], b = palB[c];
	var addr = (line - LINE_TO_RENDER_FIRST) + 8 * 672, end = addr + 4 * 672;
	for (i=0;i<672;i++) {
		imageDataData[pixelAddr] = r;
		imageDataData[CANVAS_BYTES_PER_LINE + pixelAddr++] = r;
		imageDataData[pixelAddr] = g;
		imageDataData[CANVAS_BYTES_PER_LINE + pixelAddr++] = g;
		imageDataData[pixelAddr] = b;
		imageDataData[CANVAS_BYTES_PER_LINE + pixelAddr++] = b;
		pixelAddr++;
	}
	pixelAddr += 2 * CANVAS_BYTES_PER_LINE;
}


function nickLoadLD1() {
	lpbLD1 = memory[lpt + 4] | (memory[lpt + 5] << 8);
}
function nickLoadLD2() {
	lpbLD2 = memory[lpt + 6] | (memory[lpt + 7] << 8);
	switch (lpbVM) {
		case 3: lpbLD2 <<= 8; break;
		case 4: lpbLD2 <<= 9; break;
		case 5: lpbLD2 <<= 10; break;
	}
}


function nickReloadLPB() {
	libSC = 0;
	if (lpbWasLast) {
		lpbWasLast = 0;
		lpt = ((port[0x83] & 0xF) << 12) | (port[0x82] << 4) | NICK_RAM_OFS;
	} else {
		lpt = ((lpt == 0x3FFFF0) ? NICK_RAM_OFS : lpt + 0x10);
	}
}

function nickReloadLPT() {
	lpbWasLast = 1;
	nickReloadLPB();
}


function nickByte(o) {
	return memory[(o & 0xFFFF) | NICK_RAM_OFS];
}





function renderScanLine() {
	if (256 - memory[lpt] == lpbSC) {
		nickReloadLPB();
		lpbSC = 0;
		if (lpbWasLast) {
			lpbWasLast = 0;
			lpt = ((port[0x83] & 0xF) << 12) | (port[0x82] << 4) | NICK_RAM_OFS;
		} else {
			lpt = ((lpt == 0x3FFFF0) ? NICK_RAM_OFS : lpt + 0x10);
		}
		lpt = (lpt_base + 16) & 0xFFFF | NICK_RAM_OFS;
		lpbVM = (memory[lpt] >> 1) & 7;
		lpbCM = (memory[lpt] >> 5) & 3;
		nickLoadLD1(); // call these funcs only with lpbVM initialized before!
		nickLoadLD2();
		if (memory[lpt] & 128) {
			if (!vint)
				z80_interrupt(); // TODO: it must be done via Dave!
			vint = true;
		} else
			vint = false;
		lpbWasLast = memory[lpt] & 1;
	}
	/* vsync mode causes to reset raster line counter */
	if (!lpbVM) {
		line = 0;
		lpbSC++;
		return;
	}
	/* frameskip setting handler */
	if (isSkippedFrame) {
		return; // in skipped frame mode
	}
	/* invalid video mode, render black colour .... */
	if (lpbVM == 6) {
		renderSolidColorScanLine(0);
		line++;
		lpbSC++;
		return;
	}
	/* check margins */
	var marg1 = memory[lpt + 2];
	var marg2 = memory[lpt + 3];
	var x, data1, data2;
	if (marg2 < marg1) {
		renderSolidColorScanLine(port[0x81]);
		line++;
		libSC++;
		return;
	}
	/* hmm, seems to be OK, begin the loop */
	for (x = 8; x < 54; x++) {
		switch (lpbVM) {
			case 1: /* PIXEL mode */
				break;
			case 2: /* ATTRIBUTE mode */
				break;
			case 3: /* these are CHARACTER modes */
			case 4:
			case 5:
				data1 = nickByte(lpbLD1++);
				if (x < 10 || x > 42) {
					addr += 8;
					continue; // outside of the display area. Use continue here, we don't wanna increment render address!
				}
			case 7: /* LPIXEL mode */
				break;
		}
		addr += 8;
	}
	switch (lpbVM) {
		case 3: lpbLD2 += 256; break;
		case 4: lpbLD2 += 128; break;
		case 5: lpbLD2 +=  64; break;
	}
}
