#include	"main.h"


void	FillInDriverDetails (int Game)
{
	switch (Game)
		{
		case	GAME_GALAGA:

			Driver.Proc[0].Type=CPU_Z80;
			Driver.Proc[0].Speed=3125000;
			Driver.Proc[0].RomStart1=0x0000;
			Driver.Proc[0].RomEnd1=0x4000;
			Driver.Proc[0].IntSplit=1;

			Driver.Proc[1].Type=CPU_Z80;
			Driver.Proc[1].Speed=3125000;
			Driver.Proc[1].RomStart1=0x0000;
			Driver.Proc[1].RomEnd1=0x2000;
			Driver.Proc[1].IntSplit=1;

			Driver.Proc[2].Type=CPU_Z80;
			Driver.Proc[2].Speed=3125000;
			Driver.Proc[2].RomStart1=0x0000;
			Driver.Proc[2].RomEnd1=0x2000;
			Driver.Proc[2].IntSplit=2;

			Driver.SpecialMode=MODE_224;
			Driver.TextColour=2;
			Driver.FrameRate=60;
			Driver.DataCols=32;
			Driver.StarCols=64;
			Driver.LeftEdge=0;
			Driver.RightEdge=223;
			Driver.TopEdge=0;
			Driver.BottomEdge=287;
			Driver.ScreenBase=0x8000;
			Driver.TotalChars=256;
			Driver.TotalSprites=256;
			Driver.TotalPalettes=1;
			Driver.Palette=GalagaPalette;

			Driver.fn_InitSound=InitSoundRallyX;
			Driver.fn_Translate=GalagaTranslateROM;
			Driver.fn_SetPalette=GalagaSetPalette;
			Driver.fn_Interrupt=GalagaInterrupt;
			Driver.fn_ScreenUpdate=GalagaScreenUpdate;
			Driver.fn_WriteRam=GalagaWriteRam;
			Driver.fn_ReadRam=GalagaReadRam;
			Driver.fn_UpdateSound=PengoUpdateSound;

		break;



		case	GAME_GNG:

			Driver.Proc[0].Type=CPU_6809;
			Driver.Proc[0].Speed=1500000;
			Driver.Proc[0].RomStart1=0x4000;
			Driver.Proc[0].RomEnd1=0x10000;
			Driver.Proc[0].IntSplit=1;

			Driver.Proc[1].Type=CPU_Z80S;
			Driver.Proc[1].Speed=3072000;
			Driver.Proc[1].RomStart1=0x0000;
			Driver.Proc[1].RomEnd1=0x8000;
			Driver.Proc[1].IntSplit=4;

			Driver.TextColour=248;
			Driver.FrameRate=60;
			Driver.DataCols=256;
			Driver.LeftEdge=0;
			Driver.RightEdge=255;
			Driver.TopEdge=16;
			Driver.BottomEdge=255-16;
			Driver.ScreenBase=0x2000;
			Driver.TotalChars=1024;
			Driver.TotalTiles=1024;
			Driver.TotalSprites=1024;
			Driver.TotalPalettes=16;
			Driver.Palette=GNGPalette;

			Driver.fn_InitSound=InitSoundGnG;
			Driver.fn_Translate=GNGTranslateROM;
			Driver.fn_SetPalette=GNGSetPalette;
			Driver.fn_Interrupt=GNGInterrupt;
			Driver.fn_ScreenUpdate=GNGScreenUpdate;
			Driver.fn_WriteRam=GNGWriteRam;
			Driver.fn_ReadRam=GNGReadRam;
			Driver.fn_UpdateSound=YM2203_Update;

		break;


		case	GAME_EXED:

			Driver.Proc[0].Type=CPU_Z80;
			Driver.Proc[0].Speed=3000000;
			Driver.Proc[0].RomStart1=0x0000;
			Driver.Proc[0].RomEnd1=0xc000;
			Driver.Proc[0].IntSplit=1;

			Driver.Proc[1].Type=CPU_Z80S;
			Driver.Proc[1].Speed=2000000;
			Driver.Proc[1].RomStart1=0x0000;
			Driver.Proc[1].RomEnd1=0x4000;
			Driver.Proc[1].IntSplit=4;

			Driver.TextColour=2;
			Driver.FrameRate=60;
			Driver.DataCols=256;
			Driver.LeftEdge=0+16;
			Driver.RightEdge=255-16;
			Driver.TopEdge=0;
			Driver.BottomEdge=255;
			Driver.ScreenBase=0xd000;
			Driver.TotalChars=512;
			Driver.TotalTiles=1024;
			Driver.TotalSprites=1024;
			Driver.TotalPalettes=1;
			Driver.Palette=CrestaPalette;

			Driver.fn_InitSound=InitSound1942;
			Driver.fn_Translate=ExedTranslateROM;
			Driver.fn_SetPalette=CrestaSetPalette;
			Driver.fn_Interrupt=CommandoInterrupt;
			Driver.fn_ScreenUpdate=ExedScreenUpdate;
			Driver.fn_WriteRam=CommandoWriteRam;
			Driver.fn_ReadRam=ExedReadRam;
			Driver.fn_UpdateSound=AY8910_Update;

		break;

		case	GAME_COMMANDO:

			Driver.Proc[0].Type=CPU_Z80;
			Driver.Proc[0].Speed=3000000;
			Driver.Proc[0].RomStart1=0x0000;
			Driver.Proc[0].RomEnd1=0xc000;
			Driver.Proc[0].IntSplit=1;

			Driver.Proc[1].Type=CPU_Z80S;
			Driver.Proc[1].Speed=2000000;
			Driver.Proc[1].RomStart1=0x0000;
			Driver.Proc[1].RomEnd1=0x4000;
			Driver.Proc[1].IntSplit=4;

			Driver.TextColour=248;
			Driver.FrameRate=60;
			Driver.DataCols=256;
			Driver.LeftEdge=0+16;
			Driver.RightEdge=255-16;
			Driver.TopEdge=0;
			Driver.BottomEdge=255;
			Driver.ScreenBase=0xd000;
			Driver.TotalChars=1024;
			Driver.TotalTiles=1024;
			Driver.TotalSprites=1024;
			Driver.TotalPalettes=16;
			Driver.Palette=CommandoPalette;

			Driver.fn_InitSound=InitSound1942;
			Driver.fn_Translate=CommandoTranslateROM;
			Driver.fn_SetPalette=CommandoSetPalette;
			Driver.fn_Interrupt=CommandoInterrupt;
			Driver.fn_ScreenUpdate=CommandoScreenUpdate;
			Driver.fn_WriteRam=CommandoWriteRam;
			Driver.fn_ReadRam=CommandoReadRam;
			Driver.fn_UpdateSound=AY8910_Update;

		break;




		case	GAME_1942:

			Driver.Proc[0].Type=CPU_Z80;
			Driver.Proc[0].Speed=4000000;
			Driver.Proc[0].RomStart1=0x0000;
			Driver.Proc[0].RomEnd1=0xc000;
			Driver.Proc[0].IntSplit=2;

			Driver.Proc[1].Type=CPU_Z80S;
			Driver.Proc[1].Speed=3000000;
			Driver.Proc[1].RomStart1=0x0000;
			Driver.Proc[1].RomEnd1=0x4000;
			Driver.Proc[1].IntSplit=4;

			Driver.TextColour=1;
			Driver.FrameRate=60;
			Driver.DataCols=64;
			Driver.LeftEdge=0+16;
			Driver.RightEdge=255-16;
			Driver.TopEdge=0;
			Driver.BottomEdge=255;
			Driver.ScreenBase=0xd000;
			Driver.TotalChars=512;
			Driver.TotalTiles=512;
			Driver.TotalSprites=512;
			Driver.TotalPalettes=32;

			Driver.fn_InitSound=InitSound1942;
			Driver.fn_Translate=TranslateROM1942;
			Driver.fn_SetPalette=SetPalette1942;
			Driver.fn_Interrupt=Interrupt1942;
			Driver.fn_ScreenUpdate=ScreenUpdate1942;
			Driver.fn_WriteRam=WriteRam1942;
			Driver.fn_ReadRam=ReadRam1942;
			Driver.fn_UpdateSound=AY8910_Update;

		break;

		case	GAME_MRDO:
		case	GAME_MRLO:

			Driver.Proc[0].Type=CPU_Z80;
			Driver.Proc[0].Speed=4000000;
			Driver.Proc[0].RomStart1=0x0000;
			Driver.Proc[0].RomEnd1=0x8000;

			Driver.TextColour=39;
			Driver.FrameRate=60;
			Driver.DataCols=64;
			Driver.LeftEdge=0+16;
			Driver.RightEdge=255-16;
			Driver.TopEdge=0;
			Driver.BottomEdge=255;
			Driver.Palette=MrDoPalette;
			Driver.ScreenBase=0x8000;
			Driver.TotalChars=1024;
			Driver.TotalSprites=128;
			Driver.TotalPalettes=1;	//64

			Driver.fn_InitSound=MrDoInitSound;
			Driver.fn_Translate=MrDoTranslateROM;
			Driver.fn_SetPalette=MrDoSetPalette;
			Driver.fn_Interrupt=MrDoInterrupt;
			Driver.fn_ScreenUpdate=MrDoScreenUpdate;
			Driver.fn_WriteRam=MrDoWriteRam;
			Driver.fn_ReadRam=MrDoReadRam;

		break;

		case	GAME_SCRAMBLE:

			Driver.Proc[0].Type=CPU_Z80;
			Driver.Proc[0].Speed=3072000;
			Driver.Proc[0].RomStart1=0x0000;
			Driver.Proc[0].RomEnd1=0x4000;

			Driver.TextColour=1;
			Driver.FrameRate=60;
			Driver.DataCols=32;
			Driver.StarCols=64;
			Driver.LeftEdge=0+16;
			Driver.RightEdge=255-16;
			Driver.TopEdge=0;
			Driver.BottomEdge=255;
			Driver.Palette=ScramblePalette;
			Driver.StarPal=ScrambleStarPal;
			Driver.TotalChars=256;
			Driver.TotalSprites=64;
			Driver.TotalPalettes=8;
			Driver.NMIflagAddr=0x6801;
			Driver.StarsOn=0x6804;
			Driver.ScreenBase=0x4800;

			Driver.fn_Translate=CrestaTranslateROM;
			Driver.fn_SetPalette=CrestaSetPalette;
			Driver.fn_Interrupt=CrestaInterrupt;

			Driver.fn_ScreenUpdate=ScrambleScreenUpdate;
			Driver.fn_ReadRam=ScrambleReadRam;

		break;

		case	GAME_FIREBIRD:

			Driver.Proc[0].Type=CPU_Z80;
			Driver.Proc[0].Speed=1500000;
			Driver.Proc[0].RomStart1=0x0000;
			Driver.Proc[0].RomEnd1=0x4000;
			Driver.Proc[0].IntSplit=2;

			Driver.TextColour=1;
			Driver.FrameRate=60;
			Driver.DataCols=32;
			Driver.StarCols=32;
			Driver.LeftEdge=0+16;
			Driver.RightEdge=255-16;
			Driver.TopEdge=0;
			Driver.BottomEdge=255;
			Driver.Palette=FirebirdPalette;

			Driver.ScreenBase=0x8000;
			Driver.TotalChars=256;
			Driver.TotalPalettes=8;

			Driver.fn_Translate=FirebirdTranslateROM;
			Driver.fn_SetPalette=CrestaSetPalette;
			Driver.fn_Interrupt=FirebirdInterrupt;
			Driver.fn_ScreenUpdate=FirebirdScreenUpdate;
			Driver.fn_InPort=FirebirdInPort;
			Driver.fn_OutPort=FirebirdOutPort;

		break;

		case	GAME_CRESTA:

			Driver.Proc[0].Type=CPU_Z80;
			Driver.Proc[0].Speed=3072000;
			Driver.Proc[0].RomStart1=0x0000;
			Driver.Proc[0].RomEnd1=0x4000;

			Driver.TextColour=1;
			Driver.FrameRate=60;
			Driver.DataCols=32;
			Driver.StarCols=64;
			Driver.LeftEdge=0+16;
			Driver.RightEdge=255-16;
			Driver.TopEdge=16;
			Driver.BottomEdge=255;
			Driver.NMIflagAddr=0xb000;
			Driver.Palette=CrestaPalette;
			Driver.StarPal=CrestaStarPal;
			Driver.ScreenBase=0x9000;
			Driver.StarsOn=0xb004;
			Driver.SoundAddr=0xb800;
			Driver.TotalChars=512;
			Driver.TotalSprites=128;
			Driver.TotalPalettes=16;

			Driver.fn_InitSound=CrestaInitSound;
			Driver.fn_ChangeSound=CrestaChangeSound;
			Driver.fn_Translate=CrestaTranslateROM;
			Driver.fn_SetPalette=CrestaSetPalette;
			Driver.fn_Interrupt=CrestaInterrupt;
			Driver.fn_ScreenUpdate=CrestaScreenUpdate;
			Driver.fn_WriteRam=CrestaWriteRam;
			Driver.fn_ReadRam=CrestaReadRam;

		break;

		case	GAME_GALAXIAN_PART_1:
		case	GAME_GALAXIAN_PART_4:
		case	GAME_GALAXIAN_TURBO:
		case	GAME_SUPER_GALAXIAN:	
		case	GAME_GALAXIAN_MIDWAY:
		case	GAME_GALAXIAN_NAMCO:

			Driver.Proc[0].Type=CPU_Z80;
			Driver.Proc[0].Speed=3072000;
			Driver.Proc[0].RomStart1=0x0000;
			Driver.Proc[0].RomEnd1=0x2800;

			Driver.TextColour=1;
			Driver.FrameRate=60;
			Driver.DataCols=64;
			Driver.StarCols=64;
			Driver.LeftEdge=0+16;
			Driver.RightEdge=255-16;
			Driver.TopEdge=0;
			Driver.BottomEdge=255;
			Driver.NMIflagAddr=0x7001;
			Driver.ScreenBase=0x5000;
			Driver.StarsOn=0x7004;
			Driver.SoundAddr=0x7800;
			Driver.TotalChars=256;
			Driver.TotalSprites=64;
			Driver.TotalPalettes=16;
			Driver.Palette=GalaxianPal;
			Driver.ColourTable=GalaxianColourTable;

			Driver.fn_InitSound=CrestaInitSound;
			Driver.fn_ChangeSound=CrestaChangeSound;
			Driver.fn_Translate=CrestaTranslateROM;
			Driver.fn_SetPalette=GalaxianSetPalette;
			Driver.fn_Interrupt=CrestaInterrupt;
			Driver.fn_ScreenUpdate=GalaxianScreenUpdate;
			Driver.fn_WriteRam=GalaxianWriteRam;
			Driver.fn_ReadRam=GalaxianReadRam;

		break;

		case	GAME_PISCES:

			Driver.Proc[0].Type=CPU_Z80;
			Driver.Proc[0].Speed=3072000;
			Driver.Proc[0].RomStart1=0x0000;
			Driver.Proc[0].RomEnd1=0x3000;

			Driver.TextColour=1;
			Driver.FrameRate=60;
			Driver.DataCols=64;
			Driver.StarCols=64;
			Driver.LeftEdge=0+16;
			Driver.RightEdge=255-16;
			Driver.TopEdge=0;
			Driver.BottomEdge=255;
			Driver.NMIflagAddr=0x7001;
			Driver.ScreenBase=0x5000;
			Driver.StarsOn=0x7004;
			Driver.SoundAddr=0x7800;
			Driver.TotalChars=512;
			Driver.TotalSprites=128;
			Driver.TotalPalettes=16;
			Driver.Palette=GalaxianPal;
			Driver.ColourTable=GalaxianColourTable;

			Driver.fn_InitSound=CrestaInitSound;
			Driver.fn_ChangeSound=CrestaChangeSound;
			Driver.fn_Translate=CrestaTranslateROM;
			Driver.fn_SetPalette=GalaxianSetPalette;
			Driver.fn_Interrupt=CrestaInterrupt;
			Driver.fn_ScreenUpdate=GalaxianScreenUpdate;
			Driver.fn_WriteRam=GalaxianWriteRam;
			Driver.fn_ReadRam=GalaxianReadRam;

		break;

		case	GAME_JAPIREM:

			Driver.Proc[0].Type=CPU_Z80;
			Driver.Proc[0].Speed=3072000;
			Driver.Proc[0].RomStart1=0x0000;
			Driver.Proc[0].RomEnd1=0x4000;

			Driver.TextColour=1;
			Driver.FrameRate=60;
			Driver.DataCols=32;
			Driver.StarCols=32;
			Driver.LeftEdge=0+16;
			Driver.RightEdge=255-16;
			Driver.TopEdge=0;
			Driver.BottomEdge=255;
			Driver.NMIflagAddr=0x7001;
			Driver.ScreenBase=0x5000;
			Driver.StarsOn=0x7004;
			Driver.SoundAddr=0x7800;
			Driver.TotalChars=512;
			Driver.TotalSprites=128;
			Driver.TotalPalettes=16;
			Driver.Palette=BugsPal;
			Driver.StarPal=BugsPal;

			Driver.fn_InitSound=CrestaInitSound;
			Driver.fn_ChangeSound=CrestaChangeSound;
			Driver.fn_Translate=CrestaTranslateROM;
			Driver.fn_SetPalette=CrestaSetPalette;
			Driver.fn_Interrupt=CrestaInterrupt;
			Driver.fn_ScreenUpdate=GalaxianScreenUpdate;
			Driver.fn_WriteRam=GalaxianWriteRam;
			Driver.fn_ReadRam=GalaxianReadRam;
			
		break;

		case	GAME_WAR_OF_THE_BUGS:
		
			Driver.Proc[0].Type=CPU_Z80;
			Driver.Proc[0].Speed=3072000;
			Driver.Proc[0].RomStart1=0x0000;
			Driver.Proc[0].RomEnd1=0x2800;

			Driver.TextColour=1;
			Driver.FrameRate=60;
			Driver.DataCols=32;
			Driver.StarCols=32;
			Driver.LeftEdge=0+16;
			Driver.RightEdge=255-16;
			Driver.TopEdge=0;
			Driver.BottomEdge=255;
			Driver.NMIflagAddr=0x7001;
			Driver.ScreenBase=0x5000;
			Driver.StarsOn=0x7004;
			Driver.SoundAddr=0x7800;
			Driver.TotalChars=256;
			Driver.TotalSprites=64;
			Driver.TotalPalettes=16;
			Driver.Palette=BugsPal;
			Driver.StarPal=BugsPal;
		
			Driver.fn_InitSound=CrestaInitSound;
			Driver.fn_ChangeSound=CrestaChangeSound;
			Driver.fn_Translate=CrestaTranslateROM;
			Driver.fn_SetPalette=CrestaSetPalette;
			Driver.fn_Interrupt=CrestaInterrupt;
			Driver.fn_ScreenUpdate=GalaxianScreenUpdate;
			Driver.fn_WriteRam=GalaxianWriteRam;
			Driver.fn_ReadRam=GalaxianReadRam;
		
		break;



		case	GAME_LUNAR_RESCUE:	

			Driver.Proc[0].Type=CPU_Z80;
			Driver.Proc[0].Speed=3072000;
			Driver.Proc[0].RomStart1=0x0000;
			Driver.Proc[0].RomEnd1=0x2000;
			Driver.Proc[0].RomStart2=0x4000;
			Driver.Proc[0].RomEnd2=0x5000;

			Driver.TextColour=1;
			Driver.FrameRate=60;
			Driver.ScreenBase=0x2400;

			Driver.fn_InitSound=InvadersInitSound;
			Driver.fn_SetPalette=InvadersSetPalette;
			Driver.fn_Interrupt=InvadersInterrupt;
			Driver.fn_WriteRam=InvadersWriteRam;
			Driver.fn_InPort=InvadersInPort;
			Driver.fn_OutPort=InvadersOutPort;

		break;


		case	GAME_GALAXY_WARS:

			Driver.Proc[0].Type=CPU_Z80;
			Driver.Proc[0].Speed=3072000;
			Driver.Proc[0].RomStart1=0x0000;
			Driver.Proc[0].RomEnd1=0x1000;
			Driver.Proc[0].RomStart2=0x4000;
			Driver.Proc[0].RomEnd2=0x4800;

			Driver.TextColour=1;
			Driver.FrameRate=60;
			Driver.ScreenBase=0x2400;

			Driver.fn_InitSound=InvadersInitSound;
			Driver.fn_SetPalette=InvadersSetPalette;
			Driver.fn_Interrupt=InvadersInterrupt;
			Driver.fn_WriteRam=InvadersWriteRam;
			Driver.fn_InPort=InvadersInPort;
			Driver.fn_OutPort=InvadersOutPort;

		break;


		case	GAME_INVADERS_DELUXE:	

			Driver.Proc[0].Type=CPU_Z80;
			Driver.Proc[0].Speed=3072000;
			Driver.Proc[0].RomStart1=0x0000;
			Driver.Proc[0].RomEnd1=0x2000;
			Driver.Proc[0].RomStart2=0x4000;
			Driver.Proc[0].RomEnd2=0x4800;

			Driver.TextColour=1;
			Driver.FrameRate=60;
			Driver.ScreenBase=0x2400;

			Driver.fn_InitSound=InvadersInitSound;
			Driver.fn_SetPalette=InvadersSetPalette;
			Driver.fn_Interrupt=InvadersInterrupt;
			Driver.fn_WriteRam=InvadersWriteRam;
			Driver.fn_InPort=InvadersInPort;
			Driver.fn_OutPort=InvadersOutPort;

		break;

		case	GAME_SPACE_INVADERS:
		case	GAME_INVADERS_REVENGE:
		case	GAME_SPACE_ATTACK:
		case	GAME_SUPER_INVASION:
		
			Driver.Proc[0].Type=CPU_Z80;
			Driver.Proc[0].Speed=3072000;
			Driver.Proc[0].RomStart1=0x0000;
			Driver.Proc[0].RomEnd1=0x2000;

			Driver.TextColour=1;
			Driver.FrameRate=60;
			Driver.ScreenBase=0x2400;

			Driver.fn_InitSound=InvadersInitSound;
			Driver.fn_SetPalette=InvadersSetPalette;
			Driver.fn_Interrupt=InvadersInterrupt;
			Driver.fn_WriteRam=InvadersWriteRam;
			Driver.fn_InPort=InvadersInPort;
			Driver.fn_OutPort=InvadersOutPort;
		
		break;
		
		case	GAME_PHOENIX:
		case	GAME_PLEIADES:

			Driver.Proc[0].Type=CPU_Z80;
			Driver.Proc[0].Speed=1000000;
			Driver.Proc[0].RomStart1=0x0000;
			Driver.Proc[0].RomEnd1=0x4000;

			Driver.TextColour=50;
			Driver.FrameRate=60;
			
			Driver.Palette=PhoenixPal;
			Driver.ColourTable=PhoenixColourTable;
			
			Driver.DataCols=64;
			Driver.LeftEdge=0;
			Driver.RightEdge=255;
			Driver.TopEdge=0;
			Driver.BottomEdge=255;
			
			Driver.ScreenBase=0x4000;
			Driver.TotalChars=512;
			Driver.TotalSprites=0;
			Driver.TotalPalettes=2;
		
			Driver.fn_Translate=PhoenixTranslateROM;
			Driver.fn_SetPalette=PhoenixSetPalette;
			Driver.fn_Interrupt=PhoenixInterrupt;
			Driver.fn_ScreenUpdate=PhoenixScreenUpdate;
			Driver.fn_WriteRam=PhoenixWriteRam;
			Driver.fn_ReadRam=PhoenixReadRam;
			
		break;
		}
}
