extern "C"
{
#include	"c:\emulator\seal\audio\include\audio.h"
#include	"c:\dev\ezgame\ezgame.h"
#include 	"YM2203.h"
}
#include	"main.h"
#include	"z80.h"
#include	"m6809.h"
#include	"support.h"
#include	"psg.h"
#include	<stdio.h>
#include	<conio.h>
#include	<string.h>
#include 	<stdlib.h>

//extern *AYPSG;		/* array of PSG's */

int		RunEmulation (int Game)
{
int		rc;

	// Fill in the almighty DRV structure
	memset ((char *)&Driver,0,sizeof(Driver));
	Driver.Game=Game;				// Occasionally used for minor board differences
	FillInDriverDetails(Game); 		// Stick all the info in. Seperate file for this one function as it is well massive !

	// Load in the ROMS, and store some returned info
	rc=LoadRoms(Game);
	if (rc) return (rc);

	// Initialise any sounds required
	if (Driver.fn_InitSound)
		Driver.fn_InitSound();

	// Neat video mode giving 256x256x256 addressable with none of this unchained shite. Special widths dealt with here
	SetModeQ();

	// Translate the graphics characters into PC useable format
	if (Driver.fn_Translate)
		Driver.fn_Translate();

	// Translate the colour palette, then set it
	if (Driver.fn_SetPalette)
		Driver.fn_SetPalette();

	// Set the clipping rectangle
	ez_SetClippingRectangle (Driver.LeftEdge,Driver.TopEdge,Driver.RightEdge,Driver.BottomEdge);

	// Get the machine status ready to start running the emulation
	rc=ResetMachine();
	if (rc) return (rc);

	// Set the timer rate to match the frame rate
	ez_SetTimerRate(FrameRate);

	// Sort out the joystick
	if (UseJoySticks)
		ez_InitJoysticks(JOY_1x4BUTTON);
	else
		ez_CancelJoysticks();

	// Tell the game to get on with it !
	RunTheBoards();

	// Set the timer rate back to default value
	ez_SetTimerRate(100);

	return (ERROR_NONE);	
}




int		ResetMachine (void)
{
	SyncEnabled=TRUE;				// Wait for video sync or not
	SyncMsgTimer=0;					// Delay period for printing changed message for above
	ShowFPS=0;						// Print up the current frame rate ?
	PaletteBank=0;

	BankFlag=0;						// Some display drivers need banking info
	FrameRateCounter=FrameRate=0;
	TickCount=VsyncTicks=0;
	PrintStars=0;					// No starfield until asked for by the machine
	StarScroll=0;					// Start the starfield from zero
	Bitmap=BitmapPrevious=ShiftValue=0;	// This shit for the invaders games
	SndPort3=SndPort5=0;			// As is this shite
	DipSwitchSYNC=0;				// Phoenix/Pleiades use this

	if (Driver.StarCols)
		InitStars();				// If starfield to be used, then initialise them

	FrameRate=Driver.FrameRate;	 	// Used for controlling the speed of the game
	if (!FrameRate)	
		return (ERROR_MUST_BE_A_BUG);

	return (ERROR_NONE);
}	








int		LoadRoms (int Game)
{
int		x,r,Dst,Size,Addr;
char	*Dest;
FILE	*fp;

	memset (RomSpace,0,sizeof(RomSpace));
	memset (TempChars,0,sizeof(TempChars));

	for (x=0;x<NUM_GAMES;x++)
		{
		// Search the GAMES table for a matching GameCode
		if (Games[x].GameCode==Game)
			{
			// Found the correct entry, now load em in
			for (r=0;r<NUM_ROMS;r++)
				{
				// Is this a sensible entry or a gap in the list ?
				if (Games[x].Rom[r].LoadAddr || Games[x].Rom[r].Size)
					{
					// Aha. A genuine entry
					Addr=Games[x].Rom[r].LoadAddr;		// Where should it go ?
					Size=Games[x].Rom[r].Size;			// And how large is it ?
					Dst=Games[x].Rom[r].Dest;			// And what is it ?

					switch (Dst)
						{
						case	LOAD_PROC1:
							Dest=RomSpace[0];
						break;

						case	LOAD_PROC2:
							Dest=RomSpace[1];
						break;

						case	LOAD_PROC3:
							Dest=RomSpace[2];
						break;

						case	LOAD_PROC4:
							Dest=RomSpace[3];
						break;

						case	LOAD_GFX:
							Dest=TempChars;
						break;

						default:
							return (ERROR_MUST_BE_A_BUG);	// First entry in ROM list in GAMES structure must be at 0x0000	
						}

					if (Dest==TempChars && (Addr<0 || Addr+Size>sizeof(TempChars)))
						return (ERROR_MUST_BE_A_BUG);	// Graphics are not in acceptable range

					fp=fopen (Games[x].Rom[r].Name,"rb");
					if (!fp)
						return (ERROR_NO_ROMS);

					fread (Dest+Addr,Size,1,fp);		// Stick it in the right place
					fclose (fp);
					}
				}
			return (ERROR_NONE);
			}
		}

	// Can't see why I cannot find an entry
	return (ERROR_MUST_BE_A_BUG);
}









void	Hflip (char *Data)
{
int		x,y;
char	pix;

	for (y=0;y<16;y++)
		{
		for (x=0;x<8;x++)
			{
			pix=Data[y*16+(15-x)];
			Data[y*16+(15-x)]=Data[y*16+x];
			Data[y*16+x]=pix;
			}
		}
}

void	Vflip (char *Data)
{
int		x,y;
char	pix;

	for (y=0;y<8;y++)
		{
		for (x=0;x<16;x++)
			{
			pix=Data[(15-y)*16+x];
			Data[(15-y)*16+x]=Data[y*16+x];
			Data[y*16+x]=pix;
			}
		}
}

void	CopyBlock (char *dst,char *src,int AddOn)
{
int		y;
char	*dstPtr,*srcPtr;

	dstPtr=dst+AddOn;
	srcPtr=src;
	for (y=0;y<8;y++)
		{
		memcpy (dstPtr,srcPtr,8);
		dstPtr+=16;
		srcPtr+=8;
		}
}














unsigned	CPU_Interrupt (void)
{
	// If escape key pressed, then cancel machine execution and end emulation
	if (ez_KeyPressed[SC_ESC])
		QuitReady=1;

	// Do the appropriate procedure
	if (Driver.fn_Interrupt)
		return (Driver.fn_Interrupt());
	else
		return (Z80_IGNORE_INT);		// Continue execution
}


byte CPU_IN (byte Port)
{
	if (Driver.fn_InPort)
		return (Driver.fn_InPort(Port));
	else
		return (0);
}

void CPU_OUT (byte Port,byte Value)
{
	if (Driver.fn_OutPort)
		Driver.fn_OutPort(Port,Value);
}



unsigned Z80_READOP (dword A)
{
	if (CurrentProc==0 && Driver.Game==GAME_COMMANDO)
		{
		return (CommandoDecrypt[ RAM[A] ]);
		}
	else
	if (CurrentProc==1 && Driver.Game==GAME_1942)
		{
		if (A==0x65)
			Z80_ICount=0;		// Bug out of wait loop on sound processor
		}
		   
	return (RAM[A]);
}


unsigned CPU_RDMEM (dword A)
{
	if ((A>=Driver.Proc[CurrentProc].RomStart1 && A<Driver.Proc[CurrentProc].RomEnd1) || (A>=Driver.Proc[CurrentProc].RomStart2 && A<Driver.Proc[CurrentProc].RomEnd2))
		{
		// Reading from ROMS
		return (RAM[A]);
//		return (RomSpace[CurrentProc][A]);
		}
	else
		{
		if (Driver.fn_ReadRam)
			return (Driver.fn_ReadRam(A));
		else
		  	return (RAM[A]);
		}
}


void CPU_WRMEM (dword A,byte V)
{
	if ((A>=Driver.Proc[CurrentProc].RomStart1 && A<Driver.Proc[CurrentProc].RomEnd1) || (A>=Driver.Proc[CurrentProc].RomStart2 && A<Driver.Proc[CurrentProc].RomEnd2))
		return;
	
//////////////////////////////////////////////////////////
	if (A==Driver.StarsOn)								//
		{												//
		PrintStars=V&1;									//
		StarScroll=0;									//--This stuff needs moving into the relevant memory_read routines
		}												//
														//
	if (A==Driver.SoundAddr && Driver.fn_ChangeSound)	//
		Driver.fn_ChangeSound(V);						//
//////////////////////////////////////////////////////////
	
	if (Driver.fn_WriteRam)
		Driver.fn_WriteRam(A,V);
	else
		RAM[A]=V;
}


void CPU_QUICKWRITE (dword A,byte V)
{
	if (Driver.fn_WriteRam)
		Driver.fn_WriteRam(A,V);
	else
		RAM[A]=V;
}


#define		CUT_OFF		64

void	RunTheBoards (void)
{
int		x,pSplit,MaxSplit;
int		Split[NUM_PROC];
int		SplitCount[NUM_PROC];
int		SplitAdd[NUM_PROC];

	// Clear out ALL processor structures
	ez_ClearMem((char *)Z80r,sizeof(Z80r));
	ez_ClearMem((char *)m6809r,sizeof(m6809r));
	ez_ClearMem(RamSpace,sizeof(RamSpace));
	ez_ClearMem((char *)Split,sizeof(Split));
	ez_ClearMem((char *)SplitCount,sizeof(SplitCount));
	ez_ClearMem((char *)SplitAdd,sizeof(SplitAdd));
	ez_ClearMem((char *)PalUpD,sizeof(PalUpD));
	ScrollReg=HScrollReg=HScrollLO=HScrollHI=ScrollLO=ScrollHI=0;
	doNMI=TestDone=UpdatePal=0;

	// Reset all the processor states
	for (x=0;x<NUM_PROC;x++)
		{
		Execute[x]=1;
		switch (Driver.Proc[x].Type)
			{
			case	CPU_Z80:
			case	CPU_Z80S:

				Z80r[x].R=rand();
				Z80r[x].SP.D=0xf000;

			break;

			case	CPU_6809:

				m6809r[x].cc=0x50;		// IRQ & FIRQ disabled
				m6809r[x].pc=(RomSpace[x][0xfffe]<<8)+RomSpace[x][0xffff];

			break;
			}

		if (Driver.Proc[x].IntSplit)
			Driver.Proc[x].ICount=(Driver.Proc[x].Speed/Driver.FrameRate)/(Driver.Proc[x].IntSplit);
		else
			Driver.Proc[x].ICount=Driver.Proc[x].Speed/Driver.FrameRate;
		}

	// Get the largest amount of sub-divisions for accurate processor splitting
	MaxSplit=1;
	for (x=0;x<NUM_PROC;x++)
		{
		if (Driver.Proc[x].Type)
			{
			if (Driver.Proc[x].IntSplit>MaxSplit)
				MaxSplit=Driver.Proc[x].IntSplit;
			}
		}

	// Calculate the fixed point shite for marking sub-divisions
	for (x=0;x<NUM_PROC;x++)
		{
		if (Driver.Proc[x].Type)
			{
			if (Driver.Proc[x].IntSplit)
				SplitAdd[x]=MaxSplit*CUT_OFF/Driver.Proc[x].IntSplit;
			else
				SplitAdd[x]=CUT_OFF;
			SplitCount[x]=SplitAdd[x];
			}
		}


	QuitReady=0;

	ROMPage=0;

	if (Driver.Game==GAME_GNG)
		ROMPage=4;

	while (!QuitReady)
		{
		for (pSplit=0;pSplit<MaxSplit;pSplit++)
			{
			for (CurrentProc=0;CurrentProc<NUM_PROC;CurrentProc++)
				{
				SplitCount[CurrentProc]+=CUT_OFF;
				if (SplitCount[CurrentProc]>=SplitAdd[CurrentProc])
					{
					SplitCount[CurrentProc]-=SplitAdd[CurrentProc];
					if (Execute[CurrentProc])
						{
						switch (Driver.Proc[CurrentProc].Type)
							{
							case	CPU_Z80S:

								if (!SoundPermitted)
									break;
								// Drops through into standard Z80 handler

							case	CPU_Z80:

								// Copy the relevant processor back into the correct execution structures
								ez_CopyMem ((char *)&R,(char *)&Z80r[CurrentProc],sizeof(Z80_Regs));

								// Set up the number of execution steps
								Z80_IPeriod=Driver.Proc[CurrentProc].ICount;
								Z80_ICount=Z80_IPeriod;
								CPU_IntSplit=Split[CurrentProc]+1;

								// Get the correct ROM space
								if (Driver.Game==GAME_1942 && CurrentProc==0)
									RAM=RomSpace[ROMPage+2];
								else
									RAM=RomSpace[CurrentProc];

								// Do the bastard
								Z80_Execute();

								// Store away the current processor state
								ez_CopyMem ((char *)&Z80r[CurrentProc],(char *)&R,sizeof(Z80_Regs));

								Split[CurrentProc]++;
								if (Split[CurrentProc]>=Driver.Proc[CurrentProc].IntSplit)
									Split[CurrentProc]=0;
						
							break;


							case	CPU_6809:

								// Copy the relevant processor back into the correct execution structures
								m6809_SetRegs (&m6809r[CurrentProc]);
								m6809_IRequest=INT_NONE;

								// Set up the number of execution steps
								m6809_IPeriod=Driver.Proc[CurrentProc].ICount;
								m6809_ICount=m6809_IPeriod;
								CPU_IntSplit=Split[CurrentProc]+1;

								// Get the correct ROM space
								if (Driver.Game==GAME_GNG)
									RAM=RomSpace[ROMPage+2];
								else
									RAM=RomSpace[CurrentProc];

								// Do the bastard
								m6809_Execute();

								// Store away the current processor state
								m6809_GetRegs (&m6809r[CurrentProc]);

								Split[CurrentProc]++;
								if (Split[CurrentProc]>=Driver.Proc[CurrentProc].IntSplit)
									Split[CurrentProc]=0;

							break;
							}
						}
					}
				}
			}

		// Maybe update sound stuff
		if (Driver.fn_UpdateSound)
			Driver.fn_UpdateSound();

		// Maybe take a snapshot of the screen
		if (ez_KeyPressed[SC_F12])
			ez_SaveAsGif ("SNAPSHOT.GIF",ScreenWidth,ScreenHeight,Palette,(char *)0xa0000);

		if (ez_KeyPressed[SC_F1])
			{
			ShowFPS=300;
			if (!SyncEnabled)
				{
				ShowFPS<<=2;
				SyncMsgTimer<<=2;
				MethodMsgTimer<<=2;
				}
			}

		if (ez_KeyPressed[SC_F2])
			{
			ez_KeyPressed[SC_F2]=0;
			MethodMsgTimer=100;
			ShowFPS=300;
			FrameRateCounter=TickCount=VsyncTicks=0;

			if (UseAccurateVsync)
				UseAccurateVsync=FALSE;
			else
				UseAccurateVsync=TRUE;

			if (!SyncEnabled)
				{
				ShowFPS<<=2;
				SyncMsgTimer<<=2;
				MethodMsgTimer<<=2;
				}
			}

		if (ez_KeyPressed[SC_F3])
			{
			ez_KeyPressed[SC_F3]=0;
			SyncMsgTimer=100;
			ShowFPS=300;
			FrameRateCounter=TickCount=VsyncTicks=0;

			if (SyncEnabled)
				SyncEnabled=FALSE;
			else
				SyncEnabled=TRUE;

			if (!SyncEnabled)
				{
				ShowFPS<<=2;
				SyncMsgTimer<<=2;
				MethodMsgTimer<<=2;
				}
			}

		// Slow-mo key
		if (ez_KeyPressed[SC_S])
			ez_Delay(5);

		// Draw the screen
		if (Driver.fn_ScreenUpdate && Driver.Game!=GAME_FIREBIRD)
			{
			CurrentProc=0;
			RAM=RomSpace[0];
			Driver.fn_ScreenUpdate();
			BlitScreen();
			}
		}

	if (AY8910_On)
		AYShutdown();

	if (YM2203_On)
		InitOpl();

	DisableSounds();
}

