#include	"c:\emulator\seal\audio\include\audio.h"


#define		SPACING 	16
#define		DEPTH		14
#define		WIDTH		180
#define		NUM_ENTRY	12

#define		BOX_PIECES	300
#define		NUM_HELP	12

#define		VERSION		"Version 1.16"



typedef struct
	{
	char	*CardName;
	int	AudioId;
	} SND;

typedef struct
	{
	char	*Text[NUM_HELP];
	} HELP;


typedef struct
	{
	int	Col;
	char	*Text;
	} CRD;



typedef struct
	{
	short		Xc;
	short		Yc;
	short		Delay;
	short		Piece;
	short		Col;
	short		Type;
	short		Total;
	char		*Fade;
	} BOX;



void	PrintSelectionList (int Col);
int	CheckPresenceOfRoms (void);
int	DrawTextBox (int Xc,int Yc,int Width,int Depth,char *Colours,int Total);
void	BoxPiece (int Xc,int Yc,int Piece,int Delay,char *Colours,int Total);
void 	ProcessTextBox (void);
void	ActivateAselection (int Option);
void	DoSoundSetup (void);
void	PrintConfig (void);
void	ShowCredits (void);
int	GetKeyFor (char *Text);
void	LoadDefaults (void);
void	SaveDefaults (void);
//void	MY_CloseDown (void);
int	GetSoundChannel (void);
void	DisplayRomsNeeded (int Game);
void	ShowHelp (void);
void	ChangeOptions (void);
void	ChangeControls (void);
int	DoHelp (HELP *Help);
void	LoadSageSamples(void);
void	ShowTitleScreen (void);
void	SortGamesList (void);
char	PressedInitial (void);

void	TimerHook (void);
#pragma aux TimerHook modify [eax ebx ecx edx esi edi]





char	BlackPal[770];
char	RedColour[64];
char	GreenColour[64];
char	BlueColour[64];
char	DkBlueColour[64];
char	*Palette,*BigFont,*TinyFont;
int	CursorPos,ListPos,ReuseBox;
int	FromCLI;
int	ConfigDisplay,ConfigMode;
BOX	Box[BOX_PIECES];

#define	CONFIG_TIME	300

#define	SND_MENU_MOVE	0
#define SND_TELETYPE	1
#define SND_SELECTION	2


#define AUDIO_PRODUCT_NONE              0x0000
#define AUDIO_PRODUCT_SB                0x0001
#define AUDIO_PRODUCT_SBPRO             0x0004
#define AUDIO_PRODUCT_SB16              0x0005
#define AUDIO_PRODUCT_AWE32             0x0006
#define AUDIO_PRODUCT_WSS               0x0007
#define AUDIO_PRODUCT_ESS               0x0008
#define AUDIO_PRODUCT_GUS               0x0009

#define	NUM_SOUND			8



SND	SoundSettings[NUM_SOUND]=
	{
	{"Please choose a card",-1},
	{"from the list by pressing",-1},
	{"the relevant number key",-1},
	{"No Sound",AUDIO_PRODUCT_NONE},
	{"SoundBlaster",AUDIO_PRODUCT_SB},
	{"Ensonique",AUDIO_PRODUCT_ESS},
	{"Gravis Ultra",AUDIO_PRODUCT_GUS},
	{"Windows SS",AUDIO_PRODUCT_WSS}
	};


#define	NUM_CRED	12

CRD	Credits[NUM_CRED]=
	{
	{0,"DESIGN/PRODUCTION/CODING"},
	{1,"PAUL JOHNSON"},
	{1,"E-MAIL MAYHEM @@ CIX.CO.UK"},
	{0," "},
	{0,"THANKS TO"},
	{1,"MARCEL DE KOGEL"},
	{1,"NICOLA SALMORIA "},
	{1,"PHIL MORRIS"},
	{1,"CHRIS HARDY"},
	{1,"ANDY CLARK"},
	{1,"LORRAINE JOHNSON"},
	{0," "},
	};

#define		NUM_PAGES	11

HELP	Help[NUM_PAGES]=
	{
	{"WELCOME TO SAGE","","WHILST MOVING THROUGH THESE","HELP PAGES","","PRESS @C[7]ESC","TO GO BACK TO SELECTIONS","OR","PRESS @C[7]RETURN@C[31] OR @C[7]SPACE@C[31]","FOR THE NEXT PAGE.","",""},
	{"@C[7]CONTROLS","","USE CURSOR UP/DOWN","TO SCROLL THROUGH THE","SELECTION LIST ON THE LEFT.","PRESS SPACE OR RETURN","TO SELECT THE ITEM.","","TOP ENTRIES ARE CONFIG STUFF,","THE SUBSEQUENT TITLES","RUN THE GAMES.",""},
	{"@C[7]SOUND","","SELECT 'SOUND SETUP'","TO CHOOSE A SOUNDCARD FROM","THE LIST OF THOSE SUPPORTED.","","JUST PRESS THE CORRESPONDING","NUMBER KEY FROM THE MENU","THAT APPEARS IN THIS WINDOW.","","",""},
	{"@C[7]GAME KEYS","","SELECT 'CHANGE GAME KEYS'","TO SPECIFY THE VARIOUS","KEYS YOU WISH TO ASSIGN TO","MOVEMENT AND FIRING WITHIN","THE GAMES.","","THESE SETTINGS ARE","REMEMBERED AND APPLY TO","ALL THE GAMES IN SAGE.",""},
	{"@C[7]OPTIONS","","SELECT 'OPTIONS'","TO SELECT JOYSTICK","AND EMULATION STYLE.","","YOU ARE FIRST ASKED IF","YOU HAVE A JOYSTICK.","JUST PRESS Y OR N.","YOU ARE THEN ASKED ABOUT","EMULATION STYLE","JUST PRESS A OR S."},
	{"@C[7]EMULATION STYLE","","DUE TO INCOMPATABILITIES","BETWEEN ARCADE AND PC SCREENS","THERE IS A TRADE OFF","BETWEEN ACCURATE SPEED","AND A SMOOTH DISPLAY.","","THERE WON'T BE MUCH IN IT","SO YOU MAY CHOOSE","WHAT YOU LIKE.",""},
	{"@C[7]CREDITS","","SELECT 'CREDITS'","TO SEE WHO IS TO THANK","(OR BLAME) FOR SAGE.","","THERE IS ALSO CONTACT INFO","FOR ANY BUG REPORTS/","COMMENTS/DONATIONS ETC...","","PLEASE FEEL FREE TO","DROP ME AN E-MAIL."},
	{"@C[7]ROMS","","A WORD ABOUT ROMS.","FOR REASONS OF COPYRIGHT","I CANNOT SUPPLY ROMS","FOR USE WITH SAGE,","SO PLEASE DON'T ASK !","","TRY A WEB SEARCH FOR","'ARCADE+ROMS'","","THERE ARE LINKS ON MY SITE"},
	{"@C[7]SAGE SITE","","WWW.CIX.CO.UK/~JOHNSON/","","FOR THE VERY LATEST VERSION","PLUS GREAT LINKS","AND EMULATOR UTILITIES.","","CHECK THERE REGULARLY","OR ELSE YOU WILL MISS OUT !","",""},
	{"@C[7]DISCLAIMER","","I CANNOT BE HELD","RESPONSIBLE FOR ANY","PROBLEMS THAT USE OR","MISUSE OF SAGE MAY CAUSE.","","IT IS ALSO ENTIRELY","UP TO YOU TO ENSURE","NO COPYRIGHTS ARE BROKEN","WITH RESPECT TO ROM USEAGE.",""},
	{"@C[7]THATS ALL","","","","","GO PLAY SOME GAMES !","","","","","",""}
	};




char	*ScanCodeToString[256]
={	"",		//	Nul				00	
	"",		//	Escape				01	
	"1",		//	'1!'				02	
	"2",		//	'2"'				03	
	"3",		//	'3'				04	
	"4",		//	'4$'				05	
	"5",		//	'5%'				06	
	"6",		//	'6^'				07	
	"7",		//	'7&'				08	
	"8",		//	'8*'				09	
	"9",		//	'9('				10	
	"0",		//	'0)'				11	
	"-",		//	'-_'				12	
	"=",		//	'=+'				13	
	"BkSpc",	//	Backspace			14	
	"Tab",		//	Tab				15	
	"Q",		//	'qQ'				16	
	"W",		//	'wW'				17	
	"E",		//	'eE'				18	
	"R",		//	'rR'				19	
	"T",		//	'tT'				20	
	"Y",		//	'yY'				21	
	"U",		//	'uU'				22	
	"I",		//	'iI'				23	
	"O",		//	'oO'				24	
	"P",		//	'pP'				25	
	"[",		//	'[{'				26	
	"]",		//	']}'				27	
	"Ret",		//	Return				28	
	"Lctrl",	//	Left Control			29	
	"A",		//	'aA'				30	
	"S",		//	'sS'				31	
	"D",		//	'dD'				32	
	"F",		//	'fF'				33	
	"G",		//	'gG'				34	
	"H",		//	'hH'				35	
	"J",		//	'jJ'				36	
	"K",		//	'kK'				37	
	"L",		//	'lL'				38	
	";",		//	';:'				39	
	"'",		//	''@'				40	
	"'",		//	''@'				41	
	"Lshft",	//	Left Shift			42	
	"#",		//	'~#'				43	
	"Z",		//	'zZ'				44	
	"X",		//	'xX'				45	
	"C",		//	'cC'				46	
	"V",		//	'vV'				47	
	"B",		//	'bB'				48	
	"N",		//	'nN'				49	
	"M",		//	'mM'				50	
	",",		//	',<'				51	
	".",		//	'.>'				52	
	"/",		//	'/?'				53	
	"Rshft",	//	Right Shift			54	
	"*",		//	KeyPad '*'			55	
	"Lalt",		//	Left Alt			56	
	"Space",	//	Space				57	
	"Caps",		//	Caps lock			58	
	"F1",		//	F1				59	
	"F2",		//	F2				60	
	"F3",		//	F3				61	
	"F4",		//	F4				62	
	"F5",		//	F5				63	
	"F6",		//	F6				64	
	"F7",		//	F7				65	
	"F8",		//	F8				66	
	"F9",		//	F9				67	
	"F10",		//	F10				68	
	"NumLck",	//	Numlock				69	
	"Scroll",	//	Scroll lock			70	
	"kp7",		//	Keypad '7'			71	
	"kp8",		//	Keypad '8'			72	
	"kp9",		//	Keypad '9'			73	
	"kp-",		//	Keypad '-'			74	
	"kp4",		//	Keypad '4'			75	
	"kp5",		//	Keypad '5'			76	
	"kp6",		//	Keypad '6'			77	
	"kp+",		//	Keypad '+'			78	
	"kp1",		//	Keypad '1'			79	
	"kp2",		//	Keypad '2'			80	
	"kp3",		//	Keypad '3'			81	
	"kp0",		//	Keypad '0'			82	
	"kp.",		//	Keypad '.'			83	
	"?1",		//	?				84	
	"?2",		//	?				85	
	"\\",		//	?				86	
	"F11",		//	?				87	
	"F12",		//	?				88	
	"?6",		//	?				89	
	"?7",		//	?				90	
	"?8",		//	?				91	
	"?9",		//	?				92	
	"?10",		//	?				93	
	"?11",		//	?				94	
	"?12",		//	?				95	
	"?13", 		//	?				96	
	"?14",		//					97	
	"?15",		//					98	
	"?16",		//					99	
	"?17",		//					100
	"?18",		//					101
	"?19",		//					102
	"?20",		//					103
	"?21",		//					104
	"?22",		//					105
	"?23",		//					106
	"?24",		//					107
	"?25",		//					108
	"?26",		//					109
	"?27",		//					110
	"?28",		//					111
	"?29",		//					112
	"?30",		//					113
	"?31",		//					114
	"?32",		//					115
	"?33",		//					116
	"?34",		//					117
	"?35",		//					118
	"?36",		//					119
	"?37",		//					120
	"?38",		//					121
	"?39",		//					122
	"?40",		//					123
	"?41",		//					124
	"?42",		//					125
	"?43",		//					126
	"?44",		//					127
	"?45",		//					128
	"?46",		//					129
	"?47",		//					130
	"?48",		//					131
	"?49",		//					132
	"?50",		//					133
	"?51",		//					134
	"?52",		//					135
	"?53",		//					136
	"?54",		//					137
	"?55",		//					138
	"?56",		//					139
	"?57",		//					140
	"?58",		//					141
	"?59",		//					142
	"?60",		//					143
	"?61",		//					144
	"?62",		//					145
	"?63",		//					146
	"?64",		//					147
	"?65",		//					148
	"?66",		//					149
	"?67",		//					150
	"?68",		//					151
	"?69",		//					152
	"?70",		//					153
	"?71",		//					154
	"?72",		//					155
	"kpEnt",	//					156
	"Rctrl",	//					157
	"?75",		//					158
	"?76",		//					159
	"?77",		//					160
	"?78",		//					161
	"?79",		//					162
	"?80",		//					163
	"?81",		//					164
	"?82",		//					165
	"?83",		//					166
	"?84",		//					167
	"?85",		//					168
	"?86",		//					169
	"",		//	SysReq				170 
	"?88",		//					171
	"?89",		//					172
	"?90",		//					173
	"?91",		//					174
	"?92",		//					175
	"?93",		//					176
	"?94",		//					177
	"?95",		//					178
	"?96",		//					179
	"?97",		//					180
	"kp/",		//					181
	"?99",		//					182
	"?100",		//					183
	"AltGr",	//					184
	"?102",		//					185
	"?103",		//					186
	"?104",		//					187
	"?105",		//					188
	"?106",		//					189
	"?107",		//					190
	"?108",		//					191
	"?109",		//					192
	"?110",		//					193
	"?111",		//					194
	"?112",		//					195
	"?113",		//					196
	"Break",	//					197
	"?115",		//					198
	"Home",		//					199
	"Up",		//					200
	"PgUp",		//					201
	"?119",		//					202
	"Left",		//					203
	"?121",		//					204
	"Right",	//					205
	"?123",		//					206
	"End",		//					207
	"Down",		//					208
	"PgDn",		//					209
	"Ins",		//					210
	"Del",		//					211
	"?129",		//					212
	"?130",		//					213
	"?131",		//					214
	"?132",		//					215
	"?133",		//					216
	"?134",		//					217
	"?135",		//					218
	"Lwin",		//					219
	"Rwin",		//					220
	"Start",	//					221
	"?139",		//					222
	"?140",		//					223
	"?141",		//					224
	"?142",		//					225
	"?143",		//					226
	"?144",		//					227
	"?145",		//					228
	"?146",		//					229
	"?147",		//					230
	"?148",		//					231
	"?149",		//					232
	"?150",		//					233
	"?151",		//					234
	"?152",		//					235
	"?153",		//					236
	"?154",		//					237
	"?155",		//					238
	"?156",		//					239
	"?157",		//					240
	"?158",		//					241
	"?159",		//					242
	"?160",		//					243
	"?161",		//					244
	"?162",		//					245
	"?163",		//					246
	"?164",		//					247
	"?165",		//					248
	"?166",		//					249
	"?167",		//					250
	"?168",		//					251
	"?169",		//					252
	"?170",		//					253
	"?171",		//					254
	"?172"		//					255
	};		


