#include	"z80.h"
#include	"main.h"
#include	"support.h"
#include 	"psg.h"
#include 	"8910intf.h"
#include	<string.h>
extern "C" 	
{
#include 	"YM2203.h"
#include	"c:\dev\ezgame\ezgame.h"
}
#include	<stdio.h>

#define SND_CLOCK 3072000	/* 3.072 Mhz */


void	YM2203_Update (void)
{
	if (YM2203_On)
		YM2203();
}

void	InitSoundRallyX (void)
{
	SoundEnabled=1;
	SoundChanged=0;
	EnableSounds(3,44100);
}


void	PengoUpdateSound (void)
{
int 	freq,volume,wave;
int 	voice;
static int	currwave[3] = { -1,-1,-1 };

	if (!SoundPermitted)
		return;

	if (SoundEnabled && SoundChanged)
		{
		SoundChanged=0;

		for (voice=0;voice<3;voice++)
			{
			freq = SoundRegs[0x14 + 5 * voice];	/* always 0 */
			freq = freq * 16 + SoundRegs[0x13 + 5 * voice];
			freq = freq * 16 + SoundRegs[0x12 + 5 * voice];
			freq = freq * 16 + SoundRegs[0x11 + 5 * voice];
			if (voice == 0)
				freq = freq * 16 + SoundRegs[0x10 + 5 * voice];
			else freq = freq * 16;

			freq = (SND_CLOCK / 2048) * freq / 512;

			volume = SoundRegs[0x15 + 5 * voice];
			volume = ((volume<<4)|volume);

			if (freq == 0)
				{
				freq = 1000;
				volume = 0;
				}

			wave = SoundRegs[0x05 + 5 * voice] & 7;
			if (wave != currwave[voice])
				{
				PlayActiveSample(voice,&GalagaSamples[wave * 32],32,freq,volume,1);
				currwave[voice] = wave;
				}
			else 		//osd_adjust_sample(voice,freq,volume);
				{
				ASetVoiceFrequency(Voice[voice],freq);
				ASetVoiceVolume(Voice[voice],(volume>>2)*VolumeLevel/100);
				}
			}
		}
}




void PlayActiveSample(int channel,char *data,int len,int freq,int volume,int loop)
{
	memcpy(lpWave[channel]->lpData,data,len);
	if (loop) lpWave[channel]->wFormat = AUDIO_FORMAT_8BITS | AUDIO_FORMAT_MONO | AUDIO_FORMAT_LOOP;
	else lpWave[channel]->wFormat = AUDIO_FORMAT_8BITS | AUDIO_FORMAT_MONO;

	lpWave[channel]->dwLoopStart = 0;
	lpWave[channel]->dwLoopEnd = len;
	lpWave[channel]->dwLength = len;

	//Volumi[channel] = volume/4;
	/* upload the data to the audio DRAM local memory */
	AWriteAudioData(lpWave[channel],0,len);
	APlayVoice(Voice[channel],lpWave[channel]);
	ASetVoiceFrequency(Voice[channel],freq);
	ASetVoiceVolume(Voice[channel],(volume>>2)*VolumeLevel/100);
}


void	InitSound1942 (void)
{
	// Get the sound library started
	AY8910_On=0;
	EnableSounds(2,44100);

	if (SoundPermitted)
		{
		// Init the sound emulator
		memset ((char *)&AYinterface,0,sizeof(AYINTF));
		memset ((char *)playing,0,sizeof(playing));
		memset ((char *)chn,0,sizeof(chn));
		AYinterface.num=2;
		AYinterface.clock=1500000000;
		AYinterface.volume[0]=255;
		AYinterface.volume[1]=255;

		PendingCommands = 0;

		// Get the AY8910 emulator started
		AY8910_On=AY8910_sh_start(&AYinterface)+1;	// 0-Failed, 1-Okay
		}
}


void	InitSoundGnG (void)
{
	// Get the sound library started
	YM2203_On=0;
	EnableSounds(2,44100);

	if (SoundPermitted)
		{
		// Init the sound emulator
  		BaseSb=0x220; /* Soundblaster OPL base port, at some compatibles this must be 0x388 */
  		DelayReg=4;  /* Delay after an OPL register write increase it to avoid problems ,but you'll lose speed */                          
  		DelayData=7; /* same as above but after an OPL data write this usually is greater than above */
  		InitYM();    /* inits OPL in mode OPL3 and 4ops per channel,also reset YM2203 registers */

		PendingCommands = 0;
		YM2203_On=1;
		}
}




void	MrDoInitSound (void)
{
int		x;

	EnableSounds(6,44100);
	if (SoundPermitted)
		{
		for (x=0;x<6;x++)
			{
			SoundWaves[x]=CreateCrapSineWave(44100,32);
			if (SoundWaves[x])
				{
				APlayVoice(Voice[x],SoundWaves[x]);
				ASetVoiceFrequency(Voice[x],1000);
				ASetVoiceVolume(Voice[x],0);
				}
			}
		}
}



void	MrDoChangeSound (int Voice,int Value)
{
static int lasttone[2];


	sound_changed = 1;

	if (Value & 0x80)
		{
		switch ((Value >> 4)& 0x07)
			{
			case 0x0:
				freqlo[3*Voice+0] = Value & 0x0f;
				lasttone[Voice] = 0;
				break;
			case 0x1:
				vol[3*Voice+0] = 0x0f - (Value & 0x0f);
				break;
			case 0x2:
				freqlo[3*Voice+1] = Value & 0x0f;
				lasttone[Voice] = 1;
				break;
			case 0x3:
				vol[3*Voice+1] = 0x0f - (Value & 0x0f);
				break;
			case 0x4:
				freqlo[3*Voice+2] = Value & 0x0f;
				lasttone[Voice] = 2;
				break;
			case 0x5:
				vol[3*Voice+2] = 0x0f - (Value & 0x0f);
				break;
			case 0x6:
				break;
			case 0x7:
				break;
			}
		}
	else
		freqhi[3*Voice+lasttone[Voice]] = Value & 0x3f;
}





void	InvadersInitSound (void)
{
int		x;
char	Name[64];

	EnableSounds(10,11025);
	if (SoundPermitted)
		{
		for (x=0;x<9 && SoundPermitted;x++)
			{
			sprintf (Name,"SAMPLES\\INVADER%i.WAV",x+1);
			if (ALoadWaveFile(Name,&(SoundWaves[x]),0))
				{
				SoundPermitted=FALSE;
				}
			}
		SoundWaves[UFO]->dwLoopStart=0;
		SoundWaves[UFO]->dwLoopEnd=SoundWaves[UFO]->dwLength;
		SoundWaves[UFO]->wFormat|=AUDIO_FORMAT_LOOP;
		}
}


void	CrestaInitSound (void)
{
	EnableSounds(2,44100);
	if (SoundPermitted)
		{
		SoundWaves[0]=CreateCrapSineWave(44100,32);
		SoundWaves[1]=CreateWhiteNoise(44100,sizeof(WhiteNoise));
		if (SoundWaves[0])
			{
			APlayVoice(Voice[0],SoundWaves[0]);
			ASetVoiceFrequency(Voice[0],1000);
			ASetVoiceVolume(Voice[0],0);
			}
		if (SoundWaves[1])
			{
			APlayVoice(Voice[1],SoundWaves[1]);
			ASetVoiceFrequency(Voice[1],1000);
			ASetVoiceVolume(Voice[1],0);
			}
		}
}


void	CrestaChangeSound (int Freq)
{
	if (Freq && Freq!=255)
		ChangeSound(0,(1536000/16)/(256-Freq)*32,63);
	else
		ChangeSound(0,1000,0);
}



void	ChangeSound (int voice,int Freq,int Vol)
{
	if (SoundPermitted)
		{
		ASetVoiceFrequency(Voice[voice],Freq);
		ASetVoiceVolume(Voice[voice],Vol*VolumeLevel/100);
		}
}



// Thanks to Nicola for this. Hopefully mixing this buffering
// with my interleaving, we should hear something pretty damn good :)

#define QUEUE_LENGTH 10

static int command_queue[QUEUE_LENGTH];


int 	SoundCommandLatchRead(int offset)
{
int		i,res;


	res = command_queue[0];

	if (PendingCommands > 0)
		{
		PendingCommands--;

		for (i = 0;i < PendingCommands;i++)
			command_queue[i] = command_queue[i+1];
		}

	return res;
}


int 	SoundCommandRead(int offset)
{
int		i,res;


	if (PendingCommands > 0)
		{
		res = command_queue[0];

		PendingCommands--;

		for (i = 0;i < PendingCommands;i++)
			command_queue[i] = command_queue[i+1];
		}
	else
		{
		res = 0;
		}

	return res;
}



void 	SoundCommandWrite(int offset,int data)
{
	if (PendingCommands < QUEUE_LENGTH)
		{
		command_queue[PendingCommands] = data;
		PendingCommands++;
		}
}


