#define		SUPPORT
extern "C"
{
#include	"c:\dev\ezgame\ezgame.h"
}
#include	"z80.h"
#include	"support.h"
#include	"main.h"
#include	"twkuser.h"
#include	<dos.h>
#include	<string.h>
#include	<conio.h>
#include	<stdio.h>
#include	<stdlib.h>
#include	<malloc.h>
#include	<process.h>
#include 	<math.h>


void	UpdateAudio (void)
{
	AUpdateAudio();
}

int		GetSoundChannel (void)
{
int		x,Stop;

	for (x=0;x<VoicesInUse;x++)
		{
		AGetVoiceStatus(Voice[x],&Stop);
		if (Stop)
			return (x);
		}
	return (-1);
}


void	EnableSounds (int Voices,int Freq)
{
int		x;
					   
	SoundPermitted=VoicesInUse=0;

	if (SoundCardToUse)
		{
    	if (!AInitialize() && Voices<32)
			{
    		AudioInfo.nDeviceId=SoundCardId[SoundCardToUse];
    		AudioInfo.wFormat=AUDIO_FORMAT_8BITS|AUDIO_FORMAT_MONO;
    		AudioInfo.nSampleRate=Freq;

			if (!AOpenAudio(&AudioInfo))
				{
		    	if (!AOpenVoices(Voices))
					{
			    	for (x=0;x<Voices;x++)
						{
        				if (ACreateAudioVoice(&Voice[x])) return;
        				if (ASetVoiceVolume(Voice[x],63*VolumeLevel/100)) return;
						if ((lpWave[x]=(LPAUDIOWAVE)malloc(sizeof(AUDIOWAVE)))==0) return;

						lpWave[x]->wFormat=AUDIO_FORMAT_8BITS|AUDIO_FORMAT_MONO;
						lpWave[x]->nSampleRate=Freq;
						lpWave[x]->dwLength=SAMPLE_BUFFER_LENGTH;
						lpWave[x]->dwLoopStart=lpWave[x]->dwLoopEnd = 0;

						if (ACreateAudioData(lpWave[x]))
							{
							free(lpWave[x]);
							return;
							}
						}
					VoicesInUse=Voices;
					SoundPermitted=1;
					}
				}
			}
		}
}


void	DisableSounds (void)
{
int		x;

	if (SoundPermitted)
		{
	    for (x=0;x<VoicesInUse;x++)
			{
	        AStopVoice(Voice[x]);
    	    ADestroyAudioVoice(Voice[x]);
			}
		ACloseVoices();
		ACloseAudio();
		SoundPermitted=0;
		}
}



void	SetModeQ (void)			// 256x256x256 with standard X/Y pixel addressing :)
{
Register 	*reg=0;
int 		reglen=0;

	if (Driver.SpecialMode==MODE_224)
		{
		ez_SetVideoMode(0x13);
		if (UseScanLines)
			{
			reg = Mode224x288scan;
			reglen = sizeof(Mode224x288scan)/sizeof(Register);
			}
		else
			{
			reg = Mode224x288;
			reglen = sizeof(Mode224x288)/sizeof(Register);
			}
		reg[0].value = (reg[0].value & 0xf3);// | (videofreq << 2);
		outRegArray(reg,reglen);
		ScreenWidth=224;
		ScreenHeight=288;
		}
	else
	if (Driver.SpecialMode==MODE_288)
		{
		ez_SetVideoMode(0x13);
		if (UseScanLines)
			{
			reg = Mode288x224scan;
			reglen = sizeof(Mode288x224scan)/sizeof(Register);
			}
		else
			{
			reg = Mode288x224;
			reglen = sizeof(Mode288x224)/sizeof(Register);
			}
		reg[0].value = (reg[0].value & 0xf3);// | (videofreq << 2);
		outRegArray(reg,reglen);
		ScreenWidth=288;
		ScreenHeight=224;
		}
	else
		{
		ez_SetVideoMode(0x13);
		if (UseScanLines)
			{
			reg = ModeQscan;
			reglen = sizeof(ModeQscan)/sizeof(Register);
			}
		else
			{
			reg = ModeQ;
			reglen = sizeof(ModeQ)/sizeof(Register);
			}
		reg[0].value = (reg[0].value & 0xf3);// | (videofreq << 2);
		outRegArray(reg,reglen);
		ScreenWidth=256;
		ScreenHeight=256;
		}
}



void VGAoutp (VGAData r)
{
	switch (r.port)
	{
		/* First handle special cases: */

		case ATTRCON_ADDR:
			inp(STATUS_ADDR);  				/* reset r/w flip-flop */
			outp(ATTRCON_ADDR, r.index | 0x20);
														/* ensure VGA output is enabled */
			outp(ATTRCON_ADDR, r.value);
			break;

		case MISC_ADDR:
		case VGAENABLE_ADDR:
			outp(r.port, r.value);			/*	directly to the port */
			break;

		case SEQ_ADDR:
		case GRACON_ADDR:
		case CRTC_ADDR:
		default:										/* This is the default method: */
			outp(r.port, r.index);			/*	index to port			   */
			outp(r.port+1, r.value);		/*	value to port+1 		   */
			break;
	}

}

#define WAVE_AMPLITUDE 70

LPAUDIOWAVE	CreateWhiteNoise (int SampleRate,int Freq)
{
LPAUDIOWAVE lpWave;
int			x;
float		s;

	if ((lpWave=(LPAUDIOWAVE)malloc(sizeof(AUDIOWAVE)))!=NULL) 
		{
		lpWave->wFormat=AUDIO_FORMAT_8BITS|AUDIO_FORMAT_MONO|AUDIO_FORMAT_LOOP;
		lpWave->nSampleRate=SampleRate;
		lpWave->dwLoopStart=0;
		lpWave->dwLoopEnd=Freq;
		lpWave->dwLength=Freq;
		if (ACreateAudioData(lpWave)!=AUDIO_ERROR_NONE)
			{
			free(lpWave);
			return NULL;
			}
		for (x=0;x<Freq;x++)
			lpWave->lpData[x]=(rand()%(2*WAVE_AMPLITUDE))-WAVE_AMPLITUDE;

		AWriteAudioData(lpWave,0L,Freq);
		return (lpWave);
		}
	return (NULL);
}


LPAUDIOWAVE	CreateCrapSineWave (int SampleRate,int Freq)
{
LPAUDIOWAVE lpWave;
int			x;
float		s;

	if ((lpWave=(LPAUDIOWAVE)malloc(sizeof(AUDIOWAVE)))!=NULL) 
		{
		lpWave->wFormat=AUDIO_FORMAT_8BITS|AUDIO_FORMAT_MONO|AUDIO_FORMAT_LOOP;
		lpWave->nSampleRate=SampleRate;
		lpWave->dwLoopStart=0;
		lpWave->dwLoopEnd=Freq;
		lpWave->dwLength=Freq;
		if (ACreateAudioData(lpWave)!=AUDIO_ERROR_NONE)
			{
			free(lpWave);
			return NULL;
			}
		memcpy(lpWave->lpData,SineWave,Freq);
		AWriteAudioData(lpWave,0L,Freq);
		return (lpWave);
		}
	return (NULL);
}


LPAUDIOWAVE	CreateSineWave (int SampleRate,int Freq)
{
LPAUDIOWAVE lpWave;
int			x;
float		s;

	if ((lpWave=(LPAUDIOWAVE)malloc(sizeof(AUDIOWAVE)))!=NULL) 
		{
		lpWave->wFormat=AUDIO_FORMAT_8BITS|AUDIO_FORMAT_MONO|AUDIO_FORMAT_LOOP;
		lpWave->nSampleRate=SampleRate;

		lpWave->dwLoopStart=0;
		lpWave->dwLoopEnd=Freq;
		lpWave->dwLength=Freq;
		if (ACreateAudioData(lpWave)!=AUDIO_ERROR_NONE)
			{
			free(lpWave);
			return NULL;
			}
		// Create the wave
		for (x=0;x<Freq;x++)
			{
			s=sin(2*3.14159/Freq*(x+1))*128+128;
			AudioBuffer[x]=s;
			}

		memcpy(lpWave->lpData,AudioBuffer,Freq);
		AWriteAudioData(lpWave,0L,Freq);
		return (lpWave);
		}
	return (NULL);
}



void	AccurateVsync (void)
{
	FrameRateCounter++;

	if (!SyncEnabled)
		return;

	if (UseAccurateVsync || UseScanLines || FrameRateTotal<MIN_REFRESH)
		{
		while (!VsyncTicks);
		VsyncTicks=0;
		}
	else
		ez_VidSync();
}



void	BlitScreen (void)
{
char	Text[32];
int		t,l,b,r,x,lx;
int		Pause=0,V;

	t=prv_ClipT;
	l=prv_ClipL;
	b=prv_ClipB;
	r=prv_ClipR;

	if (ShowFPS)
		{
		sprintf (Text,"@C[%03i]FPS:%i\0",Driver.TextColour,FrameRateTotal);
		ez_PointScreenAtBuffer (ScreenBmp,ScreenWidth,ScreenHeight);
		ez_PrintText (Text,0,FONT_CENTER,ScreenWidth>>1,50,EZ_NO_CLIP);
		ShowFPS--;
		}

	if (MethodMsgTimer)
		{
		sprintf (Text,"@C[%03i]%s\0",Driver.TextColour,UseAccurateVsync?"Accurate Speed":"Smooth Update");
		ez_PointScreenAtBuffer (ScreenBmp,ScreenWidth,ScreenHeight);
		ez_PrintText (Text,0,FONT_CENTER,ScreenWidth>>1,80,EZ_NO_CLIP);
		MethodMsgTimer--;
		}

	if (SyncMsgTimer)
		{
		sprintf (Text,"@C[%03i]%s\0",Driver.TextColour,SyncEnabled?"SYNC Enabled":"SYNC Disabled");
		ez_PointScreenAtBuffer (ScreenBmp,ScreenWidth,ScreenHeight);
		ez_PrintText (Text,0,FONT_CENTER,ScreenWidth>>1,110,EZ_NO_CLIP);
		SyncMsgTimer--;
		}

	if (VolumeTimer)
		{
		V=VolumeLevel;
		if (V<5) V=0;
		sprintf (Text,"@C[%03i]Volume %i%%\0",Driver.TextColour,V);
		ez_PointScreenAtBuffer (ScreenBmp,ScreenWidth,ScreenHeight);
		ez_PrintText (Text,0,FONT_CENTER,ScreenWidth>>1,150,EZ_NO_CLIP);
		VolumeTimer--;
		}


	// Regular joystick update may as well go here
	ez_ReadJoysticks (&Joy1,&Joy2);

	// Wait for appropriate sync interval, or not as the case maybe
	AccurateVsync();

	if (UpdatePal)
		{
		// Any games that change the palette, do it here in the vsync if there is one available
		UpdatePal=0;
		lx=1000;
		for (x=0;x<256;x++)
			{
			if (PalUpD[x])
				{
				// R,G or B has changed for this palette entry
				PalUpD[x]=0;

				// Only set the write address if not sequential - this takes ages so don't do it if not needed.
				if (lx!=x-1)
					outp(0x3c8,x);			// Select palette index to update

				// Wap out the RGB value (0-63)
				outp(0x3c9,Palette[x*3+2]);	// Sequential palette DAC write
				outp(0x3c9,Palette[x*3+3]);	// Sequential palette DAC write
				outp(0x3c9,Palette[x*3+4]);	// Sequential palette DAC write
				lx=x;
				}
			}
		ez_ClearMem((char *)PalUpD,sizeof(PalUpD));
		}

	if (ez_KeyPressed[SC_P] || ez_KeyPressed[SC_F4])
		{
		Pause=1;
		sprintf (Text,"@C[%03i]%s\0",Driver.TextColour,"PAUSED");
		ez_PointScreenAtBuffer (ScreenBmp,ScreenWidth,ScreenHeight);
		ez_PrintText (Text,0,FONT_CENTER,ScreenWidth>>1,130,EZ_NO_CLIP);
		}

	// Swatch ScreenBmp containing the game screen onto the PC video card. Yes all these dodgy modes are in proper addressing style - none of this ModeX shite :)
	if (Driver.SpecialMode==MODE_288)
		ez_CopyMem ((char *)0xa0000,ScreenBmp,288*224);
	else
	if (Driver.SpecialMode==MODE_224)
		ez_CopyMem ((char *)0xa0000,ScreenBmp,224*288);
	else
		ez_CopyMem ((char *)0xa0000,ScreenBmp,256*256);

	if (Pause)
		{
		ez_WaitForNoKeys();
		ez_ReadLastKey();
		Pause=0;
		}

	ez_SetClippingRectangle (l,t,r,b);
}


void	MY_CloseDown (void)
{
	DisableSounds();
	ez_CloseDown();
}






void PlayStreamedSample (int channel,unsigned char *data,int len,int freq,int volume)
{

	if (!SoundPermitted || channel>=VoicesInUse)
		return;

  	ASetVoiceVolume(Voice[channel],volume/4*VolumeLevel/100);

	if (!playing[channel])
		{
		memcpy(lpWave[channel]->lpData,data,len);
		lpWave[channel]->wFormat = AUDIO_FORMAT_8BITS | AUDIO_FORMAT_MONO | AUDIO_FORMAT_LOOP;
		lpWave[channel]->dwLoopStart = 0;
		lpWave[channel]->dwLoopEnd = 3*len;
		lpWave[channel]->dwLength = 3*len;
		/* upload the data to the audio DRAM local memory */
		AWriteAudioData(lpWave[channel],0,len);
		APlayVoice(Voice[channel],lpWave[channel]);
		ASetVoiceFrequency(Voice[channel],freq);
//		ASetVoiceVolume(Voice[channel],volume/4*VolumeLevel/100);
		playing[channel] = 1;
		chn[channel] = 1;
		}
	else
		{
		LONG pos;


		for(;;)
			{
			AGetVoicePosition(Voice[channel],&pos);
			if (chn[channel] == 0 && pos > len) break;
			if (chn[channel] == 1 && (pos < len || pos > 2*len)) break;
			if (chn[channel] == 2 && pos < 2*len) break;
			AUpdateAudio();
			}
		memcpy(&lpWave[channel]->lpData[len * chn[channel]],data,len);
		AWriteAudioData(lpWave[channel],len * chn[channel],len);
		chn[channel]++;
		if (chn[channel] == 3) chn[channel] = 0;
		}
}



void    BugCheck (int Line,char *Module)
{
	MY_CloseDown();
	ez_SetVideoMode(3);
	printf ("Trapped an assertion bug at line %i in module %s\n",Line,strupr(Module));
	puts ("\nPress a key");
	getch();
	exit (1);
}


void	InitStars (void)
{
// Thanks to Nicola Salmoria whose routine this is :)

int		x,y,generator=0x55,color,bit1,bit2;

	memset (Stars,0,sizeof(Stars));
	TotalStars=0;

	for (x=ScreenWidth-1;x>=0;x--)
		{
		for (y=ScreenHeight*2-1;y>=0;y--)
			{
			generator<<=1;
			bit1=(~generator>>17)&1;
			bit2=(generator>>5)&1;

			if (bit1^bit2) 
				generator|=1;

			if (x>=Driver.LeftEdge && x<=Driver.RightEdge && ((~generator>>16)&1) && (generator&0xff)==0xff)
				{
				color=(~(generator>>8))%(Driver.StarCols);
				if (color && TotalStars<256)
					{
					Stars[TotalStars].x=x;
					Stars[TotalStars].y=y;
					Stars[TotalStars].col=Driver.DataCols+color;
					TotalStars++;
					}
				}
			}
		}
}


void	DrawStars (void)
{
// Thanks to Nicola Salmoria whose routine this is :)

int		offs,x,y,addon;

	if (PrintStars)
		{
		for (offs=0;offs<TotalStars;offs++)
			{
			x=Stars[offs].x;
			y=(Stars[offs].y+StarScroll/2)%(ScreenHeight-1);

			if (y<0) y+=ScreenHeight;
			if (((x&1)^((y>>4)&1)))
				{
				if (Driver.Game==GAME_SCRAMBLE)
					y=(Stars[offs].y)%(ScreenHeight-1);
				addon=(y*ScreenWidth)+x;
	  			if (!ScreenBmp[addon])
					ScreenBmp[addon]=Stars[offs].col;
				}
			}
		StarScroll++;
		}
}



