extern "C"
{
#include	"c:\emulator\seal\audio\include\audio.h"
}
#include	"8910intf.h"



#pragma WARNING 389 9
#pragma WARNING 14  9
#pragma WARNING 438 9

#undef	API
#ifdef	SAGE
#define	API
#else
#define	API	extern
#endif


#include "Z80.h"
#include "m6809.h"
#include "psg.h"

///////////////////////////////////////////
// PROTOTYPES


byte CPU_IN (byte Port);
void CPU_OUT (byte Port,byte Value);
unsigned CPU_RDMEM(dword A);
void CPU_WRMEM(dword A,byte V);
unsigned CPU_Interrupt(void);
unsigned Z80_READOP (dword A);
void CPU_QUICKWRITE (dword A,byte V);

void	cpu_writemem (int Addr,int Value);
int	RunEmulation (int Game);
void	RunTheBoards (void);
int	LoadRoms (int Game);
void	FillInDriverDetails (int Game);
void	CrestaInitSound (void);
void	CrestaTranslateROM (void);
int	ResetMachine (void);
void	InitStars (void);
void	DrawStars (void);
void	CrestaSetPalette (void);
int	CrestaInterrupt (void);
void	CrestaScreenUpdate (void);
void	Hflip (char *Data);
void	Vflip (char *Data);
void	CopyBlock (char *dst,char *src,int AddOn);
int	CrestaReadRam (int Addr);
void	CrestaWriteRam (int Addr,char Value);
void	CrestaChangeSound (int Freq);
void	ChangeSound (int voice,int Freq,int Vol);
int	GalaxianReadMemory (int Addr);
void	GalaxianWriteRam (int Addr,char Value);
int  	GalaxianReadRam (int Addr);
void	GalaxianScreenUpdate (void);
void	GalaxianSetPalette (void);
void	InvadersSetPalette (void);
int 	InvadersInterrupt (void);
void	InvadersWriteRam (int Addr,char Value);
void	InvadersOutPort (char Port,char Value);
int	InvadersInPort (char Port);
void	InvadersInitSound (void);
void	PhoenixSetPalette (void);
void	PhoenixTranslateROM (void);
int	PhoenixInterrupt (void);
void	PhoenixScreenUpdate (void);
void	PhoenixWriteRam (int Addr,char Value);
int	PhoenixReadRam (int Addr);
void	DecodePhROM (int RomA,int RomB,int Index);
int	FirebirdInterrupt (void);
void	FirebirdScreenUpdate (void);
int 	FirebirdInPort (char Port);
void	FirebirdOutPort (char Port,char Value);
void	FirebirdTranslateROM (void);
void	ScrambleScreenUpdate (void);
int	ScrambleReadRam (int Addr);
int 	MrDoReadRam (int Addr);
void	MrDoSetPalette (void);
int	MrDoInterrupt (void);
void	MrDoScreenUpdate (void);
void	MrDoTranslateROM (void);
void	MrDoWriteRam (int Addr,char Value);
void	MrDoChangeSound (int Voice,int Value);
void	MrDoInitSound (void);
int	Interrupt1942 (void);
void	WriteRam1942 (int Addr,char Value);
void	TranslateROM1942 (void);
void	ScreenUpdate1942 (void);
int	ReadRam1942 (int Addr);
void 	SoundCommandWrite(int offset,int data);
int 	SoundCommandRead(int offset);
int 	SoundCommandLatchRead(int offset);
void 	AY8910_Update(void);
void	InitSound1942 (void);
void	SetPalette1942 (void);
int	CommandoReadRam (int Addr);
void	CommandoWriteRam (int Addr,char Value);
void	CommandoScreenUpdate (void);
void	CommandoTranslateROM (void);
int 	CommandoInterrupt (void);
void	CommandoSetPalette (void);
int  	ExedReadRam (int Addr);
void	ExedScreenUpdate (void);
void	ExedTranslateROM (void);
int	GalagaReadRam (int Addr);
void	GalagaWriteRam (int Addr,char Value);
void	GalagaSetPalette (void);
void 	GalagaCustomIOwrite (int offset,int data);
int 	GalagaInterrupt (void);
int	GalagaReadInputs (int Port);
void	GalagaScreenUpdate (void);
void	GalagaTranslateROM (void);
void	GNGTranslateROM (void);
void	GNGSetPalette (void);
int 	GNGInterrupt (void);
void	GNGScreenUpdate (void);
int	GNGReadRam (int Addr);
void	GNGWriteRam (int Addr,char Value);
void	InitSoundRallyX (void);
void	PengoUpdateSound (void);
void 	PlayActiveSample(int channel,char *data,int len,int freq,int volume,int loop);
void	InitSoundGnG (void);
void	YM2203_Update (void);









///////////////////////////////////////////
// DEFINES

#define	FALSE		0
#define	TRUE		(!FALSE)
#define	NUM_ROMS	24		// Number of spaces in ROM listings
#define	NUM_PROC	8		// Maximum number of processors/memory banks


#define	CPU_Z80		1
#define	CPU_Z80S	2
#define	CPU_6809	3


#define	LOAD_PROC1	1
#define	LOAD_PROC2	2
#define	LOAD_PROC3	3
#define	LOAD_PROC4	4
#define	LOAD_PROC5	5
#define	LOAD_PROC6	6
#define	LOAD_PROC7	7
#define	LOAD_PROC8	8
#define	LOAD_GFX	9



#define	MODE_256	0		// This mode *MUST* be zero
#define	MODE_288	1
#define	MODE_224	2

///////////////////////////////////////////
// ENUMERATIONS


enum	{
	ERROR_NONE,
	ERROR_NO_ROMS,
	ERROR_MUST_BE_A_BUG,
	ERROR_OUT_OF_MEMORY
	};


enum	{
	GAME_1942,	
	GAME_COMMANDO,	
	GAME_EXED,	
	GAME_GALAGA,	
	GAME_GNG,	
	GAME_SUPER_INVASION,	
	GAME_GALAXIAN_MIDWAY,
	GAME_GALAXIAN_NAMCO,
	GAME_GALAXIAN_PART_1,
	GAME_GALAXIAN_PART_4,
	GAME_GALAXIAN_TURBO,	
	GAME_GALAXY_WARS,	
	GAME_INVADERS_DELUXE,	
	GAME_INVADERS_REVENGE,
	GAME_LUNAR_RESCUE,	
	GAME_CRESTA,
	GAME_MRDO,
	GAME_MRLO,
	GAME_PHOENIX,
	GAME_PISCES,		
	GAME_PLEIADES,
	GAME_SCRAMBLE,
	GAME_SPACE_ATTACK,	
	GAME_FIREBIRD,
	GAME_SUPER_GALAXIAN,	
	GAME_SPACE_INVADERS,	
	GAME_JAPIREM,		
	GAME_WAR_OF_THE_BUGS,
	};






///////////////////////////////////////////
// STRUCTURES

typedef struct
	{
	int	Xc;
	int	Yc;
	int	Col;
	int	Chr;
	} OLDSP;

typedef struct
	{
	int	x;
	int	y;
	int	col;
	} STAR;

typedef struct
	{
	char	*Name;
	int	LoadAddr;
	int	Size;
	int	Dest;
	int	Present;
	} ROM;

typedef struct
	{
	char	*GameName;
	char	*CliName;
	int	GameCode;
	ROM	Rom[NUM_ROMS];
	int	RomsPresent;
	} GAMES;

typedef struct
	{
	int	Type;				// Processor type code
	int	Speed;				// Clock-speed
	int	RomStart1;			// Start of primary ROM area
	int	RomEnd1;  			// End of primary ROM area
	int	RomStart2;			// Start of secondary ROM area
	int	RomEnd2;  			// End of secondary ROM area
	int	ICount;				// Keeps track of the processor speed
	int	IntSplit;			// Divide up processing into this many chunks
	} PRC;

typedef struct
	{
	PRC	Proc[NUM_PROC];			// Processor details
	int	Game;				// Games ID code
	int	FrameRate;			// Desired frame rate for the game
	int	DataCols;			// Number of palette entries for character data
	int	StarCols;			// Number of palette entries for starfields
	int	TopEdge;			// Visible screen area
	int	BottomEdge;			// Visible screen area
	int	LeftEdge;			// Visible screen area
	int	RightEdge;			// Visible screen area
	int	NMIflagAddr;			// Position in memory where the NMI_ON address is
	int	ScreenBase;			// Some games use this to index into the sprite tables
	int	StarsOn;			// Address write to trap the stars activation on
	int	TotalChars;			// Number of characters used in the game
	int	TotalSprites;			// Number of sprites used in the game
	int	TotalTiles;			// Number of tiles (for Capcom games etc...)
	int	TotalPalettes;			// Number of palette variations in the game
	int	ReadPort1S;			// Address of first controller port read
	int	ReadPort1E;			// Address of first controller port read
	int	ReadPort2S;			// Address of second controller port read
	int	ReadPort2E;			// Address of second controller port read
	int	ReadPort3S;			// Address of third controller port read
	int	ReadPort3E;			// Address of third controller port read
	int	ReadPort4S;			// Address of fourth controller port read
	int	ReadPort4E;			// Address of fourth controller port read
	int	SoundAddr;			// Address of sound updates for some games
	int	TextColour;			// Palette index for text such as FPS counter
	int	SpecialMode;			// Non-zero if special case video-mode required
	char	*Palette;			// Pointer to initial palette to use in translating to a PC one
	char	*StarPal;			// As above, but for the starfield
	char	*ColourTable; 			// Pointer to colour table to use in translating to a PC one
	void	(*fn_InitSound)(void);		// Function to call for Sound initialistion
	void	(*fn_ChangeSound)(int); 	// Function to call for Sound initialistion
	void	(*fn_Translate)(void);		// Function to translate the GFX ROMs
	void	(*fn_SetPalette)(void);		// Function to decode and set the palette
	int	(*fn_Interrupt)(void);		// What to do in the Z80_Interrupt
	void	(*fn_ScreenUpdate)(void);	// What to do to actually draw the screen - usually called from interrupt
	void	(*fn_WriteRam)(int,char); 	// RAM writes aren't very generic, so get there own little routine. Isn't that sweet
	int	(*fn_ReadRam)(int); 		// RAM reads aren't very generic, so get there own little routine. Isn't that sweet
	int	(*fn_InPort)(char); 		// Port functions - IN
	void	(*fn_OutPort)(char,char); 	// Port functions - OUT
	void	(*fn_UpdateSound)(void); 	// Frame-based sound update
	} DRV;



///////////////////////////////////////////
// GLOBALS 


int	API	SoundCardToUse;			// 
int	API	Player1Up;			// 
int	API	Player1Down;			//
int	API	Player1Left;			//
int	API	Player1Right;			//
int	API	Player1Fire1;			//
int	API	Player1Fire2;			//
int	API	Player1Fire3;			//
int	API	Player2Up;			// - SYSTEM DEFAULTS AS SET UP IN THE FRONT-END
int	API	Player2Down;			//
int	API	Player2Left;			//
int	API	Player2Right;			//
int	API	Player2Fire1;			//
int	API	Player2Fire2;			//
int	API	Player2Fire3;			//
int	API	UseJoySticks;			//
int	API	UseAccurateVsync;		//
int	API	UseScanLines;			//

int 	API	Z80_IPeriod;			// For the Z80 emulator	
int 	API	Z80_ICount;			// For the Z80 emulator
int	API	m6809_IPeriod;			// For the 6809 emulator
int	API	m6809_ICount;			// For the 6809 emulator
char	API	WhiteNoise[8192];

int	API	CPU_IntSplit;			// Which sub-ointerrupt are we on
Z80_Regs API 	R;				// For the Z80 emulator
Z80_Regs API	Z80r[NUM_PROC];			// Enough space for ALL processors of each flavour
m6809_Regs API	m6809r[NUM_PROC];		// Enough space for ALL processors of each flavour
char	API	TempChars[0x38000];		// Room to load in graphics ROMs for further post-processing
char	API	RomSpace[NUM_PROC][65536*2];  	// Full address space of Z80
char	API	RamSpace[65536];  		// Full address space of Z80
int	API	Execute[NUM_PROC];  		// Don't execute this processor if non-zero
char	API	*RAM;				// Pointer to the current RAM space that processors are executing in
char	API	CharData[1024][16][64];		// Draw ready translated chars go here (16 palette variations, 512 maximum chars, 64 bytes each (8x8))
char	API	SpriteData[1024][16][16*16];  	// Draw ready translated chars go here (16 palette variations, 128 maximum sprts(+4 flips), 256 bytes each (16x16))
DRV	API	Driver;				// Keep all this shit together in one neat structure
STAR	API	Stars[256];			// Storage for pre-initialised starfield
char	API	PaletteA[64*3],PaletteB[64*3];	// For Phoenix/Pleiades
int	API	PrintStars,StarScroll,TotalStars;//Used for controlling the starfield
int	API	SyncEnabled;			// Flag asking for video-sync or not
int	API	ShowFPS;			// Flag asking to show the current frame-rate or not
int	API	BankFlag;			// Some machines use sprite banking. This is it if so
int	API	FrameRate;			// This is a low-level-use copy of the value set in the driver
int	API	FrameRateCounter;		// This is for displaying the current frame rate if desired
int	API	Joy1,Joy2;			// Read joysticks into these
int	API	IntCount;			// Some games use this to toggle various interrupt calls
short	API	Bitmap,BitmapPrevious,ShiftValue;//Invaders games use these values in their port addressing routines
int 	API	SndPort3,SndPort5;		// And these do the sound for above
int	API	DipSwitchSYNC;			// Phoenix uses this
char	API	OldScroll,PaletteReg,OldPal;	// Phoenux again
int	API	ScrollHI,ScrollLO,ScrollReg;	// For split values of scroll registers
int	API	HScrollHI,HScrollLO,HScrollReg;	// For split values of scroll registers
int	API	TempScreenA[32*64];		// Dirty buffers for 2-plane games
int	API	TempScreenB[32*64];		// See above
int	API	SyncMsgTimer;			// Used to time the printing of the sync state changed message
int	API	MethodMsgTimer;			// Similar, used for the update method changed message
int	API	QuitReady;			// Set when 'ESC' is pressed
int	API	CurrentProc;			// Currently executing processor code
int	API	doRST;				// Global used by firebird and others
char	API	ColourTable[2048]; 		// Pointer to colour table to use in translating to a PC one
int 	API	sound_changed;			// Crap borrowed from MAME for MrDo and...
int 	API	freqlo[6],freqhi[6],vol[6];	// ...Ladybug
int	API	AY8910_On;			// Flag indicating that the AY8910 emulator is functional
int	API	YM2203_On;			// Flag indicating that the YM2203 emulator is functional
int	API	PaletteBank;			// For banked palettes
int 	API	PendingCommands;
char	API	*SpritePtr;			// Used when the sprite-data buffer is too small (and no colour remap in use)
AYINTF	API	AYinterface;
OLDSP	API	Old[96];
int	API	doNMI,TestDone;			// Galaga and others
int	API	IntEnable1,IntEnable2,IntEnable3;
int	API	VolumeLevel,VolumeTimer;
int	API	SoundChanged,SoundEnabled;
int	API	ROMPage;			// Marker for use in games that use paged ROMs
int	API	UpdatePal,PalUpD[256];		// Stuff for real-time palette updates
int	API	SoundRegs[32];			// Pengo sound regs etc...

AY8910	API	*AYPSG;		/* array of PSG's */
extern "C"{
unsigned char API RegistersYM[528];		// for the YM2203 emulator
}

volatile int API TickCount,FrameRateTotal,VsyncTicks;	// This stuff for low-level maintenance
LPAUDIOWAVE API	SoundWaves[16];			// Room for up to 16 sounds

extern "C"
{
char	API	*RemapPtr;			// Points to the colour table area in use
char 	API	ScreenBmp [288*288];		// This is the screen where ALL graphics are drawn into
char 	API	ScreenBmp1[288*288];		// This is available as a temporary scratchpad
char 	API	ScreenBmp2[288*288];		// This is available as a temporary scratchpad
char 	API	ScreenBmp3[512*512];		// This is available as a temporary scratchpad
extern char	*Palette;
}



#define	NUM_GAMES	33		// Number of entries in GAMES listing





char	API *ErrorString[]
#ifdef SAGE
={
	"No Errors",			// ERROR_NONE
	"Missing ROMS",			// ERROR_NO_ROMS
	"Can't happen - must be a bug",	// ERROR_MUST_BE_A_BUG
	"Out of Memory"		       	// ERROR_OUT_OF_MEMORY
}
#endif
;


GAMES	API Games[NUM_GAMES]
#ifdef SAGE
={
	{
	"HELP",
	"",
	-999,
	{
	{"",0,0,0}
	}
	},


	{
	"SOUND SETUP",
	"",
	-998,
	{
	{"",0,0,0}
	}
	},

	{
	"CHANGE GAME KEYS",
	"",
	-997,
	{
	{"",0,0,0}
	}
	},

	{
	"OPTIONS",
	"",
	-996,
	{
	{"",0,0,0}
	}
	},

	{
	"CREDITS",
	"",
	-995,
	{
	{"",0,0,0}
	}
	},



	{
	"GALAGA",
	"GALAGA",
	GAME_GALAGA,
	{
	// MAIN GAME PROCESSORS
	{"GALAGABL\\GALAGABL.1_1",0x0000,0x1000,LOAD_PROC1},
	{"GALAGABL\\GALAGABL.1_2",0x1000,0x1000,LOAD_PROC1},
	{"GALAGABL\\GALAGABL.1_3",0x2000,0x1000,LOAD_PROC1},
	{"GALAGABL\\GALAGABL.1_4",0x3000,0x1000,LOAD_PROC1},

	{"GALAGABL\\GALAGABL.1_5",0x0000,0x1000,LOAD_PROC2},

	{"GALAGABL\\GALAGABL.1_7",0x0000,0x1000,LOAD_PROC3},

	// GRAPHICS DATA
	{"GALAGABL\\GALAGABL.1_8",0x0000,0x1000,LOAD_GFX},
	{"GALAGABL\\GALAGABL.1_a",0x1000,0x1000,LOAD_GFX},
	{"GALAGABL\\GALAGABL.1_9",0x2000,0x1000,LOAD_GFX},
	{"",0,0}
	}
	},





	{
	"GHOSTS'n'GOBLINS",
	"GNG",
	GAME_GNG,
	{
	// MAIN GAME PROCESSOR
	{"GNG\\GG4.BIN", 0x04000,0x4000,LOAD_PROC1},
	{"GNG\\GG3.BIN", 0x08000,0x8000,LOAD_PROC1},

	// 4 PAGES OF 8192
	{"GNG\\GG5.BIN", 0x10000,0x8000,LOAD_PROC1},
	{"GNG\\GG4.BIN", 0x18000,0x2000,LOAD_PROC1},

	// SOUND PROCESSOR
	{"GNG\\GG2.BIN", 0x00000,0x8000,LOAD_PROC2},

	// GRAPHICS DATA
	{"GNG\\GG1.BIN", 0x00000,0x4000,LOAD_GFX},					// Window graphics (8x8)
	{"GNG\\GG11.BIN",0x04000,0x4000,LOAD_GFX},					// Background 1 Plane 0
	{"GNG\\GG10.BIN",0x08000,0x4000,LOAD_GFX},					// Background 2 Plane 0
	{"GNG\\GG9.BIN", 0x0c000,0x4000,LOAD_GFX},					// Background 1 Plane 1
	{"GNG\\GG8.BIN", 0x10000,0x4000,LOAD_GFX},					// Background 2 Plane 1
	{"GNG\\GG7.BIN", 0x14000,0x4000,LOAD_GFX},				// Background 1 Plane 2
	{"GNG\\GG6.BIN", 0x18000,0x4000,LOAD_GFX},				// Background 2 Plane 2
	{"GNG\\GG17.BIN",0x1c000,0x4000,LOAD_GFX},	// Sprites 1 Plane 0/1
	{"GNG\\GG16.BIN",0x20000,0x4000,LOAD_GFX},	// Sprites 2 Plane 0/1
	{"GNG\\GG15.BIN",0x24000,0x4000,LOAD_GFX},	// Sprites 3 Plane 0/1
	{"GNG\\GG14.BIN",0x28000,0x4000,LOAD_GFX},	// Sprites 1 Plane 2/3
	{"GNG\\GG13.BIN",0x2c000,0x4000,LOAD_GFX},	// Sprites 2 Plane 2/3
	{"GNG\\GG12.BIN",0x30000,0x4000,LOAD_GFX},	// Sprites 3 Plane 2/3
	{"",0,0}
	}
	},



	{
	"EXED EXES",
	"EXED",
	GAME_EXED,
	{
	// MAIN GAME PROCESSOR
	{"EXED\\11M_EE04.BIN",0x00000,0x4000,LOAD_PROC1},
	{"EXED\\10M_EE03.BIN",0x04000,0x4000,LOAD_PROC1},
	{"EXED\\09M_EE02.BIN",0x08000,0x4000,LOAD_PROC1},

	// SOUND PROCESSOR
	{"EXED\\11E_EE01.BIN",0x0000,0x4000,LOAD_PROC2},

	// GRAPHICS DATA
	{"EXED\\05C_EE00.BIN",0x00000,0x2000,LOAD_GFX},	// 8K Character set
	{"EXED\\A02_EE05.BIN",0x02000,0x4000,LOAD_GFX},	// 
	{"EXED\\A03_EE06.BIN",0x06000,0x4000,LOAD_GFX},	// 
	{"EXED\\C01_EE07.BIN",0x0a000,0x4000,LOAD_GFX},	// 
	{"",0,0}
	}
	},





	{
	"COMMANDO",
	"COMMANDO",
	GAME_COMMANDO,
	{
	// MAIN GAME PROCESSOR
	{"COMMANDO\\M09_CM04.BIN",0x00000,0x8000,LOAD_PROC1},
	{"COMMANDO\\M08_CM03.BIN",0x08000,0x4000,LOAD_PROC1},

	// SOUND PROCESSOR
	{"COMMANDO\\F09_CM02.BIN",0x0000,0x4000,LOAD_PROC2},

	// GRAPHICS DATA
	{"COMMANDO\\D05_VT01.BIN",0x00000,0x4000,LOAD_GFX},	// Window graphics (8x8)
	{"COMMANDO\\A05_VT11.BIN",0x04000,0x4000,LOAD_GFX},	// Background 1 Plane 0
	{"COMMANDO\\A06_VT12.BIN",0x08000,0x4000,LOAD_GFX},	// Background 2 Plane 0
	{"COMMANDO\\A07_VT13.BIN",0x0c000,0x4000,LOAD_GFX},	// Background 1 Plane 1
	{"COMMANDO\\A08_VT14.BIN",0x10000,0x4000,LOAD_GFX},	// Background 2 Plane 1
	{"COMMANDO\\A09_VT15.BIN",0x14000,0x4000,LOAD_GFX},	// Background 1 Plane 2
	{"COMMANDO\\A10_VT16.BIN",0x18000,0x4000,LOAD_GFX},	// Background 2 Plane 2
	{"COMMANDO\\E07_VT05.BIN",0x1c000,0x4000,LOAD_GFX},	// Sprites 1 Plane 0/1
	{"COMMANDO\\E08_VT06.BIN",0x20000,0x4000,LOAD_GFX},	// Sprites 2 Plane 0/1
	{"COMMANDO\\E09_VT07.BIN",0x24000,0x4000,LOAD_GFX},	// Sprites 3 Plane 0/1
	{"COMMANDO\\H07_VT08.BIN",0x28000,0x4000,LOAD_GFX},	// Sprites 1 Plane 2/3
	{"COMMANDO\\H08_VT09.BIN",0x2c000,0x4000,LOAD_GFX},	// Sprites 2 Plane 2/3
	{"COMMANDO\\H09_VT10.BIN",0x30000,0x4000,LOAD_GFX},	// Sprites 3 Plane 2/3
	{"",0,0}
	}
	},



	{
	"1942",
	"1942",
	GAME_1942,
	{
	// MAIN GAME PROCESSOR
	{"1942\\1-N3.BIN",0x00000,0x4000,LOAD_PROC1},
	{"1942\\1-N4.BIN",0x04000,0x4000,LOAD_PROC1},
	{"1942\\1-N5.BIN",0x08000,0x4000,LOAD_PROC1},
	{"1942\\1-N5.BIN",0x10000,0x4000,LOAD_PROC1},
	{"1942\\1-N6.BIN",0x14000,0x2000,LOAD_PROC1},
	{"1942\\1-N7.BIN",0x16000,0x4000,LOAD_PROC1},

	// SOUND PROCESSOR
	{"1942\\1-C11.BIN",0x0000,0x4000,LOAD_PROC2},

	// GRAPHICS DATA
	{"1942\\1-F2.BIN",0x00000,0x2000,LOAD_GFX},	// 8K Character set
	{"1942\\2-A5.BIN",0x02000,0x2000,LOAD_GFX},	// Tiles 1, plane 0
	{"1942\\2-A3.BIN",0x04000,0x2000,LOAD_GFX},	// Tiles 1, plane 1
	{"1942\\2-A1.BIN",0x06000,0x2000,LOAD_GFX},	// Tiles 1, plane 2
	{"1942\\2-A6.BIN",0x08000,0x2000,LOAD_GFX},	// Tiles 2, plane 0
	{"1942\\2-A4.BIN",0x0a000,0x2000,LOAD_GFX},	// Tiles 2, plane 1
	{"1942\\2-A2.BIN",0x0c000,0x2000,LOAD_GFX},	// Tiles 2, plane 2
	{"1942\\2-L1.BIN",0x0e000,0x4000,LOAD_GFX},	// Object 1 planes 1&2
	{"1942\\2-L2.BIN",0x12000,0x4000,LOAD_GFX},	// Object 1 planes 3&4
	{"1942\\2-N1.BIN",0x16000,0x4000,LOAD_GFX},	// Object 2 planes 1&2
	{"1942\\2-N2.BIN",0x1a000,0x4000,LOAD_GFX},	// Object 2 planes 3&4
	{"1942\\08E_SB-5.BIN",0x1e000,0x100,LOAD_GFX},	// Colour PROM - RED
	{"1942\\09E_SB-6.BIN",0x1e100,0x100,LOAD_GFX},	// Colour PROM - GREEN
	{"1942\\10E_SB-7.BIN",0x1e200,0x100,LOAD_GFX},	// Colour PROM - BLUE
	{"1942\\F01_SB-0.BIN",0x1e300,0x100,LOAD_GFX},	// LookUp - CHARS
	{"1942\\03K_SB-8.BIN",0x1e400,0x100,LOAD_GFX},	// LookUp - SPRITES
	{"1942\\06D_SB-4.BIN",0x1e500,0x100,LOAD_GFX},	// LookUp - TILES
	}
	},


	{
	"Mr DO",
	"MRDO",
	GAME_MRDO,
	{
	{"MRDO\\D1",0x0000,0x2000,LOAD_PROC1},
	{"MRDO\\D2",0x2000,0x2000,LOAD_PROC1},
	{"MRDO\\D3",0x4000,0x2000,LOAD_PROC1},
	{"MRDO\\D4",0x6000,0x2000,LOAD_PROC1},

	{"MRDO\\D9", 0x0000,0x1000,LOAD_GFX},
	{"MRDO\\D8", 0x1000,0x1000,LOAD_GFX},
	{"MRDO\\D10",0x2000,0x1000,LOAD_GFX},
	{"MRDO\\D7", 0x3000,0x1000,LOAD_GFX},
	{"MRDO\\D5", 0x4000,0x1000,LOAD_GFX},
	{"MRDO\\D6" ,0x5000,0x1000,LOAD_GFX},
	{"",0,0}
	}
	},


	{
	"Mr LO",
	"MRLO",
	GAME_MRLO,
	{
	{"MRLO\\A4-01.BIN",0x0000,0x2000,LOAD_PROC1},
	{"MRLO\\C4-02.BIN",0x2000,0x2000,LOAD_PROC1},
	{"MRLO\\E4-03.BIN",0x4000,0x2000,LOAD_PROC1},
	{"MRLO\\G4-04.BIN",0x6000,0x2000,LOAD_PROC1},

	{"MRLO\\S8-09.BIN",0x0000,0x1000,LOAD_GFX},
	{"MRLO\\R8-08.BIN",0x1000,0x1000,LOAD_GFX},
	{"MRLO\\U8-10.BIN",0x2000,0x1000,LOAD_GFX},
	{"MRLO\\N8-07.BIN",0x3000,0x1000,LOAD_GFX},
	{"MRLO\\H5-05.BIN",0x4000,0x1000,LOAD_GFX},
	{"MRLO\\K5-06.BIN",0x5000,0x1000,LOAD_GFX},
	{"",0,0}
	}
	},


	{
	"SPACE FIREBIRD",
	"FIREBIRD",
	GAME_FIREBIRD,
	{
	{"FB\\CPU\\5e",0x0000,0x0800,LOAD_PROC1},
	{"FB\\CPU\\5f",0x0800,0x0800,LOAD_PROC1},
	{"FB\\CPU\\5h",0x1000,0x0800,LOAD_PROC1},
	{"FB\\CPU\\5i",0x1800,0x0800,LOAD_PROC1},
	{"FB\\CPU\\5j",0x2000,0x0800,LOAD_PROC1},
	{"FB\\CPU\\5k",0x2800,0x0800,LOAD_PROC1},
	{"FB\\CPU\\5m",0x3000,0x0800,LOAD_PROC1},
	{"FB\\CPU\\5n",0x3800,0x0800,LOAD_PROC1},
	{"FB\\VID\\5k",0x0000,0x0800,LOAD_GFX},
	{"FB\\VID\\6k",0x0800,0x0800,LOAD_GFX},
	{"FB\\VID\\4i",0x1000,0x0100,LOAD_GFX},
	{"",0,0}
	}
	},

	{
	"MOON CRESTA",
	"CRESTA",
	GAME_CRESTA,
	{
	{"MOONCRST\\EPR194",0x0000,0x0800,LOAD_PROC1},
	{"MOONCRST\\EPR195",0x0800,0x0800,LOAD_PROC1},
	{"MOONCRST\\EPR196",0x1000,0x0800,LOAD_PROC1},
	{"MOONCRST\\EPR197",0x1800,0x0800,LOAD_PROC1},
	{"MOONCRST\\EPR198",0x2000,0x0800,LOAD_PROC1},
	{"MOONCRST\\EPR199",0x2800,0x0800,LOAD_PROC1},
	{"MOONCRST\\EPR200",0x3000,0x0800,LOAD_PROC1},
	{"MOONCRST\\EPR201",0x3800,0x0800,LOAD_PROC1},
	{"MOONCRST\\EPR202",0x0000,0x0800,LOAD_GFX},
	{"MOONCRST\\EPR171",0x0800,0x0800,LOAD_GFX},
	{"MOONCRST\\EPR203",0x1000,0x0800,LOAD_GFX},
	{"MOONCRST\\EPR172",0x1800,0x0800,LOAD_GFX},
	{"",0,0}
	}
	},


	{
	"SCRAMBLE",
	"SCRAMBLE",
	GAME_SCRAMBLE,
	{
	{"SCRAMBLE\\SCRAMBLE.2d",0x0000,0x0800,LOAD_PROC1},
	{"SCRAMBLE\\SCRAMBLE.2e",0x0800,0x0800,LOAD_PROC1},
	{"SCRAMBLE\\SCRAMBLE.2f",0x1000,0x0800,LOAD_PROC1},
	{"SCRAMBLE\\SCRAMBLE.2h",0x1800,0x0800,LOAD_PROC1},
	{"SCRAMBLE\\SCRAMBLE.2j",0x2000,0x0800,LOAD_PROC1},
	{"SCRAMBLE\\SCRAMBLE.2l",0x2800,0x0800,LOAD_PROC1},
	{"SCRAMBLE\\SCRAMBLE.2m",0x3000,0x0800,LOAD_PROC1},
	{"SCRAMBLE\\SCRAMBLE.2p",0x3800,0x0800,LOAD_PROC1},
	{"SCRAMBLE\\SCRAMBLE.5f",0x0000,0x0800,LOAD_GFX},
	{"SCRAMBLE\\SCRAMBLE.5h",0x0800,0x0800,LOAD_GFX},
	{"SCRAMBLE\\SCRAMBLE.5c",0x1000,0x0800,LOAD_GFX},
	{"SCRAMBLE\\SCRAMBLE.5d",0x1800,0x0800,LOAD_GFX},
	{"SCRAMBLE\\SCRAMBLE.5e",0x2000,0x0800,LOAD_GFX},
	{"",0,0}
	}
	},


	{
	"PHOENIX",
	"PHOENIX",
	GAME_PHOENIX,
	{
	{"PHOENIX\\PHOENIX.45",0x0000,0x800,LOAD_PROC1},
	{"PHOENIX\\PHOENIX.46",0x0800,0x800,LOAD_PROC1},
	{"PHOENIX\\PHOENIX.47",0x1000,0x800,LOAD_PROC1},
	{"PHOENIX\\PHOENIX.48",0x1800,0x800,LOAD_PROC1},
	{"PHOENIX\\PHOENIX.49",0x2000,0x800,LOAD_PROC1},
	{"PHOENIX\\PHOENIX.50",0x2800,0x800,LOAD_PROC1},
	{"PHOENIX\\PHOENIX.51",0x3000,0x800,LOAD_PROC1},
	{"PHOENIX\\PHOENIX.52",0x3800,0x800,LOAD_PROC1},
	{"PHOENIX\\PHOENIX.39",0x0000,0x800,LOAD_GFX},
	{"PHOENIX\\PHOENIX.40",0x1000,0x800,LOAD_GFX},
	{"PHOENIX\\PHOENIX.23",0x0800,0x800,LOAD_GFX},
	{"PHOENIX\\PHOENIX.24",0x1800,0x800,LOAD_GFX},
	{"",0,0}
	}
	},		

	{
	"PLEIADES",
	"PLEIADES",
	GAME_PLEIADES,
	{
	{"PLEIADES\\PLEIADES.47",0x0000,0x800,LOAD_PROC1},
	{"PLEIADES\\PLEIADES.48",0x0800,0x800,LOAD_PROC1},
	{"PLEIADES\\PLEIADES.49",0x1000,0x800,LOAD_PROC1},
	{"PLEIADES\\PLEIADES.50",0x1800,0x800,LOAD_PROC1},
	{"PLEIADES\\PLEIADES.51",0x2000,0x800,LOAD_PROC1},
	{"PLEIADES\\PLEIADES.52",0x2800,0x800,LOAD_PROC1},
	{"PLEIADES\\PLEIADES.53",0x3000,0x800,LOAD_PROC1},
	{"PLEIADES\\PLEIADES.54",0x3800,0x800,LOAD_PROC1},
	{"PLEIADES\\PLEIADES.26",0x0000,0x800,LOAD_GFX},
	{"PLEIADES\\PLEIADES.27",0x0800,0x800,LOAD_GFX},
	{"PLEIADES\\PLEIADES.44",0x1000,0x800,LOAD_GFX},
	{"PLEIADES\\PLEIADES.45",0x1800,0x800,LOAD_GFX},
	{"",0,0}
	}
	},

	{
	"SPACE INVADERS",
	"INVADERS",
	GAME_SPACE_INVADERS,
	{
	{"INVADERS\\INVADERS.H",0x0000,0x800,LOAD_PROC1},
	{"INVADERS\\INVADERS.G",0x0800,0x800,LOAD_PROC1},
	{"INVADERS\\INVADERS.F",0x1000,0x800,LOAD_PROC1},
	{"INVADERS\\INVADERS.E",0x1800,0x800,LOAD_PROC1},
	{"",0,0}
	}
	},

	{
	"INVADERS DELUXE",
	"INVADERSD",
	GAME_INVADERS_DELUXE,
	{
	{"INVDELUX\\INVDELUX.H",0x0000,0x800,LOAD_PROC1},
	{"INVDELUX\\INVDELUX.G",0x0800,0x800,LOAD_PROC1},
	{"INVDELUX\\INVDELUX.F",0x1000,0x800,LOAD_PROC1},
	{"INVDELUX\\INVDELUX.E",0x1800,0x800,LOAD_PROC1},
	{"INVDELUX\\INVDELUX.D",0x4000,0x800,LOAD_PROC1},
	{"",0,0}
	}
	},

	{
	"INVADERS REVENGE",
	"REVENGE",
	GAME_INVADERS_REVENGE,
	{
	{"REVENGE\\INVRVNGE.H",0x0000,0x0800,LOAD_PROC1},
	{"REVENGE\\INVRVNGE.G",0x0800,0x0800,LOAD_PROC1},
	{"REVENGE\\INVRVNGE.F",0x1000,0x0800,LOAD_PROC1},
	{"REVENGE\\INVRVNGE.E",0x1800,0x0800,LOAD_PROC1},
	{"",0,0}
	}
	},

	{
	"SPACE ATTACK",
	"ATTACK",
	GAME_SPACE_ATTACK,
	{
	{"SPACEATT\\SPACEATT.H",0x0000,0x800,LOAD_PROC1},
	{"SPACEATT\\SPACEATT.G",0x0800,0x800,LOAD_PROC1},
	{"SPACEATT\\SPACEATT.F",0x1000,0x800,LOAD_PROC1},
	{"SPACEATT\\SPACEATT.E",0x1800,0x800,LOAD_PROC1},
	{"",0,0}
	}
	},

	{
	"EARTH INVASION",
	"INVASION",
	GAME_SUPER_INVASION,
	{
	{"EARTHINV\\EARTHINV.H",0x0000,0x800,LOAD_PROC1},
	{"EARTHINV\\EARTHINV.G",0x0800,0x800,LOAD_PROC1},
	{"EARTHINV\\EARTHINV.F",0x1000,0x800,LOAD_PROC1},
	{"EARTHINV\\EARTHINV.E",0x1800,0x800,LOAD_PROC1},
	{"",0,0}
	}
	},

	{
	"GALAXY WARS",
	"GALAXY",
	GAME_GALAXY_WARS,
	{
	{"GALXWARS\\GALXWARS.0",0x0000,0x400,LOAD_PROC1},
	{"GALXWARS\\GALXWARS.1",0x0400,0x400,LOAD_PROC1},
	{"GALXWARS\\GALXWARS.2",0x0800,0x400,LOAD_PROC1},
	{"GALXWARS\\GALXWARS.3",0x0c00,0x400,LOAD_PROC1},
	{"GALXWARS\\GALXWARS.4",0x4000,0x400,LOAD_PROC1},
	{"GALXWARS\\GALXWARS.5",0x4400,0x400,LOAD_PROC1},
	{"",0,0}
	}
	},

	{
	"LUNAR RESCUE",
	"RESCUE",
	GAME_LUNAR_RESCUE,
	{
	{"LRESCUE\\LRESCUE.1",0x0000,0x800,LOAD_PROC1},
	{"LRESCUE\\LRESCUE.2",0x0800,0x800,LOAD_PROC1},
	{"LRESCUE\\LRESCUE.3",0x1000,0x800,LOAD_PROC1},
	{"LRESCUE\\LRESCUE.4",0x1800,0x800,LOAD_PROC1},
	{"LRESCUE\\LRESCUE.5",0x4000,0x800,LOAD_PROC1},
	{"LRESCUE\\LRESCUE.6",0x4800,0x800,LOAD_PROC1},
	{"",0,0}
	}
	},

	{
	"GALAXIAN (Midway)",
	"GALAXIAN1",
	GAME_GALAXIAN_MIDWAY,
	{
	{"GALMIDW\\GALAXIAN.U", 0x0000,0x800,LOAD_PROC1},
	{"GALMIDW\\GALAXIAN.V", 0x0800,0x800,LOAD_PROC1},
	{"GALMIDW\\GALAXIAN.W", 0x1000,0x800,LOAD_PROC1},
	{"GALMIDW\\GALAXIAN.Y", 0x1800,0x800,LOAD_PROC1},
	{"GALMIDW\\GALAXIAN.Z", 0x2000,0x800,LOAD_PROC1},
	{"GALMIDW\\GALAXIAN.1J",0x0000,0x800,LOAD_GFX},
	{"GALMIDW\\GALAXIAN.1K",0x0800,0x800,LOAD_GFX},
	{"",0,0}
	}
	},

	{
	"GALAXIAN (Namco)",
	"GALAXIAN2",
	GAME_GALAXIAN_NAMCO,
	{
	{"GALNAMCO\\GALAXIAN.U", 0x0000,0x800,LOAD_PROC1},
	{"GALNAMCO\\GALAXIAN.V", 0x0800,0x800,LOAD_PROC1},
	{"GALNAMCO\\GALAXIAN.W", 0x1000,0x800,LOAD_PROC1},
	{"GALNAMCO\\GALAXIAN.Y", 0x1800,0x800,LOAD_PROC1},
	{"GALNAMCO\\GALAXIAN.Z", 0x2000,0x800,LOAD_PROC1},
	{"GALNAMCO\\GALAXIAN.1H",0x0000,0x800,LOAD_GFX},
	{"GALNAMCO\\GALAXIAN.1K",0x0800,0x800,LOAD_GFX},
	{"",0,0}
	}
	},

	{
	"GALAXIAN Part 1",
	"GALAXIAN3",
	GAME_GALAXIAN_PART_1,
	{
	{"GALAP1\\GALX_1.ROM",  0x0000,0x2800,LOAD_PROC1},
	{"GALAP1\\GALX_1C1.ROM",0x0000,0x0800,LOAD_GFX},
	{"GALAP1\\GALX_1C2.ROM",0x0800,0x0800,LOAD_GFX},
	{"",0,0}
	}
	},

	{
	"GALAXIAN Part 4",
	"GALAXIAN4",
	GAME_GALAXIAN_PART_4,
	{
	{"GALAP4\\GALX_4.ROM",  0x0000,0x2800,LOAD_PROC1},
	{"GALAP4\\GALX_4C1.ROM",0x0000,0x0800,LOAD_GFX},
	{"GALAP4\\GALX_4C2.ROM",0x0800,0x0800,LOAD_GFX},
	{"",0,0}
	}
	},

	{
	"GALAXIAN (Turbo)",
	"GALAXIANT",
	GAME_GALAXIAN_TURBO,
	{
	{"GALTURBO\\GALAXIAN.U", 0x0000,0x0800,LOAD_PROC1},
	{"GALTURBO\\GALAXIAN.V", 0x0800,0x0800,LOAD_PROC1},
	{"GALTURBO\\GALAXIAN.W", 0x1000,0x0800,LOAD_PROC1},
	{"GALTURBO\\GALAXIAN.Y", 0x1800,0x0800,LOAD_PROC1},
	{"GALTURBO\\GALAXIAN.Z", 0x2000,0x0800,LOAD_PROC1},
	{"GALTURBO\\GALAXIAN.1H",0x0000,0x0800,LOAD_GFX},
	{"GALTURBO\\GALAXIAN.1K",0x0800,0x0800,LOAD_GFX},
	{"",0,0}
	}
	},

	{
	"SUPER GALAXIAN",
	"GALAXIANS",
	GAME_SUPER_GALAXIAN,
	{
	{"SUPERG\\GALAXIAN.U", 0x0000,0x0800,LOAD_PROC1},
	{"SUPERG\\GALAXIAN.V", 0x0800,0x0800,LOAD_PROC1},
	{"SUPERG\\GALAXIAN.W", 0x1000,0x0800,LOAD_PROC1},
	{"SUPERG\\GALAXIAN.Y", 0x1800,0x0800,LOAD_PROC1},
	{"SUPERG\\GALAXIAN.Z", 0x2000,0x0800,LOAD_PROC1},
	{"SUPERG\\GALAXIAN.1H",0x0000,0x0800,LOAD_GFX},
	{"SUPERG\\GALAXIAN.1K",0x0800,0x0800,LOAD_GFX},
	{"",0,0}
	}
	},

	{
	"UNIWARS",
	"UNIWARS",
	GAME_JAPIREM,
	{
	{"JAPIREM\\f07_1a.bin", 0x0000,0x0800,LOAD_PROC1},
	{"JAPIREM\\h07_2a.bin", 0x0800,0x0800,LOAD_PROC1},
	{"JAPIREM\\k07_3a.bin", 0x1000,0x0800,LOAD_PROC1},
	{"JAPIREM\\m07_4a.bin", 0x1800,0x0800,LOAD_PROC1},
	{"JAPIREM\\d08p_5a.bin",0x2000,0x0800,LOAD_PROC1},
	{"JAPIREM\\e08p_6a.bin",0x2800,0x0800,LOAD_PROC1},
	{"JAPIREM\\m08p_7a.bin",0x3000,0x0800,LOAD_PROC1},
	{"JAPIREM\\n08p_8a.bin",0x3800,0x0800,LOAD_PROC1},
	{"JAPIREM\\h01_1.bin",  0x0000,0x0800,LOAD_GFX},
	{"JAPIREM\\h01_2.bin",  0x0800,0x0800,LOAD_GFX},
	{"JAPIREM\\k01_1.bin",  0x1000,0x0800,LOAD_GFX},
	{"JAPIREM\\k01_2.bin",  0x1800,0x0800,LOAD_GFX},
	{"",0,0}
	}
	},

	{
	"WAR of the BUGS",
	"BUGS",
	GAME_WAR_OF_THE_BUGS,
	{
	{"WAROFBUG\\WAROFBUG.U", 0x0000,0x0800,LOAD_PROC1},
	{"WAROFBUG\\WAROFBUG.V", 0x0800,0x0800,LOAD_PROC1},
	{"WAROFBUG\\WAROFBUG.W", 0x1000,0x0800,LOAD_PROC1},
	{"WAROFBUG\\WAROFBUG.Y", 0x1800,0x0800,LOAD_PROC1},
	{"WAROFBUG\\WAROFBUG.Z", 0x2000,0x0800,LOAD_PROC1},
	{"WAROFBUG\\WAROFBUG.1J",0x0000,0x0800,LOAD_GFX},
	{"WAROFBUG\\WAROFBUG.1K",0x0800,0x0800,LOAD_GFX},
	{"",0,0}
	}
	},

	{
	"PISCES",
	"PISCES",
	GAME_PISCES,
	{
	{"PISCES\\PISCES.A1",0x0000,0x0800,LOAD_PROC1},
	{"PISCES\\PISCES.A2",0x0800,0x0800,LOAD_PROC1},
	{"PISCES\\PISCES.B2",0x1000,0x0800,LOAD_PROC1},
	{"PISCES\\PISCES.C1",0x1800,0x0800,LOAD_PROC1},
	{"PISCES\\PISCES.D1",0x2000,0x0800,LOAD_PROC1},
	{"PISCES\\PISCES.E2",0x2800,0x0800,LOAD_PROC1},
	{"PISCES\\PISCES.1J",0x0000,0x1000,LOAD_GFX},
	{"PISCES\\PISCES.1K",0x1000,0x1000,LOAD_GFX},
	{"",0,0}
	}
	}

}
#endif
;



char	API	CrestaPalette[]
#ifdef	SAGE
={
	0x00,0x7a,0x36,0x07,0x00,0xf0,0x38,0x1f,0x00,0xc7,0xf0,0x3f,0x00,0xdb,0xc6,0x38,
	0x00,0x36,0x07,0xf0,0x00,0x33,0x3f,0xdb,0x00,0x3f,0x57,0xc6,0x00,0xc6,0x3f,0xff
}
#endif
;

char	API	CrestaStarPal[]
#ifdef	SAGE
={
	0x00,0x88,0xcc,0xff
}
#endif
;



#define	BLACK		0
#define	RED		1
#define	PURPLE		2
#define	CYAN		3
#define	YELLOW		4
#define	BLUE		5
#define	GREEN		6
#define	WHITE		7



char	API GalaxianColourTable[64]
#ifdef	SAGE
={
	BLACK,WHITE,WHITE,WHITE,
	BLACK,RED,BLUE,YELLOW,
	BLACK,BLUE,RED,YELLOW,
	BLACK,BLUE,PURPLE,RED,
	BLACK,BLUE,GREEN,RED,
	BLACK,RED,RED,RED,
	BLACK,WHITE,RED,CYAN,
	BLACK,YELLOW,RED,PURPLE,
	BLACK,RED,BLUE,GREEN,
	BLACK,RED,GREEN,BLUE,
	BLACK,RED,BLUE,YELLOW,
	BLACK,BLUE,RED,YELLOW,
	BLACK,BLUE,PURPLE,RED,
	BLACK,BLUE,GREEN,RED,
	BLACK,WHITE,RED,CYAN,
	BLACK,YELLOW,RED,PURPLE
}
#endif
;



char	API	GalaxianPal[24]
#ifdef	SAGE
={
	0,0,0,		// BLACK
	63,0,0,		// RED
	38,0,56,	// PURPLE
	0,63,63,	// CYAN,
	63,63,0,	// YELLOW,
	0,0,55,		// BLUE
	0,38,38, 	// GREEN
	56,56,56 	// WHITE

}
#endif
;


char	API	BugsPal[32]
#ifdef	SAGE
={
	0x00,0x7A,0x36,0x07,0x00,0xF0,0x38,0x1F,0x00,0xC7,0xF0,0x3F,0x00,0xDB,0xC6,0x38,
	0x00,0x36,0x07,0xF0,0x00,0x33,0x3F,0xDB,0x00,0x3F,0x57,0xC6,0x00,0xC6,0x3F,0xFF
}
#endif
;


// Space invader variants sound channels
#define	BASE_DEAD	0
#define	INV_DEAD	1
#define	BASE_FIRE	2
#define	UFO		3
#define	UFO_DEAD	4
#define	WALK_1		5
#define	WALK_2		6
#define	WALK_3		7
#define	WALK_4		8



char	API	PhoenixPal[48]
#ifdef	SAGE
={	0x00,0x00,0x00,	/* BLACK */
	0xdb,0xdb,0xdb,	/* WHITE */
	0xff,0x00,0x00,	/* RED */
	0x00,0xff,0x00,	/* GREEN */
	0x24,0x24,0xdb,	/* BLUE */
	0x00,0xff,0xdb,	/* CYAN, */
	0xff,0xff,0x00,	/* YELLOW, */
	0xff,0xb6,0xdb,	/* PINK */
	0xff,0xb6,0x49,	/* ORANGE */
        0xff,0x24,0xb6, /* LTPURPLE */
	0xff,0xb6,0x00,	/* DKORANGE */
        0xb6,0x24,0xff, /* DKPURPLE */
	0x00,0xdb,0xdb,	/* DKCYAN */
	0xdb,0xdb,0x00,	/* DKYELLOW */
        0x95,0x95,0xff, /* BLUISH */
        0xff,0x00,0xff /* PURPLE */
}
#endif
;


#undef	BLACK 
#undef	RED   
#undef	PURPLE
#undef	CYAN  
#undef	YELLOW
#undef	BLUE  
#undef	GREEN 
#undef	WHITE 

enum {BLACK,WHITE,RED,GREEN,BLUE,CYAN,YELLOW,PINK,ORANGE,LTPURPLE,DKORANGE,DKPURPLE,DKCYAN,DKYELLOW,BLUISH,PURPLE};

char	API	PhoenixColourTable[128]
#ifdef	SAGE
={
        /* charset A pallette A */  
        BLACK,BLACK,CYAN,CYAN,          /* Background, Unused, Letters, asterisks */   
        BLACK,YELLOW,RED,WHITE,         /* Background, Ship middle, Numbers/Ship, Ship edge */     
        BLACK,YELLOW,RED,WHITE,         /* Background, Ship middle, Ship, Ship edge/bullets */     
        BLACK,PINK,PURPLE,YELLOW,       /* Background, Bird eyes, Bird middle, Bird Wings */       
        BLACK,PINK,PURPLE,YELLOW,       /* Background, Bird eyes, Bird middle, Bird Wings */       
        BLACK,PINK,PURPLE,YELLOW,       /* Background, Bird eyes, Bird middle, Bird Wings */       
        BLACK,WHITE,PURPLE,YELLOW,      /* Background, Explosions */       
        BLACK,PURPLE,GREEN,WHITE,       /* Background, Barrier */
        /* charset A pallette B */
        BLACK,BLUE,CYAN,CYAN,           /* Background, Unused, Letters, asterisks */   
        BLACK,YELLOW,RED,WHITE,         /* Background, Ship middle, Numbers/Ship, Ship edge */     
        BLACK,YELLOW,RED,WHITE,         /* Background, Ship middle, Ship, Ship edge/bullets */     
        BLACK,YELLOW,GREEN,PURPLE,      /* Background, Bird eyes, Bird middle, Bird Wings */       
        BLACK,YELLOW,GREEN,PURPLE,      /* Background, Bird eyes, Bird middle, Bird Wings */       
        BLACK,YELLOW,GREEN,PURPLE,      /* Background, Bird eyes, Bird middle, Bird Wings */       
        BLACK,WHITE,RED,PURPLE,         /* Background, Explosions */       
        BLACK,PURPLE,GREEN,WHITE,       /* Background, Barrier */
        /* charset B pallette A */
        BLACK,RED,BLUE,WHITE,           /* Background, Starfield */   
        BLACK,PURPLE,BLUISH,DKORANGE,   /* Background, Planets */     
        BLACK,DKPURPLE,GREEN,DKORANGE,  /* Background, Mothership: turrets, u-body, l-body */      
        BLACK,BLUISH,DKPURPLE,LTPURPLE, /* Background, Motheralien: face, body, feet */   
        BLACK,PURPLE,BLUISH,GREEN,      /* Background, Eagles: face, body, shell */   
        BLACK,PURPLE,BLUISH,GREEN,      /* Background, Eagles: face, body, feet */    
        BLACK,PURPLE,BLUISH,GREEN,      /* Background, Eagles: face, body, feet */    
        BLACK,PURPLE,BLUISH,GREEN,      /* Background, Eagles: face, body, feet */
        /* charset B pallette B */
        BLACK,RED,BLUE,WHITE,           /* Background, Starfield */   
        BLACK,PURPLE,BLUISH,DKORANGE,   /* Background, Planets */     
        BLACK,DKPURPLE,GREEN,DKORANGE,  /* Background, Mothership: turrets, upper body, lower body */      
        BLACK,BLUISH,DKPURPLE,LTPURPLE, /* Background, Motheralien: face, body, feet */   
        BLACK,BLUISH,LTPURPLE,GREEN,    /* Background, Eagles: face, body, shell */   
        BLACK,BLUISH,LTPURPLE,GREEN,    /* Background, Eagles: face, body, feet */    
        BLACK,BLUISH,LTPURPLE,GREEN,    /* Background, Eagles: face, body, feet */    
        BLACK,BLUISH,LTPURPLE,GREEN,    /* Background, Eagles: face, body, feet */
}
#endif
;


char 	API	FirebirdPalette[32]
#ifdef SAGE
={
	0x00,0x17,0x27,0xd0,0x00,0xa4,0xc0,0x16,
	0x00,0x07,0xc7,0x37,0x00,0x3f,0xd8,0x07,
	0x00,0x3b,0xc0,0x16,0x00,0xdb,0xc0,0xc7,
	0x00,0x07,0xc7,0x37,0x00,0x3f,0xd8,0x07
}
#endif
;


char 	API	ScramblePalette[32]
#ifdef SAGE
={
	0x00,0x17,0xC7,0xF6,0x00,0x17,0xC0,0x3F,0x00,0x07,0xC0,0x3F,0x00,0xC0,0xC4,0x07,
	0x00,0xC7,0x31,0x17,0x00,0x31,0xC7,0x3F,0x00,0xF6,0x07,0xF0,0x00,0x3F,0x07,0xC4
}
#endif
;


char 	API	ScrambleStarPal[4]
#ifdef SAGE
={
	0x00,0x88,0xcc,0xff
}
#endif
;



char 	API	MrDoPalette[96]
#ifdef SAGE
={
	0x00,0x0C,0x03,0x00,0x0F,0x0B,0x0C,0x3F,0x0D,0x0F,0x0F,0x0C,0x0C,0x3C,0x0C,0x30,
	0x0C,0x03,0x30,0x03,0x0C,0x0F,0x00,0x3F,0x03,0x1E,0x00,0x0F,0x37,0x36,0x0D,0x33,
	0x00,0x0C,0x03,0x00,0x0C,0x03,0x00,0x3F,0x0F,0x03,0x0F,0x3F,0x0C,0x0F,0x0F,0x3A,
	0x03,0x0F,0x00,0x0C,0x00,0x0F,0x3F,0x03,0x2A,0x0C,0x00,0x0A,0x0C,0x0E,0x3F,0x0F,
	0x00,0x97,0x71,0xF9,0x00,0x27,0xA5,0x13,0x00,0x32,0x77,0x3F,0x00,0xA7,0x72,0xF9,
	0x00,0x1F,0x9A,0x77,0x00,0x15,0x27,0x38,0x00,0xC2,0x55,0x69,0x00,0x7F,0x76,0x7A
}
#endif
;



char 	API	CommandoDecrypt[256]
#ifdef SAGE
={
	0x00,0x01,0x20,0x21,0x40,0x41,0x60,0x61,0x80,0x81,0xA0,0xA1,0xC0,0xC1,0xE0,0xE1,
	0x10,0x11,0x30,0x31,0x50,0x51,0x70,0x71,0x90,0x91,0xB0,0xB1,0xD0,0xD1,0xF0,0xF1,
	0x02,0x03,0x22,0x23,0x42,0x43,0x62,0x63,0x82,0x83,0xA2,0xA3,0xC2,0xC3,0xE2,0xE3,
	0x12,0x13,0x32,0x33,0x52,0x53,0x72,0x73,0x92,0x93,0xB2,0xB3,0xD2,0xD3,0xF2,0xF3,
	0x04,0x05,0x24,0x25,0x44,0x45,0x64,0x65,0x84,0x85,0xA4,0xA5,0xC4,0xC5,0xE4,0xE5,
	0x14,0x15,0x34,0x35,0x54,0x55,0x74,0x75,0x94,0x95,0xB4,0xB5,0xD4,0xD5,0xF4,0xF5,
	0x06,0x07,0x26,0x27,0x46,0x47,0x66,0x67,0x86,0x87,0xA6,0xA7,0xC6,0xC7,0xE6,0xE7,
	0x16,0x17,0x36,0x37,0x56,0x57,0x76,0x77,0x96,0x97,0xB6,0xB7,0xD6,0xD7,0xF6,0xF7,
	0x08,0x09,0x28,0x29,0x48,0x49,0x68,0x69,0x88,0x89,0xA8,0xA9,0xC8,0xC9,0xE8,0xE9,
	0x18,0x19,0x38,0x39,0x58,0x59,0x78,0x79,0x98,0x99,0xB8,0xB9,0xD8,0xD9,0xF8,0xF9,
	0x0A,0x0B,0x2A,0x2B,0x4A,0x4B,0x6A,0x6B,0x8A,0x8B,0xAA,0xAB,0xCA,0xCB,0xEA,0xEB,
	0x1A,0x1B,0x3A,0x3B,0x5A,0x5B,0x7A,0x7B,0x9A,0x9B,0xBA,0xBB,0xDA,0xDB,0xFA,0xFB,
	0x0C,0x0D,0x2C,0x2D,0x4C,0x4D,0x6C,0x6D,0x8C,0x8D,0xAC,0xAD,0xCC,0xCD,0xEC,0xED,
	0x1C,0x1D,0x3C,0x3D,0x5C,0x5D,0x7C,0x7D,0x9C,0x9D,0xBC,0xBD,0xDC,0xDD,0xFC,0xFD,
	0x0E,0x0F,0x2E,0x2F,0x4E,0x4F,0x6E,0x6F,0x8E,0x8F,0xAE,0xAF,0xCE,0xCF,0xEE,0xEF,
	0x1E,0x1F,0x3E,0x3F,0x5E,0x5F,0x7E,0x7F,0x9E,0x9F,0xBE,0xBF,0xDE,0xDF,0xFE,0xFF
}
#endif
;


char 	API	CommandoPalette[3*256]
#ifdef SAGE
={
0x00, 0x00, 0x00, 0x88, 0x55, 0x33, 0x00, 0x55, 0x77, 0x99, 0x66, 0x44, 
0x66, 0x33, 0x00, 0x00, 0x77, 0x88, 0x77, 0x44, 0x00, 0x33, 0x44, 0x55, 
0x44, 0x33, 0x00, 0x88, 0x66, 0x44, 0xaa, 0x88, 0x66, 0x77, 0x88, 0x55, 
0x55, 0x66, 0x22, 0x33, 0x44, 0x00, 0x77, 0x55, 0x33, 0x55, 0x44, 0x33, 
0x33, 0x44, 0x00, 0x88, 0x66, 0x44, 0x00, 0x55, 0x77, 0x66, 0x88, 0x44, 
0x44, 0x66, 0x00, 0x00, 0x77, 0x88, 0x77, 0x55, 0x33, 0x33, 0x44, 0x55, 
0xaa, 0x88, 0x66, 0x88, 0x66, 0x44, 0x99, 0xbb, 0x66, 0x66, 0x88, 0x44, 
0x44, 0x66, 0x00, 0x33, 0x44, 0x00, 0x66, 0x44, 0x22, 0x44, 0x33, 0x00, 
0xaa, 0x88, 0x66, 0x88, 0x66, 0x44, 0x55, 0x55, 0x33, 0x55, 0x66, 0x33, 
0x44, 0x44, 0x00, 0x99, 0x77, 0x55, 0x55, 0x44, 0x33, 0x77, 0x55, 0x33, 
0x00, 0x00, 0x00, 0x00, 0x99, 0xaa, 0x00, 0x66, 0x88, 0x00, 0x44, 0x55, 
0x66, 0x66, 0x55, 0x44, 0x44, 0x33, 0x77, 0x55, 0x33, 0xbb, 0x99, 0x77, 
0x00, 0x00, 0x00, 0x99, 0x77, 0x55, 0xaa, 0x88, 0x66, 0x88, 0x66, 0x44, 
0xbb, 0x99, 0x77, 0x77, 0x55, 0x33, 0x44, 0x33, 0x00, 0x66, 0x44, 0x00, 
0x33, 0x33, 0x22, 0x88, 0x66, 0x44, 0x77, 0x77, 0x66, 0xaa, 0xaa, 0x99, 
0x88, 0x88, 0x77, 0x66, 0x66, 0x55, 0x44, 0x44, 0x33, 0x88, 0x55, 0x33, 
0x55, 0x44, 0x33, 0x88, 0x66, 0x44, 0x00, 0x55, 0x77, 0x99, 0x77, 0x55, 
0x66, 0x44, 0x00, 0x00, 0x77, 0x88, 0x77, 0x55, 0x33, 0x33, 0x44, 0x55, 
0x88, 0x55, 0x33, 0x33, 0x44, 0x55, 0xaa, 0x99, 0x66, 0x99, 0x88, 0x55, 
0x77, 0x66, 0x00, 0x77, 0x44, 0x00, 0x55, 0x44, 0x00, 0x44, 0x33, 0x00, 
0x99, 0x77, 0x55, 0x88, 0x66, 0x44, 0xaa, 0xaa, 0x99, 0x77, 0x77, 0x66, 
0x66, 0x66, 0x55, 0x55, 0x55, 0x44, 0x44, 0x44, 0x33, 0x77, 0x55, 0x33, 
0x00, 0x00, 0x00, 0x88, 0x55, 0x33, 0x66, 0x33, 0x00, 0x55, 0x22, 0x00, 
0x44, 0x00, 0x00, 0x99, 0x66, 0x44, 0x77, 0x44, 0x00, 0xbb, 0x99, 0x77, 
0x00, 0x00, 0x00, 0x88, 0x55, 0x33, 0x66, 0x33, 0x00, 0x55, 0x22, 0x00, 
0x44, 0x00, 0x00, 0x99, 0x66, 0x44, 0x77, 0x44, 0x00, 0x88, 0x55, 0x00, 
0x00, 0x00, 0x00, 0x88, 0x66, 0x44, 0x88, 0x55, 0x33, 0xaa, 0x99, 0x77, 
0x88, 0x77, 0x55, 0x66, 0x55, 0x33, 0x00, 0x00, 0x00, 0xcc, 0xaa, 0x88, 
0x00, 0x00, 0x00, 0x99, 0x77, 0x55, 0x77, 0x55, 0x33, 0x66, 0x44, 0x00, 
0x44, 0x33, 0x00, 0xaa, 0x88, 0x66, 0x66, 0x66, 0x55, 0x44, 0x44, 0x33, 
0x00, 0x00, 0x00, 0x88, 0x55, 0x33, 0xaa, 0xaa, 0x99, 0x77, 0x77, 0x66, 
0x66, 0x66, 0x55, 0x55, 0x55, 0x44, 0x44, 0x44, 0x33, 0x77, 0x44, 0x00, 
0x11, 0x11, 0x11, 0x00, 0x99, 0xaa, 0x00, 0x66, 0x88, 0x00, 0x44, 0x55, 
0xcc, 0xaa, 0x00, 0xaa, 0x88, 0x00, 0x88, 0x66, 0x00, 0xcc, 0xaa, 0x88, 
0x77, 0x55, 0x33, 0xcc, 0xcc, 0xff, 0xaa, 0x00, 0x00, 0xaa, 0xaa, 0x99, 
0x88, 0x88, 0x77, 0x66, 0x66, 0x55, 0x44, 0x44, 0x33, 0x00, 0x00, 0x00, 
0x11, 0x11, 0x11, 0xaa, 0x99, 0x77, 0x88, 0x77, 0x55, 0x66, 0x55, 0x33, 
0x66, 0x88, 0x88, 0x44, 0x66, 0x55, 0x22, 0x44, 0x33, 0xcc, 0xaa, 0x88, 
0x77, 0x55, 0x33, 0x66, 0x66, 0x55, 0xbb, 0xaa, 0x00, 0x99, 0x99, 0x88, 
0x77, 0x77, 0x66, 0x55, 0x55, 0x44, 0x44, 0x44, 0x33, 0x00, 0x00, 0x00, 
0x11, 0x11, 0x11, 0xaa, 0xaa, 0xaa, 0x77, 0x77, 0x77, 0x55, 0x55, 0x55, 
0x99, 0x88, 0x55, 0x99, 0x66, 0x44, 0x55, 0x22, 0x00, 0xbb, 0x99, 0x77, 
0x55, 0x55, 0x44, 0x33, 0x44, 0x55, 0x77, 0x66, 0x00, 0x88, 0x55, 0x33, 
0x77, 0x44, 0x00, 0x66, 0x33, 0x00, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x11, 0x11, 0x11, 0x77, 0x99, 0x44, 0x55, 0x66, 0x00, 0x33, 0x44, 0x00, 
0x88, 0x66, 0x44, 0x44, 0x33, 0x00, 0x66, 0x44, 0x00, 0xcc, 0xaa, 0x88, 
0x55, 0x55, 0x44, 0xff, 0xee, 0xbb, 0x99, 0xcc, 0x44, 0xaa, 0x88, 0x66, 
0x99, 0x77, 0x55, 0x77, 0x55, 0x33, 0x55, 0x44, 0x33, 0x00, 0x00, 0x00, 
0xaa, 0x00, 0x00, 0xaa, 0xaa, 0xaa, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0xcc, 0xcc, 0xcc, 0xbb, 0xaa, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0xcc, 0xcc, 0xcc, 0xbb, 0x66, 0xaa, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0xcc, 0xcc, 0xcc, 0x00, 0x00, 0xbb, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0xcc, 0xcc, 0xcc, 0x00, 0x00, 0xcc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0xcc, 0xcc, 0xcc, 0x00, 0x88, 0xbb, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0xcc, 0xcc, 0xcc, 0xaa, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0xaa, 0x00, 0x00, 0x00, 0x66, 0xcc, 0x44, 0x44, 0x77, 0x00, 0x00, 0x00, 
0xbb, 0x99, 0x77, 0x33, 0x22, 0x00, 0x66, 0x33, 0x00, 0x00, 0x00, 0x00, 
0x55, 0x44, 0x00, 0xbb, 0xaa, 0xaa, 0xaa, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x55, 0x44, 0x00, 0xbb, 0xaa, 0xaa, 0x00, 0x77, 0x00, 0x00, 0x00, 0x00, 
0xbb, 0xaa, 0x00, 0x55, 0x44, 0x00, 0x88, 0x66, 0x00, 0x00, 0x00, 0x00, 
0x33, 0x55, 0x44, 0x77, 0x99, 0x99, 0x55, 0x77, 0x66, 0x00, 0x00, 0x00, 
0x44, 0x44, 0x33, 0xaa, 0x99, 0x77, 0x00, 0x66, 0x99, 0x00, 0x00, 0x00, 
0xcc, 0xcc, 0xcc, 0x00, 0xbb, 0x77, 0x33, 0x22, 0x66, 0x00, 0x00, 0x00, 
0x88, 0x88, 0x77, 0x44, 0x44, 0x33, 0x66, 0x66, 0x55, 0x00, 0x00, 0x00
}
#endif
;



char 	API	GalagaPalette[]
#ifdef SAGE
={
	/* 5N - palette */
	0xF6,0x07,0x3F,0x27,0x2F,0xC7,0xF8,0xED,0x16,0x38,0x21,0xD8,0xC4,0xC0,0xA0,0x00,
	0xF6,0x07,0x3F,0x27,0x00,0xC7,0xF8,0xE8,0x00,0x38,0x00,0xD8,0xC5,0xC0,0x00,0x00,
	/* 2N - chars */
	0x0F,0x00,0x00,0x06,0x0F,0x0D,0x01,0x00,0x0F,0x02,0x0C,0x0D,0x0F,0x0B,0x01,0x00,
	0x0F,0x01,0x00,0x01,0x0F,0x00,0x00,0x02,0x0F,0x00,0x00,0x03,0x0F,0x00,0x00,0x05,
	0x0F,0x00,0x00,0x09,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x0F,0x0B,0x07,0x06,0x0F,0x06,0x0B,0x07,0x0F,0x07,0x06,0x0B,0x0F,0x0F,0x0F,0x01,
	0x0F,0x0F,0x0B,0x0F,0x0F,0x02,0x0F,0x0F,0x0F,0x06,0x06,0x0B,0x0F,0x06,0x0B,0x0B,
	/* 1C - sprites */
	0x0F,0x08,0x0E,0x02,0x0F,0x05,0x0B,0x0C,0x0F,0x00,0x0B,0x01,0x0F,0x01,0x0B,0x02,
	0x0F,0x08,0x0D,0x02,0x0F,0x06,0x01,0x04,0x0F,0x09,0x01,0x05,0x0F,0x07,0x0B,0x01,
	0x0F,0x01,0x06,0x0B,0x0F,0x01,0x0B,0x00,0x0F,0x01,0x02,0x00,0x0F,0x00,0x01,0x06,
	0x0F,0x00,0x00,0x06,0x0F,0x03,0x0B,0x09,0x0F,0x06,0x02,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
}
#endif
;


char 	API	GNGPalette[3*256]
#ifdef SAGE
={
0x00, 0x00, 0x00, 0x88, 0x55, 0x33, 0x00, 0x55, 0x77, 0x99, 0x66, 0x44, 
0x66, 0x33, 0x00, 0x00, 0x77, 0x88, 0x77, 0x44, 0x00, 0x33, 0x44, 0x55, 
0x44, 0x33, 0x00, 0x88, 0x66, 0x44, 0xaa, 0x88, 0x66, 0x77, 0x88, 0x55, 
0x55, 0x66, 0x22, 0x33, 0x44, 0x00, 0x77, 0x55, 0x33, 0x55, 0x44, 0x33, 
0x33, 0x44, 0x00, 0x88, 0x66, 0x44, 0x00, 0x55, 0x77, 0x66, 0x88, 0x44, 
0x44, 0x66, 0x00, 0x00, 0x77, 0x88, 0x77, 0x55, 0x33, 0x33, 0x44, 0x55, 
0xaa, 0x88, 0x66, 0x88, 0x66, 0x44, 0x99, 0xbb, 0x66, 0x66, 0x88, 0x44, 
0x44, 0x66, 0x00, 0x33, 0x44, 0x00, 0x66, 0x44, 0x22, 0x44, 0x33, 0x00, 
0xaa, 0x88, 0x66, 0x88, 0x66, 0x44, 0x55, 0x55, 0x33, 0x55, 0x66, 0x33, 
0x44, 0x44, 0x00, 0x99, 0x77, 0x55, 0x55, 0x44, 0x33, 0x77, 0x55, 0x33, 
0x00, 0x00, 0x00, 0x00, 0x99, 0xaa, 0x00, 0x66, 0x88, 0x00, 0x44, 0x55, 
0x66, 0x66, 0x55, 0x44, 0x44, 0x33, 0x77, 0x55, 0x33, 0xbb, 0x99, 0x77, 
0x00, 0x00, 0x00, 0x99, 0x77, 0x55, 0xaa, 0x88, 0x66, 0x88, 0x66, 0x44, 
0xbb, 0x99, 0x77, 0x77, 0x55, 0x33, 0x44, 0x33, 0x00, 0x66, 0x44, 0x00, 
0x33, 0x33, 0x22, 0x88, 0x66, 0x44, 0x77, 0x77, 0x66, 0xaa, 0xaa, 0x99, 
0x88, 0x88, 0x77, 0x66, 0x66, 0x55, 0x44, 0x44, 0x33, 0x88, 0x55, 0x33, 
0x55, 0x44, 0x33, 0x88, 0x66, 0x44, 0x00, 0x55, 0x77, 0x99, 0x77, 0x55, 
0x66, 0x44, 0x00, 0x00, 0x77, 0x88, 0x77, 0x55, 0x33, 0x33, 0x44, 0x55, 
0x88, 0x55, 0x33, 0x33, 0x44, 0x55, 0xaa, 0x99, 0x66, 0x99, 0x88, 0x55, 
0x77, 0x66, 0x00, 0x77, 0x44, 0x00, 0x55, 0x44, 0x00, 0x44, 0x33, 0x00, 
0x99, 0x77, 0x55, 0x88, 0x66, 0x44, 0xaa, 0xaa, 0x99, 0x77, 0x77, 0x66, 
0x66, 0x66, 0x55, 0x55, 0x55, 0x44, 0x44, 0x44, 0x33, 0x77, 0x55, 0x33, 
0x00, 0x00, 0x00, 0x88, 0x55, 0x33, 0x66, 0x33, 0x00, 0x55, 0x22, 0x00, 
0x44, 0x00, 0x00, 0x99, 0x66, 0x44, 0x77, 0x44, 0x00, 0xbb, 0x99, 0x77, 
0x00, 0x00, 0x00, 0x88, 0x55, 0x33, 0x66, 0x33, 0x00, 0x55, 0x22, 0x00, 
0x44, 0x00, 0x00, 0x99, 0x66, 0x44, 0x77, 0x44, 0x00, 0x88, 0x55, 0x00, 
0x00, 0x00, 0x00, 0x88, 0x66, 0x44, 0x88, 0x55, 0x33, 0xaa, 0x99, 0x77, 
0x88, 0x77, 0x55, 0x66, 0x55, 0x33, 0x00, 0x00, 0x00, 0xcc, 0xaa, 0x88, 
0x00, 0x00, 0x00, 0x99, 0x77, 0x55, 0x77, 0x55, 0x33, 0x66, 0x44, 0x00, 
0x44, 0x33, 0x00, 0xaa, 0x88, 0x66, 0x66, 0x66, 0x55, 0x44, 0x44, 0x33, 
0x00, 0x00, 0x00, 0x88, 0x55, 0x33, 0xaa, 0xaa, 0x99, 0x77, 0x77, 0x66, 
0x66, 0x66, 0x55, 0x55, 0x55, 0x44, 0x44, 0x44, 0x33, 0x77, 0x44, 0x00, 
0x11, 0x11, 0x11, 0x00, 0x99, 0xaa, 0x00, 0x66, 0x88, 0x00, 0x44, 0x55, 
0xcc, 0xaa, 0x00, 0xaa, 0x88, 0x00, 0x88, 0x66, 0x00, 0xcc, 0xaa, 0x88, 
0x77, 0x55, 0x33, 0xcc, 0xcc, 0xff, 0xaa, 0x00, 0x00, 0xaa, 0xaa, 0x99, 
0x88, 0x88, 0x77, 0x66, 0x66, 0x55, 0x44, 0x44, 0x33, 0x00, 0x00, 0x00, 
0x11, 0x11, 0x11, 0xaa, 0x99, 0x77, 0x88, 0x77, 0x55, 0x66, 0x55, 0x33, 
0x66, 0x88, 0x88, 0x44, 0x66, 0x55, 0x22, 0x44, 0x33, 0xcc, 0xaa, 0x88, 
0x77, 0x55, 0x33, 0x66, 0x66, 0x55, 0xbb, 0xaa, 0x00, 0x99, 0x99, 0x88, 
0x77, 0x77, 0x66, 0x55, 0x55, 0x44, 0x44, 0x44, 0x33, 0x00, 0x00, 0x00, 
0x11, 0x11, 0x11, 0xaa, 0xaa, 0xaa, 0x77, 0x77, 0x77, 0x55, 0x55, 0x55, 
0x99, 0x88, 0x55, 0x99, 0x66, 0x44, 0x55, 0x22, 0x00, 0xbb, 0x99, 0x77, 
0x55, 0x55, 0x44, 0x33, 0x44, 0x55, 0x77, 0x66, 0x00, 0x88, 0x55, 0x33, 
0x77, 0x44, 0x00, 0x66, 0x33, 0x00, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x11, 0x11, 0x11, 0x77, 0x99, 0x44, 0x55, 0x66, 0x00, 0x33, 0x44, 0x00, 
0x88, 0x66, 0x44, 0x44, 0x33, 0x00, 0x66, 0x44, 0x00, 0xcc, 0xaa, 0x88, 
0x55, 0x55, 0x44, 0xff, 0xee, 0xbb, 0x99, 0xcc, 0x44, 0xaa, 0x88, 0x66, 
0x99, 0x77, 0x55, 0x77, 0x55, 0x33, 0x55, 0x44, 0x33, 0x00, 0x00, 0x00, 
0xaa, 0x00, 0x00, 0xaa, 0xaa, 0xaa, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0xcc, 0xcc, 0xcc, 0xbb, 0xaa, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0xcc, 0xcc, 0xcc, 0xbb, 0x66, 0xaa, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0xcc, 0xcc, 0xcc, 0x00, 0x00, 0xbb, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0xcc, 0xcc, 0xcc, 0x00, 0x00, 0xcc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0xcc, 0xcc, 0xcc, 0x00, 0x88, 0xbb, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0xcc, 0xcc, 0xcc, 0xaa, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0xaa, 0x00, 0x00, 0x00, 0x66, 0xcc, 0x44, 0x44, 0x77, 0x00, 0x00, 0x00, 
0xbb, 0x99, 0x77, 0x33, 0x22, 0x00, 0x66, 0x33, 0x00, 0x00, 0x00, 0x00, 
0x55, 0x44, 0x00, 0xbb, 0xaa, 0xaa, 0xaa, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x55, 0x44, 0x00, 0xbb, 0xaa, 0xaa, 0x00, 0x77, 0x00, 0x00, 0x00, 0x00, 
0xbb, 0xaa, 0x00, 0x55, 0x44, 0x00, 0x88, 0x66, 0x00, 0x00, 0x00, 0x00, 
0x33, 0x55, 0x44, 0x77, 0x99, 0x99, 0x55, 0x77, 0x66, 0x00, 0x00, 0x00, 
0x44, 0x44, 0x33, 0xaa, 0x99, 0x77, 0x00, 0x66, 0x99, 0x00, 0x00, 0x00, 
0xcc, 0xcc, 0xcc, 0x00, 0xbb, 0x77, 0x33, 0x22, 0x66, 0x00, 0x00, 0x00, 
0x88, 0x88, 0x77, 0x44, 0x44, 0x33, 0x66, 0x66, 0x55, 0x00, 0x00, 0x00
}
#endif
;


char 	API	GalagaSamples[8*32]
#ifdef SAGE
={
	0xff,0x11,0x22,0x33,0x44,0x55,0x55,0x66,0x66,0x66,0x55,0x55,0x44,0x33,0x22,0x11,
	0xff,0xdd,0xcc,0xbb,0xaa,0x99,0x99,0x88,0x88,0x88,0x99,0x99,0xaa,0xbb,0xcc,0xdd,

	0xff,0x11,0x22,0x33,0xff,0x55,0x55,0xff,0x66,0xff,0x55,0x55,0xff,0x33,0x22,0x11,
	0xff,0xdd,0xff,0xbb,0xff,0x99,0xff,0x88,0xff,0x88,0xff,0x99,0xff,0xbb,0xff,0xdd,

	0x66,0x66,0x66,0x66,0x66,0x66,0x66,0x66,0x66,0x66,0x66,0x66,0x66,0x66,0x66,0x66,
	0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,0x88,

	0x33,0x55,0x66,0x55,0x44,0x22,0x00,0x00,0x00,0x22,0x44,0x55,0x66,0x55,0x33,0x00,
	0xcc,0xaa,0x99,0xaa,0xbb,0xdd,0xff,0xff,0xff,0xdd,0xbb,0xaa,0x99,0xaa,0xcc,0xff,

	0xff,0x22,0x44,0x55,0x66,0x55,0x44,0x22,0xff,0xcc,0xaa,0x99,0x88,0x99,0xaa,0xcc,
	0xff,0x33,0x55,0x66,0x55,0x33,0xff,0xbb,0x99,0x88,0x99,0xbb,0xff,0x66,0xff,0x88,

	0xff,0x66,0x44,0x11,0x44,0x66,0x22,0xff,0x44,0x77,0x55,0x00,0x22,0x33,0xff,0xaa,
	0x00,0x55,0x11,0xcc,0xdd,0xff,0xaa,0x88,0xbb,0x00,0xdd,0x99,0xbb,0xee,0xbb,0x99,

	0xff,0x00,0x22,0x44,0x66,0x55,0x44,0x44,0x33,0x22,0x00,0xff,0xdd,0xee,0xff,0x00,
	0x00,0x11,0x22,0x33,0x11,0x00,0xee,0xdd,0xcc,0xcc,0xbb,0xaa,0xcc,0xee,0x00,0x11,

	0x22,0x44,0x44,0x22,0xff,0xff,0x00,0x33,0x55,0x66,0x55,0x22,0xee,0xdd,0xdd,0xff,
	0x11,0x11,0x00,0xcc,0x99,0x88,0x99,0xbb,0xee,0xff,0xff,0xcc,0xaa,0xaa,0xcc,0xff,
}
#endif
;
