#define	SAGE
		
#include	<stdio.h>
#include	<stdlib.h>
#include	<conio.h>
#include	<conio.h>
#include	<string.h>
#include	<process.h>
#include	<time.h>
#include	"main.h"
#include	"sage.h"
#include	"z80.h"
#include	"support.h"
extern "C" 	
{
#include	"c:\dev\ezgame\ezgame.h"
}



void	main (int argc,char *argv[])
{
int		x,UpD,Pos,Game;
char	Char;

	// Set up defaults
	LoadDefaults();

	// Check to see if run from the command-line
	FromCLI=0;
	if (argc!=1)
		{
		for (x=0;x<NUM_GAMES;x++)
			{
			if (stricmp(argv[1],Games[x].CliName)==0)
				{
				FromCLI=x;
				}
			}
		}

	// Ensure that the games list is in alphabetical order
	if (!FromCLI)
		SortGamesList();

	switch ( ez_InitialiseMemory(0,200,0,0) )
		{
		case	_EZERR_OUT_OF_MEMORY:
			if (FromCLI)
				{
				MY_CloseDown();
				exit (ERROR_OUT_OF_MEMORY);
				}
			else
				ez_Error ("INSUFFICIENT MEMORY");
		break;
		}

	ez_InitialiseTimer((int)TimerHook);
	ez_InitialiseKeyboard();


	switch ( ez_SetVideoMode(0x13) )
		{
		case _EZERR_OUT_OF_MEMORY:
			ez_Error ("INSUFFICIENT MEMORY");
		break;
		}

	Palette=ez_LoadFile (1,"SAGE.PAL");
	if (!Palette)
		ez_ShowFileError();

//	if (!FromCLI)
		{

		TinyFont=ez_LoadFile (1,"TINYFONT.BIN");
		if (!TinyFont)
			ez_ShowFileError();
		}

	BigFont=ez_LoadFile (1,"BIGFONT.BIN");
	if (!BigFont)
		ez_ShowFileError();

	ez_ClearMem(BlackPal,770);
	ez_SetPalette(BlackPal);

	// Set up the large font
	ez_RegisterFontStyle (BigFont,6,FONT_PROP,0,33,13,1,1);
	ez_RegisterFontStyle (BigFont,6,FONT_PROP,1,33,13,1,2);
	ez_RegisterFontStyle (BigFont,6,FONT_PROP,2,33,13,1,3);
	ez_RegisterFontStyle (BigFont,6,FONT_PROP,3,33,13,1,4);
	ez_RegisterFontStyle (BigFont,6,FONT_PROP,4,33,13,1,5);
	ez_RegisterFontStyle (BigFont,6,FONT_PROP,5,33,13,1,6);
	ez_RegisterFontStyle (BigFont,6,FONT_PROP,6,33,13,1,7);
	ez_RegisterFontStyle (BigFont,6,FONT_PROP,7,33,13,1,255);
	ez_RegisterFontStyle (TinyFont,3,FONT_PROP,8,33,6,1,7);

	if (!FromCLI)
		{
		ReuseBox=0;
		RedColour[0]=7;
		for (x=1;x<64;x++)
			RedColour[x]=((x-1)>>3)+8;
		BlueColour[0]=7;
		for (x=1;x<64;x++)
			BlueColour[x]=((x-1)>>3)+24;
		DkBlueColour[0]=7;
		for (x=1;x<64;x++)
			DkBlueColour[x]=(((x-1)>>3)<3)?((x-1)>>3)+24:3+24;
		GreenColour[0]=7;
		for (x=1;x<64;x++)
			GreenColour[x]=((x-1)>>3)+16;

		memset (Box,0,sizeof(Box));

		ReuseBox=DrawTextBox(181,97,28,19,RedColour,sizeof(RedColour));
		}

	// Check for missing ROMS
	CheckPresenceOfRoms();

	CursorPos=ListPos=0;

	if (FromCLI)
		{
		ActivateAselection(FromCLI);
		}
	else
		{
		EnableSounds(4,11025);
		LoadSageSamples();

		ShowTitleScreen();
				
		ez_FadePalette (Palette,20);

		ConfigMode=ConfigDisplay=0;

		for (;;)
			{
			if (ez_KeyPressed[SC_ESC])
				break;

			UpD=0;

			// Check for zooming to games with pressed initial letter in name
			Char=PressedInitial();
			if (Char)
				{
				for (x=0;x<NUM_GAMES;x++)
					{
					Game=(CursorPos+ListPos+x+1)%NUM_GAMES;
					if (Game>=5 && Games[Game].GameName[0]==Char)
						{
						UpD=CursorPos+ListPos;
						CursorPos=Game;
						ListPos=0;
						if (CursorPos>NUM_ENTRY-1)
							{
							ListPos=CursorPos-NUM_ENTRY+1;
							CursorPos=NUM_ENTRY-1;
							if (ListPos>NUM_GAMES-NUM_ENTRY)
								ListPos=NUM_GAMES-NUM_ENTRY;
							}
						UpD-=(CursorPos+ListPos);
						break;
						}
					}
				}

			if (ez_KeyPressed[SC_HOME])
				{
				ez_KeyPressed[SC_HOME]=0;
				if (CursorPos+ListPos!=5)
					UpD=1;
				CursorPos=5;
				ListPos=0;
				}
			if (ez_KeyPressed[SC_END])
				{
				ez_KeyPressed[SC_END]=0;
				if (CursorPos+ListPos!=NUM_GAMES-1)
					UpD=1;
				CursorPos=NUM_ENTRY-1;
				ListPos=NUM_GAMES-NUM_ENTRY;
				}

			if (ez_KeyPressed[SC_PGUP])
				{
				UpD=CursorPos+ListPos;
				ez_KeyPressed[SC_PGUP]=0;
				CursorPos-=(NUM_ENTRY-1);
				if (CursorPos<0)
					{
					ListPos+=CursorPos;
					CursorPos=0;
					if (ListPos<0)
						ListPos=0;
					}
				if (CursorPos+ListPos<5)
					{
					CursorPos=5;
					ListPos=0;
					}
				UpD-=(CursorPos+ListPos);
				}

			if (ez_KeyPressed[SC_PGDOWN])
				{
				UpD=CursorPos+ListPos;
				ez_KeyPressed[SC_PGDOWN]=0;
				CursorPos+=(NUM_ENTRY-1);
				if (CursorPos>NUM_ENTRY-1)
					{
					ListPos+=(CursorPos-NUM_ENTRY+1);
					CursorPos=NUM_ENTRY-1;
					if (ListPos>NUM_GAMES-NUM_ENTRY)
						ListPos=NUM_GAMES-NUM_ENTRY;
					}
				if (CursorPos+ListPos>NUM_GAMES-1)
					{
					CursorPos=NUM_ENTRY-1;
					ListPos=NUM_GAMES-NUM_ENTRY;
					}
				UpD-=(CursorPos+ListPos);
				}


			if (ez_KeyPressed[SC_RIGHT])
				{
				ez_KeyPressed[SC_RIGHT]=0;
				ConfigDisplay=0;
				ConfigMode++;
				if (ConfigMode==4)
					ConfigMode=0;
				}
			if (ez_KeyPressed[SC_LEFT])
				{
				ez_KeyPressed[SC_LEFT]=0;
				ConfigDisplay=0;
				ConfigMode--;
				if (ConfigMode==-1)
					ConfigMode=3;
				}


			if (ez_KeyPressed[SC_UP])
				{
				ez_KeyPressed[SC_UP]=0;
				CursorPos--;
				UpD=1;
				if (CursorPos<0)
					{
					CursorPos=0;
					if (ListPos)
						ListPos--;
					else
						UpD=0;
					}
				}
			if (ez_KeyPressed[SC_DOWN])
				{
				ez_KeyPressed[SC_DOWN]=0;
				CursorPos++;
				UpD=1;
				if (CursorPos>=NUM_ENTRY)
					{
					CursorPos=NUM_ENTRY-1;
					if (ListPos<NUM_GAMES-NUM_ENTRY)
						ListPos++;
					else
						UpD=0;
					}
				}

			if (UpD && SoundPermitted)
				{
				ASetVoiceVolume(Voice[SND_MENU_MOVE],63*VolumeLevel/100);
				APlayVoice(Voice[SND_MENU_MOVE],SoundWaves[SND_MENU_MOVE]);
				}

			if (ez_KeyPressed[SC_RETURN] || ez_KeyPressed[SC_SPACE])
				{
				ActivateAselection(CursorPos+ListPos);
				ez_WaitForNoKeys();
				}

			ez_ClearScreen();
			PrintSelectionList(2);
			ProcessTextBox();

			ez_VidSync();
			ez_UpdateDisplay();
			ConfigDisplay++;
			if (ConfigDisplay>CONFIG_TIME)
				{
				ConfigDisplay=0;
				ConfigMode=(ConfigMode+1)&3;
				}
			}
		}
	MY_CloseDown();
	ez_SetVideoMode(3);

	// This mainly for the volume level
	SaveDefaults ();

	puts ("Thanks for playing with SAGE,");
	puts ("the Superb Arcade Game Emulator !");
	puts ("\nIf you really want, drop us an e-mail:");
	puts ("mayhem@cix.co.uk is also known as Paul Johnson");
	puts ("andy@mindeater.demon.co.uk is aka Andy Clark");
	puts ("\nGames are being added all the time,");
	puts ("so check the website regularly:");
	puts ("www.cix.co.uk/~johnson/");
	exit (1);
}


void	LoadSageSamples (void)
{
	if (SoundPermitted)
		{
		ALoadWaveFile("SAMPLES\\SAGE1.WAV",&(SoundWaves[SND_TELETYPE]),0);
		ALoadWaveFile("SAMPLES\\SAGE2.WAV",&(SoundWaves[SND_MENU_MOVE]),0);
		ALoadWaveFile("SAMPLES\\INVADER2.WAV",&(SoundWaves[SND_SELECTION]),0);
		}
}


void	ActivateAselection (int Option)
{
int		rc;
char	Pal[770];

	if (SoundPermitted && !FromCLI)
		{
		ASetVoiceVolume(Voice[SND_SELECTION],63*VolumeLevel/100);
 		APlayVoice(Voice[SND_SELECTION],SoundWaves[SND_SELECTION]);
		}

	if (!FromCLI)
		ez_WaitForNoKeys();

	if (Option==0)
		{
		ShowHelp();
		ez_WaitForNoKeys();
		}
	else
	if (Option==1)
		{
		DoSoundSetup();
		ez_WaitForNoKeys();
		}
	else
	if (Option==2)
		{
		ChangeControls();
		ez_WaitForNoKeys();
		}
	else
	if (Option==3)
		{
		ChangeOptions();
		ez_WaitForNoKeys();
		}
	else
	if (Option==4)
		{
		ShowCredits();
		ez_WaitForNoKeys();
		}
	else
		{
		// Fire up a game
		if (Games[Option].RomsPresent)
			{
			ez_CopyMem(Pal,Palette,770);
			ez_ClearMem(BlackPal,770);
			ez_FadePalette(BlackPal,20);
			ez_FadeWait(0);
			
			DisableSounds();		// Up to the emulation to ask for them back again

			rc=RunEmulation(Games[Option].GameCode);

			if (FromCLI)
				return;
			else
			if (rc)
				{
				ez_SetVideoMode(3);
				printf ("SAGE RUNTIME ERROR: %s\n",ErrorString[rc]);
				exit (rc);
				}

			ez_SetVideoMode(0x13);
			ez_ClearMem(BlackPal,770);
			ez_SetPalette(BlackPal);
			ez_CopyMem (Palette,Pal,770);
			ez_FadePalette(Palette,20);
			DisableSounds();		// To clear the system ready for the front-end sounds to work
			EnableSounds(4,11025);
			LoadSageSamples();
			}
		else
			{
			if (FromCLI)
				{
				MY_CloseDown();
				puts ("ERROR: NO ROMS");
				exit (1);
				}
			else
				{
				DisplayRomsNeeded(Option);
				}
			}
		}
}


void	ShowHelp (void)
{
int		Ret,x,y;

	DrawTextBox(181,-2,28,20,BlueColour,sizeof(BlueColour));

	for (y=0;y<NUM_PAGES;y++)
		{
		Ret=DoHelp (&Help[y]);
		if (SoundPermitted)
			{
			ASetVoiceVolume(Voice[SND_SELECTION],63*VolumeLevel/100);
 			APlayVoice(Voice[SND_SELECTION],SoundWaves[SND_SELECTION]);
			}

		ez_WaitForNoKeys();
		if (!Ret)
			{
			for (x=ReuseBox;x<BOX_PIECES;x++)
				{
				Box[x].Xc=0;
				Box[x].Yc=0;
				}
			return;
			}
		}

	for (x=ReuseBox;x<BOX_PIECES;x++)
		{
		Box[x].Xc=0;
		Box[x].Yc=0;
		}
}


int		DoHelp (HELP *Help)
{
int		Pause[NUM_HELP];
int		Col[NUM_HELP];
char	Text[NUM_HELP][64];
char	Rammel[5];
int		x;

	for (x=0;x<NUM_HELP;x++)
		{
		strcpy (Text[x],"@C[  ]");
		strcat (Text[x],Help->Text[x]);
		Pause[x]=(x+1)*8;
		sprintf (Rammel,"%02i",BlueColour[0]);
		Col[x]=BlueColour[0];
		Text[x][3]=Rammel[0];
		Text[x][4]=Rammel[1];
		}

	for (;;)
		{
		ez_ClearScreen();
		PrintSelectionList(0);
		ProcessTextBox();
		for (x=0;x<NUM_HELP;x++)
			{
			if (Pause[x])
				{
				Pause[x]--;
				if (SoundPermitted && Pause[x]==0 && strlen(Help->Text[x]))
					{
					ASetVoiceVolume(Voice[SND_TELETYPE],63*VolumeLevel/100);
					APlayVoice(Voice[SND_TELETYPE],SoundWaves[SND_TELETYPE]);
					}
				}
			else
			if (Col[x]<64)
				{
				sprintf (Rammel,"%02i",BlueColour[Col[x]]);
				Text[x][3]=Rammel[0];
				Text[x][4]=Rammel[1];
				Col[x]++;
				}

			if (!Pause[x])
				{
				ez_PrintText (Text[x],8,FONT_CENTER,250,6+x*7,EZ_NO_CLIP);
				}
			}
		ez_VidSync();
		ez_UpdateDisplay();

		if (ez_KeyPressed[SC_ESC])
			return (0);
		else
		if (ez_KeyPressed[SC_RETURN] || ez_KeyPressed[SC_SPACE])
			return (1);
		}
}


void	ChangeOptions (void)
{
int		Key,x;

	DrawTextBox(181,-2,28,20,BlueColour,sizeof(BlueColour));

	for (;;)
		{
		ConfigMode=3;
		ConfigDisplay=0;
		ez_ClearScreen();
		PrintSelectionList(0);
		ProcessTextBox();

		ez_PrintText ("@C[31]DO YOU WISH TO USE A",8,FONT_CENTER,250,20,EZ_NO_CLIP);
		ez_PrintText ("@C[31]JOYSTICK ? PRESS @C[7]Y@C[31] OR @C[7]N@C[31]",8,FONT_CENTER,250,27,EZ_NO_CLIP);

		ez_PrintText ("@C[28]TIP: IF ONE IS NOT CONNECTED",8,FONT_CENTER,250,40,EZ_NO_CLIP);
		ez_PrintText ("@C[28]HIT 'N' ELSE THE GAME WILL",8,FONT_CENTER,250,47,EZ_NO_CLIP);
		ez_PrintText ("@C[28]RUN MUCH SLOWER.",8,FONT_CENTER,250,54,EZ_NO_CLIP);

		Key=ez_ReadCurrentKey();
		if (Key==SC_ESC || Key==SC_RETURN || Key==SC_SPACE)
			{
			if (SoundPermitted)
				{
				ASetVoiceVolume(Voice[SND_SELECTION],63*VolumeLevel/100);
 				APlayVoice(Voice[SND_SELECTION],SoundWaves[SND_SELECTION]);
				}
			break;
			}

		if (Key==SC_Y)
			{
			if (SoundPermitted)
				{
				ASetVoiceVolume(Voice[SND_SELECTION],63*VolumeLevel/100);
 				APlayVoice(Voice[SND_SELECTION],SoundWaves[SND_SELECTION]);
				}
			UseJoySticks=1;
			SaveDefaults();
			break;
			}

		if (Key==SC_N)
			{
			if (SoundPermitted)
				{
				ASetVoiceVolume(Voice[SND_SELECTION],63*VolumeLevel/100);
 				APlayVoice(Voice[SND_SELECTION],SoundWaves[SND_SELECTION]);
				}
			UseJoySticks=0;
			SaveDefaults();
			break;
			}

		ez_VidSync();
		ez_UpdateDisplay();
		}

	ez_WaitForNoKeys();

	for (;;)
		{
		ConfigMode=3;
		ConfigDisplay=0;
		ez_ClearScreen();
		PrintSelectionList(0);
		ProcessTextBox();

		ez_PrintText ("@C[31]CHOOSE EMULATION STYLE",8,FONT_CENTER,250,20,EZ_NO_CLIP);
		ez_PrintText ("@C[31]PRESS '@C[7]A@C[31]' FOR ACCURATE SPEED",8,FONT_CENTER,250,30,EZ_NO_CLIP);
		ez_PrintText ("@C[31]PRESS '@C[7]S@C[31]' FOR SMOOTH DISPLAY",8,FONT_CENTER,250,37,EZ_NO_CLIP);

		Key=ez_ReadCurrentKey();
		if (Key==SC_ESC || Key==SC_RETURN || Key==SC_SPACE)
			{
			if (SoundPermitted)
				{
				ASetVoiceVolume(Voice[SND_SELECTION],63*VolumeLevel/100);
 				APlayVoice(Voice[SND_SELECTION],SoundWaves[SND_SELECTION]);
				}
			break;
			}

		if (Key==SC_A)
			{
			if (SoundPermitted)
				{
				ASetVoiceVolume(Voice[SND_SELECTION],63*VolumeLevel/100);
 				APlayVoice(Voice[SND_SELECTION],SoundWaves[SND_SELECTION]);
				}
			UseAccurateVsync=1;
			SaveDefaults();
			break;
			}

		if (Key==SC_S)
			{
			if (SoundPermitted)
				{
				ASetVoiceVolume(Voice[SND_SELECTION],63*VolumeLevel/100);
 				APlayVoice(Voice[SND_SELECTION],SoundWaves[SND_SELECTION]);
				}
			UseAccurateVsync=0;
			SaveDefaults();
			break;
			}

		ez_VidSync();
		ez_UpdateDisplay();
		}

	ez_WaitForNoKeys();


	for (;;)
		{
		ConfigMode=3;
		ConfigDisplay=0;
		ez_ClearScreen();
		PrintSelectionList(0);
		ProcessTextBox();

		ez_PrintText ("@C[31]CHOOSE DISPLAY QUALITY",8,FONT_CENTER,250,20,EZ_NO_CLIP);
		ez_PrintText ("@C[31]PRESS '@C[7]A@C[31]' FOR ARCADE STYLE",8,FONT_CENTER,250,30,EZ_NO_CLIP);
		ez_PrintText ("@C[31]PRESS '@C[7]M@C[31]' FOR MONITOR STYLE",8,FONT_CENTER,250,37,EZ_NO_CLIP);

		Key=ez_ReadCurrentKey();
		if (Key==SC_ESC || Key==SC_RETURN || Key==SC_SPACE)
			{
			if (SoundPermitted)
				{
				ASetVoiceVolume(Voice[SND_SELECTION],63*VolumeLevel/100);
 				APlayVoice(Voice[SND_SELECTION],SoundWaves[SND_SELECTION]);
				}
			break;
			}

		if (Key==SC_A)
			{
			if (SoundPermitted)
				{
				ASetVoiceVolume(Voice[SND_SELECTION],63*VolumeLevel/100);
 				APlayVoice(Voice[SND_SELECTION],SoundWaves[SND_SELECTION]);
				}
			UseScanLines=1;
			SaveDefaults();
			break;
			}

		if (Key==SC_M)
			{
			if (SoundPermitted)
				{
				ASetVoiceVolume(Voice[SND_SELECTION],63*VolumeLevel/100);
 				APlayVoice(Voice[SND_SELECTION],SoundWaves[SND_SELECTION]);
				}
			UseScanLines=0;
			SaveDefaults();
			break;
			}

		ez_VidSync();
		ez_UpdateDisplay();
		}


	for (x=ReuseBox;x<BOX_PIECES;x++)
		{
		Box[x].Xc=0;
		Box[x].Yc=0;
		}
	return;
}

void	ChangeControls (void)
{
int		x;

	DrawTextBox(181,-2,28,20,BlueColour,sizeof(BlueColour));

	Player1Up=GetKeyFor("Player 1:  UP");
	if (SoundPermitted)
		{
		ASetVoiceVolume(Voice[SND_SELECTION],63*VolumeLevel/100);
 		APlayVoice(Voice[SND_SELECTION],SoundWaves[SND_SELECTION]);
		}
	if (Player1Up==SC_ESC)
		{
		LoadDefaults();
		for (x=ReuseBox;x<BOX_PIECES;x++)
			{
			Box[x].Xc=0;
			Box[x].Yc=0;
			}
		return;
		}
	Player1Down=GetKeyFor("Player 1:  DOWN");
	if (SoundPermitted)
		{
		ASetVoiceVolume(Voice[SND_SELECTION],63*VolumeLevel/100);
 		APlayVoice(Voice[SND_SELECTION],SoundWaves[SND_SELECTION]);
		}
	if (Player1Down==SC_ESC)
		{
		LoadDefaults();
		for (x=ReuseBox;x<BOX_PIECES;x++)
			{
			Box[x].Xc=0;
			Box[x].Yc=0;
			}
		return;
		}
	Player1Left=GetKeyFor("Player 1:  LEFT");
	if (SoundPermitted)
		{
		ASetVoiceVolume(Voice[SND_SELECTION],63*VolumeLevel/100);
 		APlayVoice(Voice[SND_SELECTION],SoundWaves[SND_SELECTION]);
		}
	if (Player1Left==SC_ESC)
		{
		LoadDefaults();
		for (x=ReuseBox;x<BOX_PIECES;x++)
			{
			Box[x].Xc=0;
			Box[x].Yc=0;
			}
		return;
		}
	Player1Right=GetKeyFor("Player 1:  RIGHT");
	if (SoundPermitted)
		{
		ASetVoiceVolume(Voice[SND_SELECTION],63*VolumeLevel/100);
 		APlayVoice(Voice[SND_SELECTION],SoundWaves[SND_SELECTION]);
		}
	if (Player1Right==SC_ESC)
		{
		LoadDefaults();
		for (x=ReuseBox;x<BOX_PIECES;x++)
			{
			Box[x].Xc=0;
			Box[x].Yc=0;
			}
		return;
		}
	Player1Fire1=GetKeyFor("Player 1:  FIRE BUTTON");
	if (SoundPermitted)
		{
		ASetVoiceVolume(Voice[SND_SELECTION],63*VolumeLevel/100);
 		APlayVoice(Voice[SND_SELECTION],SoundWaves[SND_SELECTION]);
		}
	if (Player1Fire1==SC_ESC)
		{
		LoadDefaults();
		for (x=ReuseBox;x<BOX_PIECES;x++)
			{
			Box[x].Xc=0;
			Box[x].Yc=0;
			}
		return;
		}
	Player1Fire2=GetKeyFor("Player 1:  BUTTON 2");
	if (SoundPermitted)
		{
		ASetVoiceVolume(Voice[SND_SELECTION],63*VolumeLevel/100);
 		APlayVoice(Voice[SND_SELECTION],SoundWaves[SND_SELECTION]);
		}
	if (Player1Fire2==SC_ESC)
		{
		LoadDefaults();
		for (x=ReuseBox;x<BOX_PIECES;x++)
			{
			Box[x].Xc=0;
			Box[x].Yc=0;
			}
		return;
		}
	Player1Fire3=GetKeyFor("Player 1:  BUTTON 3");
	if (SoundPermitted)
		{
		ASetVoiceVolume(Voice[SND_SELECTION],63*VolumeLevel/100);
 		APlayVoice(Voice[SND_SELECTION],SoundWaves[SND_SELECTION]);
		}
	if (Player1Fire3==SC_ESC)
		{
		LoadDefaults();
		for (x=ReuseBox;x<BOX_PIECES;x++)
			{
			Box[x].Xc=0;
			Box[x].Yc=0;
			}
		return;
		}
	Player2Up=GetKeyFor("Player 2:  UP");
	if (SoundPermitted)
		{
		ASetVoiceVolume(Voice[SND_SELECTION],63*VolumeLevel/100);
 		APlayVoice(Voice[SND_SELECTION],SoundWaves[SND_SELECTION]);
		}
	if (Player2Up==SC_ESC)
		{
		LoadDefaults();
		for (x=ReuseBox;x<BOX_PIECES;x++)
			{
			Box[x].Xc=0;
			Box[x].Yc=0;
			}
		return;
		}
	Player2Down=GetKeyFor("Player 2:  DOWN");
	if (SoundPermitted)
		{
		ASetVoiceVolume(Voice[SND_SELECTION],63*VolumeLevel/100);
 		APlayVoice(Voice[SND_SELECTION],SoundWaves[SND_SELECTION]);
		}
	if (Player2Down==SC_ESC)
		{
		LoadDefaults();
		for (x=ReuseBox;x<BOX_PIECES;x++)
			{
			Box[x].Xc=0;
			Box[x].Yc=0;
			}
		return;
		}

	Player2Left=GetKeyFor("Player 2:  LEFT");
	if (SoundPermitted)
		{
		ASetVoiceVolume(Voice[SND_SELECTION],63*VolumeLevel/100);
 		APlayVoice(Voice[SND_SELECTION],SoundWaves[SND_SELECTION]);
		}
	if (Player2Left==SC_ESC)
		{
		LoadDefaults();
		for (x=ReuseBox;x<BOX_PIECES;x++)
			{
			Box[x].Xc=0;
			Box[x].Yc=0;
			}
		return;
		}
	Player2Right=GetKeyFor("Player 2:  RIGHT");
	if (SoundPermitted)
		{
		ASetVoiceVolume(Voice[SND_SELECTION],63*VolumeLevel/100);
 		APlayVoice(Voice[SND_SELECTION],SoundWaves[SND_SELECTION]);
		}
	if (Player2Right==SC_ESC)
		{
		LoadDefaults();
		for (x=ReuseBox;x<BOX_PIECES;x++)
			{
			Box[x].Xc=0;
			Box[x].Yc=0;
			}
		return;
		}
	Player2Fire1=GetKeyFor("Player 2:  FIRE BUTTON");
	if (SoundPermitted)
		{
		ASetVoiceVolume(Voice[SND_SELECTION],63*VolumeLevel/100);
 		APlayVoice(Voice[SND_SELECTION],SoundWaves[SND_SELECTION]);
		}
	if (Player2Fire1==SC_ESC)
		{
		LoadDefaults();
		for (x=ReuseBox;x<BOX_PIECES;x++)
			{
			Box[x].Xc=0;
			Box[x].Yc=0;
			}
		return;
		}
	Player2Fire2=GetKeyFor("Player 2:  BUTTON 2");
	if (SoundPermitted)
		{
		ASetVoiceVolume(Voice[SND_SELECTION],63*VolumeLevel/100);
 		APlayVoice(Voice[SND_SELECTION],SoundWaves[SND_SELECTION]);
		}
	if (Player2Fire2==SC_ESC)
		{
		LoadDefaults();
		for (x=ReuseBox;x<BOX_PIECES;x++)
			{
			Box[x].Xc=0;
			Box[x].Yc=0;
			}
		return;
		}
	Player2Fire3=GetKeyFor("Player 2:  BUTTON 3");
	if (SoundPermitted)
		{
		ASetVoiceVolume(Voice[SND_SELECTION],63*VolumeLevel/100);
 		APlayVoice(Voice[SND_SELECTION],SoundWaves[SND_SELECTION]);
		}
	if (Player2Fire3==SC_ESC)
		{
		LoadDefaults();
		for (x=ReuseBox;x<BOX_PIECES;x++)
			{
			Box[x].Xc=0;
			Box[x].Yc=0;
			}
		return;
		}

	for (x=ReuseBox;x<BOX_PIECES;x++)
		{
		Box[x].Xc=0;
		Box[x].Yc=0;
		}

	if (SoundPermitted)
		{
		ASetVoiceVolume(Voice[SND_SELECTION],63*VolumeLevel/100);
 		APlayVoice(Voice[SND_SELECTION],SoundWaves[SND_SELECTION]);
		}

	SaveDefaults();
}


int		GetKeyFor (char *Text)
{
char	Txt[64];
char	*String=NULL;
int		Key=-1;

	strcpy (Txt,"@C[7]");
	strcat (Txt,Text);

	for (;;)
		{
		ConfigMode=0;
		ConfigDisplay=0;
		ez_ClearScreen();
		PrintSelectionList(0);
		ProcessTextBox();

		ez_PrintText ("@C[31]CONTROL REDEFINITION:",8,FONT_CENTER,250,13,EZ_NO_CLIP);
		ez_PrintText ("@C[31]PLEASE PRESS A KEY FOR",8,FONT_CENTER,250,20,EZ_NO_CLIP);
		ez_PrintText ("@C[26]PRESS ESCAPE TO RESTORE",8,FONT_CENTER,250,80,EZ_NO_CLIP);

		ez_PrintText (Txt,8,FONT_CENTER,250,30,EZ_NO_CLIP);

		Key=ez_ReadCurrentKey();
		if (Key==SC_ESC)
			return (Key);

		if (Key!=-1)
			String=ScanCodeToString[Key];

		if (String && strlen(String))
			ez_PrintText (String,6,FONT_CENTER,250,50,EZ_NO_CLIP);

		ez_VidSync();
		ez_UpdateDisplay();

		if (Key!=-1)
			{
			ez_WaitForNoKeys();
			return (Key);
			}
		}
}


#define	MAX_ROMS	13

void	DisplayRomsNeeded (int Game)
{
int		x,Pos,Len,l;
int		Pause[NUM_ROMS];
int		Col[NUM_ROMS];
char	Text[NUM_ROMS][128];
char	Dummy[128];
char	Rammel[5];


	// Find all the ROMs that are missing
	Pos=0;
	for (x=0;x<NUM_ROMS && Pos<MAX_ROMS;x++)
		{
		if (!Games[Game].Rom[x].Present && Games[Game].Rom[x].Name && strlen(Games[Game].Rom[x].Name))
			{
			strcpy (Text[Pos],"@C[  ]");
			strcat (Text[Pos],Games[Game].Rom[x].Name);
			Pause[Pos]=(Pos+1)*8;
				sprintf (Rammel,"%02i",GreenColour[0]);
			Col[Pos]=GreenColour[0];
			Text[Pos][3]=Rammel[0];
			Text[Pos][4]=Rammel[1];
			Pos++;
			}
		}

	DrawTextBox(181,-2,28,20,GreenColour,sizeof(GreenColour));


	// Get the maximum line-length
	Len=0;
	for (x=0;x<Pos;x++)
		{
		strcpy (Dummy,Text[x]);
		sprintf (Rammel,"%02i",GreenColour[Col[x]]);
		Dummy[3]=Rammel[0];
		Dummy[4]=Rammel[1];

		l=ez_GetTextStringLength(8,Dummy);
		if (l>Len) Len=l;
		}

	// Print them up
	for (;;)
		{
		ez_ClearScreen();
		ez_PrintText ("@C[19]COULD NOT FIND ROMS NAMED:",8,FONT_CENTER,250,3,EZ_NO_CLIP);
		PrintSelectionList(0);
		ProcessTextBox();
		for (x=0;x<Pos;x++)
			{
			if (Pause[x])
				{
				Pause[x]--;
				if (SoundPermitted && Pause[x]==0)
					{
					ASetVoiceVolume(Voice[SND_TELETYPE],63*VolumeLevel/100);
					APlayVoice(Voice[SND_TELETYPE],SoundWaves[SND_TELETYPE]);
					}
				}
			else
			if (Col[x]<64)
				{
				sprintf (Rammel,"%02i",GreenColour[Col[x]]);
				Text[x][3]=Rammel[0];
				Text[x][4]=Rammel[1];
				Col[x]++;
				}
		
			if (!Pause[x])
				{
				//ez_PrintText (Text[x],8,FONT_CENTER,250,16+x*6,EZ_NO_CLIP);
				ez_PrintText (Text[x],8,FONT_LEFT,252-(Len>>1),16+x*6,EZ_NO_CLIP);
				}
			}
		ez_VidSync();
		ez_UpdateDisplay();

		if (ez_KeyPressed[SC_ESC] || ez_KeyPressed[SC_RETURN] || ez_KeyPressed[SC_SPACE])
			{
			for (x=ReuseBox;x<BOX_PIECES;x++)
				{
				Box[x].Xc=0;
				Box[x].Yc=0;
				}
			if (SoundPermitted)
				{
				ASetVoiceVolume(Voice[SND_TELETYPE],63*VolumeLevel/100);
				APlayVoice(Voice[SND_TELETYPE],SoundWaves[SND_TELETYPE]);
				}
			return;
			}
		}
}

void	ShowCredits (void)
{
int		x;
int		Pause[NUM_CRED];
int		Col[NUM_CRED];
char	Text[NUM_CRED][64];
char	Rammel[5];

	for (x=0;x<NUM_CRED;x++)
		{
		strcpy (Text[x],"@C[  ]");
		strcat (Text[x],Credits[x].Text);
		Pause[x]=(x+1)*8;
		if (Credits[x].Col)
			sprintf (Rammel,"%02i",BlueColour[0]);
		else
			sprintf (Rammel,"%02i",DkBlueColour[0]);
		Col[x]=BlueColour[0];
		Text[x][3]=Rammel[0];
		Text[x][4]=Rammel[1];
		}

	DrawTextBox(181,-2,28,20,BlueColour,sizeof(BlueColour));
	for (;;)
		{
		ez_ClearScreen();
		PrintSelectionList(0);
		ProcessTextBox();
		for (x=0;x<NUM_CRED;x++)
			{
			if (Pause[x])
				{
				Pause[x]--;
				if (SoundPermitted && Pause[x]==0)
					{
					ASetVoiceVolume(Voice[SND_TELETYPE],63*VolumeLevel/100);
					APlayVoice(Voice[SND_TELETYPE],SoundWaves[SND_TELETYPE]);
					}
				}
			else
			if (Col[x]<64)
				{

				if (Credits[x].Col)
					sprintf (Rammel,"%02i",BlueColour[Col[x]]);
				else
					sprintf (Rammel,"%02i",DkBlueColour[Col[x]]);
				Text[x][3]=Rammel[0];
				Text[x][4]=Rammel[1];
				Col[x]++;
				}

			if (!Pause[x])
				{
				ez_PrintText (Text[x],8,FONT_CENTER,250,6+x*7,EZ_NO_CLIP);
				}
			}
		ez_VidSync();
		ez_UpdateDisplay();

		if (ez_KeyPressed[SC_ESC] || ez_KeyPressed[SC_RETURN] || ez_KeyPressed[SC_SPACE])
			{
			for (x=ReuseBox;x<BOX_PIECES;x++)
				{
				Box[x].Xc=0;
				Box[x].Yc=0;
				}
			if (SoundPermitted)
				{
				ASetVoiceVolume(Voice[SND_TELETYPE],63*VolumeLevel/100);
				APlayVoice(Voice[SND_TELETYPE],SoundWaves[SND_TELETYPE]);
				}
			return;
			}
		}
}

void	DoSoundSetup (void)
{
int		x;
int		Pause[NUM_SOUND];
int		Col[NUM_SOUND];
char	Text[NUM_SOUND][64];
char	Rammel[5];

	for (x=0;x<NUM_SOUND;x++)
		{
		if (x<3)
			{
			strcpy (Text[x],"@C[  ]");
			strcat (Text[x],SoundSettings[x].CardName);
			Pause[x]=(x+1)*8;
			sprintf (Rammel,"%02i",BlueColour[0]);
			Col[x]=BlueColour[0];
			Text[x][3]=Rammel[0];
			Text[x][4]=Rammel[1];
			}
		else
			{
			sprintf (Text[x],"@C[7] %i@J[16]@C[  ]",x-3);
			strcat (Text[x],SoundSettings[x].CardName);
			Pause[x]=(x+1)*8;
			sprintf (Rammel,"%02i",BlueColour[0]);
			Col[x]=BlueColour[0];
			Text[x][16]=Rammel[0];
			Text[x][17]=Rammel[1];
			}
		}

	DrawTextBox(181,-2,28,20,BlueColour,sizeof(BlueColour));
	for (;;)
		{
		ConfigMode=3;
		ConfigDisplay=0;
		ez_ClearScreen();
		PrintSelectionList(0);
		ProcessTextBox();
		for (x=0;x<NUM_SOUND;x++)
			{
			if (Pause[x])
				{
				Pause[x]--;
				if (SoundPermitted && Pause[x]==0)
					{
					ASetVoiceVolume(Voice[SND_TELETYPE],63*VolumeLevel/100);
					APlayVoice(Voice[SND_TELETYPE],SoundWaves[SND_TELETYPE]);
					}
				}
			else
			if (Col[x]<64)
				{
				if (x<3)
					{
					sprintf (Rammel,"%02i",BlueColour[Col[x]]);
					Text[x][3]=Rammel[0];
					Text[x][4]=Rammel[1];
					}
				else
					{
					sprintf (Rammel,"%02i",BlueColour[Col[x]]);
					Text[x][16]=Rammel[0];
					Text[x][17]=Rammel[1];
					}
				Col[x]++;
				}

			if (!Pause[x])
				{
				if (x<3)
					{
					ez_PrintText (Text[x],8,FONT_LEFT,188,6+x*7,EZ_NO_CLIP);
					}
				else
					{
					ez_PrintText (Text[x],8,FONT_LEFT,188,6+(x+1)*7,EZ_NO_CLIP);
					}
				}
			}
		ez_VidSync();
		ez_UpdateDisplay();

		if (ez_KeyPressed[SC_0] || ez_KeyPressed[SC_NUM0])
			{
			SoundCardToUse=0;
			for (x=ReuseBox;x<BOX_PIECES;x++)
				{
				Box[x].Xc=0;
				Box[x].Yc=0;
				}
			DisableSounds();
			EnableSounds(4,11025);
			LoadSageSamples();
			if (SoundPermitted)
				{
				ASetVoiceVolume(Voice[SND_SELECTION],63*VolumeLevel/100);
 				APlayVoice(Voice[SND_SELECTION],SoundWaves[SND_SELECTION]);
				}
			SaveDefaults();
			return;
			}
		if (ez_KeyPressed[SC_1] || ez_KeyPressed[SC_NUM1])
			{
			SoundCardToUse=1;
			for (x=ReuseBox;x<BOX_PIECES;x++)
				{
				Box[x].Xc=0;
				Box[x].Yc=0;
				}
			DisableSounds();
			EnableSounds(4,11025);
			LoadSageSamples();
			if (SoundPermitted)
				{
				ASetVoiceVolume(Voice[SND_SELECTION],63*VolumeLevel/100);
 				APlayVoice(Voice[SND_SELECTION],SoundWaves[SND_SELECTION]);
				}
			SaveDefaults();
			return;
			}
		if (ez_KeyPressed[SC_2] || ez_KeyPressed[SC_NUM2])
			{
			SoundCardToUse=2;
			for (x=ReuseBox;x<BOX_PIECES;x++)
				{
				Box[x].Xc=0;
				Box[x].Yc=0;
				}
			DisableSounds();
			EnableSounds(4,11025);
			LoadSageSamples();
			if (SoundPermitted)
				{
				ASetVoiceVolume(Voice[SND_SELECTION],63*VolumeLevel/100);
 				APlayVoice(Voice[SND_SELECTION],SoundWaves[SND_SELECTION]);
				}
			SaveDefaults();
			return;
			}
		if (ez_KeyPressed[SC_3] || ez_KeyPressed[SC_NUM3])
			{
			SoundCardToUse=3;
			for (x=ReuseBox;x<BOX_PIECES;x++)
				{
				Box[x].Xc=0;
				Box[x].Yc=0;
				}
			DisableSounds();
			EnableSounds(4,11025);
			LoadSageSamples();
			if (SoundPermitted)
				{
				ASetVoiceVolume(Voice[SND_SELECTION],63*VolumeLevel/100);
 				APlayVoice(Voice[SND_SELECTION],SoundWaves[SND_SELECTION]);
				}
			SaveDefaults();
			return;
			}
		if (ez_KeyPressed[SC_4] || ez_KeyPressed[SC_NUM4])
			{
			SoundCardToUse=4;
			for (x=ReuseBox;x<BOX_PIECES;x++)
				{
				Box[x].Xc=0;
				Box[x].Yc=0;
				}
			DisableSounds();
			EnableSounds(4,11025);
			LoadSageSamples();
			if (SoundPermitted)
				{
				ASetVoiceVolume(Voice[SND_SELECTION],63*VolumeLevel/100);
 				APlayVoice(Voice[SND_SELECTION],SoundWaves[SND_SELECTION]);
				}
			SaveDefaults();
			return;
			}
		if (ez_KeyPressed[SC_RETURN] || ez_KeyPressed[SC_SPACE] || ez_KeyPressed[SC_ESC])
			{
			if (SoundPermitted)
				{
				ASetVoiceVolume(Voice[SND_SELECTION],63*VolumeLevel/100);
 				APlayVoice(Voice[SND_SELECTION],SoundWaves[SND_SELECTION]);
				}
			for (x=ReuseBox;x<BOX_PIECES;x++)
				{
				Box[x].Xc=0;
				Box[x].Yc=0;
				}
			return;
			}
		}
}


void	PrintConfig (void)
{
char	Text[256];

	switch (ConfigMode)
		{
		case	0:

			ez_PrintText ("@C[07]GAME CONTROLS",8,FONT_CENTER,250,106,EZ_NO_CLIP);

			ez_PrintText ("@C[11]            PLAYER 1  PLAYER 2",8,FONT_CENTER,250,120,EZ_NO_CLIP);
			ez_PrintText ("@C[11]UP:",8,FONT_LEFT,188,130,EZ_NO_CLIP);
			ez_PrintText ("@C[11]DOWN:",8,FONT_LEFT,188,137,EZ_NO_CLIP);
			ez_PrintText ("@C[11]LEFT:",8,FONT_LEFT,188,144,EZ_NO_CLIP);
			ez_PrintText ("@C[11]RIGHT:",8,FONT_LEFT,188,151,EZ_NO_CLIP);
			ez_PrintText ("@C[11]FIRE:",8,FONT_LEFT,188,158,EZ_NO_CLIP);
			ez_PrintText ("@C[11]BTN 2:",8,FONT_LEFT,188,165,EZ_NO_CLIP);
			ez_PrintText ("@C[11]BTN 3:",8,FONT_LEFT,188,172,EZ_NO_CLIP);
	
			sprintf (Text,"@C[15]%s",ScanCodeToString[Player1Up]);
			ez_PrintText (Text,8,FONT_CENTER,250,130,EZ_NO_CLIP);

			sprintf (Text,"@C[15]%s",ScanCodeToString[Player1Down]);
			ez_PrintText (Text,8,FONT_CENTER,250,137,EZ_NO_CLIP);

			sprintf (Text,"@C[15]%s",ScanCodeToString[Player1Left]);
			ez_PrintText (Text,8,FONT_CENTER,250,144,EZ_NO_CLIP);

			sprintf (Text,"@C[15]%s",ScanCodeToString[Player1Right]);
			ez_PrintText (Text,8,FONT_CENTER,250,151,EZ_NO_CLIP);

			sprintf (Text,"@C[15]%s",ScanCodeToString[Player1Fire1]);
			ez_PrintText (Text,8,FONT_CENTER,250,158,EZ_NO_CLIP);

			sprintf (Text,"@C[15]%s",ScanCodeToString[Player1Fire2]);
			ez_PrintText (Text,8,FONT_CENTER,250,165,EZ_NO_CLIP);

			sprintf (Text,"@C[15]%s",ScanCodeToString[Player1Fire3]);
			ez_PrintText (Text,8,FONT_CENTER,250,172,EZ_NO_CLIP);

			sprintf (Text,"@C[15]%s",ScanCodeToString[Player2Up]);
			ez_PrintText (Text,8,FONT_CENTER,293,130,EZ_NO_CLIP);

			sprintf (Text,"@C[15]%s",ScanCodeToString[Player2Down]);
			ez_PrintText (Text,8,FONT_CENTER,293,137,EZ_NO_CLIP);

			sprintf (Text,"@C[15]%s",ScanCodeToString[Player2Left]);
			ez_PrintText (Text,8,FONT_CENTER,293,144,EZ_NO_CLIP);

			sprintf (Text,"@C[15]%s",ScanCodeToString[Player2Right]);
			ez_PrintText (Text,8,FONT_CENTER,293,151,EZ_NO_CLIP);

			sprintf (Text,"@C[15]%s",ScanCodeToString[Player2Fire1]);
			ez_PrintText (Text,8,FONT_CENTER,293,158,EZ_NO_CLIP);

			sprintf (Text,"@C[15]%s",ScanCodeToString[Player2Fire2]);
			ez_PrintText (Text,8,FONT_CENTER,293,165,EZ_NO_CLIP);

			sprintf (Text,"@C[15]%s",ScanCodeToString[Player2Fire3]);
			ez_PrintText (Text,8,FONT_CENTER,293,172,EZ_NO_CLIP);

		break;


		case	1:

			ez_PrintText ("@C[07]MORE GAME CONTROLS",8,FONT_CENTER,250,106,EZ_NO_CLIP);

			ez_PrintText ("@C[11]1 Player Start:@C[15]@J[70]1",8,FONT_LEFT,188,120,EZ_NO_CLIP);
			ez_PrintText ("@C[11]2 Player Start:@C[15]@J[70]2",8,FONT_LEFT,188,127,EZ_NO_CLIP);
			ez_PrintText ("@C[11]Coin:@C[15]@J[70]3",8,FONT_LEFT,188,134,EZ_NO_CLIP);
			ez_PrintText ("@C[11]Pause:@C[15]@J[70]P or F4",8,FONT_LEFT,188,141,EZ_NO_CLIP);
			ez_PrintText ("@C[11]SlowMo:@C[15]@J[70]S",8,FONT_LEFT,188,148,EZ_NO_CLIP);
			ez_PrintText ("@C[11]Frame Rate:@C[15]@J[70]F1",8,FONT_LEFT,188,155,EZ_NO_CLIP);
			ez_PrintText ("@C[11]Toggle Speed:@C[15]@J[70]F2",8,FONT_LEFT,188,162,EZ_NO_CLIP);
			ez_PrintText ("@C[11]Toggle Sync:@C[15]@J[70]F3",8,FONT_LEFT,188,169,EZ_NO_CLIP);
			ez_PrintText ("@C[11]Snapshot:@C[15]@J[70]F12",8,FONT_LEFT,188,176,EZ_NO_CLIP);

		break;

		case	2:

			ez_PrintText ("@C[07]MENU CONTROLS",8,FONT_CENTER,250,106,EZ_NO_CLIP);

			ez_PrintText ("@C[11]Scroll Up:@C[15]@J[70]Cursor Up",8,FONT_LEFT,188,120,EZ_NO_CLIP);
			ez_PrintText ("@C[11]Scroll Down:@C[15]@J[70]Cursor Down",8,FONT_LEFT,188,127,EZ_NO_CLIP);
			ez_PrintText ("@C[11]Fast Up:@C[15]@J[70]Page Up",8,FONT_LEFT,188,134,EZ_NO_CLIP);
			ez_PrintText ("@C[11]Fast Down:@C[15]@J[70]Page Down",8,FONT_LEFT,188,141,EZ_NO_CLIP);
			ez_PrintText ("@C[11]Top:@C[15]@J[70]Home",8,FONT_LEFT,188,148,EZ_NO_CLIP);
			ez_PrintText ("@C[11]Bottom:@C[15]@J[70]End",8,FONT_LEFT,188,155,EZ_NO_CLIP);
			ez_PrintText ("@C[11]Select:@C[15]@J[70]Enter/Space",8,FONT_LEFT,188,162,EZ_NO_CLIP);
			ez_PrintText ("@C[11]Cancel/Quit:@C[15]@J[70]Escape",8,FONT_LEFT,188,169,EZ_NO_CLIP);
			ez_PrintText ("@C[11]Dip Switch:@C[15]@J[70]Tab",8,FONT_LEFT,188,176,EZ_NO_CLIP);

		break;


		case	3:

			ez_PrintText ("@C[07]EMULATOR SETUP",8,FONT_CENTER,250,106,EZ_NO_CLIP);

			sprintf (Text,"@C[11]SOUNDCARD:@C[15]@J[70]%s",SoundSettings[SoundCardToUse+3].CardName);
			ez_PrintText (Text,8,FONT_LEFT,188,120,EZ_NO_CLIP);

			sprintf (Text,"@C[11]JOYSTICK ?:@C[15]@J[70]%s",UseJoySticks?"YES":"NO");
			ez_PrintText (Text,8,FONT_LEFT,188,134,EZ_NO_CLIP);

			sprintf (Text,"@C[11]DISPLAY SPEED:@C[15]@J[70]%s",UseAccurateVsync?"ACCURATE":"SMOOTH");
			ez_PrintText (Text,8,FONT_LEFT,188,148,EZ_NO_CLIP);

			sprintf (Text,"@C[11]SCREEN QUALITY:@C[15]@J[70]%s",UseScanLines?"ARCADE":"MONITOR");
			ez_PrintText (Text,8,FONT_LEFT,188,162,EZ_NO_CLIP);



		break;
		}
}









/*
			sprintf (Text,"@C[11]SND:@C[15]%s",SoundSettings[SoundCardToUse+3].CardName);
			ez_PrintText (Text,8,FONT_LEFT,188,102,EZ_NO_CLIP);
			sprintf (Text,"@C[11]JSTK:@C[15]%s",UseJoySticks?"YES":"NO");
			ez_PrintText (Text,8,FONT_LEFT,280,102,EZ_NO_CLIP);

			ez_PrintText ("@C[11]CONTROLS  PLAYER 1  PLAYER 2",8,FONT_CENTER,250,110,EZ_NO_CLIP);

			ez_PrintText ("@C[11]UP:",8,FONT_LEFT,188,120,EZ_NO_CLIP);
			ez_PrintText ("@C[11]DOWN:",8,FONT_LEFT,188,127,EZ_NO_CLIP);
			ez_PrintText ("@C[11]LEFT:",8,FONT_LEFT,188,134,EZ_NO_CLIP);
			ez_PrintText ("@C[11]RIGHT:",8,FONT_LEFT,188,141,EZ_NO_CLIP);
			ez_PrintText ("@C[11]FIRE:",8,FONT_LEFT,188,148,EZ_NO_CLIP);
			ez_PrintText ("@C[11]BTN 2:",8,FONT_LEFT,188,155,EZ_NO_CLIP);
			ez_PrintText ("@C[11]BTN 3:",8,FONT_LEFT,188,162,EZ_NO_CLIP);
			ez_PrintText ("@C[11]DIP S/W:               COIN:  @C[15]3",8,FONT_LEFT,188,172,EZ_NO_CLIP);
			ez_PrintText ("@C[11]START 1P:  @C[15]1@C[11]@J[64]START 2P:  @C[15]2",8,FONT_LEFT,188,179,EZ_NO_CLIP);
	
			sprintf (Text,"@C[15]%s",ScanCodeToString[Player1Up]);
			ez_PrintText (Text,8,FONT_CENTER,250,120,EZ_NO_CLIP);

			sprintf (Text,"@C[15]%s",ScanCodeToString[Player1Down]);
			ez_PrintText (Text,8,FONT_CENTER,250,127,EZ_NO_CLIP);

			sprintf (Text,"@C[15]%s",ScanCodeToString[Player1Left]);
			ez_PrintText (Text,8,FONT_CENTER,250,134,EZ_NO_CLIP);

			sprintf (Text,"@C[15]%s",ScanCodeToString[Player1Right]);
			ez_PrintText (Text,8,FONT_CENTER,250,141,EZ_NO_CLIP);

			sprintf (Text,"@C[15]%s",ScanCodeToString[Player1Fire1]);
			ez_PrintText (Text,8,FONT_CENTER,250,148,EZ_NO_CLIP);

			sprintf (Text,"@C[15]%s",ScanCodeToString[Player1Fire2]);
			ez_PrintText (Text,8,FONT_CENTER,250,155,EZ_NO_CLIP);

			sprintf (Text,"@C[15]%s",ScanCodeToString[Player1Fire3]);
			ez_PrintText (Text,8,FONT_CENTER,250,162,EZ_NO_CLIP);

			sprintf (Text,"@C[15]%s",ScanCodeToString[Player2Up]);
			ez_PrintText (Text,8,FONT_CENTER,293,120,EZ_NO_CLIP);

			sprintf (Text,"@C[15]%s",ScanCodeToString[Player2Down]);
			ez_PrintText (Text,8,FONT_CENTER,293,127,EZ_NO_CLIP);

			sprintf (Text,"@C[15]%s",ScanCodeToString[Player2Left]);
			ez_PrintText (Text,8,FONT_CENTER,293,134,EZ_NO_CLIP);

			sprintf (Text,"@C[15]%s",ScanCodeToString[Player2Right]);
			ez_PrintText (Text,8,FONT_CENTER,293,141,EZ_NO_CLIP);

			sprintf (Text,"@C[15]%s",ScanCodeToString[Player2Fire1]);
			ez_PrintText (Text,8,FONT_CENTER,293,148,EZ_NO_CLIP);

			sprintf (Text,"@C[15]%s",ScanCodeToString[Player2Fire2]);
			ez_PrintText (Text,8,FONT_CENTER,293,155,EZ_NO_CLIP);

			sprintf (Text,"@C[15]%s",ScanCodeToString[Player2Fire3]);
			ez_PrintText (Text,8,FONT_CENTER,293,162,EZ_NO_CLIP);

			sprintf (Text,"@C[15]%s",ScanCodeToString[DipSwitch]);
			ez_PrintText (Text,8,FONT_LEFT,232,172,EZ_NO_CLIP);
*/











void	PrintSelectionList (int Colr)
{
int		x,Start,Col;

	for (x=0;x<NUM_ENTRY;x++)
		{
		Col=Colr+1;
		Start=ListPos+x;

		if (x==CursorPos)
			Col+=3;

		if (ListPos+x>4)
			Col+=32;

		ez_PlotRectangle(0,x*SPACING,WIDTH-1,x*SPACING+DEPTH-1,Col,EZ_NO_CLIP);
		ez_PlotLine (0,x*SPACING+DEPTH-1,WIDTH-1,x*SPACING+DEPTH-1,Col-1,EZ_NO_CLIP);
		ez_PlotLine (WIDTH-1,x*SPACING+0,WIDTH-1,x*SPACING+DEPTH-1,Col-1,EZ_NO_CLIP);
		ez_PlotLine (0,x*SPACING+0,WIDTH-1,x*SPACING+0,Col+1,EZ_NO_CLIP);
		ez_PlotLine (0,x*SPACING+0,0,x*SPACING+DEPTH-1,Col+1,EZ_NO_CLIP);

		if (Games[Start].RomsPresent)
			ez_PrintText (Games[Start].GameName,Colr+4,FONT_CENTER,WIDTH>>1,x*SPACING+1,EZ_CLIP);
		else
			ez_PrintText (Games[Start].GameName,Colr+2,FONT_CENTER,WIDTH>>1,x*SPACING+1,EZ_CLIP);
		}
	PrintConfig();
}


int		CheckPresenceOfRoms (void)
{
int		x,r,Miss,NotAll;
FILE	*fp;

	Miss=0;
	for (x=0;x<NUM_GAMES;x++)
		{
		NotAll=0;
		for (r=0;r<NUM_ROMS;r++)
			{
			if (Games[x].Rom[r].Name && strlen(Games[x].Rom[r].Name))
				{
				fp=fopen (Games[x].Rom[r].Name,"rb");
				if (fp)
					{
					Games[x].Rom[r].Present=1;
					fclose (fp);
					}
				else
					{
					Games[x].Rom[r].Present=0;
					NotAll=1;
					Miss++;
					}
				}
			}
		if (NotAll)
			Games[x].RomsPresent=0;
		else
			Games[x].RomsPresent=1;
		}

	return (Miss);
}


int		DrawTextBox (int Xc,int Yc,int Width,int Depth,char *Colours,int Total)
{
int		c,t,rc;

	for (c=ReuseBox;c<BOX_PIECES;c++)
		{
		Box[c].Xc=0;
		Box[c].Yc=0;
		}

	rc=0;
	for (c=0;c<Width;c++)
		{
		t=abs(c-(Width>>1));

		// Top row
		if (c==0)
			{
			rc++;
			BoxPiece(Xc+c*5,Yc,2,t,Colours,Total);
			}
		else
		if (c==Width-1)
			{
			rc++;
			BoxPiece(Xc+c*5,Yc,3,t,Colours,Total);
			}
		else
			{
			rc++;
			BoxPiece(Xc+c*5,Yc,0,t,Colours,Total);
			}

		// Bottom row
		if (c==0)
			{
			rc++;
			BoxPiece(Xc+c*5,Yc+(Depth-1)*5,4,t,Colours,Total);
			}
		else
		if (c==Width-1)
			{
			rc++;
			BoxPiece(Xc+c*5,Yc+(Depth-1)*5,5,t,Colours,Total);
			}
		else
			{
			rc++;
			BoxPiece(Xc+c*5,Yc+(Depth-1)*5,0,t,Colours,Total);
			}
		}
	Depth-=2;
	for (c=0;c<Depth;c++)
		{
		if (c<(Depth>>1))
			t=c+(Width>>1);
		else
			t=Depth-1-c+(Width>>1);
		BoxPiece(Xc,Yc+(c+1)*5,1,t,Colours,Total);
		BoxPiece(Xc+(Width-1)*5,Yc+(c+1)*5,1,t,Colours,Total);
		rc+=2;
		}

	return (rc+1);
}


void	BoxPiece (int Xc,int Yc,int Piece,int Delay,char *Colours,int Total)
{
int		x;

	for (x=ReuseBox;x<BOX_PIECES;x++)
		{
		if (!Box[x].Xc && !Box[x].Yc)
			{
			Box[x].Col=0;
			Box[x].Xc=Xc;
			Box[x].Yc=Yc;
			Box[x].Piece=95+Piece;
			Box[x].Delay=Delay;
			Box[x].Fade=Colours;
			Box[x].Total=Total;
			return;
			}
		}
}

void 	ProcessTextBox (void)
{
int		x;

	for (x=0;x<BOX_PIECES;x++)
		{
		if (Box[x].Xc || Box[x].Yc)
			{
			if (Box[x].Delay)
				Box[x].Delay--;
			else
				{
				ez_PlotSprite (Box[x].Piece,Box[x].Xc,Box[x].Yc,TinyFont,EZ_CLIP,Box[x].Fade[Box[x].Col]);
				if (Box[x].Col<Box[x].Total-1)
					Box[x].Col++;
				}
			}
		}
}


void	SaveDefaults (void)
{
FILE	*fp;
int		Dummy=0;

	fp=fopen("SAGE.CFG","wb");
	if (fp)
		{
		fwrite ((char *)&SoundCardToUse,4,1,fp);
		fwrite ((char *)&Player1Up,4,1,fp);
		fwrite ((char *)&Player1Down,4,1,fp);
		fwrite ((char *)&Player1Left,4,1,fp);
		fwrite ((char *)&Player1Right,4,1,fp);
		fwrite ((char *)&Player1Fire1,4,1,fp);
		fwrite ((char *)&Player1Fire2,4,1,fp);
		fwrite ((char *)&Player1Fire3,4,1,fp);
		fwrite ((char *)&Player2Up,4,1,fp);
		fwrite ((char *)&Player2Down,4,1,fp);
		fwrite ((char *)&Player2Left,4,1,fp);
		fwrite ((char *)&Player2Right,4,1,fp);
		fwrite ((char *)&Player2Fire1,4,1,fp);
		fwrite ((char *)&Player2Fire2,4,1,fp);
		fwrite ((char *)&Player2Fire3,4,1,fp);
		fwrite ((char *)&Dummy,4,1,fp);
		fwrite ((char *)&UseJoySticks,4,1,fp);
		fwrite ((char *)&UseAccurateVsync,4,1,fp);
		fwrite ((char *)&UseScanLines,4,1,fp);
		fwrite ((char *)&VolumeLevel,4,1,fp);
		 
		fclose (fp);
		}
}


void	LoadDefaults (void)
{
FILE	*fp;
int		Dummy;

	SoundCardToUse=0;
	Player1Up=SC_UP;
	Player1Down=SC_DOWN;
	Player1Left=SC_LEFT;
	Player1Right=SC_RIGHT;
	Player1Fire1=SC_LCTRL;
	Player1Fire2=SC_LALT;
	Player1Fire3=SC_LSHIFT;
	Player2Up=SC_UP;
	Player2Down=SC_DOWN;
	Player2Left=SC_LEFT;
	Player2Right=SC_RIGHT;
	Player2Fire1=SC_LCTRL;
	Player2Fire2=SC_LALT;
	Player2Fire3=SC_LSHIFT;
	UseJoySticks=0;
	UseAccurateVsync=1;
	UseScanLines=0;
	VolumeLevel=75;

	fp=fopen("SAGE.CFG","rb");
	if (!fp)
		{
		SaveDefaults();
		return;
		}

	fread ((char *)&SoundCardToUse,4,1,fp);
	fread ((char *)&Player1Up,4,1,fp);
	fread ((char *)&Player1Down,4,1,fp);
	fread ((char *)&Player1Left,4,1,fp);
	fread ((char *)&Player1Right,4,1,fp);
	fread ((char *)&Player1Fire1,4,1,fp);
	fread ((char *)&Player1Fire2,4,1,fp);
	fread ((char *)&Player1Fire3,4,1,fp);
	fread ((char *)&Player2Up,4,1,fp);
	fread ((char *)&Player2Down,4,1,fp);
	fread ((char *)&Player2Left,4,1,fp);
	fread ((char *)&Player2Right,4,1,fp);
	fread ((char *)&Player2Fire1,4,1,fp);
	fread ((char *)&Player2Fire2,4,1,fp);
	fread ((char *)&Player2Fire3,4,1,fp);
	fread ((char *)&Dummy,4,1,fp);				// Skip the dip-switch, now fixed to SC_TAB
	fread ((char *)&UseJoySticks,4,1,fp);
	fread ((char *)&UseAccurateVsync,4,1,fp);
	fread ((char *)&UseScanLines,4,1,fp);
	fread ((char *)&VolumeLevel,4,1,fp);

	if (VolumeLevel<5) VolumeLevel=1;

	// Done and dusted
	fclose (fp);

	// To update older versions of the config file !
	SaveDefaults();
}



void	TimerHook (void)
{
	if (SoundPermitted)
		{
		if (ez_KeyPressed[SC_NUMPLUS])
			{
			ez_KeyPressed[SC_NUMPLUS]=0;
			VolumeLevel+=5;
			VolumeTimer=50;
			if (VolumeLevel>100) VolumeLevel=100;
			if (VolumeLevel==6) VolumeLevel=5;
			}
		if (ez_KeyPressed[SC_NUMMINUS])
			{
			ez_KeyPressed[SC_NUMMINUS]=0;
			VolumeLevel-=5;
			VolumeTimer=50;
			if (VolumeLevel<1) VolumeLevel=1;
			}
		AUpdateAudio();
		}

	TickCount++;
	if (TickCount>=FrameRate)
		{
		TickCount-=FrameRate;
		FrameRateTotal=FrameRateCounter;
		FrameRateCounter=0;
		}

	VsyncTicks=1;
}



void	ShowTitleScreen (void)
{
char	*Pal,*Pic;

	ez_ResetTimer(0);

	Pal=ez_LoadFile (1,"TITLE.PAL");
	if (!Pal)
		return;

	Pic=ez_LoadFile (1,"TITLE.BIN");
	if (!Pic)
		return;

	ez_PrintSprite (0,0,0,Pic,EZ_NO_CLIP);
	ez_PrintText (VERSION,7,FONT_CENTER,160,178,EZ_NO_CLIP);

	ez_FadePalette (Pal,20);
	ez_UpdateDisplay ();

	while (ez_ReadTimer(0)<1000)
		{
		if (ez_ReadCurrentKey()!=-1)
			break;
		}
	ez_WaitForNoKeys();
}


void	SortGamesList (void)
{
// Sort the games list so they appear in the order they are enumerated

GAMES	TempGames[NUM_GAMES];
int		x,y,Lowest,Id;

	for (x=0;x<NUM_GAMES;x++)
		{
		Lowest=10000;
		Id=-1;
		for (y=0;y<NUM_GAMES;y++)
			{
			if (Games[y].GameCode<Lowest)
				{
				Lowest=Games[y].GameCode;
				Id=y;
				}
			}
		ez_CopyMem ((char *)&TempGames[x],(char *)&Games[Id],sizeof(GAMES));
		Games[Id].GameCode=20000;
		}

	ez_CopyMem((char *)Games,(char *)TempGames,sizeof(Games));
}


char	InitialLetters[26]={SC_A,SC_B,SC_C,SC_D,SC_E,SC_F,SC_G,SC_H,SC_I,SC_J,SC_K,SC_L,SC_M,SC_N,SC_O,SC_P,SC_Q,SC_R,SC_S,SC_T,SC_U,SC_V,SC_W,SC_X,SC_Y,SC_Z};
char	InitialNumbers[10]={SC_0,SC_1,SC_2,SC_3,SC_4,SC_5,SC_6,SC_7,SC_8,SC_9};

char	PressedInitial (void)
{
int		x;

	for (x=0;x<26;x++)
		{
		if (ez_KeyPressed[InitialLetters[x]])
			{
			ez_KeyPressed[InitialLetters[x]]=0;
			return (x+'A');
			}
		}
	for (x=0;x<10;x++)
		{
		if (ez_KeyPressed[InitialNumbers[x]])
			{
			ez_KeyPressed[InitialNumbers[x]]=0;
			return (x+'0');
			}
		}

	return (0);
}
