#include	<stdio.h>
#include	"main.h"
#include	"z80.h"
#include	"support.h"
#include	"8910intf.h"
extern "C" 	
{
#include	"c:\dev\ezgame\ezgame.h"
#include 	"YM2203.h"
}


int		GalagaReadRam (int Addr)
{
int		Flags;
int		bit0,bit1;

	//	Shared RAM area
	if (Addr>=0x8000 && Addr<=0x9fff)
		return (RamSpace[Addr]);

	Flags=RAM[Addr];

	// DIP switches
	if (Addr>=0x6800 && Addr<=0x6807)
		{
		bit0=(GalagaReadInputs(0)>>(Addr-0x6800))&1;
		bit1=(GalagaReadInputs(1)>>(Addr-0x6800))&1;
		Flags=bit0|(bit1<<1);
		}

	if (CurrentProc==0 && Addr==0x7100)
		{
		// Custom IO read
		Flags=0x10;
		}

	return (Flags);
}


void	GalagaWriteRam (int Addr,char Value)
{
//	if (Addr==0x6830)
//		return;

	if (Addr>=0x8000 && Addr<=0x9fff)
		{
		RamSpace[Addr]=Value;
		return;
		}

	switch (CurrentProc)
		{
		case	0:

			if (Addr==0x7100)
				{
				GalagaCustomIOwrite(Addr,Value);
				}
			else
			if (Addr>=0xa000 && Addr<=0xa005)
				{
				;// Star control
				}
			else
			if (Addr==0x6820)
				{
				// INT enable 1
				IntEnable1=Value;
				}
			else
			if (Addr==0x6822)
				{
				// INT enable 3
				IntEnable3=Value;
				}
			else
			if (Addr==0x6823)
				{
				// HALT
				Execute[1]=Value;
				Execute[2]=Value;
				}

			RAM[Addr]=Value;

		break;

		case	1:
			if (Addr==0x6821)
				{
				// INT enable 2
				IntEnable2=Value;
				}

			RAM[Addr]=Value;
		break;

		case	2:
			if (Addr==0x6822)
				{
				// INT enable 3
				IntEnable3=Value;
				}
			else
			if (Addr>=0x6800 && Addr<=0x681f)
				{
				Value&=0x0f;
				if (SoundRegs[Addr-0x6800]!=Value)
					{
					SoundChanged = 1;
					SoundRegs[Addr-0x6800]=Value;
					}
				}

			RAM[Addr]=Value;
		break;
		}
}





void GalagaCustomIOwrite (int offset,int data)
{
static int mode,credits;
static int coin,start1,start2,fire;
int in;
Z80_Regs regs;


//	printf ("WRITE CUSTOM DATA %x\n",data);


	Z80_GetRegs(&regs);

	switch (data)
		{
		case 0x10:	/* nop */
			break;

		case 0x71:
			{
				/* check if the user inserted a coin */
				if (ez_KeyPressed[SC_3])
				{
					if (coin == 0 && credits < 99) credits++;
					coin = 1;
				}
				else coin = 0;

				/* check for 1 player start button */
				if (ez_KeyPressed[SC_1])
				{
					if (start1 == 0 && credits >= 1) credits--;
					start1 = 1;
				}
				else start1 = 0;

				/* check for 2 players start button */
				if (ez_KeyPressed[SC_2])
				{
					if (start2 == 0 && credits >= 2) credits -= 2;
					start2 = 1;
				}
				else start2 = 0;

				in = GalagaReadInputs(2);
				/* check fire */
				if ((in & 0x10) == 0)
					{
					if (fire) in |= 0x10;
					else fire = 1;
					}
				else fire = 0;


				if (mode)								/* switch mode */
					cpu_writemem(regs.DE2.D,0x80);
				else									/* credits mode: return number of credits in BCD format */
					cpu_writemem(regs.DE2.D,(credits / 10) * 16 + credits % 10);

				cpu_writemem(regs.DE2.D + 1,in);
				cpu_writemem(regs.DE2.D + 2,0xff);
			}
			break;

		case 0xb1:	/* status? */
                        TestDone = 1;
			credits = 0;	/* this is a good time to reset the credits counter */
			cpu_writemem(regs.DE2.D,0);
			cpu_writemem(regs.DE2.D + 1,0);
			cpu_writemem(regs.DE2.D + 2,0);
			break;

       	case 0xa8:
           	TestDone = 0;
		break;

		case 0xa1:	/* go into switch mode */
			mode = 1;
			break;

		case 0xe1:	/* go into credit mode */
			mode = 0;
			break;

		case 0x61:	/* generate an NMI to recover from DI/HALT */
			doNMI = 1;
			break;

//		default:
//if (errorlog) fprintf(errorlog,"%04x: warning: unknown custom IO command %02x\n",cpu_getpc(),data);
//			break;
	}
}

void	cpu_writemem (int Addr,int Value)
{
//	printf ("WRITE %02x to %04x\n",Value,Addr);

	if (Addr>=0x8000 && Addr<=0x9fff)
		RamSpace[Addr]=Value;
	else
		RAM[Addr]=Value;
}


int		GalagaReadInputs (int Port)
{
int		Flags;

	switch (Port)
		{
		case	0:

			Flags=0x97;

		break;

		case	1:

			Flags=0xf7;

		break;

		case	2:

			Flags=0xff;

			if (ez_KeyPressed[Player1Right] || Joy1&JOY_RIGHT)
				Flags^=BIT1;
			if (ez_KeyPressed[Player1Left] || Joy1&JOY_LEFT)
				Flags^=BIT3;
			if (ez_KeyPressed[Player1Fire1]|| Joy1&JOY_BUTTON1)
				Flags^=BIT4;

		break;
		}

	return (Flags);
}




void	GNGWriteRam (int Addr,char Value)
{
int		x, palChanged = 0;

m6809_Regs R;

	switch (CurrentProc)
		{
		case	0:
			// GAME PROCESSOR

			if (Addr==0x3e00)
				{
				//ez_CopyMem( RAM+0x4000, RAM+0x10000+(Value*8192), 8192 );
				ROMPage=Value;
				RAM=RomSpace[ROMPage+2];
				}
		   	else
			if (Addr==0x3a00)
				{
				SoundCommandWrite(Addr,Value);
				}
			else
			if ((Addr>=0x3800)&&(Addr<=0x38bf))
				{
				// Red
				if  (Palette[(Addr-0x3800)*3+2]!=(Value&0xf0)>>2)
					{
					Palette[(Addr-0x3800)*3+2]=(Value&0xf0)>>2;
					PalUpD[Addr-0x3800]=1;
					UpdatePal=1;
					}
				
				//Green
				if (Palette[(Addr-0x3800)*3+3]!=(Value&0xf)<<2)
					{
					Palette[(Addr-0x3800)*3+3]=(Value&0xf)<<2;
					PalUpD[Addr-0x3800]=1;
					UpdatePal=1;
					}
				}
			else
			if ((Addr>=0x3900)&&(Addr<=0x39bf))
				{
				// Blue
				if (Palette[(Addr-0x3900)*3+4]!=(Value&0xf0)>>2)
					{
					Palette[(Addr-0x3900)*3+4]=(Value&0xf0)>>2;
					PalUpD[Addr-0x3900]=1;
					UpdatePal=1;
					}
				}
			else
			if (Addr>=0x2800 && Addr<0x2c00)
				TempScreenA[Addr-0x2800]=1;
			else
			if (Addr>=0x2c00 && Addr<0x3000)
				TempScreenA[Addr-0x2c00]=1;
			else
			if (Addr==0x3b08)
				{
				ScrollLO=Value;
				ScrollReg=ScrollLO+(256*ScrollHI);
				}
			else
			if (Addr==0x3b09)
				{
				ScrollHI=Value;
				ScrollReg=ScrollLO+(256*ScrollHI);
				}
			else
			if (Addr==0x3b0a)
				{
				HScrollLO=Value;
				HScrollReg=HScrollLO+(256*HScrollHI);
				}
			else
			if (Addr==0x3b0b)
				{
				HScrollHI=Value;
				HScrollReg=HScrollLO+(256*HScrollHI);
				}

			RomSpace[0][Addr]=Value;

		break;

		case	1:
			// SOUND PROCESSOR

			switch (Addr)					
				{
				case	0xe001:
					// Write port 0
                  YMNumber=0;  //Number of YM chip 0 or 1 
                  RegistersYM[RAM[0xE000]]=Value;
                  if (RAM[0xE000]==0x28)  SlotCh(); //SlotCh is the Note On Note Off Rutine

				break;
				
				case	0xe003:
					// Write port 1
                  YMNumber=1;  //Number of YM chip 0 or 1 
                  RegistersYM[RAM[0xE002]]=Value;
                  if (RAM[0xE002]==0x28)  SlotCh(); //SlotCh is the Note On Note Off Rutine

				break;

				//case	0xe000:
				//	// Control port 0
				//	if (Value<16)
				//		AY8910_control_port_0_w (Addr,Value);
				//break;
				//
				//case	0xe001:
				//	// Write port 0
				//	AY8910_write_port_0_w (Addr,Value);
				//break;
				//
				//case	0xe002:
				//	// Control port 1
				//	if (Value<16)
				//		AY8910_control_port_1_w (Addr,Value);
				//break;
				//
				//case	0xe003:
				//	// Write port 1
				//	AY8910_write_port_1_w (Addr,Value);
				//break;
				}

			RAM[Addr]=Value;

		break;
		}
}


int		GNGReadRam (int Addr)
{
int		Flags;
				
	switch (CurrentProc)
		{
		case	0:
			// GAME PROCESSOR

			Flags=RomSpace[0][Addr];

			if (Addr==0x3000)
				{
				Flags=255;

				if (ez_KeyPressed[SC_3])
					Flags^=BIT6;

				if (ez_KeyPressed[SC_1])
					Flags^=BIT0;

				if (ez_KeyPressed[SC_2])
					Flags^=BIT1;
				}
			else
			if (Addr==0x3001)
				{
				Flags=255;

				if (ez_KeyPressed[Player1Left] || Joy1&JOY_LEFT)
					Flags^=BIT1;

				if (ez_KeyPressed[Player1Right] || Joy1&JOY_RIGHT)
					Flags^=BIT0;

				if (ez_KeyPressed[Player1Down] || Joy1&JOY_DOWN)
					Flags^=BIT2;

				if (ez_KeyPressed[Player1Up] || Joy1&JOY_UP)
					Flags^=BIT3;

				if (ez_KeyPressed[Player1Fire1] || Joy1&JOY_BUTTON1)
					Flags^=BIT4;					

				if (ez_KeyPressed[Player1Fire2] || Joy1&JOY_BUTTON2)
					Flags^=BIT5;
				}
			else
			if (Addr==0x3002)
				{
				Flags=255;

				if (ez_KeyPressed[Player2Left] || Joy2&JOY_LEFT)
					Flags^=BIT1;

				if (ez_KeyPressed[Player2Right] || Joy2&JOY_RIGHT)
					Flags^=BIT0;

				if (ez_KeyPressed[Player2Down] || Joy2&JOY_DOWN)
					Flags^=BIT2;

				if (ez_KeyPressed[Player2Up] || Joy2&JOY_UP)
					Flags^=BIT3;

				if (ez_KeyPressed[Player2Fire1] || Joy2&JOY_BUTTON1)
					Flags^=BIT4;					

				if (ez_KeyPressed[Player2Fire2] || Joy2&JOY_BUTTON2)
					Flags^=BIT5;
				}
			else
			if (Addr==0x3003)
				{
				Flags=0xdf;			//DIP A
				}
			else
			if (Addr==0x3004)
				{
				Flags=0xfb;			//DIP B
				}

		break;

		case	1:
			// SOUND PROCESSOR

			Flags=RAM[Addr];

			if (Addr==0xc800)
				{
				Flags=SoundCommandLatchRead(Addr);
				}
		break;
		}

	return (Flags);
}




int		ExedReadRam (int Addr)
{
int			Flags;
Z80_Regs	Regs;

	switch (CurrentProc)
		{
		case	0:
			// GAME PROCESSOR

			Flags=RAM[Addr];
			Z80_GetRegs(&Regs);

			if (Addr==0xc003 && Regs.PC.D==0x61)
				return (0x40);

			if (Addr==0xc003)
				{
				Flags=0xff-BIT2;		//DIP A
				}

			if (Addr==0xc004)
				{
				Flags=0xff;				//DIP B
				}

			if (Addr==0xc001)
				{
				Flags=255;

				if (ez_KeyPressed[Player1Left] || Joy1&JOY_LEFT)
					Flags^=BIT1;

				if (ez_KeyPressed[Player1Right] || Joy1&JOY_RIGHT)
					Flags^=BIT0;

				if (ez_KeyPressed[Player1Down] || Joy1&JOY_DOWN)
					Flags^=BIT2;

				if (ez_KeyPressed[Player1Up] || Joy1&JOY_UP)
					Flags^=BIT3;

				if (ez_KeyPressed[Player1Fire1] || Joy1&JOY_BUTTON1)
					Flags^=BIT4;					

				if (ez_KeyPressed[Player1Fire2] || Joy1&JOY_BUTTON2)
					Flags^=BIT5;
				}

			if (Addr==0xc002)
				{
				Flags=255;

				if (ez_KeyPressed[Player2Left] || Joy2&JOY_LEFT)
					Flags^=BIT1;

				if (ez_KeyPressed[Player2Right] || Joy2&JOY_RIGHT)
					Flags^=BIT0;

				if (ez_KeyPressed[Player2Down] || Joy2&JOY_DOWN)
					Flags^=BIT2;

				if (ez_KeyPressed[Player2Up] || Joy2&JOY_UP)
					Flags^=BIT3;

				if (ez_KeyPressed[Player2Fire1] || Joy2&JOY_BUTTON1)
					Flags^=BIT4;					

				if (ez_KeyPressed[Player2Fire2] || Joy2&JOY_BUTTON2)
					Flags^=BIT5;
				}

			if (Addr==0xc000)
				{
				Flags=255;

				if (ez_KeyPressed[SC_3])
					Flags^=BIT6;

				if (ez_KeyPressed[SC_1])
					Flags^=BIT0;

				if (ez_KeyPressed[SC_2])
					Flags^=BIT1;
				}

		break;

		case	1:
			// SOUND PROCESSOR

			Flags=RAM[Addr];

			if (Addr==0x6000)
				{
				Flags=SoundCommandLatchRead(Addr);
				}
		break;
		}

	return (Flags);
}





void	CommandoWriteRam (int Addr,char Value)
{
int		x;

	switch (CurrentProc)
		{
		case	0:
			// GAME PROCESSOR

			if (Addr>=0xd800 && Addr<0xdc00)
				TempScreenA[Addr-0xd800]=1;
			else
			if (Addr>=0xdc00 && Addr<0xe000)
				TempScreenA[Addr-0xdc00]=1;
			else
			if (Addr==0xc808)
				{
				ScrollLO=Value;
				ScrollReg=ScrollLO+(256*ScrollHI);
				}
			else
			if (Addr==0xc809)
				{
				ScrollHI=Value;
				ScrollReg=ScrollLO+(256*ScrollHI);
				}
			else
			if (Addr==0xc800)
				{
				SoundCommandWrite(Addr,Value);
				}

		break;

		case	1:
			// SOUND PROCESSOR

			switch (Addr)					
				{
				case	0x8000:
					// Control port 0
					if (Value<16)
						AY8910_control_port_0_w (Addr,Value);
				break;

				case	0x8001:
					// Write port 0
					AY8910_write_port_0_w (Addr,Value);
				break;

				case	0xc000:
					// Control port 1
					if (Value<16)
						AY8910_control_port_1_w (Addr,Value);
				break;
				
				case	0xc001:
					// Write port 1
					AY8910_write_port_1_w (Addr,Value);
				break;
				}
		break;
		}

	RAM[Addr]=Value;

}







int		CommandoReadRam (int Addr)
{
int		Flags;

	Flags=RAM[Addr];

	switch (CurrentProc)
		{
		case	0:
			// GAME PROCESSOR

			if (Addr==0xc003)
				{
				Flags=0xff-BIT2;		//DIP A
				}

			if (Addr==0xc004)
				{
				Flags=0xff;				//DIP B
				}

			if (Addr==0xc001)
				{
				Flags=255;

				if (ez_KeyPressed[Player1Left] || Joy1&JOY_LEFT)
					Flags^=BIT1;

				if (ez_KeyPressed[Player1Right] || Joy1&JOY_RIGHT)
					Flags^=BIT0;

				if (ez_KeyPressed[Player1Down] || Joy1&JOY_DOWN)
					Flags^=BIT2;

				if (ez_KeyPressed[Player1Up] || Joy1&JOY_UP)
					Flags^=BIT3;

				if (ez_KeyPressed[Player1Fire1] || Joy1&JOY_BUTTON1)
					Flags^=BIT4;					

				if (ez_KeyPressed[Player1Fire2] || Joy1&JOY_BUTTON2)
					Flags^=BIT5;
				}

			if (Addr==0xc002)
				{
				Flags=255;

				if (ez_KeyPressed[Player2Left] || Joy2&JOY_LEFT)
					Flags^=BIT1;

				if (ez_KeyPressed[Player2Right] || Joy2&JOY_RIGHT)
					Flags^=BIT0;

				if (ez_KeyPressed[Player2Down] || Joy2&JOY_DOWN)
					Flags^=BIT2;

				if (ez_KeyPressed[Player2Up] || Joy2&JOY_UP)
					Flags^=BIT3;

				if (ez_KeyPressed[Player2Fire1] || Joy2&JOY_BUTTON1)
					Flags^=BIT4;					

				if (ez_KeyPressed[Player2Fire2] || Joy2&JOY_BUTTON2)
					Flags^=BIT5;
				}

			if (Addr==0xc000)
				{
				Flags=255;

				if (ez_KeyPressed[SC_3])
					Flags^=BIT6;

				if (ez_KeyPressed[SC_1])
					Flags^=BIT0;

				if (ez_KeyPressed[SC_2])
					Flags^=BIT1;
				}

		break;

		case	1:
			// SOUND PROCESSOR

			if (Addr==0x6000)
				{
				Flags=SoundCommandLatchRead(Addr);
				}
		break;
		}

	return (Flags);
}


void	WriteRam1942 (int Addr,char Value)
{
int		x;

	switch (CurrentProc)
		{
		case	0:
			// GAME PROCESSOR

			if (Addr==0xc802)
				{
				ScrollLO=Value;
				ScrollReg=ScrollLO+(256*ScrollHI);
				}

			if (Addr==0xc803)
				{
				ScrollHI=Value;
				ScrollReg=ScrollLO+(256*ScrollHI);
				}

			if (Addr==0xc805)
				{
				if (PaletteBank!=Value)
					{
					PaletteBank=Value&7;
					for (x=0;x<32*32;x++)
						TempScreenA[x]=1;
					}
				}

			if (Addr==0xc800)
				{
				SoundCommandWrite(Addr,Value);
				}

			if (Addr==0xc806)
				{
				// No heroics just yet, copy the ROM about by hand - probably faster in the long-run anyway
				ROMPage=Value;
				RAM=RomSpace[ROMPage+2];
				}

			if (Addr>=0xd800 && Addr<0xdc00)
				TempScreenA[Addr-0xd800]=1;

			RomSpace[0][Addr]=Value;
				
		break;

		case	1:
			// SOUND PROCESSOR
			switch (Addr)
				{
				case	0x8000:
					// Control port 0
					if (Value<16)
					AY8910_control_port_0_w (Addr,Value);
				break;

				case	0x8001:
					// Write port 0
					AY8910_write_port_0_w (Addr,Value);
				break;

				case	0xc000:
					// Control port 1
					if (Value<16)
					AY8910_control_port_1_w (Addr,Value);
				break;

				case	0xc001:
					// Write port 1
					AY8910_write_port_1_w (Addr,Value);
				break;
				}

			RAM[Addr]=Value;

		break;
		}

}


int		ReadRam1942 (int Addr)
{
int		Flags;

	switch (CurrentProc)
		{
		case	0:
			// GAME PROCESSOR

			Flags=RomSpace[0][Addr];

			if (Addr==0xc003)		// Dip A
				{
				Flags=255;
				Flags^=BIT4;		// Ensure UPRIGHT display
				}
			else
			if (Addr==0xc004)		// Dip B
				{
				Flags=255;
				}
			else		 
			if (Addr==0xc000)
				{
				Flags=255;

				if (ez_KeyPressed[SC_1])
					Flags^=BIT0;

				if (ez_KeyPressed[SC_2])
					Flags^=BIT1;

				if (ez_KeyPressed[SC_3])
					Flags^=BIT4;
				}
			else		 
			if (Addr==0xc001)
				{
				Flags=255;

				if (ez_KeyPressed[Player1Right] || Joy1&JOY_RIGHT)
					Flags^=BIT0;

				if (ez_KeyPressed[Player1Left] || Joy1&JOY_LEFT)
					Flags^=BIT1;

				if (ez_KeyPressed[Player1Down] || Joy1&JOY_DOWN)
					Flags^=BIT2;

				if (ez_KeyPressed[Player1Up] || Joy1&JOY_UP)
					Flags^=BIT3;

				if (ez_KeyPressed[Player1Fire1] || Joy1&JOY_BUTTON1)
					Flags^=BIT4;

				if (ez_KeyPressed[Player1Fire2] || Joy1&JOY_BUTTON2)
					Flags^=BIT5;
				}

		break;

		case	1:
			// SOUND PROCESSOR

			Flags=RAM[Addr];

			if (Addr==0x6000)
				{
				Flags=SoundCommandLatchRead(Addr);
				}
		break;
		}

	return (Flags);
}




int		MrDoReadRam (int Addr)
{
int		Flags,A;
Z80_Regs Regs;

	Flags=RAM[Addr];

	switch (Addr)
		{
		case	0xA000:
			Flags=0xff;

			if (ez_KeyPressed[Player1Left] || Joy1&JOY_LEFT)
				Flags^=BIT0;
			if (ez_KeyPressed[Player1Down] || Joy1&JOY_DOWN)
				Flags^=BIT1;
			if (ez_KeyPressed[Player1Right] || Joy1&JOY_RIGHT)
				Flags^=BIT2;
			if (ez_KeyPressed[Player1Up] || Joy1&JOY_UP)
				Flags^=BIT3;
			if (ez_KeyPressed[Player1Fire1] || Joy1&JOY_BUTTON1)
				Flags^=BIT4;
			if (ez_KeyPressed[SC_1])
				Flags^=BIT5;
			if (ez_KeyPressed[SC_2])
				Flags^=BIT6;

		break;

		case	0xA001:
			Flags=0xff;

			if (ez_KeyPressed[SC_3])
				Flags^=BIT6;
		break;

		case	0xA002:
			Flags=0xdf;
		break;

		case	0xA003:
			Flags=0xff;
		break;

		case	0x9803:
			Z80_GetRegs(&Regs);
			A=Regs.HL.D;
			if ((A>=Driver.Proc[CurrentProc].RomStart1 && A<Driver.Proc[CurrentProc].RomEnd1) || (A>=Driver.Proc[CurrentProc].RomStart2 && A<Driver.Proc[CurrentProc].RomEnd2))
				Flags=RomSpace[CurrentProc][A];
			else
				Flags=RAM[A];
		break;
		}

	return (Flags);
}



void	MrDoWriteRam (int Addr,char Value)
{
	if (Addr>=Driver.ScreenBase+0x000 && Addr<Driver.ScreenBase+0x1000)
		{
		if (RAM[Addr]!=Value)
			TempScreenA[(Addr-Driver.ScreenBase)&0x3ff]=1;
		}
	else
	if (Addr==0x9801)
		{
		MrDoChangeSound(0,Value);
		}
	else
	if (Addr==0x9802)
		{
		MrDoChangeSound(1,Value);
		}
	else
	if (Addr==0xf800)
		{
		ScrollReg=Value;
		}
	RAM[Addr]=Value;
}



int		ScrambleReadRam (int Addr)
{
int		Flags;

	Flags=RAM[Addr];

	switch (Addr)
		{
		case	0x8100:
			Flags=255;

			if (ez_KeyPressed[SC_3])
				Flags^=BIT7;

			if (ez_KeyPressed[Player1Left] || Joy1&JOY_LEFT)
				Flags^=BIT5;

			if (ez_KeyPressed[Player1Right] || Joy1&JOY_RIGHT)
				Flags^=BIT4;

			if (ez_KeyPressed[Player1Fire1] || Joy1&JOY_BUTTON1)
				Flags^=BIT3;

			if (ez_KeyPressed[Player1Fire2] || Joy1&JOY_BUTTON2)
				Flags^=BIT1;

			if (ez_KeyPressed[Player2Up] || Joy2&JOY_UP)
				Flags^=BIT0;
		break;

		case	0x8101:
			Flags=255-BIT0-BIT1;

			if (ez_KeyPressed[SC_1])
				Flags^=BIT7;

			if (ez_KeyPressed[SC_2])
				Flags^=BIT6;

			if (ez_KeyPressed[Player2Left] || Joy2&JOY_LEFT)
				Flags^=BIT5;

			if (ez_KeyPressed[Player2Right] || Joy2&JOY_RIGHT)
				Flags^=BIT4;

			if (ez_KeyPressed[Player2Fire1] || Joy2&JOY_BUTTON1)
				Flags^=BIT3;

			if (ez_KeyPressed[Player2Fire2] || Joy2&JOY_BUTTON2)
				Flags^=BIT2;
		break;

		case	0x8102:
			Flags=255-BIT1-BIT2-BIT3;

			if (ez_KeyPressed[Player1Down] || Joy1&JOY_DOWN)
				Flags&=~BIT6;

			if (ez_KeyPressed[Player1Up] || Joy1&JOY_UP)
				Flags&=~BIT4;

			if (ez_KeyPressed[Player2Down] || Joy2&JOY_DOWN)
				Flags&=~BIT0;

			if (Z80_GetPC()==0x00e4)
				Flags&=0x7f;
		break;


		case	0x8202:
			Flags=0x6f;
		break;
		}

	return (Flags);
}




int		FirebirdInPort (char Port)
{
int		Flags=0;

	switch (Port)
		{
		case	0:

			if (ez_KeyPressed[Player1Left] || Joy1&JOY_LEFT)
				Flags|=BIT1;

			if (ez_KeyPressed[Player1Right] || Joy1&JOY_RIGHT)
				Flags|=BIT0;

			if (ez_KeyPressed[Player1Fire1] || Joy1&JOY_BUTTON1)
				Flags|=BIT7;

			if (ez_KeyPressed[Player1Fire2] || Joy1&JOY_BUTTON2)
				Flags|=BIT4;

		break;

		case	3:

			// Bits 0-1  = Lives+3  (ie 3,4,5 or 6)

			Flags=1;

		break;

		case	2:

			if (ez_KeyPressed[SC_3])
				Flags|=BIT7;

			if (ez_KeyPressed[SC_1])
				Flags|=BIT2;

			if (ez_KeyPressed[SC_2])
				Flags|=BIT3;

		break;
		}

	return (Flags);
}

void	FirebirdOutPort (char Port,char Value)
{
	if (Port==0)
		{
		if (Value==0x20)
			{
			BankFlag=1;
			}
		if (Value==0x00)
			{
			BankFlag=0;
			}
		}

	if (Port==2)
		{
		if (Driver.fn_ScreenUpdate)
			Driver.fn_ScreenUpdate();

		// Let's see it then
		BlitScreen();
		}
}





int		PhoenixReadRam (int Addr)
{
int		Flags;

	Flags=RAM[Addr];

	if (Addr>=0x7000 && Addr<=0x73ff)
		{
		Flags=255;

		if (ez_KeyPressed[SC_3])
			Flags&=~1;
		if (ez_KeyPressed[SC_1])
			Flags&=~2;
		if (ez_KeyPressed[SC_2])
			Flags&=~4;
		if (ez_KeyPressed[Player1Fire1] || Joy1&JOY_BUTTON1)
			Flags&=~16;
		if (ez_KeyPressed[Player1Right] || Joy1&JOY_RIGHT)
			Flags&=~32;
		if (ez_KeyPressed[Player1Left] || Joy1&JOY_LEFT)
			Flags&=~64;
		if (ez_KeyPressed[Player1Fire2] || Joy1&JOY_BUTTON2)
			Flags&=~128;
		}
	else
	if (Addr>=0x7800 && Addr<=0x7bff)
		{
		if (DipSwitchSYNC==1)
			{
			DipSwitchSYNC=0;
			//return (128+(BonusAt<<2)+Lives+64);
			Flags=(128+64);
			}
		else
			//return ((BonusAt<<2)+Lives+64);
			Flags=(0+64);
		}

	return (Flags);
}




void	PhoenixWriteRam (int Addr,char Value)
{
	if (Addr>=0x5800 && Addr<=0x5bff)
		ScrollReg=Value;
	else
	if (Addr>=0x5000 && Addr<=0x53ff)
		{
		PaletteReg=(Value<<6)>>7;
		}
	RAM[Addr]=Value;
}


void	GalaxianWriteRam (int Addr,char Value)
{
	if (Addr==0x6002 && (Driver.Game==GAME_PISCES || Driver.Game==GAME_JAPIREM))
		BankFlag=Value;

	if (Addr==0x6803)
		{
		// Update white-noise
		if (Value&1)
			ChangeSound(1,1000,63*VolumeLevel/100);
		else
			ChangeSound(1,1000,0);
		}
	RAM[Addr]=Value;
}


int		GalaxianReadRam (int Addr)
{
int		Flags;

	Flags=RAM[Addr];

	switch (Addr)
		{
		case	0x6000:
			Flags=0;

			if (ez_KeyPressed[SC_3])
				Flags|=BIT0;

			if (ez_KeyPressed[Player1Left] || Joy1&JOY_LEFT)
				Flags|=BIT2;

			if (ez_KeyPressed[Player1Right] || Joy1&JOY_RIGHT)
				Flags|=BIT3;

			if (ez_KeyPressed[Player1Fire1] || Joy1&JOY_BUTTON1)
				Flags|=BIT4;

			if (Driver.Game==GAME_WAR_OF_THE_BUGS)
				{
				if (ez_KeyPressed[Player1Up] || Joy1&JOY_UP)
					Flags|=BIT7;

				if (ez_KeyPressed[Player1Down] || Joy1&JOY_DOWN)
					Flags|=BIT6;
				}
		break;

		case	0x6800:
			Flags=0;

			if (ez_KeyPressed[SC_1])
				Flags|=BIT0;

			if (ez_KeyPressed[SC_2])
				Flags|=BIT1;

			if (ez_KeyPressed[Player2Left] || Joy2&JOY_LEFT)
				Flags|=BIT2;

			if (ez_KeyPressed[Player2Right] || Joy2&JOY_RIGHT)
				Flags|=BIT3;

			if (ez_KeyPressed[Player2Fire1] || Joy2&JOY_BUTTON1)
				Flags|=BIT4;
		break;
		}

	return (Flags);
}


int		CrestaReadRam (int Addr)
{
int		Flags;

	Flags=RAM[Addr];

	switch (Addr)
		{
		case	0xa000:
			Flags=0;

			if (ez_KeyPressed[SC_3])
				Flags|=BIT0;

			if (ez_KeyPressed[Player1Left] || Joy1&JOY_LEFT)
				Flags|=BIT2;

			if (ez_KeyPressed[Player1Right] || Joy1&JOY_RIGHT)
				Flags|=BIT3;

			if (ez_KeyPressed[Player1Fire1] || Joy1&JOY_BUTTON1)
				Flags|=BIT4;
		break;

		case	0xa800:
			Flags=0;

			if (ez_KeyPressed[SC_1])
				Flags|=BIT0;

			if (ez_KeyPressed[SC_2])
				Flags|=BIT1;
 		break;
		}
	return (Flags);
}



void	CrestaWriteRam (int Addr,char Value)
{
	if (Addr==0xA000)
		{
		if (Value)
			BankFlag|=BIT4;
		else
			BankFlag&=~BIT4;
		}
	else
	if (Addr==0xA001)
		{
		if (Value)
			BankFlag|=BIT5;
		else
			BankFlag&=~BIT5;
		}
	else
	if (Addr==0xA002)
		{
		if (Value)
			BankFlag|=BIT6;
		else
			BankFlag&=~BIT6;
		}
	RAM[Addr]=Value;
}

#undef	RED
#undef	GREEN
#undef	WHITE
#define	RED		1
#define	WHITE	2
#define	GREEN	3


void	InvadersWriteRam (int Addr,char Value)
{
int		Xc,Yc,x,Pos,Col,V;

	V=Value;
	if (Addr>=Driver.ScreenBase && Addr<Driver.ScreenBase+0x1b00)
		{
		Pos=Addr-Driver.ScreenBase;

		Xc=(Pos>>5)+16;
		Yc=248-((Pos&31)<<3);

		for (x=0;x<8;x++)
			{
			if (Value&128) 
				{
				Col=WHITE;
				if (Yc>31 && Yc<64)
					Col=RED;
				else
				if (Yc>191 && Yc<240)
					Col=GREEN;
				*((char *)0xa0000+Yc*256+Xc)=Col;
				}
			else
				*((char *)0xa0000+Yc*256+Xc)=0;

			Yc++;
			Value<<=1;
			}
		}
	RAM[Addr]=V;
}


void	InvadersOutPort (char Port,char Value)
{
int		Chan;

	switch (Port)
		{
		case	3:
			if (SoundPermitted)
				{
				if (Value&BIT0 && ~SndPort3&BIT0)
					{
					ASetVoiceVolume(Voice[UFO],63*VolumeLevel/100);
					APlayVoice(Voice[UFO],SoundWaves[UFO]);
					}
				if (~Value&BIT0 && SndPort3&BIT0)
					AStopVoice(Voice[UFO]);

				if (Value&BIT1 && ~SndPort3&BIT1)
					{
					ASetVoiceVolume(Voice[BASE_FIRE],63*VolumeLevel/100);
					APlayVoice(Voice[BASE_FIRE],SoundWaves[BASE_FIRE]);
					}

				if (~Value&BIT1 && SndPort3&BIT1)
					AStopVoice(Voice[BASE_FIRE]);

				if (Value&BIT2 && ~SndPort3&BIT2)
					{
					ASetVoiceVolume(Voice[BASE_DEAD],63*VolumeLevel/100);
					APlayVoice(Voice[BASE_DEAD],SoundWaves[BASE_DEAD]);
					}

				if (~Value&BIT2 && SndPort3&BIT2)
					AStopVoice(Voice[BASE_DEAD]);

				if (Value&BIT3 && ~SndPort3&BIT3)
					{
					ASetVoiceVolume(Voice[INV_DEAD],63*VolumeLevel/100);
					APlayVoice(Voice[INV_DEAD],SoundWaves[INV_DEAD]);
					}
				if (~Value&BIT3 && SndPort3&BIT3)
					AStopVoice(Voice[INV_DEAD]);

				SndPort3=Value;
				}
		break;

		case	5:
			if (SoundPermitted)
				{
				if (Value&BIT0 && ~SndPort5&BIT0)
					{
					ASetVoiceVolume(Voice[WALK_1],63*VolumeLevel/100);
					APlayVoice(Voice[WALK_1],SoundWaves[WALK_1]);
					}

				if (Value&BIT1 && ~SndPort5&BIT1)
					{
					ASetVoiceVolume(Voice[WALK_2],63*VolumeLevel/100);
					APlayVoice(Voice[WALK_2],SoundWaves[WALK_2]);
					}

				if (Value&BIT2 && ~SndPort5&BIT2)
					{
					ASetVoiceVolume(Voice[WALK_3],63*VolumeLevel/100);
					APlayVoice(Voice[WALK_3],SoundWaves[WALK_3]);
					}

				if (Value&BIT3 && ~SndPort5&BIT3)
					{
					ASetVoiceVolume(Voice[WALK_4],63*VolumeLevel/100);
					APlayVoice(Voice[WALK_4],SoundWaves[WALK_4]);
					}


				if (Value&BIT4 && ~SndPort5&BIT4)
					{
					ASetVoiceVolume(Voice[UFO_DEAD],63*VolumeLevel/100);
					APlayVoice(Voice[UFO_DEAD],SoundWaves[UFO_DEAD]);
					}
				if (~Value&BIT4 && SndPort5&BIT4)
					AStopVoice(Voice[UFO_DEAD]);

				SndPort5=Value;
				}
		break;

		case	2:
			ShiftValue=Value;
		break;

		case 4:
			BitmapPrevious=Bitmap;
			Bitmap=Value;
		break;
		}
}


int		InvadersInPort (char Port)
{
int		Flags=0;

	switch (Port)
		{
		case	1:

			Flags=BIT7+BIT0;

			if (ez_KeyPressed[SC_3])
				Flags&=~BIT0;

			if (ez_KeyPressed[SC_2])
				Flags|=BIT1;

			if (ez_KeyPressed[SC_1])
				Flags|=BIT2;

			if (ez_KeyPressed[Player1Fire1] || Joy1&JOY_BUTTON1)
				Flags|=BIT4;

			if (ez_KeyPressed[Player1Left] || Joy1&JOY_LEFT)
				Flags|=BIT5;

			if (ez_KeyPressed[Player1Right] || Joy1&JOY_RIGHT)
				Flags|=BIT6;


		break;

		case 2:
			if (Driver.Game!=GAME_INVADERS_DELUXE)
				{
				if (ez_KeyPressed[Player1Fire1] || Joy1&JOY_BUTTON1)
					Flags|=BIT4;

				if (ez_KeyPressed[Player1Left] || Joy1&JOY_LEFT)
					Flags|=BIT5;

				if (ez_KeyPressed[Player1Right] || Joy1&JOY_RIGHT)
					Flags|=BIT6;
				}
		break;

		case 3:
			Flags=(((Bitmap<<8)|BitmapPrevious)<<ShiftValue)>>8;
		break;
		}

	return (Flags);
}
