#include	<string.h>
#include	<stdio.h>
#include	<conio.h>
#include	"main.h"
#include	"z80.h"
#include	"support.h"
extern "C" 	
{
#include 	"YM2203.h"
#include	"c:\dev\ezgame\ezgame.h"
}

char commandoRemap[256];
char commandoRemapBackground[256];
char CharBank[8] = { 0, 2, 3, 3, 1, 2, 3, 3 };
char GNGRemap[256];
char GNGRemapBackground[256];
char GnGBuffer1[96*4];
char GnGBuffer2[96*4];


#define	SPR1	0x0b80
#define	SPR2	0x1380
#define	SPR3	0x1b80

void	GalagaScreenUpdate (void)
{
int		Pos,i,Speed;
int		mx,my,Xc,Yc,Chr,Col,Flip;

	ez_ClearMem (ScreenBmp,224*288);
	SpritePtr=(char *)SpriteData;

	for (i=0;i<64;i++)
		{
		if ((RamSpace[Driver.ScreenBase+SPR3+2*i+1]&2)==0)
			{
			Flip=RamSpace[Driver.ScreenBase+SPR3+2*i]&3;
			if (RamSpace[Driver.ScreenBase+SPR3+2*i]&8)
				{
				// Double Width
				Xc=RamSpace[Driver.ScreenBase+SPR2+2*i]-16;
				Yc=RamSpace[Driver.ScreenBase+SPR2+2*i+1]-40+256*(RamSpace[Driver.ScreenBase+SPR3+2*i+1]&1);
				Chr=RamSpace[Driver.ScreenBase+SPR1+2*i]+2;
				Col=RamSpace[Driver.ScreenBase+SPR1+2*i+1]&63;
				RemapPtr=ColourTable+Col*4+Driver.DataCols*4;
				RemapPrintSpriteClipped224 (Xc,Yc,SpritePtr+256*(Chr+Flip*256),16,16,ScreenBmp);

				Xc=RamSpace[Driver.ScreenBase+SPR2+2*i];
				Yc=RamSpace[Driver.ScreenBase+SPR2+2*i+1]-40+256*(RamSpace[Driver.ScreenBase+SPR3+2*i+1]&1);
				Chr=RamSpace[Driver.ScreenBase+SPR1+2*i];
				Col=RamSpace[Driver.ScreenBase+SPR1+2*i+1]&63;
				RemapPtr=ColourTable+Col*4+Driver.DataCols*4;
				RemapPrintSpriteClipped224 (Xc,Yc,SpritePtr+256*(Chr+Flip*256),16,16,ScreenBmp);

				if (RamSpace[Driver.ScreenBase+SPR3+2*i]&4)
					{
					// Double Height too
					Xc=RamSpace[Driver.ScreenBase+SPR2+2*i]-16;
					Yc=RamSpace[Driver.ScreenBase+SPR2+2*i+1]-24+256*(RamSpace[Driver.ScreenBase+SPR3+2*i+1]&1);
					Chr=RamSpace[Driver.ScreenBase+SPR1+2*i]+3;
					Col=RamSpace[Driver.ScreenBase+SPR1+2*i+1]&63;
					RemapPtr=ColourTable+Col*4+Driver.DataCols*4;
					RemapPrintSpriteClipped224 (Xc,Yc,SpritePtr+256*(Chr+Flip*256),16,16,ScreenBmp);

					Xc=RamSpace[Driver.ScreenBase+SPR2+2*i];
					Yc=RamSpace[Driver.ScreenBase+SPR2+2*i+1]-24+256*(RamSpace[Driver.ScreenBase+SPR3+2*i+1]&1);
					Chr=RamSpace[Driver.ScreenBase+SPR1+2*i]+1;
					Col=RamSpace[Driver.ScreenBase+SPR1+2*i+1]&63;
					RemapPtr=ColourTable+Col*4+Driver.DataCols*4;
					RemapPrintSpriteClipped224 (Xc,Yc,SpritePtr+256*(Chr+Flip*256),16,16,ScreenBmp);
					}
				}
			else
				{
				Xc=RamSpace[Driver.ScreenBase+SPR2+2*i]-16;
				Yc=RamSpace[Driver.ScreenBase+SPR2+2*i+1]-40+256*(RamSpace[Driver.ScreenBase+SPR3+2*i+1]&1);
				Chr=RamSpace[Driver.ScreenBase+SPR1+2*i];
				Col=RamSpace[Driver.ScreenBase+SPR1+2*i+1]&63;
				RemapPtr=ColourTable+Col*4+Driver.DataCols*4;
				RemapPrintSpriteClipped224 (Xc,Yc,SpritePtr+256*(Chr+Flip*256),16,16,ScreenBmp);
				}
			}
		}

	for (Pos=0;Pos<0x400;Pos++)
		{
		Chr=RamSpace[Driver.ScreenBase+Pos];
		if (Chr!=36)
			{
			mx=Pos>>5;
			my=Pos&31;

			if (mx<=1)
				{
				Xc = 29 - my;
				Yc = mx + 34;
				}
			else
			if (mx >= 30)
				{
				Xc = 29 - my;
				Yc = mx - 30;
				}
			else
				{
				Xc = 29 - mx;
				Yc = my + 2;
				}

			Col=RamSpace[Driver.ScreenBase+Pos+0x400]&63;
			RemapPtr=ColourTable+Col*4;
			RemapPrintSpriteClipped224 (Xc<<3,Yc<<3,CharData[Chr][0],8,8,ScreenBmp);
			}
		}

	if (RomSpace[0][0xa002]&1)
		Speed=-1;
	else
		Speed=0;

	if (RomSpace[0][0xa001]&1)
		Speed|=2;
	else
		Speed&=~2;

	if (RomSpace[0][0xa000]&1)
		Speed|=1;
	else
		Speed&=~1;

	Speed+=2;

	StarScroll-=Speed;

	PrintStars=1;
	DrawStars();
}





void	GNGScreenUpdate (void)
{
int		Xc,Yc,x,y,z,w,Chr,Col,Pos,Flp;
int		Bank;
char	Text[64];

	SpritePtr=(char *)SpriteData;

	// Print the scroll-field
	for (y=0;y<32;y++)
		{
		for (x=0;x<32;x++)
			{
			Pos=32*(x)+y;
			if (TempScreenA[Pos])
				{
				TempScreenA[Pos]=0;

				Xc=x*16;
				Yc=y*16;

				Chr=RomSpace[0][Driver.ScreenBase+0x800+Pos]+(((RomSpace[0][Driver.ScreenBase+0xc00+Pos])&0xc0)<<2);
			   	Flp=(RomSpace[0][Driver.ScreenBase+0xc00+Pos]>>4)&3;

				// Color of background tiles
				Col = (RomSpace[0][Driver.ScreenBase+0xc00+Pos])&0x7;
				
				RemapPtr=&GNGRemapBackground[Col*8];

				if (Xc>=0 && Xc<=512-16 && Yc>=0 && Yc<=512-16)
				switch (Flp)
					{
					case	0:
						RemapForceSprite512 (Xc,Yc,SpritePtr+Chr*256,16,16,ScreenBmp3);
					break;

					case	1:
						RemapForceSprite512H (Xc,Yc,SpritePtr+Chr*256,16,16,ScreenBmp3);
					break;

					case	2:
						RemapForceSprite512V (Xc,Yc,SpritePtr+Chr*256,16,16,ScreenBmp3);
					break;

					case	3:
						RemapForceSprite512HV (Xc,Yc,SpritePtr+Chr*256,16,16,ScreenBmp3);
					break;
					}
				}
			}
		}		 



	Xc=(ScrollReg)&511;
	Yc=(HScrollReg)&511;




	if (Xc<=256 && Yc<=256)
		{
		CopyRect512x512 (ScreenBmp,ScreenBmp3+Xc+512*Yc,256,256,ScreenWidth);
		}
	else
		{
		if (Yc<=256)
			{
			// Yc is, so Xc can't be
			CopyRect512x512 (ScreenBmp,         ScreenBmp3+Xc+512*Yc,  512-Xc,  256,  ScreenWidth);
			CopyRect512x512 (ScreenBmp+512-Xc,  ScreenBmp3+512*Yc,     Xc-256,  256,  ScreenWidth);
			}
		else
		if (Xc<=256)
			{
			// Xc is, so Yc can't be
			CopyRect512x512 (ScreenBmp,         	  ScreenBmp3+Xc+512*Yc,  256,  512-Yc,  ScreenWidth);
			CopyRect512x512 (ScreenBmp+256*(512-Yc),  ScreenBmp3+Xc,         256,  Yc-256,  ScreenWidth);
			}
		else
			{
			// Xc can't be, and Yc can't be
			CopyRect512x512 (ScreenBmp,         	         ScreenBmp3+Xc+512*Yc,  512-Xc,  512-Yc,  ScreenWidth);
			CopyRect512x512 (ScreenBmp+512-Xc,         	     ScreenBmp3+512*Yc,     Xc-256,  512-Yc,  ScreenWidth);
			CopyRect512x512 (ScreenBmp+256*(512-Yc),         ScreenBmp3+Xc,         512-Xc,  Yc-256,  ScreenWidth);
			CopyRect512x512 (ScreenBmp+256*(512-Yc)+512-Xc,  ScreenBmp3,            Xc-256,  Yc-256,  ScreenWidth);
			}
		}

#define		GNGSPR		-0x200

	// Print the sprites
	for (Pos=95*4;Pos>=0;Pos-=4)
		{
		Bank=(GnGBuffer2[Pos+1]>>6)&3;
		if (Bank<3)
			{
			Xc=GnGBuffer2[Pos+3]-256*(GnGBuffer2[Pos+1]&1);
			Yc=GnGBuffer2[Pos+2];
			Chr=GnGBuffer2[Pos]+(((GnGBuffer2[Pos+1]&0xc0)<<2));

			// Color of sprites
			Col=((GnGBuffer2[Pos+1]>>4)&0x3)+4;

			// X-Flip
			if (GnGBuffer2[Pos+1]&4)
				Chr+=Driver.TotalSprites;
			// Y-Flip
			if (GnGBuffer2[Pos+1]&8)
				Chr+=(Driver.TotalSprites<<1);

			RemapPtr=&GNGRemap[Col*16];
			RemapPrintSpriteClipped (Xc,Yc,SpritePtr+((Chr+Driver.TotalTiles)*256),16,16,ScreenBmp);
			}
		}
		
	// Print the TEXT layer
	for (z=0;z<0x400;z++)
		{
		Yc=8*(z/32);
		Xc=8*(z%32);

		Chr=RomSpace[0][Driver.ScreenBase+z]+(((RomSpace[0][Driver.ScreenBase+z+0x400]&0xc0)>>6)*256);

		// Color of text
		Col=(RomSpace[0][Driver.ScreenBase+z+0x400])&15;

		if (Chr!=32)
			{
			RemapPtr=&GNGRemap[(Col*4)+0x80];
			if (RomSpace[0][Driver.ScreenBase+z+0x400]&32)
				RemapPrintSpriteH (Xc,Yc,CharData[Chr][0],8,8,ScreenBmp);
			else
				RemapPrintSprite (Xc,Yc,CharData[Chr][0],8,8,ScreenBmp);
			}
		}
}





void	GalagaTranslateROM (void)
{
int		x,y,z,c;
int		byte1,byte2;

	ez_ClearMem((char *)SpriteData,sizeof(SpriteData));
	ez_ClearMem((char *)CharData,sizeof(CharData));
	ez_ClearMem((char *)ScreenBmp,sizeof(ScreenBmp));
	ez_ClearMem((char *)TempScreenA,sizeof(TempScreenA));

	for (z=0;z<Driver.TotalChars;z++)
		{
		for (y = 0; y < 8; y++)
			{
			byte1=TempChars[z*16+y];
			byte2=TempChars[z*16+y+8];

	   		CharData[z][0][0*8+7-y]=((byte2>>6)&2)+((byte2>>3)&1);
	   		CharData[z][0][1*8+7-y]=((byte2>>5)&2)+((byte2>>2)&1);
	   		CharData[z][0][2*8+7-y]=((byte2>>4)&2)+((byte2>>1)&1);
	   		CharData[z][0][3*8+7-y]=((byte2>>3)&2)+((byte2>>0)&1);
	   		CharData[z][0][4*8+7-y]=((byte1>>6)&2)+((byte1>>3)&1);
	   		CharData[z][0][5*8+7-y]=((byte1>>5)&2)+((byte1>>2)&1);
	   		CharData[z][0][6*8+7-y]=((byte1>>4)&2)+((byte1>>1)&1);
	   		CharData[z][0][7*8+7-y]=((byte1>>3)&2)+((byte1>>0)&1);
            }
		}

	SpritePtr=(char *)SpriteData;

	for (z=0;z<Driver.TotalChars;z++)
		{
		for (y = 0; y < 8; y++)
			{
			byte1=TempChars[(Driver.TotalChars<<4)+z*64+y+0];
			byte2=TempChars[(Driver.TotalChars<<4)+z*64+y+8];

	   		*(SpritePtr+z*256+ 0*16+15-y)=((byte1>>6)&2)+((byte1>>3)&1);
	   		*(SpritePtr+z*256+ 1*16+15-y)=((byte1>>5)&2)+((byte1>>2)&1);
	   		*(SpritePtr+z*256+ 2*16+15-y)=((byte1>>4)&2)+((byte1>>1)&1);
	   		*(SpritePtr+z*256+ 3*16+15-y)=((byte1>>3)&2)+((byte1>>0)&1);
	   		*(SpritePtr+z*256+ 4*16+15-y)=((byte2>>6)&2)+((byte2>>3)&1);
	   		*(SpritePtr+z*256+ 5*16+15-y)=((byte2>>5)&2)+((byte2>>2)&1);
	   		*(SpritePtr+z*256+ 6*16+15-y)=((byte2>>4)&2)+((byte2>>1)&1);
	   		*(SpritePtr+z*256+ 7*16+15-y)=((byte2>>3)&2)+((byte2>>0)&1);


			byte1=TempChars[(Driver.TotalChars<<4)+z*64+y+16];
			byte2=TempChars[(Driver.TotalChars<<4)+z*64+y+24];
			
	   		*(SpritePtr+z*256+ 8*16+15-y)=((byte1>>6)&2)+((byte1>>3)&1);
	   		*(SpritePtr+z*256+ 9*16+15-y)=((byte1>>5)&2)+((byte1>>2)&1);
	   		*(SpritePtr+z*256+10*16+15-y)=((byte1>>4)&2)+((byte1>>1)&1);
	   		*(SpritePtr+z*256+11*16+15-y)=((byte1>>3)&2)+((byte1>>0)&1);
	   		*(SpritePtr+z*256+12*16+15-y)=((byte2>>6)&2)+((byte2>>3)&1);
	   		*(SpritePtr+z*256+13*16+15-y)=((byte2>>5)&2)+((byte2>>2)&1);
	   		*(SpritePtr+z*256+14*16+15-y)=((byte2>>4)&2)+((byte2>>1)&1);
	   		*(SpritePtr+z*256+15*16+15-y)=((byte2>>3)&2)+((byte2>>0)&1);
            }

		for (y = 8; y < 16; y++)
			{
			byte1=TempChars[(Driver.TotalChars<<4)+z*64+y+0+24];
			byte2=TempChars[(Driver.TotalChars<<4)+z*64+y+8+24];

	   		*(SpritePtr+z*256+ 0*16+15-y)=((byte1>>6)&2)+((byte1>>3)&1);
	   		*(SpritePtr+z*256+ 1*16+15-y)=((byte1>>5)&2)+((byte1>>2)&1);
	   		*(SpritePtr+z*256+ 2*16+15-y)=((byte1>>4)&2)+((byte1>>1)&1);
	   		*(SpritePtr+z*256+ 3*16+15-y)=((byte1>>3)&2)+((byte1>>0)&1);
	   		*(SpritePtr+z*256+ 4*16+15-y)=((byte2>>6)&2)+((byte2>>3)&1);
	   		*(SpritePtr+z*256+ 5*16+15-y)=((byte2>>5)&2)+((byte2>>2)&1);
	   		*(SpritePtr+z*256+ 6*16+15-y)=((byte2>>4)&2)+((byte2>>1)&1);
	   		*(SpritePtr+z*256+ 7*16+15-y)=((byte2>>3)&2)+((byte2>>0)&1);
																	 
			byte1=TempChars[(Driver.TotalChars<<4)+z*64+y+16+24];
			byte2=TempChars[(Driver.TotalChars<<4)+z*64+y+24+24];
			
	   		*(SpritePtr+z*256+ 8*16+15-y)=((byte1>>6)&2)+((byte1>>3)&1);
	   		*(SpritePtr+z*256+ 9*16+15-y)=((byte1>>5)&2)+((byte1>>2)&1);
	   		*(SpritePtr+z*256+10*16+15-y)=((byte1>>4)&2)+((byte1>>1)&1);
	   		*(SpritePtr+z*256+11*16+15-y)=((byte1>>3)&2)+((byte1>>0)&1);
	   		*(SpritePtr+z*256+12*16+15-y)=((byte2>>6)&2)+((byte2>>3)&1);
	   		*(SpritePtr+z*256+13*16+15-y)=((byte2>>5)&2)+((byte2>>2)&1);
	   		*(SpritePtr+z*256+14*16+15-y)=((byte2>>4)&2)+((byte2>>1)&1);
	   		*(SpritePtr+z*256+15*16+15-y)=((byte2>>3)&2)+((byte2>>0)&1);
            }
		}

	for (c=0;c<Driver.TotalSprites;c++)
		{
		ez_CopyMem ((SpritePtr+(Driver.TotalTiles+Driver.TotalSprites+c)*256),(SpritePtr+(Driver.TotalTiles+c)*256),256);
		Vflip ((SpritePtr+(Driver.TotalTiles+Driver.TotalSprites+c)*256));
		}

	// Copy and Y-Flip all the sprites for fast printing
	for (c=0;c<Driver.TotalSprites<<1;c++)
		{
		ez_CopyMem ((SpritePtr+(Driver.TotalTiles+(Driver.TotalSprites<<1)+c)*256),(SpritePtr+(Driver.TotalTiles+c)*256),256);
		Hflip ((SpritePtr+(Driver.TotalTiles+(Driver.TotalSprites<<1)+c)*256));
		}

	InitStars();
}


int		GalagaInterrupt (void)
{

	Z80_IRQ=Z80_IGNORE_INT;

	switch (CurrentProc)
		{
		case	0:

			if (doNMI)
				{
				doNMI=0;
				return (Z80_NMI_INT);
				}

			if (IntEnable1)
				return (0xff);
			else
				{
				return (Z80_IGNORE_INT);
				}

		case	1:

			if (IntEnable2)
				return (0xff);
			else
				{
				return (Z80_IGNORE_INT);
				}

		case	2:

			if (IntEnable3)
				{
				return (Z80_IGNORE_INT);
				}
			else
				return (Z80_NMI_INT);
		}

	return (Z80_IGNORE_INT);
}



void	GalagaSetPalette (void)
{
int 	i;
int		bit0,bit1,bit2;
int		bits;
int		map[4] = { 0x00, 0x88, 0xcc, 0xff };
char	*color_prom;

	Palette[0]=0;
	Palette[1]=Driver.DataCols+Driver.StarCols;
	color_prom=Driver.Palette;

	for (i = 0;i < Driver.DataCols;i++)
		{
		bit0 = (color_prom[31-i] >> 0) & 0x01;
		bit1 = (color_prom[31-i] >> 1) & 0x01;
		bit2 = (color_prom[31-i] >> 2) & 0x01;
		Palette[3*i+2] = (0x21 * bit0 + 0x47 * bit1 + 0x97 * bit2)>>2;
		bit0 = (color_prom[31-i] >> 3) & 0x01;
		bit1 = (color_prom[31-i] >> 4) & 0x01;
		bit2 = (color_prom[31-i] >> 5) & 0x01;
		Palette[3*i+3] = (0x21 * bit0 + 0x47 * bit1 + 0x97 * bit2)>>2;
		bit0 = 0;
		bit1 = (color_prom[31-i] >> 6) & 0x01;
		bit2 = (color_prom[31-i] >> 7) & 0x01;
		Palette[3*i+4] = (0x21 * bit0 + 0x47 * bit1 + 0x97 * bit2)>>2;
		}

	/* characters */
	for (i=0;i<Driver.DataCols*4;i++)
		ColourTable[i]=15-(color_prom[i+Driver.DataCols]&0x0f);

	/* sprites */
	for (i = Driver.DataCols*4;i < Driver.DataCols*8;i++)
		ColourTable[i] = (15-(color_prom[i + Driver.DataCols] & 0x0f)) + 0x10;

	/* now the stars */
	for (i = Driver.DataCols;i<Driver.DataCols+Driver.StarCols;i++)
		{
		bits = ((i-32) >> 0) & 0x03;
		Palette[i*3+2] = map[bits]>>2;
		bits = ((i-32) >> 2) & 0x03;
		Palette[i*3+3] = map[bits]>>2;
		bits = ((i-32) >> 4) & 0x03;
		Palette[i*3+4] = map[bits]>>2;
		}

	for (i=Driver.DataCols*8;i<Driver.DataCols*10;i++)
 		ColourTable[i] = i;

	ez_SetPalette(Palette);
}














int		GNGInterrupt (void)
{
Z80_Regs	R;
char		Text[64];
int			x;

	switch (CurrentProc)
		{
		case	0:
			// GAME PROCESSOR

			ez_CopyMem(GnGBuffer2,GnGBuffer1,sizeof(GnGBuffer2));
			ez_CopyMem(GnGBuffer1,&RomSpace[0][Driver.ScreenBase+GNGSPR],sizeof(GnGBuffer1));

			return (INT_IRQ);

		case	1:
			// SOUND PROCESSOR

			Z80_IRQ = Z80_IGNORE_INT;	// Make sure there are no queued interrupts

			return (0xff);				// RST 38h
		}

	return (INT_IRQ);
}


void	GNGSetPalette (void)
{
char	*PaletteValues;
int		x;

	PaletteValues=Driver.Palette;

	ez_ClearMem(Palette,770);

	Palette[0]=0;
	Palette[1]=Driver.DataCols;

	for (x=0;x<Driver.DataCols;x++)
		{
		Palette[x*3+2]=*PaletteValues++>>2;
		Palette[x*3+3]=*PaletteValues++>>2;
		Palette[x*3+4]=*PaletteValues++>>2;
		}

	ez_SetPalette(Palette);

	for ( x = 0; x < 256; x++ )
		{
		GNGRemap[x] = x-1;				// Move color 0 to remove transparent color
		GNGRemapBackground[x] = x;		// But don't do it for scroll tiles as they need it
		}

}

void	GNGTranslateROM (void)
{
int		x,y,z,q,c,v,bit,pixel;
char	byte1,byte2,byte3;
char	Buffer[256];


	// Copy the code banks into seperate address spaces
	for (x=0;x<5;x++)
		{
		ez_CopyMem ((char *)&RomSpace[x+2][0],(char *)&RomSpace[0][0],65536);
		ez_CopyMem ((char *)&RomSpace[x+2][0x4000],(char *)&RomSpace[0][0x10000+x*8192],8192);
		}

	ez_ClearMem((char *)SpriteData,sizeof(SpriteData));
	ez_ClearMem((char *)CharData,sizeof(CharData));
	ez_ClearMem((char *)ScreenBmp,sizeof(ScreenBmp));
	ez_ClearMem((char *)ScreenBmp1,sizeof(ScreenBmp1));
	ez_ClearMem((char *)TempScreenA,sizeof(TempScreenA));
	ez_ClearMem((char *)TempScreenB,sizeof(TempScreenB));
	ez_ClearMem((char *)GnGBuffer1,sizeof(GnGBuffer1));
	ez_ClearMem((char *)GnGBuffer2,sizeof(GnGBuffer2));

	// NOP out the self test shit
	RomSpace[0][0x607a] = 0x12;
	RomSpace[0][0x607b] = 0x12;
	RomSpace[0][0x607c] = 0x12;

	ScrollLO=ScrollHI=ScrollReg=0;

	// CHARACTERS

	for (c=0;c<Driver.TotalChars;c++)
		{
/////////////////////////////////////////////////////
// Left half first plane
/////////////////////////////////////////////////////
		for ( y = 0; y < 8; y++ )
			{
			bit = 8;
			v = TempChars[((y*2))+(c*16)];
			for ( x = 0; x < 4; x++ )
				{
				if ( (v&bit) == 0 ) CharData[c][0][x+(y*8)] = 2; //AWPlotPixel( (x)+(c*8), (3-y)+(row*8), textColWhite );
				bit = bit>>1;
				}
			}	
/////////////////////////////////////////////////////
// Right half first plane
/////////////////////////////////////////////////////
		for ( y = 0; y < 8; y++ )
			{
			bit = 8;
			
			v = TempChars[((y*2)+1)+(c*16)];
			
			for ( x = 0; x < 4; x++ )
				{
				if ( (v&bit) == 0 ) CharData[c][0][x+4+(y*8)] = 2; //AWPlotPixel( (x)+(c*8), (3-y)+(row*8)+4, textColWhite );
				bit = bit>>1;
				}
			}
/////////////////////////////////////////////////////
// Left half second plane
/////////////////////////////////////////////////////
		for ( y = 0; y < 8; y++ )
			{
			bit = 128;
			
			v = TempChars[((y*2))+(c*16)];
			
			for ( x = 0; x < 4; x++ )
				{
				if ( (v&bit) == 0 ) CharData[c][0][x+(y*8)] |= 1; //AWPlotPixel( (x)+(c*8), (3-y)+(row*8), AWGetPixel( (x)+(c*8), (3-y)+(row*8) )+1  );
				bit = bit>>1;
				}
			}	
		
/////////////////////////////////////////////////////
// Right half second plane
/////////////////////////////////////////////////////
		for ( y = 0; y < 8; y++ )
			{
			bit = 128;

			v = TempChars[((y*2)+1)+(c*16)];
			for ( x = 0; x < 4; x++ )
				{
				if ( (v&bit) == 0 ) CharData[c][0][x+4+(y*8)] |= 1; //AWPlotPixel( (x)+(c*8), (3-y)+(row*8)+4, AWGetPixel( (x)+(c*8), (3-y)+(row*8)+4 )+1 );
				bit = bit>>1;
				}
			}	
		}
		
	// Reverse colors and remove color 0
	for (c=0;c<Driver.TotalChars;c++)
		{
		for ( x = 0; x < 64; x++ )
			{
			CharData[c][0][x] = 3-CharData[c][0][x];
			CharData[c][0][x] = (CharData[c][0][x]+1)&3;
			}
		}

	// SCROLL-FIELD TILES
	SpritePtr=(char *)SpriteData;

	for (c=0;c<Driver.TotalTiles*2;c++)
		{
		for ( y = 0; y < 16; y++ )
			{
			bit = 128;
			for ( x = 0; x < 8; x++ )
				{
				pixel = 0;
				// Plane 0;
				if ( TempChars[(Driver.TotalChars<<4)+(c*16)+y]&bit ) pixel |= 1;	//backgroundGraphics[(c*128)+(y*8)+x] = 1;

				// Plane 1;
				if ( TempChars[(Driver.TotalChars<<4)+(c*16)+y+32768]&bit ) pixel |= 2;	//backgroundGraphics[(c*128)+(y*8)+x] = 1;

				// Plane 2;
				if ( TempChars[(Driver.TotalChars<<4)+(c*16)+y+65536]&bit ) pixel |= 4;	//backgroundGraphics[(c*128)+(y*8)+x] = 1;
				
				if (!(c&1))
					Buffer[(y*16)+x] = pixel;
				else
					Buffer[(y*16)+x+8] = pixel;

				bit = bit>>1;
				}
			}
		for (y=0;y<16;y++)
			{
			for (x=0;x<16;x++)
				{
				SpritePtr[((c>>1)*256)+(y*16)+x]=Buffer[(y*16)+x];
				}
			}
		}	

	// SPRITES

	for ( c = 0; c < Driver.TotalSprites<<1; c++ )
		{
/////////////////////////////////////////////////////
// Left half plane 0
/////////////////////////////////////////////////////
		for ( y = 0; y < 16; y++ )
			{
			v = TempChars[(Driver.TotalChars<<4)+((Driver.TotalTiles*96))+((y*2))+(c*32)];
			bit = 8;
			for ( x = 0; x < 4; x++ )
				{
				if ( !(c&1) )
					{
					if ( (v&bit) == 0 ) SpritePtr[(Driver.TotalTiles*256)+((c>>1)*256)+x+(y*16)] = 2; //AWPlotPixel( (x)+(c*8), (3-y)+(row*8), textColWhite );
					}
				else if ( (v&bit) == 0 ) SpritePtr[(Driver.TotalTiles*256)+((c>>1)*256)+(x+8)+(y*16)] = 2; //AWPlotPixel( (x)+(c*8), (3-y)+(row*8), textColWhite );
				bit = bit>>1;
				}
			}	
		
/////////////////////////////////////////////////////
// Left half plane 1
/////////////////////////////////////////////////////
		for ( y = 0; y < 16; y++ )
			{
			v = TempChars[(Driver.TotalChars<<4)+((Driver.TotalTiles*96))+((y*2))+(c*32)];
			bit = 128;
			for ( x = 0; x < 4; x++ )
				{
				if ( !(c&1) )
					{
					if ( (v&bit) == 0 ) SpritePtr[(Driver.TotalTiles*256)+((c>>1)*256)+x+(y*16)] |= 1; //AWPlotPixel( (x)+(c*8), (3-y)+(row*8), textColWhite );
					}
				else if ( (v&bit) == 0 ) SpritePtr[(Driver.TotalTiles*256)+((c>>1)*256)+(x+8)+(y*16)] |= 1; //AWPlotPixel( (x)+(c*8), (3-y)+(row*8), textColWhite );
				bit = bit>>1;
				}
			}	
			
		
/////////////////////////////////////////////////////
// Right half plane 0
/////////////////////////////////////////////////////
		for ( y = 0; y < 16; y++ )
			{
			v = TempChars[(Driver.TotalChars<<4)+((Driver.TotalTiles*96))+((y*2)+1)+(c*32)];
			bit = 8;
			for ( x = 0; x < 4; x++ )
				{
				if ( !(c&1) )
					{
					if ( (v&bit) == 0 ) SpritePtr[(Driver.TotalTiles*256)+((c>>1)*256)+(x+4)+(y*16)] = 2; //AWPlotPixel( (x)+(c*8), (3-y)+(row*8), textColWhite );
					}
				else if ( (v&bit) == 0 ) SpritePtr[(Driver.TotalTiles*256)+((c>>1)*256)+(x+4+8)+(y*16)] = 2; //AWPlotPixel( (x)+(c*8), (3-y)+(row*8), textColWhite );
				
				bit = bit>>1;
				}
			}	
		
/////////////////////////////////////////////////////
// Right half plane 1
/////////////////////////////////////////////////////
		for ( y = 0; y < 16; y++ )
			{
			v = TempChars[(Driver.TotalChars<<4)+((Driver.TotalTiles*96))+((y*2)+1)+(c*32)];
			bit = 128;
			for ( x = 0; x < 4; x++ )
				{
				if ( !(c&1) )
					{
					if ( (v&bit) == 0 ) SpritePtr[(Driver.TotalTiles*256)+((c>>1)*256)+(x+4)+(y*16)] |= 1; //AWPlotPixel( (x)+(c*8), (3-y)+(row*8), textColWhite );
					}
				else if ( (v&bit) == 0 ) SpritePtr[(Driver.TotalTiles*256)+((c>>1)*256)+(x+4+8)+(y*16)] |= 1; //AWPlotPixel( (x)+(c*8), (3-y)+(row*8), textColWhite );
				bit = bit>>1;
				}
			}	
			
/////////////////////////////////////////////////////
// Left half plane 2
/////////////////////////////////////////////////////
		for ( y = 0; y < 16; y++ )
			{
			v = TempChars[(Driver.TotalChars<<4)+((Driver.TotalTiles*96))+((y*2))+(c*32)+49152];
			bit = 8;
			for ( x = 0; x < 4; x++ )
				{
				if ( !(c&1) )
					{
					if ( (v&bit) == 0 ) SpritePtr[(Driver.TotalTiles*256)+((c>>1)*256)+x+(y*16)] |= 8; //AWPlotPixel( (x)+(c*8), (3-y)+(row*8), textColWhite );
					}
				else if ( (v&bit) == 0 ) SpritePtr[(Driver.TotalTiles*256)+((c>>1)*256)+(x+8)+(y*16)] |= 8; //AWPlotPixel( (x)+(c*8), (3-y)+(row*8), textColWhite );
				bit = bit>>1;
				}
			}	
		
/////////////////////////////////////////////////////
// Left half plane 3
/////////////////////////////////////////////////////
		for ( y = 0; y < 16; y++ )
			{
			v = TempChars[(Driver.TotalChars<<4)+((Driver.TotalTiles*96))+((y*2))+(c*32)+49152];
			bit = 128;
			for ( x = 0; x < 4; x++ )
				{
				if ( !(c&1) )
					{
					if ( (v&bit) == 0 ) SpritePtr[(Driver.TotalTiles*256)+((c>>1)*256)+x+(y*16)] |= 4; //AWPlotPixel( (x)+(c*8), (3-y)+(row*8), textColWhite );
					}
				else if ( (v&bit) == 0 ) SpritePtr[(Driver.TotalTiles*256)+((c>>1)*256)+(x+8)+(y*16)] |= 4; //AWPlotPixel( (x)+(c*8), (3-y)+(row*8), textColWhite );
				bit = bit>>1;
				}
			}	
			
		
/////////////////////////////////////////////////////
// Right half plane 2
/////////////////////////////////////////////////////
		for ( y = 0; y < 16; y++ )
			{
			v = TempChars[(Driver.TotalChars<<4)+((Driver.TotalTiles*96))+((y*2)+1)+(c*32)+49152];
			bit = 8;
			for ( x = 0; x < 4; x++ )
				{
				if ( !(c&1) )
					{
					if ( (v&bit) == 0 ) SpritePtr[(Driver.TotalTiles*256)+((c>>1)*256)+(x+4)+(y*16)] |= 8; //AWPlotPixel( (x)+(c*8), (3-y)+(row*8), textColWhite );
					}
				else if ( (v&bit) == 0 ) SpritePtr[(Driver.TotalTiles*256)+((c>>1)*256)+(x+4+8)+(y*16)] |= 8; //AWPlotPixel( (x)+(c*8), (3-y)+(row*8), textColWhite );
				bit = bit>>1;
				}
			}	
		
/////////////////////////////////////////////////////
// Right half plane 3
/////////////////////////////////////////////////////
		for ( y = 0; y < 16; y++ )
			{
			v = TempChars[(Driver.TotalChars<<4)+((Driver.TotalTiles*96))+((y*2)+1)+(c*32)+49152];
			bit = 128;
			for ( x = 0; x < 4; x++ )
				{
				if ( !(c&1) )
					{
					if ( (v&bit) == 0 ) SpritePtr[(Driver.TotalTiles*256)+((c>>1)*256)+(x+4)+(y*16)] |= 4; //AWPlotPixel( (x)+(c*8), (3-y)+(row*8), textColWhite );
					}
				else if ( (v&bit) == 0 ) SpritePtr[(Driver.TotalTiles*256)+((c>>1)*256)+(x+4+8)+(y*16)] |= 4; //AWPlotPixel( (x)+(c*8), (3-y)+(row*8), textColWhite );
				bit = bit>>1;
				}
			}	
		}	


	// Remove color 15 (transparent)
	for (c=0;c<Driver.TotalSprites;c++)
		{
		for (y=0;y<256;y++)
			{
			SpritePtr[(Driver.TotalTiles+c)*256+y] = 15-SpritePtr[(Driver.TotalTiles+c)*256+y];
			SpritePtr[(Driver.TotalTiles+c)*256+y] = (SpritePtr[(Driver.TotalTiles+c)*256+y]+1)&15;
//			SpritePtr[(Driver.TotalTiles+c)*256+y] = (SpritePtr[(Driver.TotalTiles+c)*256+y]+1)&15;
			}
		}

	// Copy and X-Flip all the sprites for fast printing

	for (c=0;c<Driver.TotalSprites;c++)
		{
		ez_CopyMem ((SpritePtr+(Driver.TotalTiles+Driver.TotalSprites+c)*256),(SpritePtr+(Driver.TotalTiles+c)*256),256);
		Hflip ((SpritePtr+(Driver.TotalTiles+Driver.TotalSprites+c)*256));
		}

	// Copy and Y-Flip all the sprites for fast printing
	for (c=0;c<Driver.TotalSprites<<1;c++)
		{
		ez_CopyMem ((SpritePtr+(Driver.TotalTiles+(Driver.TotalSprites<<1)+c)*256),(SpritePtr+(Driver.TotalTiles+c)*256),256);
		Vflip ((SpritePtr+(Driver.TotalTiles+(Driver.TotalSprites<<1)+c)*256));
		}

}


void	CommandoSetPalette (void)
{
char	*PaletteValues;
int		x;

	PaletteValues=Driver.Palette;

	ez_ClearMem(Palette,770);

	Palette[0]=0;
	Palette[1]=Driver.DataCols;

	for (x=0;x<Driver.DataCols;x++)
		{
		Palette[x*3+2]=*PaletteValues++>>2;
		Palette[x*3+3]=*PaletteValues++>>2;
		Palette[x*3+4]=*PaletteValues++>>2;
		}

	ez_SetPalette(Palette);

	for ( x = 0; x < 256; x++ )
		{
		commandoRemap[x] = x-1;				// Move color 0 to remove transparent color
		commandoRemapBackground[x] = x;		// But don't do it for scroll tiles as they need it
		}

}


void	ExedScreenUpdate (void)
{
int		Xc,Yc,x,y,z,w,Chr,Col,Pos,Flp;
int		Bank;
char	Text[64];

	SpritePtr=(char *)SpriteData;

//	for (Yc=0;Yc<32;Yc++)
//		{
//		for (Xc=0;Xc<32;Xc++)
//			{
//			//PrintSprite (Xc*16,Yc*16,SpritePtr+(Driver.TotalTiles+256+Yc*16+Xc)*256,16,16,ScreenBmp);
//			PrintSprite (Xc*8,Yc*8,CharData[Yc*32+Xc][0],8,8,ScreenBmp);
//			}
//		}
//	return;

//	// Print the scroll-field
//	for (y=0;y<32;y++)
//		{
//		for (x=1;x<15;x++)
//			{
//			Pos=32*(31-y)+x;
//			Xc=(x-1)*16;
//			Yc=y*16;
//
//			Chr=RAM[Driver.ScreenBase+0x00+Pos];//+(((RAM[Driver.ScreenBase+0xc00+Pos]>>6)&3)<<8);
//			ForceSprite (Xc,Yc,SpritePtr+Chr*256,16,16,ScreenBmp3);
//			}
//		}		 

	Yc=(-(ScrollReg-256))&511;

	Yc=0;

	if (Yc<256)
		CopyThin (ScreenBmp+16,ScreenBmp3+Yc*256,256,224,32);
	else
		{
		CopyThin (ScreenBmp+16,ScreenBmp3+Yc*256,512-Yc,224,32);
		CopyThin (ScreenBmp+(512-Yc)*256+16,ScreenBmp3,Yc-256,224,32);
		}


#undef		SPR
#define		SPR		(0x2000)


	ez_PointScreenAtBuffer (ScreenBmp,256,256);


	// Print the sprites
	for (Pos=0;Pos<128*4;Pos+=4)
		{
		Xc=RAM[Driver.ScreenBase+SPR+Pos+2];
		Yc=240-RAM[Driver.ScreenBase+SPR+Pos+3]+((RAM[Driver.ScreenBase+SPR+Pos+1]&1)<<8);
		//Chr=RAM[Driver.ScreenBase+SPR+Pos]+((RAM[Driver.ScreenBase+SPR+Pos+1]&0xc0)<<2);

		Xc+=16;

		Xc&=0xff;
		Yc&=0xff;

		PrintSpriteClipped (Xc,Yc,SpritePtr,16,16,ScreenBmp);

		sprintf (Text,"@C[03]%04x\0",Driver.ScreenBase+SPR+Pos);
		ez_PrintText (Text,8,FONT_LEFT,Xc,Yc,EZ_CLIP);
		}


	// Print the TEXT layer
	for (z=64;z<0x400-64;z++)
		{
		Xc=8*(z/32);
		Yc=8*(31-z%32);

		Chr=RAM[Driver.ScreenBase+z]+(((RAM[Driver.ScreenBase+z+0x400]&0x80)>>7)*256);

		if (Chr!=36)
			PrintSprite (Xc,Yc,CharData[Chr][0],8,8,ScreenBmp);
		}
}






void	ExedTranslateROM (void)
{
int		x,y,z,q,c,v,bit,pixel;
char	byte1,byte2,byte3;
char	Buffer[256];

	ez_ClearMem((char *)SpriteData,sizeof(SpriteData));
	ez_ClearMem((char *)CharData,sizeof(CharData));
	ez_ClearMem((char *)ScreenBmp,sizeof(ScreenBmp));
	ez_ClearMem((char *)ScreenBmp1,sizeof(ScreenBmp1));
	ez_ClearMem((char *)TempScreenA,sizeof(TempScreenA));
	ez_ClearMem((char *)TempScreenB,sizeof(TempScreenB));

	ScrollLO=ScrollHI=ScrollReg=0;

	// CHARACTERS

	for (x=0;x<Driver.TotalChars;x++)
		{
		for (y=0;y<8;y++)
			{
			byte1=TempChars[(x<<4)+(y<<1)+0];
			byte2=TempChars[(x<<4)+(y<<1)+1];

			CharData[x][0][y+7*8]=(((byte1>>3)&1)<<1)+(((byte1>>7)&1));
			CharData[x][0][y+6*8]=(((byte1>>2)&1)<<1)+(((byte1>>6)&1));
			CharData[x][0][y+5*8]=(((byte1>>1)&1)<<1)+(((byte1>>5)&1));
			CharData[x][0][y+4*8]=(((byte1>>0)&1)<<1)+(((byte1>>4)&1));
			CharData[x][0][y+3*8]=(((byte2>>3)&1)<<1)+(((byte2>>7)&1));
			CharData[x][0][y+2*8]=(((byte2>>2)&1)<<1)+(((byte2>>6)&1));
			CharData[x][0][y+1*8]=(((byte2>>1)&1)<<1)+(((byte2>>5)&1));
			CharData[x][0][y+0*8]=(((byte2>>0)&1)<<1)+(((byte2>>4)&1));

//			for ( z = 0; z < 8; z++ ) CharData[x][0][y+z*8] = (CharData[x][0][y+z*8]+1)&3;
			}
		}


	// SCROLL-FIELD TILES


	SpritePtr=(char *)SpriteData;

	for (c=0;c<Driver.TotalTiles*2;c++)
		{
		for ( y = 0; y < 16; y++ )
			{
			bit = 128;
			for ( x = 0; x < 8; x++ )
				{
				pixel = 0;
				// Plane 0;
				if ( TempChars[(Driver.TotalChars<<4)+(c*16)+y]&bit ) pixel |= 4;	//backgroundGraphics[(c*128)+(y*8)+x] = 1;

				// Plane 1;
				if ( TempChars[(Driver.TotalChars<<4)+(c*16)+y+32768]&bit ) pixel |= 2;	//backgroundGraphics[(c*128)+(y*8)+x] = 1;

				// Plane 2;
				if ( TempChars[(Driver.TotalChars<<4)+(c*16)+y+65536]&bit ) pixel |= 1;	//backgroundGraphics[(c*128)+(y*8)+x] = 1;
				
				if (!(c&1))
					Buffer[(y*16)+x] = pixel;
				else
					Buffer[(y*16)+x+8] = pixel;

				bit = bit>>1;
				}
			}
		for (y=0;y<16;y++)
			{
			for (x=0;x<16;x++)
				{
				SpritePtr[((c>>1)*256)+(y*16)+x]=1;//Buffer[(x*16)+15-y];
				}
			}
		}	


	// SPRITES

	for ( c = 0; c < Driver.TotalSprites<<1; c++ )
		{
/////////////////////////////////////////////////////
// Left half plane 0
/////////////////////////////////////////////////////
		for ( y = 0; y < 16; y++ )
			{
			v = TempChars[(Driver.TotalChars<<4)+((Driver.TotalTiles*96))+((y*2))+(c*32)];
			bit = 8;
			for ( x = 3; x > -1; x-- )
				{
				if ( !(c&1) )
					{
					if ( (v&bit)  ) SpritePtr[((Driver.TotalTiles+(c>>1))*256)+((x+4+8)*16)+y] |= 2;
					}
				else if ( (v&bit)  ) SpritePtr[((Driver.TotalTiles+(c>>1))*256)+((x+4)*16)+y] |=  2;
				bit = bit>>1;
				}
			}	
		
/////////////////////////////////////////////////////
// Left half plane 1
/////////////////////////////////////////////////////
		for ( y = 0; y < 16; y++ )
			{
			v = TempChars[(Driver.TotalChars<<4)+((Driver.TotalTiles*96))+((y*2))+(c*32)];
			bit = 128;
			for ( x = 3; x > -1; x-- )
				{
				if ( !(c&1) )
					{
					if ( (v&bit)  ) SpritePtr[((Driver.TotalTiles+(c>>1))*256)+((x+4+8)*16)+y] |=1;
					}
				else if ( (v&bit)  ) SpritePtr[((Driver.TotalTiles+(c>>1))*256)+((x+4)*16)+y] |= 1;
				bit = bit>>1;
				}
			}	

/////////////////////////////////////////////////////
// Left half plane 2
/////////////////////////////////////////////////////
		for ( y = 0; y < 16; y++ )
			{
			v = TempChars[(Driver.TotalChars<<4)+((Driver.TotalTiles*96))+((y*2))+(c*32)+49152];
			bit = 8;
			for ( x = 3; x > -1; x-- )
				{
				if ( !(c&1) )
					{
					if ( (v&bit)  ) SpritePtr[((Driver.TotalTiles+(c>>1))*256)+((x+4+8)*16)+y] |=8;
					}
				else if ( (v&bit)  ) SpritePtr[((Driver.TotalTiles+(c>>1))*256)+((x+4)*16)+y] |= 8;
				bit = bit>>1;
				}
			}	
		
/////////////////////////////////////////////////////
// Left half plane 3
/////////////////////////////////////////////////////
		for ( y = 0; y < 16; y++ )
			{
			v = TempChars[(Driver.TotalChars<<4)+((Driver.TotalTiles*96))+((y*2))+(c*32)+49152];
			bit = 128;
			for ( x = 3; x > -1; x-- )
				{
				if ( !(c&1) )
					{
					if ( (v&bit)  ) SpritePtr[((Driver.TotalTiles+(c>>1))*256)+((x+4+8)*16)+y] |=4;
					}
				else if ( (v&bit) ) SpritePtr[((Driver.TotalTiles+(c>>1))*256)+((x+4)*16)+y]  |= 4;
				bit = bit>>1;
				}
			}	
			
		
/////////////////////////////////////////////////////
// Right half plane 0
/////////////////////////////////////////////////////
		for ( y = 0; y < 16; y++ )
			{
			v = TempChars[(Driver.TotalChars<<4)+((Driver.TotalTiles*96))+((y*2)+1)+(c*32)];
			bit = 8;
			for ( x = 3; x > -1; x-- )
				{
				if ( !(c&1) )
					{
					if ( (v&bit)  ) SpritePtr[((Driver.TotalTiles+(c>>1))*256)+((x+8)*16)+y] |=2;
					}
				else if ( (v&bit) ) SpritePtr[((Driver.TotalTiles+(c>>1))*256)+(x*16)+y] |=    2;
				bit = bit>>1;
				}
			}	
		
/////////////////////////////////////////////////////
// Right half plane 1
/////////////////////////////////////////////////////
		for ( y = 0; y < 16; y++ )
			{
			v = TempChars[(Driver.TotalChars<<4)+((Driver.TotalTiles*96))+((y*2)+1)+(c*32)];
			bit = 128;
			for ( x = 3; x > -1; x-- )
				{
				if ( !(c&1) )
					{
					if ( (v&bit)  ) SpritePtr[((Driver.TotalTiles+(c>>1))*256)+((x+8)*16)+y] |=1;
					}
				else if ( (v&bit) ) SpritePtr[((Driver.TotalTiles+(c>>1))*256)+(x*16)+y] |=   1;
				bit = bit>>1;
				}
			}	
			
		
/////////////////////////////////////////////////////
// Right half plane 2
/////////////////////////////////////////////////////
		for ( y = 0; y < 16; y++ )
			{
			v = TempChars[(Driver.TotalChars<<4)+((Driver.TotalTiles*96))+((y*2)+1)+(c*32)+49152];
			bit = 8;
			for ( x = 3; x > -1; x-- )
				{
				if ( !(c&1) )
					{
					if ( (v&bit)  ) SpritePtr[((Driver.TotalTiles+(c>>1))*256)+((x+8)*16)+y] |=8;
					}
				else if ( (v&bit) ) SpritePtr[((Driver.TotalTiles+(c>>1))*256)+(x*16)+y] |=   8;
				bit = bit>>1;
				}
			}	
		
/////////////////////////////////////////////////////
// Right half plane 3
/////////////////////////////////////////////////////
		for ( y = 0; y < 16; y++ )
			{
			v = TempChars[(Driver.TotalChars<<4)+((Driver.TotalTiles*96))+((y*2)+1)+(c*32)+49152];
			bit = 128;
			for ( x = 3; x > -1; x-- )
				{
				if ( !(c&1) )
					{
					if ( (v&bit)  ) SpritePtr[((Driver.TotalTiles+(c>>1))*256)+((x+8)*16)+y] |=4;
					}																			
				else if ( (v&bit) ) SpritePtr[((Driver.TotalTiles+(c>>1))*256)+(x*16)+y] |=   4;
					
				bit = bit>>1;
				}
			}	

		} 

	// Remove color 15 (transparent)
	for (c=0;c<Driver.TotalSprites;c++)
		{
		for (y=0;y<256;y++)
			{
			SpritePtr[(Driver.TotalTiles+c)*256+y] = (SpritePtr[(Driver.TotalTiles+c)*256+y]+1)&15;
			}
		}

	// Copy and X-Flip all the sprites for fast printing

	for (c=0;c<Driver.TotalSprites;c++)
		{
		ez_CopyMem ((SpritePtr+(Driver.TotalTiles+Driver.TotalSprites+c)*256),(SpritePtr+(Driver.TotalTiles+c)*256),256);
		Hflip ((SpritePtr+(Driver.TotalTiles+Driver.TotalSprites+c)*256));
		}

	// Copy and Y-Flip all the sprites for fast printing
	for (c=0;c<Driver.TotalSprites<<1;c++)
		{
		ez_CopyMem ((SpritePtr+(Driver.TotalTiles+(Driver.TotalSprites<<1)+c)*256),(SpritePtr+(Driver.TotalTiles+c)*256),256);
		Vflip ((SpritePtr+(Driver.TotalTiles+(Driver.TotalSprites<<1)+c)*256));
		}
}




int		CommandoInterrupt (void)
{
Z80_Regs	R;
char		Text[64];
int			x;

	switch (CurrentProc)
		{
		case	0:
			// GAME PROCESSOR

			ez_CopyMem(GnGBuffer2,GnGBuffer1,sizeof(GnGBuffer2));
			ez_CopyMem(GnGBuffer1,&RomSpace[0][Driver.ScreenBase+0x2e00],sizeof(GnGBuffer1));

			Z80_IRQ = Z80_IGNORE_INT;	// Make sure there are no queued interrupts
			return (0xd7);		// RST 10h

		//break;

		case	1:
			// SOUND PROCESSOR

			Z80_IRQ = Z80_IGNORE_INT;	// Make sure there are no queued interrupts

			return (0xff);				// RST 38h
		}

	return (Z80_IGNORE_INT);
}


void	CommandoTranslateROM (void)
{
int		x,y,z,q,c,v,bit,pixel;
char	byte1,byte2,byte3;
char	Buffer[256];

	ez_ClearMem((char *)SpriteData,sizeof(SpriteData));
	ez_ClearMem((char *)CharData,sizeof(CharData));
	ez_ClearMem((char *)ScreenBmp,sizeof(ScreenBmp));
	ez_ClearMem((char *)ScreenBmp1,sizeof(ScreenBmp1));
	ez_ClearMem((char *)TempScreenA,sizeof(TempScreenA));
	ez_ClearMem((char *)TempScreenB,sizeof(TempScreenB));

	ScrollLO=ScrollHI=ScrollReg=0;

	// CHARACTERS

	for (x=0;x<Driver.TotalChars;x++)
		{
		for (y=0;y<8;y++)
			{
			byte1=TempChars[(x<<4)+(y<<1)+0];
			byte2=TempChars[(x<<4)+(y<<1)+1];

			CharData[x][0][y+7*8]=(((byte1>>3)&1)<<1)+(((byte1>>7)&1));
			CharData[x][0][y+6*8]=(((byte1>>2)&1)<<1)+(((byte1>>6)&1));
			CharData[x][0][y+5*8]=(((byte1>>1)&1)<<1)+(((byte1>>5)&1));
			CharData[x][0][y+4*8]=(((byte1>>0)&1)<<1)+(((byte1>>4)&1));
			CharData[x][0][y+3*8]=(((byte2>>3)&1)<<1)+(((byte2>>7)&1));
			CharData[x][0][y+2*8]=(((byte2>>2)&1)<<1)+(((byte2>>6)&1));
			CharData[x][0][y+1*8]=(((byte2>>1)&1)<<1)+(((byte2>>5)&1));
			CharData[x][0][y+0*8]=(((byte2>>0)&1)<<1)+(((byte2>>4)&1));

			for ( z = 0; z < 8; z++ ) CharData[x][0][y+z*8] = (CharData[x][0][y+z*8]+1)&3;
			}
		}


	// SCROLL-FIELD TILES


	SpritePtr=(char *)SpriteData;


	for (c=0;c<Driver.TotalTiles*2;c++)
		{
		for ( y = 0; y < 16; y++ )
			{
			bit = 128;
			for ( x = 0; x < 8; x++ )
				{
				pixel = 0;
				// Plane 0;
				if ( TempChars[(Driver.TotalChars<<4)+(c*16)+y]&bit ) pixel |= 4;	//backgroundGraphics[(c*128)+(y*8)+x] = 1;

				// Plane 1;
				if ( TempChars[(Driver.TotalChars<<4)+(c*16)+y+32768]&bit ) pixel |= 2;	//backgroundGraphics[(c*128)+(y*8)+x] = 1;

				// Plane 2;
				if ( TempChars[(Driver.TotalChars<<4)+(c*16)+y+65536]&bit ) pixel |= 1;	//backgroundGraphics[(c*128)+(y*8)+x] = 1;
				
				if (!(c&1))
					Buffer[(y*16)+x] = pixel;
				else
					Buffer[(y*16)+x+8] = pixel;

				bit = bit>>1;
				}
			}
		for (y=0;y<16;y++)
			{
			for (x=0;x<16;x++)
				{
				SpritePtr[((c>>1)*256)+(y*16)+x]=Buffer[(x*16)+15-y];
				}
			}
		}	


	// SPRITES

	for ( c = 0; c < Driver.TotalSprites<<1; c++ )
		{
/////////////////////////////////////////////////////
// Left half plane 0
/////////////////////////////////////////////////////
		for ( y = 0; y < 16; y++ )
			{
			v = TempChars[(Driver.TotalChars<<4)+((Driver.TotalTiles*96))+((y*2))+(c*32)];
			bit = 8;
			for ( x = 3; x > -1; x-- )
				{
				if ( !(c&1) )
					{
					if ( (v&bit)  ) SpritePtr[((Driver.TotalTiles+(c>>1))*256)+((x+4+8)*16)+y] |= 2;
					}
				else if ( (v&bit)  ) SpritePtr[((Driver.TotalTiles+(c>>1))*256)+((x+4)*16)+y] |=  2;
				bit = bit>>1;
				}
			}	
		
/////////////////////////////////////////////////////
// Left half plane 1
/////////////////////////////////////////////////////
		for ( y = 0; y < 16; y++ )
			{
			v = TempChars[(Driver.TotalChars<<4)+((Driver.TotalTiles*96))+((y*2))+(c*32)];
			bit = 128;
			for ( x = 3; x > -1; x-- )
				{
				if ( !(c&1) )
					{
					if ( (v&bit)  ) SpritePtr[((Driver.TotalTiles+(c>>1))*256)+((x+4+8)*16)+y] |=1;
					}
				else if ( (v&bit)  ) SpritePtr[((Driver.TotalTiles+(c>>1))*256)+((x+4)*16)+y] |= 1;
				bit = bit>>1;
				}
			}	

/////////////////////////////////////////////////////
// Left half plane 2
/////////////////////////////////////////////////////
		for ( y = 0; y < 16; y++ )
			{
			v = TempChars[(Driver.TotalChars<<4)+((Driver.TotalTiles*96))+((y*2))+(c*32)+49152];
			bit = 8;
			for ( x = 3; x > -1; x-- )
				{
				if ( !(c&1) )
					{
					if ( (v&bit)  ) SpritePtr[((Driver.TotalTiles+(c>>1))*256)+((x+4+8)*16)+y] |=8;
					}
				else if ( (v&bit)  ) SpritePtr[((Driver.TotalTiles+(c>>1))*256)+((x+4)*16)+y] |= 8;
				bit = bit>>1;
				}
			}	
		
/////////////////////////////////////////////////////
// Left half plane 3
/////////////////////////////////////////////////////
		for ( y = 0; y < 16; y++ )
			{
			v = TempChars[(Driver.TotalChars<<4)+((Driver.TotalTiles*96))+((y*2))+(c*32)+49152];
			bit = 128;
			for ( x = 3; x > -1; x-- )
				{
				if ( !(c&1) )
					{
					if ( (v&bit)  ) SpritePtr[((Driver.TotalTiles+(c>>1))*256)+((x+4+8)*16)+y] |=4;
					}
				else if ( (v&bit) ) SpritePtr[((Driver.TotalTiles+(c>>1))*256)+((x+4)*16)+y]  |= 4;
				bit = bit>>1;
				}
			}	
			
		
/////////////////////////////////////////////////////
// Right half plane 0
/////////////////////////////////////////////////////
		for ( y = 0; y < 16; y++ )
			{
			v = TempChars[(Driver.TotalChars<<4)+((Driver.TotalTiles*96))+((y*2)+1)+(c*32)];
			bit = 8;
			for ( x = 3; x > -1; x-- )
				{
				if ( !(c&1) )
					{
					if ( (v&bit)  ) SpritePtr[((Driver.TotalTiles+(c>>1))*256)+((x+8)*16)+y] |=2;
					}
				else if ( (v&bit) ) SpritePtr[((Driver.TotalTiles+(c>>1))*256)+(x*16)+y] |=    2;
				bit = bit>>1;
				}
			}	
		
/////////////////////////////////////////////////////
// Right half plane 1
/////////////////////////////////////////////////////
		for ( y = 0; y < 16; y++ )
			{
			v = TempChars[(Driver.TotalChars<<4)+((Driver.TotalTiles*96))+((y*2)+1)+(c*32)];
			bit = 128;
			for ( x = 3; x > -1; x-- )
				{
				if ( !(c&1) )
					{
					if ( (v&bit)  ) SpritePtr[((Driver.TotalTiles+(c>>1))*256)+((x+8)*16)+y] |=1;
					}
				else if ( (v&bit) ) SpritePtr[((Driver.TotalTiles+(c>>1))*256)+(x*16)+y] |=   1;
				bit = bit>>1;
				}
			}	
			
		
/////////////////////////////////////////////////////
// Right half plane 2
/////////////////////////////////////////////////////
		for ( y = 0; y < 16; y++ )
			{
			v = TempChars[(Driver.TotalChars<<4)+((Driver.TotalTiles*96))+((y*2)+1)+(c*32)+49152];
			bit = 8;
			for ( x = 3; x > -1; x-- )
				{
				if ( !(c&1) )
					{
					if ( (v&bit)  ) SpritePtr[((Driver.TotalTiles+(c>>1))*256)+((x+8)*16)+y] |=8;
					}
				else if ( (v&bit) ) SpritePtr[((Driver.TotalTiles+(c>>1))*256)+(x*16)+y] |=   8;
				bit = bit>>1;
				}
			}	
		
/////////////////////////////////////////////////////
// Right half plane 3
/////////////////////////////////////////////////////
		for ( y = 0; y < 16; y++ )
			{
			v = TempChars[(Driver.TotalChars<<4)+((Driver.TotalTiles*96))+((y*2)+1)+(c*32)+49152];
			bit = 128;
			for ( x = 3; x > -1; x-- )
				{
				if ( !(c&1) )
					{
					if ( (v&bit)  ) SpritePtr[((Driver.TotalTiles+(c>>1))*256)+((x+8)*16)+y] |=4;
					}																			
				else if ( (v&bit) ) SpritePtr[((Driver.TotalTiles+(c>>1))*256)+(x*16)+y] |=   4;
					
				bit = bit>>1;
				}
			}	

		} 

	// Remove color 15 (transparent)
	for (c=0;c<Driver.TotalSprites;c++)
		{
		for (y=0;y<256;y++)
			{
			SpritePtr[(Driver.TotalTiles+c)*256+y] = (SpritePtr[(Driver.TotalTiles+c)*256+y]+1)&15;
			}
		}

	// Copy and X-Flip all the sprites for fast printing

	for (c=0;c<Driver.TotalSprites;c++)
		{
		ez_CopyMem ((SpritePtr+(Driver.TotalTiles+Driver.TotalSprites+c)*256),(SpritePtr+(Driver.TotalTiles+c)*256),256);
		Hflip ((SpritePtr+(Driver.TotalTiles+Driver.TotalSprites+c)*256));
		}

	// Copy and Y-Flip all the sprites for fast printing
	for (c=0;c<Driver.TotalSprites<<1;c++)
		{
		ez_CopyMem ((SpritePtr+(Driver.TotalTiles+(Driver.TotalSprites<<1)+c)*256),(SpritePtr+(Driver.TotalTiles+c)*256),256);
		Vflip ((SpritePtr+(Driver.TotalTiles+(Driver.TotalSprites<<1)+c)*256));
		}
}



void	CommandoScreenUpdate (void)
{
int		Xc,Yc,x,y,z,w,Chr,Col,Pos,Flp;
int		Bank;
char	Text[64];

	SpritePtr=(char *)SpriteData;

	// Print the scroll-field
	for (y=0;y<32;y++)
		{
		for (x=1;x<15;x++)
			{
			Pos=32*(31-y)+x;
			if (TempScreenA[Pos] || TempScreenA[Pos+16])
				{
				TempScreenA[Pos]=TempScreenA[Pos+16]=0;

				Xc=(x-1)*16;
				Yc=y*16;

				Chr=RAM[Driver.ScreenBase+0x800+Pos]+(((RAM[Driver.ScreenBase+0xc00+Pos]>>6)&3)<<8);
		   		Flp=(RAM[Driver.ScreenBase+0xc00+Pos]>>4)&3;

				// Color of background tiles
				Col = (RAM[Driver.ScreenBase+0xc00+Pos])&0xf;
				RemapPtr=&commandoRemapBackground[Col*8];

				switch (Flp)
					{
					case	0:
						RemapForceSprite (Xc,Yc,SpritePtr+Chr*256,16,16,ScreenBmp3);
					break;

					case	1:
						RemapForceSpriteV (Xc,Yc,SpritePtr+Chr*256,16,16,ScreenBmp3);
					break;

					case	2:
						RemapForceSpriteH (Xc,Yc,SpritePtr+Chr*256,16,16,ScreenBmp3);
					break;

					case	3:
						RemapForceSpriteHV (Xc,Yc,SpritePtr+Chr*256,16,16,ScreenBmp3);
					break;
					}
				}
			}
		}		 

	Yc=(-(ScrollReg-256))&511;

	if (Yc<256)
		CopyThin (ScreenBmp+16,ScreenBmp3+Yc*256,256,224,32);
	else
		{
		CopyThin (ScreenBmp+16,ScreenBmp3+Yc*256,512-Yc,224,32);
		CopyThin (ScreenBmp+(512-Yc)*256+16,ScreenBmp3,Yc-256,224,32);
		}

#undef		SPR
#define		SPR		0x2e00

	// Print the sprites
	for (Pos=95*4;Pos>=0;Pos-=4)
		{
		Xc=GnGBuffer2[Pos+2];
		Yc=240-GnGBuffer2[Pos+3]+((GnGBuffer2[Pos+1]&1)<<8);
		Chr=GnGBuffer2[Pos]+((GnGBuffer2[Pos+1]&0xc0)<<2);

		// Color of sprites
		Col =	((GnGBuffer2[Pos+1]>>4)&0x3)+8;

		// X-Flip
		if (GnGBuffer2[Pos+1]&8)
			Chr+=Driver.TotalSprites;
		// Y-Flip
		if (GnGBuffer2[Pos+1]&4)
			Chr+=(Driver.TotalSprites<<1);

		//Old[x>>2].Xc=Xc;
		//Old[x>>2].Yc=Yc;
		//Old[x>>2].Col=Col;
		//Old[x>>2].Chr=Chr;

		RemapPtr=&commandoRemap[Col*16];
		RemapPrintSpriteClipped (Xc,Yc,SpritePtr+((Chr+Driver.TotalTiles)*256),16,16,ScreenBmp);
		}

	// Print the TEXT layer
	for (z=64;z<0x400-64;z++)
		{
		Xc=8*(z/32);
		Yc=8*(31-z%32);

		Chr=RAM[Driver.ScreenBase+z]+(((RAM[Driver.ScreenBase+z+0x400]&0xc0)>>6)*256);

		// Color of text
		Col=(RAM[Driver.ScreenBase+z+0x400])&31;

		// For the moment all chars over 512 (logo use color 8) will look at this later (maybe)
		if ( Chr > 512 ) Col = 8;

		if (Chr!=32)
			{
			RemapPtr=&commandoRemap[(Col*4)+0xc0];
			if (RAM[Driver.ScreenBase+z+0x400]&32)
				RemapPrintSpriteH (Xc,Yc,CharData[Chr][0],8,8,ScreenBmp);
			else
				RemapPrintSprite (Xc,Yc,CharData[Chr][0],8,8,ScreenBmp);
			}
		}
}








// Manu thanks to Nicola for supplying me with palette routines as always

void	SetPalette1942 (void)
{
char	*color_prom;
int 	i,j,bit0,bit1,bit2,bit3;

	Palette[0]=0;
	Palette[1]=0;

	color_prom=TempChars+0x1e000;

	for (i = 0;i < 256;i++)
		{
		bit0 = (color_prom[i] >> 0) & 0x01;
		bit1 = (color_prom[i] >> 1) & 0x01;
		bit2 = (color_prom[i] >> 2) & 0x01;
		bit3 = (color_prom[i] >> 3) & 0x01;
		Palette[3*i+2] = (0x0e * bit0 + 0x1f * bit1 + 0x43 * bit2 + 0x8f * bit3)>>2;
		bit0 = (color_prom[i+256] >> 0) & 0x01;
		bit1 = (color_prom[i+256] >> 1) & 0x01;
		bit2 = (color_prom[i+256] >> 2) & 0x01;
		bit3 = (color_prom[i+256] >> 3) & 0x01;
		Palette[3*i+3] = (0x0e * bit0 + 0x1f * bit1 + 0x43 * bit2 + 0x8f * bit3)>>2;
		bit0 = (color_prom[i+256*2] >> 0) & 0x01;
		bit1 = (color_prom[i+256*2] >> 1) & 0x01;
		bit2 = (color_prom[i+256*2] >> 2) & 0x01;
		bit3 = (color_prom[i+256*2] >> 3) & 0x01;
		Palette[3*i+4] = (0x0e * bit0 + 0x1f * bit1 + 0x43 * bit2 + 0x8f * bit3)>>2;
		}

	/* characters use colors 128-143 */
	for (i = 0;i < 64*4;i++)
		ColourTable[i] = color_prom[i + 256*3] + 128;

	/* sprites use colors 64-79 */
	for (i=0;i<16;i++)
		{
		for (j=0;j<16;j++)
			{
			ColourTable[256+(i*16)+((j+1)&15)] = color_prom[i*16+j + 256*4]+ 64;
			}
		}

	/* background tiles use colors 0-63 in four banks */
	for (i = 64*4+16*16;i < 64*4+16*16+32*8;i++)
		{
		ColourTable[i] = color_prom[i + 256*3];
		ColourTable[i+32*8] = color_prom[i + 256*3] + 16;
		ColourTable[i+2*32*8] = color_prom[i + 256*3] + 32;
		ColourTable[i+3*32*8] = color_prom[i + 256*3] + 48;
		}

	ez_SetPalette(Palette);
}


void	ScreenUpdate1942 (void)
{
int		Xc,Yc,x,y,z,w,Chr,Col,Pos,Flp;
int		Bank;

//	for (Yc=0;Yc<16;Yc++)
//		{
//		for (Xc=0;Xc<16;Xc++)
//			{
//			ForceSprite (Xc*16,Yc*16,SpriteData[512+256+Yc*16+Xc][0],16,16,ScreenBmp);
//			}
//		}
//	return;


	// Print the scroll-field
	for (y=0;y<32;y++)
		{
		for (x=0;x<16;x++)
			{
			Pos=32*(31-y)+x+1;
			if (TempScreenA[Pos] || TempScreenA[Pos+16])
				{
				TempScreenA[Pos]=TempScreenA[Pos+16]=0;

				Xc=x*16;
				Yc=y*16;

				Chr=RomSpace[0][Driver.ScreenBase+0x800+Pos]+((RomSpace[0][Driver.ScreenBase+0x800+Pos+16]>>7)<<8);
				Col=RomSpace[0][Driver.ScreenBase+0x800+Pos+16]&31;
				Flp=(RomSpace[0][Driver.ScreenBase+0x800+Pos+16]>>5)&3;

				RemapPtr=ColourTable+(Col*8)+(32*8*PaletteBank)+512;

				switch (Flp)
					{
					case	0:
						RemapForceSprite (Xc,Yc,SpriteData[Chr][0],16,16,ScreenBmp3);
					break;

					case	1:
						RemapForceSpriteV (Xc,Yc,SpriteData[Chr][0],16,16,ScreenBmp3);
					break;

					case	2:
						RemapForceSpriteH (Xc,Yc,SpriteData[Chr][0],16,16,ScreenBmp3);
					break;

					case	3:
						RemapForceSpriteHV (Xc,Yc,SpriteData[Chr][0],16,16,ScreenBmp3);
					break;
					}
				}
			}
		}		 

	Yc=(-(ScrollReg-256))&511;
	if (Yc<256)
		CopyThin (ScreenBmp+16,ScreenBmp3+Yc*256,256,224,32);
	else
		{
		CopyThin (ScreenBmp+16,ScreenBmp3+Yc*256,512-Yc,224,32);
		CopyThin (ScreenBmp+(512-Yc)*256+16,ScreenBmp3,Yc-256,224,32);
		}

	// Print the sprites
	for (Pos=31*4;Pos>=0;Pos-=4)
		{
		Bank=0;
		if (RomSpace[0][Driver.ScreenBase-0x400+Pos]&0x80)
			Bank++;
		if (RomSpace[0][Driver.ScreenBase-0x400+Pos+1]&0x20)
			Bank+=2;

		Xc=RomSpace[0][Driver.ScreenBase-0x400+Pos+2];
		Yc=240-RomSpace[0][Driver.ScreenBase-0x400+Pos+3]+((RomSpace[0][Driver.ScreenBase-0x400+Pos+1]&16)<<4);
		Chr=RomSpace[0][Driver.ScreenBase-0x400+Pos]&127;
		Col=RomSpace[0][Driver.ScreenBase-0x400+Pos+1]&15;

		w=((RomSpace[0][Driver.ScreenBase-0x400+Pos+1]&0xc0)>>6)+1;
		if (w==3) w++;

		if (Xc>0)
		for (z=0;z<w;z++) 
			{
			RemapPtr=&ColourTable[Col*16+256];
			RemapPrintSpriteClipped (Xc+(z<<4),Yc,SpriteData[Bank*128+Chr+z+Driver.TotalTiles][0],16,16,ScreenBmp);
			}
		}


	// Print the TEXT layer
	for (z=64;z<0x400-64;z++)
		{
		Xc=8*(z/32);
		Yc=8*(31-z%32);

		Chr=RomSpace[0][Driver.ScreenBase+z]+(((RomSpace[0][Driver.ScreenBase+z+0x400]&0x80)>>7)*256);
		Col=(RomSpace[0][Driver.ScreenBase+z+0x400])&63;

		if (Chr!=48)
			{
			RemapPtr=ColourTable+Col*4;
			RemapPrintSprite (Xc,Yc,CharData[Chr][0],8,8,ScreenBmp);
			}
		}
}


int		Interrupt1942 (void)
{
Z80_Regs	R;

	switch (CurrentProc)
		{
		case	0:
			// GAME PROCESSOR

			Z80_IRQ = Z80_IGNORE_INT;	// Make sure there are no queued interrupts

			if (CPU_IntSplit==Driver.Proc[CurrentProc].IntSplit)
				return (0xd7);		// RST 10h
			else
			if (CPU_IntSplit==Driver.Proc[CurrentProc].IntSplit-1)
				return (0xcf);		// RST 08h
			else
				return (Z80_IGNORE_INT);

		case	1:
			// SOUND PROCESSOR

			Z80_IRQ = Z80_IGNORE_INT;	// Make sure there are no queued interrupts

			return (0xff);				// RST 38h
		}

	return (Z80_IGNORE_INT);
}






void	TranslateROM1942 (void)
{
int		x,y,z,q,c,v,bit;
char	byte1,byte2,byte3;
char	Buffer[256];


	// Copy the code banks into seperate address spaces
	for (x=0;x<3;x++)
		ez_CopyMem ((char *)&RomSpace[x+2][0],(char *)&RomSpace[0][0],65536);

	ez_CopyMem ((char *)&RomSpace[2][0x8000],(char *)&RomSpace[0][0x10000],0x4000);
	ez_CopyMem ((char *)&RomSpace[3][0x8000],(char *)&RomSpace[0][0x14000],0x2000);
	ez_CopyMem ((char *)&RomSpace[4][0x8000],(char *)&RomSpace[0][0x16000],0x4000);

	ez_ClearMem((char *)SpriteData,sizeof(SpriteData));
	ez_ClearMem((char *)CharData,sizeof(CharData));
	ez_ClearMem((char *)ScreenBmp,sizeof(ScreenBmp));
	ez_ClearMem((char *)ScreenBmp1,sizeof(ScreenBmp1));
	ez_ClearMem((char *)TempScreenA,sizeof(TempScreenA));
	ez_ClearMem((char *)TempScreenB,sizeof(TempScreenB));

	ScrollLO=ScrollHI=ScrollReg=0;


	// CHARACTERS

	for (x=0;x<Driver.TotalChars;x++)
		{
		for (y=0;y<8;y++)
			{
			byte1=TempChars[(x<<4)+(y<<1)+0];
			byte2=TempChars[(x<<4)+(y<<1)+1];

			CharData[x][0][y+7*8]=(((byte1>>3)&1)<<1)+(((byte1>>7)&1));
			CharData[x][0][y+6*8]=(((byte1>>2)&1)<<1)+(((byte1>>6)&1));
			CharData[x][0][y+5*8]=(((byte1>>1)&1)<<1)+(((byte1>>5)&1));
			CharData[x][0][y+4*8]=(((byte1>>0)&1)<<1)+(((byte1>>4)&1));
			CharData[x][0][y+3*8]=(((byte2>>3)&1)<<1)+(((byte2>>7)&1));
			CharData[x][0][y+2*8]=(((byte2>>2)&1)<<1)+(((byte2>>6)&1));
			CharData[x][0][y+1*8]=(((byte2>>1)&1)<<1)+(((byte2>>5)&1));
			CharData[x][0][y+0*8]=(((byte2>>0)&1)<<1)+(((byte2>>4)&1));
			}
		}

	// SCROLL-FIELD TILES

	for (x=0;x<Driver.TotalTiles>>1;x++)
		{
		for (y=0;y<16;y++)
			{
			byte3=TempChars[(Driver.TotalChars<<4)+(x<<5)+y];
			byte2=TempChars[(Driver.TotalChars<<4)+(x<<5)+y+((Driver.TotalTiles)<<4)];
			byte1=TempChars[(Driver.TotalChars<<4)+(x<<5)+y+((Driver.TotalTiles)<<5)];

			SpriteData[x][0][y+15*16]=(((byte1>>7)&1)<<2)+(((byte2>>7)&1)<<1)+(((byte3>>7)&1)<<0);
			SpriteData[x][0][y+14*16]=(((byte1>>6)&1)<<2)+(((byte2>>6)&1)<<1)+(((byte3>>6)&1)<<0);
			SpriteData[x][0][y+13*16]=(((byte1>>5)&1)<<2)+(((byte2>>5)&1)<<1)+(((byte3>>5)&1)<<0);
			SpriteData[x][0][y+12*16]=(((byte1>>4)&1)<<2)+(((byte2>>4)&1)<<1)+(((byte3>>4)&1)<<0);
			SpriteData[x][0][y+11*16]=(((byte1>>3)&1)<<2)+(((byte2>>3)&1)<<1)+(((byte3>>3)&1)<<0);
			SpriteData[x][0][y+10*16]=(((byte1>>2)&1)<<2)+(((byte2>>2)&1)<<1)+(((byte3>>2)&1)<<0);
			SpriteData[x][0][y+9*16]=(((byte1>>1)&1)<<2)+(((byte2>>1)&1)<<1)+(((byte3>>1)&1)<<0);
			SpriteData[x][0][y+8*16]=(((byte1>>0)&1)<<2)+(((byte2>>0)&1)<<1)+(((byte3>>0)&1)<<0);

			byte3=TempChars[(Driver.TotalChars<<4)+(x<<5)+y+16];
			byte2=TempChars[(Driver.TotalChars<<4)+(x<<5)+y+((Driver.TotalTiles)<<4)+16];
			byte1=TempChars[(Driver.TotalChars<<4)+(x<<5)+y+((Driver.TotalTiles)<<5)+16];

			SpriteData[x][0][y+7*16]=(((byte1>>7)&1)<<2)+(((byte2>>7)&1)<<1)+(((byte3>>7)&1)<<0);
			SpriteData[x][0][y+6*16]=(((byte1>>6)&1)<<2)+(((byte2>>6)&1)<<1)+(((byte3>>6)&1)<<0);
			SpriteData[x][0][y+5*16]=(((byte1>>5)&1)<<2)+(((byte2>>5)&1)<<1)+(((byte3>>5)&1)<<0);
			SpriteData[x][0][y+4*16]=(((byte1>>4)&1)<<2)+(((byte2>>4)&1)<<1)+(((byte3>>4)&1)<<0);
			SpriteData[x][0][y+3*16]=(((byte1>>3)&1)<<2)+(((byte2>>3)&1)<<1)+(((byte3>>3)&1)<<0);
			SpriteData[x][0][y+2*16]=(((byte1>>2)&1)<<2)+(((byte2>>2)&1)<<1)+(((byte3>>2)&1)<<0);
			SpriteData[x][0][y+1*16]=(((byte1>>1)&1)<<2)+(((byte2>>1)&1)<<1)+(((byte3>>1)&1)<<0);
			SpriteData[x][0][y+0*16]=(((byte1>>0)&1)<<2)+(((byte2>>0)&1)<<1)+(((byte3>>0)&1)<<0);
			}
		}
  
	for (x=Driver.TotalTiles>>1;x<Driver.TotalTiles;x++)
		{
		for (y=0;y<16;y++)
			{
			byte3=TempChars[(Driver.TotalChars<<4)+((x-(Driver.TotalTiles>>1))<<5)+y+Driver.TotalTiles*48];
			byte2=TempChars[(Driver.TotalChars<<4)+((x-(Driver.TotalTiles>>1))<<5)+y+((Driver.TotalTiles)<<4)+Driver.TotalTiles*48];
			byte1=TempChars[(Driver.TotalChars<<4)+((x-(Driver.TotalTiles>>1))<<5)+y+((Driver.TotalTiles)<<5)+Driver.TotalTiles*48];

			SpriteData[x][0][y+15*16]=(((byte1>>7)&1)<<2)+(((byte2>>7)&1)<<1)+(((byte3>>7)&1)<<0);
			SpriteData[x][0][y+14*16]=(((byte1>>6)&1)<<2)+(((byte2>>6)&1)<<1)+(((byte3>>6)&1)<<0);
			SpriteData[x][0][y+13*16]=(((byte1>>5)&1)<<2)+(((byte2>>5)&1)<<1)+(((byte3>>5)&1)<<0);
			SpriteData[x][0][y+12*16]=(((byte1>>4)&1)<<2)+(((byte2>>4)&1)<<1)+(((byte3>>4)&1)<<0);
			SpriteData[x][0][y+11*16]=(((byte1>>3)&1)<<2)+(((byte2>>3)&1)<<1)+(((byte3>>3)&1)<<0);
			SpriteData[x][0][y+10*16]=(((byte1>>2)&1)<<2)+(((byte2>>2)&1)<<1)+(((byte3>>2)&1)<<0);
			SpriteData[x][0][y+9*16]=(((byte1>>1)&1)<<2)+(((byte2>>1)&1)<<1)+(((byte3>>1)&1)<<0);
			SpriteData[x][0][y+8*16]=(((byte1>>0)&1)<<2)+(((byte2>>0)&1)<<1)+(((byte3>>0)&1)<<0);

			byte3=TempChars[(Driver.TotalChars<<4)+((x-(Driver.TotalTiles>>1))<<5)+y+16+Driver.TotalTiles*48];
			byte2=TempChars[(Driver.TotalChars<<4)+((x-(Driver.TotalTiles>>1))<<5)+y+16+((Driver.TotalTiles)<<4)+Driver.TotalTiles*48];
			byte1=TempChars[(Driver.TotalChars<<4)+((x-(Driver.TotalTiles>>1))<<5)+y+16+((Driver.TotalTiles)<<5)+Driver.TotalTiles*48];

			SpriteData[x][0][y+7*16]=(((byte1>>7)&1)<<2)+(((byte2>>7)&1)<<1)+(((byte3>>7)&1)<<0);
			SpriteData[x][0][y+6*16]=(((byte1>>6)&1)<<2)+(((byte2>>6)&1)<<1)+(((byte3>>6)&1)<<0);
			SpriteData[x][0][y+5*16]=(((byte1>>5)&1)<<2)+(((byte2>>5)&1)<<1)+(((byte3>>5)&1)<<0);
			SpriteData[x][0][y+4*16]=(((byte1>>4)&1)<<2)+(((byte2>>4)&1)<<1)+(((byte3>>4)&1)<<0);
			SpriteData[x][0][y+3*16]=(((byte1>>3)&1)<<2)+(((byte2>>3)&1)<<1)+(((byte3>>3)&1)<<0);
			SpriteData[x][0][y+2*16]=(((byte1>>2)&1)<<2)+(((byte2>>2)&1)<<1)+(((byte3>>2)&1)<<0);
			SpriteData[x][0][y+1*16]=(((byte1>>1)&1)<<2)+(((byte2>>1)&1)<<1)+(((byte3>>1)&1)<<0);
			SpriteData[x][0][y+0*16]=(((byte1>>0)&1)<<2)+(((byte2>>0)&1)<<1)+(((byte3>>0)&1)<<0);
			}
		}

#define		LO	128
#define		HI	8

	// SPRITES

	for ( c = 0; c < Driver.TotalSprites<<1; c++ )
		{
/////////////////////////////////////////////////////
// Left half plane 0
/////////////////////////////////////////////////////
		for ( y = 0; y < 16; y++ )
			{
			v = TempChars[(Driver.TotalChars<<4)+((Driver.TotalTiles*96))+((y*2))+(c*32)];
			bit = LO;
			for ( x = 3; x > -1; x-- )
				{
				if ( !(c&1) )
					{
					if ( (v&bit)  ) SpriteData[Driver.TotalTiles+(c>>1)][0][((x+4+8)*16)+y] = 1;
					}
				else if ( (v&bit)  ) SpriteData[Driver.TotalTiles+(c>>1)][0][((x+4)*16)+y] =  1;
				bit = bit>>1;
				}
			}	
		
/////////////////////////////////////////////////////
// Left half plane 1
/////////////////////////////////////////////////////
		for ( y = 0; y < 16; y++ )
			{
			v = TempChars[(Driver.TotalChars<<4)+((Driver.TotalTiles*96))+((y*2))+(c*32)];
			bit = HI;
			for ( x = 3; x > -1; x-- )
				{
				if ( !(c&1) )
					{
					if ( (v&bit)  ) SpriteData[Driver.TotalTiles+(c>>1)][0][((x+4+8)*16)+y] |=2;
					}
				else if ( (v&bit)  ) SpriteData[Driver.TotalTiles+(c>>1)][0][((x+4)*16)+y] |= 2;
				bit = bit>>1;
				}
			}	

/////////////////////////////////////////////////////
// Left half plane 2
/////////////////////////////////////////////////////
		for ( y = 0; y < 16; y++ )
			{
			v = TempChars[(Driver.TotalChars<<4)+((Driver.TotalTiles*96))+((y*2))+(c*32)+32768];
			bit = LO;
			for ( x = 3; x > -1; x-- )
				{
				if ( !(c&1) )
					{
					if ( (v&bit)  ) SpriteData[Driver.TotalTiles+(c>>1)][0][((x+4+8)*16)+y] |=4;
					}
				else if ( (v&bit)  ) SpriteData[Driver.TotalTiles+(c>>1)][0][((x+4)*16)+y] |= 4;
				bit = bit>>1;
				}
			}	
		
/////////////////////////////////////////////////////
// Left half plane 3
/////////////////////////////////////////////////////
		for ( y = 0; y < 16; y++ )
			{
			v = TempChars[(Driver.TotalChars<<4)+((Driver.TotalTiles*96))+((y*2))+(c*32)+32768];
			bit = HI;
			for ( x = 3; x > -1; x-- )
				{
				if ( !(c&1) )
					{
					if ( (v&bit)  ) SpriteData[Driver.TotalTiles+(c>>1)][0][((x+4+8)*16)+y] |=8;
					}
				else if ( (v&bit) ) SpriteData[Driver.TotalTiles+(c>>1)][0][((x+4)*16)+y] |= 8;
				bit = bit>>1;
				}
			}	
			
		
/////////////////////////////////////////////////////
// Right half plane 0
/////////////////////////////////////////////////////
		for ( y = 0; y < 16; y++ )
			{
			v = TempChars[(Driver.TotalChars<<4)+((Driver.TotalTiles*96))+((y*2)+1)+(c*32)];
			bit = LO;
			for ( x = 3; x > -1; x-- )
				{
				if ( !(c&1) )
					{
					if ( (v&bit)  ) SpriteData[Driver.TotalTiles+(c>>1)][0][((x+8)*16)+y] =1;
					}
				else if ( (v&bit) ) SpriteData[Driver.TotalTiles+(c>>1)][0][(x*16)+y] =   1;
				bit = bit>>1;
				}
			}	
		
/////////////////////////////////////////////////////
// Right half plane 1
/////////////////////////////////////////////////////
		for ( y = 0; y < 16; y++ )
			{
			v = TempChars[(Driver.TotalChars<<4)+((Driver.TotalTiles*96))+((y*2)+1)+(c*32)];
			bit = HI;
			for ( x = 3; x > -1; x-- )
				{
				if ( !(c&1) )
					{
					if ( (v&bit)  ) SpriteData[Driver.TotalTiles+(c>>1)][0][((x+8)*16)+y] |=2;
					}
				else if ( (v&bit) ) SpriteData[Driver.TotalTiles+(c>>1)][0][(x*16)+y] |=   2;
				bit = bit>>1;
				}
			}	
			
		
/////////////////////////////////////////////////////
// Right half plane 2
/////////////////////////////////////////////////////
		for ( y = 0; y < 16; y++ )
			{
			v = TempChars[(Driver.TotalChars<<4)+((Driver.TotalTiles*96))+((y*2)+1)+(c*32)+32768];
			bit = LO;
			for ( x = 3; x > -1; x-- )
				{
				if ( !(c&1) )
					{
					if ( (v&bit)  ) SpriteData[Driver.TotalTiles+(c>>1)][0][((x+8)*16)+y] |=4;
					}
				else if ( (v&bit) ) SpriteData[Driver.TotalTiles+(c>>1)][0][(x*16)+y] |=   4;
				bit = bit>>1;
				}
			}	
		
/////////////////////////////////////////////////////
// Right half plane 3
/////////////////////////////////////////////////////
		for ( y = 0; y < 16; y++ )
			{
			v = TempChars[(Driver.TotalChars<<4)+((Driver.TotalTiles*96))+((y*2)+1)+(c*32)+32768];
			bit = HI;
			for ( x = 3; x > -1; x-- )
				{
				if ( !(c&1) )
					{
					if ( (v&bit)  ) SpriteData[Driver.TotalTiles+(c>>1)][0][((x+8)*16)+y] |=8;
					}																			
				else if ( (v&bit) ) SpriteData[Driver.TotalTiles+(c>>1)][0][(x*16)+y] |=   8;
					
				bit = bit>>1;
				}
			}	

		} 

	for (c=0;c<512;c++)
		{
		for (y=0;y<256;y++)
			{
			SpriteData[Driver.TotalTiles+c][0][y]=(SpriteData[Driver.TotalTiles+c][0][y]+1)&15;
			}
		}


	// Re-order the sprites in memory
	for (c=0;c<128;c++)
		{
		ez_CopyMem (Buffer,SpriteData[Driver.TotalTiles+c+128][0],256);
		ez_CopyMem (SpriteData[Driver.TotalTiles+c+128][0],SpriteData[Driver.TotalTiles+c+256][0],256);
		ez_CopyMem (SpriteData[Driver.TotalTiles+c+256][0],Buffer,256);
		}


}



void	MrDoTranslateROM (void)
{
int		x,y,z,q;
char	byte1,byte2;

	for (x=0;x<256;x++)
		{
		if (x%4==0)
			ColourTable[x]=0;
		else
			ColourTable[x]=x;
		}
	ColourTable[256]=3;			// Black, but avoid transparency
	for (x=1;x<256;x++)
		ColourTable[x+256]=x;

	ez_ClearMem((char *)SpriteData,sizeof(SpriteData));
	ez_ClearMem((char *)CharData,sizeof(CharData));
	ez_ClearMem((char *)ScreenBmp2,sizeof(ScreenBmp2));
	ez_ClearMem((char *)ScreenBmp1,sizeof(ScreenBmp1));
	ez_ClearMem((char *)ScreenBmp,sizeof(ScreenBmp));

	memset ((char *)TempScreenA,255,sizeof(TempScreenA));
	memset ((char *)TempScreenB,255,sizeof(TempScreenB));

	for (x=0;x<Driver.TotalChars;x++)
		{
		for (y=0;y<8;y++)
			{
			byte1=TempChars[(x<<3)+y];
			byte2=TempChars[(x<<3)+y+((Driver.TotalChars>>1)<<4)];
			for (q=0;q<8;q++)
    			CharData[x][0][q*8+y]=(((byte1>>(7-q))&1)<<1)+((byte2>>(7-q))&1);
			}
		}

	for (x=0;x<Driver.TotalSprites;x++)
		{
		for (y=0;y<16;y++)
			{
			byte1=TempChars[Driver.TotalChars*16+(x<<6)+(y<<2)+3];
			byte2=TempChars[Driver.TotalChars*16+(x<<6)+(y<<2)+2];

			SpriteData[x][0][y+16*0]=(((byte1>>3)&1)<<1)+(((byte1>>7)&1));
			SpriteData[x][0][y+16*1]=(((byte1>>2)&1)<<1)+(((byte1>>6)&1));
			SpriteData[x][0][y+16*2]=(((byte1>>1)&1)<<1)+(((byte1>>5)&1));
			SpriteData[x][0][y+16*3]=(((byte1>>0)&1)<<1)+(((byte1>>4)&1));
			SpriteData[x][0][y+16*4]=(((byte2>>3)&1)<<1)+(((byte2>>7)&1));
			SpriteData[x][0][y+16*5]=(((byte2>>2)&1)<<1)+(((byte2>>6)&1));
			SpriteData[x][0][y+16*6]=(((byte2>>1)&1)<<1)+(((byte2>>5)&1));
			SpriteData[x][0][y+16*7]=(((byte2>>0)&1)<<1)+(((byte2>>4)&1));

			byte1=TempChars[Driver.TotalChars*16+(x<<6)+(y<<2)+1];
			byte2=TempChars[Driver.TotalChars*16+(x<<6)+(y<<2)+0];

			SpriteData[x][0][y+16*8 ]= (((byte1>>3)&1)<<1)+(((byte1>>7)&1));
			SpriteData[x][0][y+16*9 ]= (((byte1>>2)&1)<<1)+(((byte1>>6)&1));
			SpriteData[x][0][y+16*10]=(((byte1>>1)&1)<<1)+(((byte1>>5)&1));
			SpriteData[x][0][y+16*11]=(((byte1>>0)&1)<<1)+(((byte1>>4)&1));
			SpriteData[x][0][y+16*12]=(((byte2>>3)&1)<<1)+(((byte2>>7)&1));
			SpriteData[x][0][y+16*13]=(((byte2>>2)&1)<<1)+(((byte2>>6)&1));
			SpriteData[x][0][y+16*14]=(((byte2>>1)&1)<<1)+(((byte2>>5)&1));
			SpriteData[x][0][y+16*15]=(((byte2>>0)&1)<<1)+(((byte2>>4)&1));
			}

		// Make 3 more copies for the flipping
		ez_CopyMem (SpriteData[x+Driver.TotalSprites*1][0],SpriteData[x][0],256);
		ez_CopyMem (SpriteData[x+Driver.TotalSprites*2][0],SpriteData[x][0],256);
		ez_CopyMem (SpriteData[x+Driver.TotalSprites*3][0],SpriteData[x][0],256);


		Vflip (SpriteData[x+Driver.TotalSprites*1][0]);

		Hflip (SpriteData[x+Driver.TotalSprites*2][0]);

	   	Vflip (SpriteData[x+Driver.TotalSprites*3][0]);
	   	Hflip (SpriteData[x+Driver.TotalSprites*3][0]);
		}
}


void	MrDoScreenUpdate (void)
{
int		Chr,Col,sp;
int		x,y,z,spritenum,colour;
int		Xc,Yc,dir,w;

	for (z=0;z<0x400;z++)
		{
		if (TempScreenA[z])
			{
			TempScreenA[z]=0;
			Xc=8*(z/32);
			Yc=8*(31-z%32);

			Chr=RAM[Driver.ScreenBase+z+0x400]+(2*(RAM[Driver.ScreenBase+z+0x000]&0x80))+512;
			Col=(RAM[Driver.ScreenBase+z+0x000]>>0)&127;
			RemapPtr=ColourTable+(Col<<2);
			RemapForceSprite (Xc,Yc,CharData[Chr][0],8,8,ScreenBmp2);
			if (Xc>=4*8 && Xc<256-4*8)
				RemapForceSprite (Xc,Yc,CharData[Chr][0],8,8,ScreenBmp1);

			Chr=RAM[Driver.ScreenBase+z+0xc00]+ (2*(RAM[Driver.ScreenBase+z+0x800]&0x80));
			Col=(RAM[Driver.ScreenBase+z+0x800]>>0)&127;
			RemapPtr=ColourTable+(Col<<2);
			RemapForceSprite (Xc,Yc,CharData[Chr][0],8,8,ScreenBmp3); 
			if (Xc>=4*8 && Xc<256-4*8)
				{
				if (Col&0x40)
					RemapForceSprite (Xc,Yc,CharData[Chr][0],8,8,ScreenBmp1); 
				else
					RemapPrintSprite (Xc,Yc,CharData[Chr][0],8,8,ScreenBmp1); 
				}
			}
		}

	if (ScrollReg)
		{
		for (z=0;z<256;z++)
			for (x=32;x<256-32;x++)
				ScreenBmp[z*256+x]=ScreenBmp2[z*256+((x+ScrollReg)&255)];

		for (z=0;z<256;z++)
			for (x=32;x<256-32;x++)
				if (ScreenBmp3[z*256+x])
					ScreenBmp[z*256+x]=ScreenBmp3[z*256+x];
		}
	else
		ez_CopyMem (ScreenBmp,ScreenBmp1,65536);

	for (x=4*63;x>=0;x-=4)
		{
		Xc=256-RAM[Driver.ScreenBase+0x1001+x];
		Yc=240-RAM[Driver.ScreenBase+0x1003+x];
		if (Xc<256-32 && Xc>=16 && Yc>=0 && Yc<256-32)
			{
			Chr=RAM[Driver.ScreenBase+0x1000+x]+((0+((RAM[Driver.ScreenBase+0x1002+x]>>4))&3)*Driver.TotalSprites);
			Col=RAM[Driver.ScreenBase+0x1002+x]&15;

			RemapPtr=ColourTable+512+(Col<<2);
   			RemapPrintSprite (Xc,Yc,SpriteData[Chr][0],16,16,ScreenBmp);
			}
		}
}




int		MrDoInterrupt (void)
{
int		voice;

	//// Draw the stuff into ScreenBmp
	//if (Driver.fn_ScreenUpdate)
	//	Driver.fn_ScreenUpdate();
	//
	//// Let's see it then
	//BlitScreen();

	if (SoundPermitted && sound_changed)
		{
		sound_changed = 0;

		for (voice = 0;voice < 6;voice++)
			{
			int freq,volume;


			freq = freqlo[voice] | (freqhi[voice] << 4);
			if (freq) freq = 4000000 / freq;

			volume = vol[voice];
			volume = (volume << 4) | volume;

			ChangeSound(voice,freq,volume>>2);
			}
		}

	Z80_IRQ = Z80_IGNORE_INT;	// Make sure there are no queued interrupts
	return (0xff);				// RST 38h
}


void	MrDoSetPalette (void)
{
int		i,j;
int		bit0,bit1,bit2,bit3;
int		bits1,bits2;

	Palette[0]=0;
	Palette[1]=(Driver.DataCols*4)&255;

	for (i=0;i<Driver.DataCols;i++)
		{
		for (j=0;j<4;j++)
			{
			bit0=(Driver.Palette[4*(i / 8) + j + 32] >> 1) & 0x01;
			bit1=(Driver.Palette[4*(i / 8) + j + 32] >> 0) & 0x01;
			bit2=(Driver.Palette[4*(i % 8) + j] >> 1) & 0x01;
			bit3=(Driver.Palette[4*(i % 8) + j] >> 0) & 0x01;
			Palette[3*(4*i+j)+2]=(0x2c * bit0 + 0x37 * bit1 + 0x43 * bit2 + 0x59 * bit3)>>2;

			bit0=(Driver.Palette[4*(i / 8) + j + 32] >> 3) & 0x01;
			bit1=(Driver.Palette[4*(i / 8) + j + 32] >> 2) & 0x01;
			bit2=(Driver.Palette[4*(i % 8) + j] >> 3) & 0x01;
			bit3=(Driver.Palette[4* (i % 8) + j] >> 2) & 0x01;
			Palette[3*(4*i+j)+3]=(0x2c * bit0 + 0x37 * bit1 + 0x43 * bit2 + 0x59 * bit3)>>2;

			bit0=(Driver.Palette[4*(i / 8) + j + 32] >> 5) & 0x01;
			bit1=(Driver.Palette[4*(i / 8) + j + 32] >> 4) & 0x01;
			bit2=(Driver.Palette[4*(i % 8) + j] >> 5) & 0x01;
			bit3=(Driver.Palette[4*(i % 8) + j] >> 4) & 0x01;
			Palette[3*(4*i+j)+4]=(0x2c * bit0 + 0x37 * bit1 + 0x43 * bit2 + 0x59 * bit3)>>2;
			}
		}

	for (i=0;i<32;i++)
		{
		bits1=(Driver.Palette[i+64]>>0)&3;
		bits2=(Driver.Palette[i+64]>>2)&3;
		ColourTable[i+4*128] = bits1 + (bits2 << 2) + (bits2 << 5);

		bits1=(Driver.Palette[i+64]>>4)&3;
		bits2=(Driver.Palette[i+64]>>6)&3;
		ColourTable[i+4*136] = bits1 + (bits2 << 2) + (bits2 << 5);
		}

	ez_SetPalette(Palette);
}

void	ScrambleScreenUpdate (void)
{
int		Pos,Chr;
int		x,y,z,Col,spritenum,colour;
int		Xc,Yc,dir;
char	Sync[16];

	ez_ClearMem (ScreenBmp,65536);

//	for (y=0;y<16;y++)
//		{
//		for (x=0;x<32;x++)
//			{
//			PrintSprite (x*8,y*8,CharData[y*32+x][0],8,8);
//			}
//		}
//	return;


	for (y=0;y<32;y++)
		{
		for (x=0;x<32;x++)
			{
			Chr=RAM[Driver.ScreenBase+(31-y)*32+x];
			if (Chr!=16)
				{
				Xc=((y*8+RAM[Driver.ScreenBase+0x800+x*2])&255);
				Yc=x<<3;

				//if (Xc<248)
					{
					ForceSpriteClipped (Xc,Yc,CharData[Chr][RAM[Driver.ScreenBase+0x801+x*2]],8,8,ScreenBmp);
					}
				}
			}
		}

	// Now draw up to the maximum of 8 sprite instances
	for (Pos=0;Pos<32;Pos+=4)
		{
		x=RAM[Driver.ScreenBase+0x840+Pos];
		spritenum=RAM[Driver.ScreenBase+0x841+Pos];
		colour=RAM[Driver.ScreenBase+0x842+Pos];
		y=RAM[Driver.ScreenBase+0x843+Pos];
	

		if (spritenum && x && y && x<248)
			{
			PrintSpriteClipped (x,y,SpriteData[spritenum][colour],16,16,ScreenBmp);
			}
		}

	// Now draw the bullets
	for (Pos=0;Pos<32;Pos+=4)
		{
		x=RAM[Driver.ScreenBase+0x861+Pos];
		y=256-RAM[Driver.ScreenBase+0x863+Pos]-8;
		if (y && x)
			{
			ScreenBmp[(y<<8)+x]=7;
			}
		}

//	StarScroll=0;
	DrawStars();
}




void	FirebirdTranslateROM (void)
{
int		offset;
int		x,y,z,no,p;
int		byte1,byte2,tempbyte;
int		c,bit,v,pixel;
char	*BulletData;

	ez_ClearMem((char *)SpriteData,sizeof(SpriteData));
	ez_ClearMem((char *)CharData,sizeof(CharData));
	ez_ClearMem((char *)ScreenBmp,sizeof(ScreenBmp));

	for (z=0;z<Driver.TotalPalettes;z++)
		{
		for (x=0;x<Driver.TotalChars;x++)
			{
			offset=x<<3;
			no=x;
			p=(z*4)%Driver.DataCols;

			for (y = 0; y < 8; y++)
				{
				byte1=TempChars[offset+y];
				byte2=TempChars[offset+y+((Driver.TotalChars>>1)<<4)];

				tempbyte = byte1 & 0x80;
				tempbyte = tempbyte >> 6;
				tempbyte = tempbyte + ((byte2 & 0x80) >> 7);
				if (tempbyte)
    				CharData[no][z][0+(7-y)]=p+tempbyte;

				tempbyte = byte1 & 0x40;
				tempbyte = tempbyte >> 5;
				tempbyte = tempbyte + ((byte2 & 0x40) >> 6);
				if (tempbyte)
    				CharData[no][z][8+(7-y)]=p+tempbyte;

				tempbyte = byte1 & 0x20;
				tempbyte = tempbyte >> 4;
				tempbyte = tempbyte + ((byte2 & 0x20) >> 5);
				if (tempbyte)
    				CharData[no][z][16+(7-y)]=p+tempbyte;

				tempbyte = byte1 & 0x10;
				tempbyte = tempbyte >> 3;
				tempbyte = tempbyte + ((byte2 & 0x10) >> 4);
				if (tempbyte)
    				CharData[no][z][24+(7-y)]=p+tempbyte;

				tempbyte = byte1 & 0x08;
				tempbyte = tempbyte >> 2;
				tempbyte = tempbyte + ((byte2 & 0x8) >> 3);
				if (tempbyte)
    				CharData[no][z][32+(7-y)]=p+tempbyte;

				tempbyte = byte1 & 0x04;
				tempbyte = tempbyte >> 1;
				tempbyte = tempbyte + ((byte2 & 0x4) >> 2);
				if (tempbyte)
    				CharData[no][z][40+(7-y)]=p+tempbyte;

				tempbyte = byte1 & 0x02;
				tempbyte = tempbyte + ((byte2 & 0x2) >> 1);
				if (tempbyte)
    				CharData[no][z][48+(7-y)]=p+tempbyte;

				tempbyte = byte1 & 0x01;
				tempbyte = tempbyte << 1;
				tempbyte = tempbyte + (byte2 & 0x1);
				if (tempbyte)
    				CharData[no][z][56+(7-y)]=p+tempbyte;
              	}
			}
		}

	// Do the bullets differently (They are chars, but store in sprite area so screen redraw can easily get to them)

	BulletData=(char *)SpriteData;

	for (c=0;c<64;c++)
		{
		bit=8;
		for (y=0;y<4;y++)
			{
			for (x=0;x<4;x++)
				{
				pixel=0;
				v=TempChars[(c*4)+x+0x1000];
				if ((v&bit)!=0)
					pixel=1;
				
				BulletData[(c*16)+(y*4)+(x)]=pixel+8;
				}
			bit=bit>>1;	
			}
		}	
}

void	FirebirdScreenUpdate (void)
{
long i;

int		Pos,Chr;
int		x,y,z,Col,spritenum,colour;
int		Xc,Yc,dir;
//char	Sync[16];
char	*BulletData;

	ez_ClearMem (ScreenBmp,65536);
	BulletData=(char *)SpriteData;

	for (i=BankFlag<<7;i<128+(BankFlag<<7);i++)
		{
		if ((RAM[Driver.ScreenBase+512+i]) && (RAM[Driver.ScreenBase+768+i]) )
			{
			if (RAM[Driver.ScreenBase+768+i]==0x20)
				{
			  	PrintSpriteClipped (255-RAM[Driver.ScreenBase+256+i],(255-RAM[Driver.ScreenBase+i]<<8)/260,(char *)&BulletData[(RAM[Driver.ScreenBase+512+i])<<4],4,4,ScreenBmp);
				}
			else
			if (RAM[Driver.ScreenBase+768+i]&0x40)
				{
			  	//PrintSpriteClipped (255-RAM[Driver.ScreenBase+256+i],(255-RAM[Driver.ScreenBase+i]<<8)/260,CharData[255-RAM[Driver.ScreenBase+512+i]][((RAM[Driver.ScreenBase+768+i]&1)^1)+2],8,8,ScreenBmp);
			  	PrintSpriteClipped (255-RAM[Driver.ScreenBase+256+i],(255-RAM[Driver.ScreenBase+i]<<8)/260,CharData[255-RAM[Driver.ScreenBase+512+i]][(7-RAM[Driver.ScreenBase+768+i])&7],8,8,ScreenBmp);
				}
			}
		}

	PrintStars=1;
	DrawStars();
}


int		FirebirdInterrupt (void)
{
short	key;
long 	x,y,pos,i;
unsigned char c;
Z80_Regs r;
	

//	IntCount++;

	Z80_GetRegs( &r );
	if (r.I==1)
		{
		if ((!doRST))
			{
			r.IFF1 = 1;
			Z80_SetRegs( &r );
			doRST = 1;
			return 0xcf;  //RST 8
			}

		else
			{
			doRST = 0;

			// Rst 10
			r.IFF1 = 1;
			Z80_SetRegs( &r );
			return 0xd7;	//0xd7; //RST 10
			}
		}
	else
		return (Z80_IGNORE_INT);
}

void	PhoenixTranslateROM (void)
{
int		x,c,sets,sub,CharPos;
char	*CharSet;

	ez_ClearMem((char *)CharData,sizeof(CharData));
	ez_ClearMem((char *)ScreenBmp,sizeof(ScreenBmp));

	if (Driver.Game==GAME_PHOENIX)
		{
		DecodePhROM (0x0000,0x1000,0);
		DecodePhROM (0x0800,0x1800,1);
		}
	else
		{
		DecodePhROM (0x0800,0x0000,0);
		DecodePhROM (0x1800,0x1000,1);
		}

	CharSet=(char *)CharData;

	// Correct the graphics so that pixels point to those in my palette
	for (sets=0;sets<2;sets++)			// 2 CharSets
		{
		for (sub=0;sub<8;sub++) 		// 8 Subgroups of 32 characters
			{
			for (c=0;c<32;c++)			// 32 characters per Subgroup
				{
				CharPos=c*64+sub*32*64+sets*8*32*64;	// Pointer to relevant characters 8x8 data entry (currently this data is in 0-3 range)
				for (x=0;x<64;x++)		// 64 pixels in a character
					{
					if (CharSet[CharPos])
						CharSet[CharPos]=sub+(CharSet[CharPos]<<3)+(sets<<5);
					CharPos++;
					}
				}
			}
		}
}




void	DecodePhROM (int RomA,int RomB,int Index)
{
FILE	*fp;
int		plane,c,x,y,offs;
unsigned char	bits;
char	*CharSet;

	CharSet=(char *)CharData;

	for (c=0;c<256;c++)
		{
		for (x=0;x<8;x++)
			{
			bits=TempChars[RomA+8*c+x];
			for (y=0;y<8;y++)
				{
				offs=8*8*256*Index+8*8*c+8*(7-y)+(7-x);
				CharSet[offs]<<=1;
				if (bits >= 128) CharSet[offs]++;
				bits <<= 1;
				}
			}
		}

	for (c=0;c<256;c++)
		{
		for (x=0;x<8;x++)
			{
			bits=TempChars[RomB+8*c+x];
			for (y=0;y<8;y++)
				{
				offs=8*8*256*Index+8*8*c+8*(7-y)+(7-x);
				CharSet[offs]<<=1;
				if (bits >= 128) CharSet[offs]++;
				bits <<= 1;
				}
			}
		}

}




int	PhoenixInterrupt (void)
{
	if (DipSwitchSYNC!=1)
		{
		DipSwitchSYNC=1;
		}

	return (0xffff);	// Continue execution
}
	

	
void	PhoenixScreenUpdate (void)
{
int	pos,sx,sy,x,y;
char	c,*RamPtr;
char	*srcPtr,*dstPtr,*CharSet;


	CharSet=(char *)CharData;

	if (PaletteReg!=OldPal)
		{
		// Palette needs changing!
		if (PaletteReg)
			ez_CopyMem (Palette+2,PaletteB,Driver.DataCols*3);
		else
			ez_CopyMem (Palette+2,PaletteA,Driver.DataCols*3);
			
		ez_SetPalette (Palette);
		OldPal=PaletteReg;
		}
		
	RamPtr=&(RAM[Driver.ScreenBase+0x800]);
	for (pos=0;pos<26*32;pos++)
		{
		sx=(31-(pos>>5));
		sy=(pos&31);

		// Draw Char on 'B'

		c=*RamPtr++;
		if (sx>=6 && (c != TempScreenB[pos]))
			{
			srcPtr=CharSet+256*64+(c<<6);		// Point to the data in 8x8 printable form
			sx-=3;
			dstPtr=ScreenBmp1+(256*8*sy)+(sx*8);

			for (y=0;y<8;y++)
				{
				*(long *)dstPtr=*(long *)srcPtr;
				srcPtr+=4;
				dstPtr+=4;
				*(long *)dstPtr=*(long *)srcPtr;
				srcPtr+=4;
				dstPtr+=256-4;
	    		}
			}
		TempScreenB[pos]=c;
		}

	// Copy this nice correct bitmap into a spare one so the other chars can be overprinted, adding in the scroll
	dstPtr=ScreenBmp;
	for (y=0;y<256;y++)
		{
		srcPtr=ScreenBmp1+(((y+ScrollReg)<<8)&65535);
		ez_CopyMem (dstPtr,srcPtr,256);
		dstPtr+=256;
		}

	ez_ClearMem (ScreenBmp,256*8);			// Clear out top line as mentioned in the H/W manual. Quicker like this than a conditional line in the main blit above

	RamPtr=&(RAM[Driver.ScreenBase]);
	for (pos=0;pos<26*32;pos++)
		{
		sx=(31-(pos>>5));
		sy=(pos&31);

		// Draw Char on 'A'

		c=*RamPtr++;
		if (c || TempScreenA[pos])
			{
			srcPtr=CharSet+(c<<6);			// Point to the data in 8x8 printable form
			sx-=3;
			dstPtr=ScreenBmp+(256*8*sy)+(sx*8);

			for (y=0;y<8;y++)
				{
				for (x=0;x<8;x++)
					{
					if (*srcPtr)
						*dstPtr=*srcPtr;
					srcPtr++;
					dstPtr++;
					}
				dstPtr+=256-8;
	    		}
			}
		TempScreenA[pos]=c;
        }

	//Z80_IRQ=Z80_IGNORE_INT;
	DipSwitchSYNC=1;
	OldScroll=ScrollReg;
}
	
void	PhoenixSetPalette (void)
{
int	x,Index;

	Palette[0]=0;
	Palette[1]=Driver.DataCols;
	for (x=0;x<Driver.DataCols*2;x++)
		{
		Index=((x&7)<<2)+((x&24)>>3)+((x&32)<<1)+((x&64)>>1);

		Palette[x*3+2]=Driver.Palette[Driver.ColourTable[Index]*3+0]>>2;
		Palette[x*3+3]=Driver.Palette[Driver.ColourTable[Index]*3+1]>>2;
		Palette[x*3+4]=Driver.Palette[Driver.ColourTable[Index]*3+2]>>2;
		}

	ez_CopyMem (PaletteA,Palette+2,Driver.DataCols*3);
	ez_CopyMem (PaletteB,Palette+2+Driver.DataCols*3,Driver.DataCols*3);
	
	ez_SetPalette(Palette);

}

int		InvadersInterrupt (void)
{
Z80_Regs	Regs;

	IntCount++;

	Z80_IRQ=Z80_IGNORE_INT;

	if (IntCount&1)
		{
		ez_ReadJoysticks (&Joy1,&Joy2);
		AccurateVsync();	 
		return (0xcf);		// RST 08h - 8080 IRQ
		}
	else
		{
		Z80_GetRegs(&Regs);
		Regs.IFF2 = 1;			// EI
		Z80_SetRegs(&Regs);

		return (0xd7);		// RST 10h - 8080 NMI
		}
}

void	InvadersSetPalette (void)
{
	Palette[0]=0;
	Palette[1]=4;

	// 0=Black
	Palette[2]=0;
	Palette[3]=0;
	Palette[4]=0;

	// 1=Red
	Palette[5]=63;
	Palette[6]=0;
	Palette[7]=0;

	// 2=White
	Palette[8]=56;
	Palette[9]=56;
	Palette[10]=56;

	// 3=Green
	Palette[11]=0;
	Palette[12]=56;
	Palette[13]=0;

	ez_SetPalette(Palette);
}
void	GalaxianScreenUpdate (void)
{
int		Pos,Chr;
int		x,y,z,Col,spritenum,colour;
int		Xc,Yc,dir;
char	Sync[16];

	ez_ClearMem (ScreenBmp,65536);

	for (y=0;y<32;y++)
		{
		for (x=0;x<32;x++)
			{
			Chr=RAM[Driver.ScreenBase+(31-y)*32+x];
			if (Driver.Game==GAME_PISCES)
				{
				if (Chr!=64 && Chr!=16)
					{
					Chr+=(BankFlag<<8);
					Xc=((y*8+RAM[Driver.ScreenBase+0x800+x*2])&255);
					Yc=x<<3;

					//if (Xc<248)
						{
						ForceSpriteClipped (Xc,Yc,CharData[Chr][RAM[Driver.ScreenBase+0x801+x*2]],8,8,ScreenBmp);
						}
					}
				}
			else
			if (Driver.Game==GAME_JAPIREM)
				{
				if ((Chr<44 || Chr>47) && Chr!=16)
					{
					Xc=((y*8+RAM[Driver.ScreenBase+0x800+x*2])&255);
					Yc=x<<3;

					//if (Xc<248)
						{
						ForceSpriteClipped (Xc,Yc,CharData[Chr][RAM[Driver.ScreenBase+0x801+x*2]],8,8,ScreenBmp);
						}
					}
				}
			else
				{
				if (( Chr<42 || Chr>45) && Chr!=64 && Chr!=16 )
					{
					Xc=((y*8+RAM[Driver.ScreenBase+0x800+x*2])&255);
					Yc=x<<3;

					//if (Xc<248)
						{
						ForceSpriteClipped (Xc,Yc,CharData[Chr][RAM[Driver.ScreenBase+0x801+x*2]],8,8,ScreenBmp);
						}
					}
				}
			}
		}

	// Now draw up to the maximum of 8 sprite instances
	for (Pos=0;Pos<32;Pos+=4)
		{
		x=RAM[Driver.ScreenBase+0x840+Pos];
		spritenum=RAM[Driver.ScreenBase+0x841+Pos];
		colour=RAM[Driver.ScreenBase+0x842+Pos];
		y=RAM[Driver.ScreenBase+0x843+Pos];
	

		if (Driver.Game==GAME_PISCES || Driver.Game==GAME_JAPIREM)
			{
			if (spritenum && x && y && x<248)
				{
				dir=spritenum>>6;
				spritenum=(spritenum&63)|(64*BankFlag)|(dir<<7);
				PrintSpriteClipped (x,y,SpriteData[spritenum][colour],16,16,ScreenBmp);
				}
			}
		else
			{
			if (spritenum && x && y && x<248)
				{
				PrintSpriteClipped (x,y,SpriteData[spritenum][colour],16,16,ScreenBmp);
				}
			}
		}

	// Now draw the bullets
	for (Pos=0;Pos<32;Pos+=4)
		{
		x=RAM[Driver.ScreenBase+0x861+Pos];
		y=256-RAM[Driver.ScreenBase+0x863+Pos];
		if (x>=16 && y>=16 && x<256-16 && y>=4)
			{
			Col=1;
			if (Pos==28)
				Col=7;
			for (z=0;z<4;z++)
				ScreenBmp[((y-4+z)<<8)+x]=Col;
			}
		}

	DrawStars();
}


void	GalaxianSetPalette (void)
{
int		x;

	Palette[0]=0;
	Palette[1]=Driver.DataCols+Driver.StarCols;

	for (x=0;x<Driver.DataCols;x++)
		{
		// For the characters
		Palette[x*3+2]=Driver.Palette[Driver.ColourTable[x]*3+0];
		Palette[x*3+3]=Driver.Palette[Driver.ColourTable[x]*3+1];
		Palette[x*3+4]=Driver.Palette[Driver.ColourTable[x]*3+2];

		// Same palette for the stars
		Palette[(Driver.DataCols+x)*3+2]=Driver.Palette[Driver.ColourTable[x]*3+0];
		Palette[(Driver.DataCols+x)*3+3]=Driver.Palette[Driver.ColourTable[x]*3+1];
		Palette[(Driver.DataCols+x)*3+4]=Driver.Palette[Driver.ColourTable[x]*3+2];
		}

	ez_SetPalette(Palette);
}


void	CrestaSetPalette (void)
{
char	*PaletteValues,*StarValues;
int		x,bit0,bit1,bit2,bits;

	PaletteValues=Driver.Palette;
	StarValues=Driver.StarPal;

	ez_ClearMem(Palette,770);

	Palette[0]=0;
	Palette[1]=Driver.DataCols+Driver.StarCols;

	// Many thanks to Nicola for this bit :)
	if (PaletteValues)
		{
		for (x=0;x<Driver.DataCols;x++)
			{
			bit0=(PaletteValues[x]>>0)&1;
			bit1=(PaletteValues[x]>>1)&1;
			bit2=(PaletteValues[x]>>2)&1;
			Palette[3*x+2] = ((0x21 * bit0 + 0x47 * bit1 + 0x97 * bit2))>>2;

			bit0=(PaletteValues[x]>>3)&1;
			bit1=(PaletteValues[x]>>4)&1;
			bit2=(PaletteValues[x]>>5)&1;
			Palette[3*x+3] = ((0x21 * bit0 + 0x47 * bit1 + 0x97 * bit2))>>2;

			bit0=0;
			bit1=(PaletteValues[x]>>6)&1;
			bit2=(PaletteValues[x]>>7)&1;
			Palette[3*x+4] = ((0x21 * bit0 + 0x47 * bit1 + 0x97 * bit2))>>2;
			}
		}

	if (StarValues)
		{
		for (x=Driver.DataCols;x<Driver.DataCols+Driver.StarCols;x++)
			{
			bits = ((x-32) >> 0) & 0x03;
			Palette[3*x+2]=StarValues[bits]>>2;
			bits = ((x-32) >> 2) & 0x03;
			Palette[3*x+3]=StarValues[bits]>>2;
			bits = ((x-32) >> 4) & 0x03;
			Palette[3*x+4]=StarValues[bits]>>2;
			}
		}

	ez_SetPalette(Palette);
}




void	CrestaTranslateROM (void)
{
int		offset;
int		x,y,z,no,p;
int		byte1,byte2,tempbyte;

	ez_ClearMem((char *)SpriteData,sizeof(SpriteData));
	ez_ClearMem((char *)CharData,sizeof(CharData));
	ez_ClearMem((char *)ScreenBmp,sizeof(ScreenBmp));

	for (z=0;z<Driver.TotalPalettes;z++)
		{
		for (x=0;x<Driver.TotalChars;x++)
			{
			offset=x<<3;
			no=x;
			p=(z*4);

			for (y = 0; y < 8; y++)
				{
				byte1=TempChars[offset+y];
				byte2=TempChars[offset+y+((Driver.TotalChars>>1)<<4)];

				tempbyte = byte1 & 0x80;
				tempbyte = tempbyte >> 6;
				tempbyte = tempbyte + ((byte2 & 0x80) >> 7);
				if (tempbyte)
    				CharData[no][z][0+(7-y)]=(p+tempbyte)%Driver.DataCols;

				tempbyte = byte1 & 0x40;
				tempbyte = tempbyte >> 5;
				tempbyte = tempbyte + ((byte2 & 0x40) >> 6);
				if (tempbyte)
    				CharData[no][z][8+(7-y)]=(p+tempbyte)%Driver.DataCols;

				tempbyte = byte1 & 0x20;
				tempbyte = tempbyte >> 4;
				tempbyte = tempbyte + ((byte2 & 0x20) >> 5);
				if (tempbyte)
    				CharData[no][z][16+(7-y)]=(p+tempbyte)%Driver.DataCols;

				tempbyte = byte1 & 0x10;
				tempbyte = tempbyte >> 3;
				tempbyte = tempbyte + ((byte2 & 0x10) >> 4);
				if (tempbyte)
    				CharData[no][z][24+(7-y)]=(p+tempbyte)%Driver.DataCols;

				tempbyte = byte1 & 0x08;
				tempbyte = tempbyte >> 2;
				tempbyte = tempbyte + ((byte2 & 0x8) >> 3);
				if (tempbyte)
    				CharData[no][z][32+(7-y)]=(p+tempbyte)%Driver.DataCols;

				tempbyte = byte1 & 0x04;
				tempbyte = tempbyte >> 1;
				tempbyte = tempbyte + ((byte2 & 0x4) >> 2);
				if (tempbyte)
    				CharData[no][z][40+(7-y)]=(p+tempbyte)%Driver.DataCols;

				tempbyte = byte1 & 0x02;
				tempbyte = tempbyte + ((byte2 & 0x2) >> 1);
				if (tempbyte)
    				CharData[no][z][48+(7-y)]=(p+tempbyte)%Driver.DataCols;

				tempbyte = byte1 & 0x01;
				tempbyte = tempbyte << 1;
				tempbyte = tempbyte + (byte2 & 0x1);
				if (tempbyte)
    				CharData[no][z][56+(7-y)]=(p+tempbyte)%Driver.DataCols;
              	}
			}
		}

	for (z=0;z<Driver.TotalPalettes;z++)
		{
		for (x=0;x<Driver.TotalSprites;x++)
			{
			for (y=0;y<4;y++)
				{
				CopyBlock(SpriteData[x+y*Driver.TotalSprites][z],CharData[x*4+2][z],0);
				CopyBlock(SpriteData[x+y*Driver.TotalSprites][z],CharData[x*4+0][z],8);
				CopyBlock(SpriteData[x+y*Driver.TotalSprites][z],CharData[x*4+3][z],128);
				CopyBlock(SpriteData[x+y*Driver.TotalSprites][z],CharData[x*4+1][z],136);
				}
			}
		}

	// Vertical flip the second bank of 128 sprites
	for (z=0;z<Driver.TotalPalettes;z++)
		{
		for (x=Driver.TotalSprites;x<Driver.TotalSprites*2;x++)
			{
			Vflip (SpriteData[x][z]);
			}
		}
	// Horizontal flip the second bank of 128 sprites
	for (z=0;z<Driver.TotalPalettes;z++)
		{
		for (x=Driver.TotalSprites*2;x<Driver.TotalSprites*3;x++)
			{
			Hflip (SpriteData[x][z]);
			}
		}
	// Horizontal and Vertical flip the second bank of 128 sprites
	for (z=0;z<Driver.TotalPalettes;z++)
		{
		for (x=Driver.TotalSprites*3;x<Driver.TotalSprites*4;x++)
			{
			Vflip (SpriteData[x][z]);
			Hflip (SpriteData[x][z]);
			}
		}
}


	
int		CrestaInterrupt (void)
{
	// Return the correct interrupt procedure
	if (RAM[Driver.NMIflagAddr])
		return (Z80_NMI_INT);
	else
		return (Z80_IGNORE_INT);
}



void	CrestaScreenUpdate (void)
{
int		Pos,Chr;
int		x,y,z,Col,spritenum,colour;
int		Xc,Yc,flip;

	ez_ClearMem (ScreenBmp,65536);

	for (y=0;y<32;y++)
		{
		for (x=0;x<32;x++)
			{
			Chr=RAM[Driver.ScreenBase+(31-y)*32+x];
			if ((Chr<36 || Chr>39) && Chr!=47 && Chr!=47 && Chr!=48)
				{
				Xc=((y*8+RAM[Driver.ScreenBase+0x800+x*2])&255);
				Yc=x<<3;

				if (Xc<248 && Xc)
					{
					if (Chr>127)
						Chr=(Chr&127)|((BankFlag)<<2);

					Col=RAM[Driver.ScreenBase+0x801+x*2];
			  		PrintSprite (Xc,Yc,CharData[Chr][Col],8,8,ScreenBmp);
					}
				}
			}
		}

	// Now draw up to the maximum of 8 sprite instances
	for (Pos=0;Pos<32;Pos+=4)
		{
		x=RAM[Driver.ScreenBase+0x840+Pos];
		spritenum=RAM[Driver.ScreenBase+0x841+Pos];
		colour=RAM[Driver.ScreenBase+0x842+Pos];
		y=RAM[Driver.ScreenBase+0x843+Pos];

		flip=spritenum>>6;
		spritenum&=63;
	
		if (BankFlag&BIT6)
			{
			if ((spritenum>31) && (spritenum<48))
				{
				spritenum=(spritenum & 0x1f)|BankFlag;
				}
			}

		spritenum|=(flip<<7);

		if (x && y && spritenum)
			{  
			PrintSpriteClipped (x,y,SpriteData[spritenum][colour],16,16,ScreenBmp);
			}
		}

	// Now draw the bullets
	for (Pos=0;Pos<32;Pos+=4)
		{
		x=RAM[Driver.ScreenBase+0x861+Pos];
		y=256-RAM[Driver.ScreenBase+0x863+Pos];
		if (x>=16 && y>=16 && x<256-16 && y>=4)
			{
			Col=1;
			if (Pos==28)
				Col=7;
			for (z=0;z<4;z++)
				ScreenBmp[((y-4+z)<<8)+x]=Col;
			}
		}

	DrawStars();
}


