/*
  AdViEmulator - AdventureVision emulator
  Copyright (C) 2012-2013  JustBurn

  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef CPUVIEWBOX_H
#define CPUVIEWBOX_H

#include <QWidget>
#include <QVector>
#include <QScrollBar>
#include "adviemulator.h"

class CPUViewBox : public QWidget
{
	Q_OBJECT
public:
	explicit CPUViewBox(QWidget *parent = 0);
	void attachEmu(AdViEmulator *emu, QScrollBar *sb);
	void setTopAddress(int addr);
	void clipAddress(int addr);
	void moveCursor(int addr, bool refresh = false);

protected:
	AdViEmulator *avemu;
	QScrollBar *viewsb;
	void resizeY(int height);
	void paintEvent(QPaintEvent *);
	void resizeEvent(QResizeEvent *);
	void keyPressEvent(QKeyEvent *event);
	void wheelEvent(QWheelEvent *event);
	void mousePressEvent(QMouseEvent *event);
	void mouseDoubleClickEvent(QMouseEvent *event);
	bool scrollProc;
	int numLines;
	int topAddr, topAddrLast;
	int maxAddr;
	int curAddr;
	QVector<int> addressesCache;

signals:
	
public slots:
	void scrollChanged(int value);
};

#endif // CPUVIEWBOX_H
