/*
  AdViEmulator - AdventureVision emulator
  Copyright (C) 2012-2013  JustBurn

  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef TRACEWINDOW_H
#define TRACEWINDOW_H

#include <QMainWindow>
#include <QTimer>
#include "baseviewwindow.h"
#include "adviemulator.h"

namespace Ui {
class TraceWindow;
}

class TraceWindow : public BaseViewWindow
{
	Q_OBJECT
	
public:
	explicit TraceWindow(QWidget *parent, AdViEmulator *emu);
	~TraceWindow();

protected:
	QTimer *refreshTmr;
	int refreshCnt;
	AdViEmulator *avemu;

private slots:
	void refreshWindow(void);
	void emuStateChanged(int);

private:
	Ui::TraceWindow *ui;
};

#endif // TRACEWINDOW_H
