/*
  AdViEmulator - AdventureVision emulator
  Copyright (C) 2012-2013  JustBurn

  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef APUWINDOW_H
#define APUWINDOW_H

#include <QMainWindow>
#include <QTimer>
#include "baseviewwindow.h"
#include "adviemulator.h"

namespace Ui {
class APUWindow;
}

class APUWindow : public BaseViewWindow
{
	Q_OBJECT
	
public:
	explicit APUWindow(QWidget *parent, AdViEmulator *emu);
	~APUWindow();
	void setAPUAddress(int addr);

protected:
	QTimer *refreshTmr;
	int refreshCnt;
	AdViEmulator *avemu;
	int setAddress;

private slots:
	void firstWindow(void);
	void refreshWindow(void);
	void refreshRegisters(void);
	void emuStateChanged(int);
	void hexioChanged(int value);
	void abuttonChanged(bool checked);
	void findPC(void);
	void goToAddress(void);

private:
	Ui::APUWindow *ui;
};

#endif // APUWINDOW_H
