/*
  AdViEmulator - AdventureVision emulator
  Copyright (C) 2012-2013  JustBurn

  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include "baseviewwindow.h"

QList<BaseViewWindow *> BaseViewWindow::viewslist;

BaseViewWindow::BaseViewWindow(QWidget *parent) :
	QMainWindow(parent)
{
	setAttribute(Qt::WA_DeleteOnClose, true);
	viewslist.append(this);
}

BaseViewWindow::~BaseViewWindow()
{
	viewslist.removeAt(viewslist.indexOf(this));
}

void BaseViewWindow::CloseAll()
{
	foreach(BaseViewWindow *item, viewslist) {
		item->close();
	}
}
