/*
  AdViEmulator - AdventureVision emulator
  Copyright (C) 2012-2013  JustBurn

  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef CPU8048_H
#define CPU8048_H

#include <stdint.h>
#include "core8048.h"

class AdViEmulator;

class CPU8048 : public Core8048
{
public:
	CPU8048(AdViEmulator *emu);

	// Callbacks
	virtual uint8_t OnDecodeROM(uint16_t addr);
	virtual uint8_t OnReadROM(uint16_t addr);
	virtual uint8_t OnReadRAM(uint8_t addr);
	virtual void OnWriteRAM(uint8_t addr, uint8_t data);
	virtual uint8_t OnReadEx(uint8_t addr);
	virtual void OnWriteEx(uint8_t addr, uint8_t data);
	virtual uint8_t OnPortRd(uint8_t port);
	virtual void OnPortWr(uint8_t port, uint8_t data);
	virtual void OnException(Exception exception, int value);

private:
	AdViEmulator *avemu;
};

#endif // CPU8048_H
