/*
  AdViEmulator - AdventureVision emulator
  Copyright (C) 2012-2013  JustBurn

  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef HEXIOEDIT_H
#define HEXIOEDIT_H

#include <QLineEdit>
#include <QPainter>
#include <QLayout>
#include <QTextLayout>

class HexIOEdit : public QLineEdit
{
	Q_OBJECT
public:
	explicit HexIOEdit(QWidget *parent = 0);
	void setValue(int value);
	int value();
	void setMinimum(int value);
	int minimum();
	void setMaximum(int value);
	int maximum();
	void setDigits(int value);
	int digits();

protected:
	QString convValue;
	QPoint textEditPos;
	QTextLayout textLayout;
	QTextOption textOption;
	void convertValue(void);
	void updateTextLayout(void);
	void paintEvent(QPaintEvent *);
	void mousePressEvent(QMouseEvent* e);
	void mouseMoveEvent(QMouseEvent* e);
	void keyPressEvent(QKeyEvent *e);
	int _value;
	int _minimum;
	int _maximum;
	int _digits;

signals:
	bool valueChanged(int value);

public slots:

};

#endif // HEXIOEDIT_H
