/*
  AdViEmulator - AdventureVision emulator
  Copyright (C) 2012-2013  JustBurn

  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <QPainter>
#include "displayleds.h"

DisplayLEDs::DisplayLEDs(QWidget *parent) :
	QWidget(parent)
{
	preledoff.setStart(QPointF(0, 0));
	preledoff.setFinalStop(QPointF(0, 1));
	preledoff.setColorAt(0.0, Qt::black);
	preledoff.setColorAt(0.4, QColor::fromRgb(96, 0, 96));
	preledoff.setColorAt(0.6, QColor::fromRgb(96, 0, 96));
	preledoff.setColorAt(1.0, Qt::black);
	preledoff.setCoordinateMode(QGradient::ObjectBoundingMode);
	preledon.setStart(QPointF(0, 0));
	preledon.setFinalStop(QPointF(0, 1));
	preledon.setColorAt(0.0, Qt::black);
	preledon.setColorAt(0.4, QColor::fromRgb(255, 64, 255));
	preledon.setColorAt(0.6, QColor::fromRgb(255, 64, 255));
	preledon.setColorAt(1.0, Qt::black);
	preledon.setCoordinateMode(QGradient::ObjectBoundingMode);
	postledoff.setStart(QPointF(0, 0));
	postledoff.setFinalStop(QPointF(0, 1));
	postledoff.setColorAt(0.0, Qt::black);
	postledoff.setColorAt(0.4, QColor::fromRgb(96, 0, 0));
	postledoff.setColorAt(0.6, QColor::fromRgb(96, 0, 0));
	postledoff.setColorAt(1.0, Qt::black);
	postledoff.setCoordinateMode(QGradient::ObjectBoundingMode);
	postledon.setStart(QPointF(0, 0));
	postledon.setFinalStop(QPointF(0, 1));
	postledon.setColorAt(0.0, Qt::black);
	postledon.setColorAt(0.4, QColor::fromRgb(255, 64, 64));
	postledon.setColorAt(0.6, QColor::fromRgb(255, 64, 64));
	postledon.setColorAt(1.0, Qt::black);
	postledon.setCoordinateMode(QGradient::ObjectBoundingMode);
}

void DisplayLEDs::attachEmu(AdViEmulator *emu)
{
	avemu = emu;
}

void DisplayLEDs::paintEvent(QPaintEvent *)
{
	QPainter painter(this);
	double ledh = (double)height() / 40.0;
	painter.setPen(Qt::transparent);

	for (int y=0; y<40; y++) {
		int ry = 39 - y;
		if (avemu->displayPre[ry >> 3] & (1 << (ry & 7))) {
			painter.setBrush(preledoff);
		} else {
			painter.setBrush(preledon);
		}
		painter.drawRect(0, (double)y * ledh, width()/2, (int)ledh + 1);
		if (avemu->displayPost[ry >> 3] & (1 << (ry & 7))) {
			painter.setBrush(postledoff);
		} else {
			painter.setBrush(postledon);
		}
		painter.drawRect(width()/2, (double)y * ledh, width()/2, (int)ledh + 1);
	}
}
