/*
  AdViEmulator - AdventureVision emulator
  Copyright (C) 2012-2013  JustBurn

  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <QKeyEvent>
#include "keyinputwidget.h"

KeyInputWidget::KeyInputWidget(QWidget *parent) :
	QLineEdit(parent)
{
	AssignedKey = 0;
}

void KeyInputWidget::setAssignedKey(int key)
{
	AssignedKey = key;
	if (AssignedKey == Qt::Key_Space) {
		setText("Space");
	} else if (AssignedKey <= 0xFF) {
		setText(QChar(AssignedKey));
	} else {
		switch (AssignedKey) {
		case Qt::Key_Escape: setText("Escape"); break;
		case Qt::Key_Tab: setText("Tab"); break;
		case Qt::Key_Backtab: setText("Backtab"); break;
		case Qt::Key_Backspace: setText("Backspace"); break;
		case Qt::Key_Return: setText("Return"); break;
		case Qt::Key_Enter: setText("Enter"); break;
		case Qt::Key_Insert: setText("Insert"); break;
		case Qt::Key_Delete: setText("Delete"); break;
		case Qt::Key_Pause: setText("Pause"); break;
		case Qt::Key_Print: setText("Print"); break;
		case Qt::Key_SysReq: setText("SysReq"); break;
		case Qt::Key_Clear: setText("Clear"); break;
		case Qt::Key_Home: setText("Home"); break;
		case Qt::Key_End: setText("End"); break;
		case Qt::Key_Left: setText("Left"); break;
		case Qt::Key_Up: setText("Up"); break;
		case Qt::Key_Right: setText("Right"); break;
		case Qt::Key_Down: setText("Down"); break;
		case Qt::Key_PageUp: setText("Page Up"); break;
		case Qt::Key_PageDown: setText("Page Down"); break;
		case Qt::Key_Shift: setText("Shift"); break;
		case Qt::Key_Control: setText("Control"); break;
		case Qt::Key_Meta: setText("Meta"); break;
		case Qt::Key_Alt: setText("Alt"); break;
		case Qt::Key_AltGr: setText("Alt Gr"); break;
		case Qt::Key_CapsLock: setText("Caps Lock"); break;
		case Qt::Key_NumLock: setText("Num Lock"); break;
		case Qt::Key_ScrollLock: setText("Scroll Lock"); break;
		case Qt::Key_F1: setText("F1"); break;
		case Qt::Key_F2: setText("F2"); break;
		case Qt::Key_F3: setText("F3"); break;
		case Qt::Key_F4: setText("F4"); break;
		case Qt::Key_F5: setText("F5"); break;
		case Qt::Key_F6: setText("F6"); break;
		case Qt::Key_F7: setText("F7"); break;
		case Qt::Key_F8: setText("F8"); break;
		case Qt::Key_F9: setText("F9"); break;
		case Qt::Key_F10: setText("F10"); break;
		case Qt::Key_F11: setText("F11"); break;
		case Qt::Key_F12: setText("F12"); break;
		default: setText("Key " + QString::number(AssignedKey, 16)); break;
		}
	}
	emit newAssignedKey(AssignedKey);
}

int KeyInputWidget::getAssignedKey()
{
	return AssignedKey;
}

void KeyInputWidget::keyPressEvent(QKeyEvent *event)
{
	setAssignedKey(event->key());
	event->accept();
}
