/*
  AdViEmulator - AdventureVision emulator
  Copyright (C) 2012-2013  JustBurn

  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include "memorywindow.h"
#include "ui_memorywindow.h"

MemoryWindow::MemoryWindow(QWidget *parent, AdViEmulator *emu)
	: BaseViewWindow(parent)
	, refreshTmr(new QTimer(this))
	, ui(new Ui::MemoryWindow)
{
	ui->setupUi(this);
	avemu = emu;
	connect(refreshTmr, SIGNAL(timeout()), this, SLOT(refreshWindow()));
	refreshTmr->start(500);
	ui->boxMemoryView->attachEmu(emu, ui->scrollMemoryView);
	ui->boxMemoryView->setTypeMem(AdViEmulator::CPU_IRAM);
}

MemoryWindow::~MemoryWindow()
{
	refreshTmr->stop();
	delete refreshTmr;
	delete ui;
}

void MemoryWindow::refreshWindow(void)
{
	ui->boxMemoryView->update();
}

void MemoryWindow::typeChanged(void)
{
	QRadioButton *obj = (QRadioButton *)sender();
	QVariant typvar = obj->property("Type");
	typeShow = typvar.toInt();
	ui->boxMemoryView->setTypeMem(typeShow);
	ui->boxMemoryView->update();
}

void MemoryWindow::goToAddress(void)
{
	bool okConv;
	int number = ui->lineAddress->text().toInt(&okConv, 16);
	if (okConv) {
		ui->boxMemoryView->moveCursor(number);
	}
}
