/*
  AdViEmulator - AdventureVision emulator
  Copyright (C) 2012-2013  JustBurn

  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef OPTIONSWINDOW_H
#define OPTIONSWINDOW_H

#include <QDialog>
#include "mainwindow.h"
#include "settings.h"

namespace Ui {
class OptionsWindow;
}

class OptionsWindow : public QDialog
{
	Q_OBJECT

public:
	explicit OptionsWindow(QWidget *parent = 0);
	~OptionsWindow();
	void loadSettings(void);
	void saveSettings(void);

protected:
	MainWindow *mainwin;

private slots:
	void clicked(QAbstractButton *button);
	void OnCPUBrowse(void);
	void OnAPUBrowse(void);
	void OnRedChange(int value);
	void OnGreenChange(int value);
	void OnBlueChange(int value);
	void OnAnalogDecayChange(int value);
	void OnVolumeChange(int value);
	void OnAPUFreqChange(int value);

private:
	Ui::OptionsWindow *ui;
};

#endif // OPTIONSWINDOW_H
