/*
  AdViEmulator - AdventureVision emulator
  Copyright (C) 2012-2013  JustBurn

  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef SOUNDOUT_H
#define SOUNDOUT_H

#include <QAudioOutput>

class SoundOut
{
public:
	SoundOut();
	~SoundOut();
	bool enabled;
	quint8 *WBuffer;
	int WBufferSize;
	int GetBuffersFree(void);
	void BufferSend(void);
	void Enable(bool enable);
	void Play(bool enable);
	void SetBufferSize(int numsamples);
	int GetBufferSize();

private:
	bool InitializeQ(void);
	void TerminateQ(void);
	QAudioDeviceInfo audDevice;
	QAudioFormat audFormat;
	QAudioOutput *audOutput;
	QIODevice *audIODev;
	int buffSize;
};

#endif // SOUNDOUT_H
