/*
  AdViEmulator - AdventureVision emulator
  Copyright (C) 2012-2013  JustBurn

  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef ADVIWINDOW_H
#define ADVIWINDOW_H

#include <QMainWindow>
#include <QElapsedTimer>
#include <QLabel>

#include "ui_mainwindow.h"
#include "adviemulator.h"
#include "soundout.h"

class MainWindow: public QMainWindow
{
	Q_OBJECT
public:
	explicit MainWindow(QWidget *parent = 0);
	~MainWindow();
	void ProcessArgs(int argc, char **argv);
	bool OpenROM(QString filename);
	void LoadSettings(void);
	void SaveSettings(void);

protected:
	void SetState(bool enable);
	void TempState(bool temp);
	quint32 emuTotalCycles;
	quint64 emuLastFPSTick;
	quint64 emuLastEmuTick;
	void closeEvent(QCloseEvent *event);
	void moveEvent(QMoveEvent *event);
	void resizeEvent(QResizeEvent *event);
	int keysMatrix;
	void keyPressEvent(QKeyEvent *event);
	void keyReleaseEvent(QKeyEvent *event);
	void addRecentList(QString filename);
	void rebuildRecentList(void);
	void dragEnterEvent(QDragEnterEvent *event);
	void dragMoveEvent(QDragMoveEvent *event);
	void dragLeaveEvent(QDragLeaveEvent *event);
	void dropEvent(QDropEvent *event);

private slots:
	void EmuStarted(void);
	void EmuTick(void);
	void OnMenuFileOpen(void);
	void OnMenuReloadROM(void);
	void OnMenuReloadBIOS(void);
	void OnMenuRecentClear(void);
	void OnMenuRecentRun(void);
	void OnMenuFileQuit(void);
	void OnMenuStartEmu(void);
	void OnMenuStopEmu(void);
	void OnMenuCPUStepEmu(void);
	void OnMenuAPUStepEmu(void);
	void OnMenuResetEmu(void);
	void OnMenuOptions(void);
	void OnMenuEnableBreaks(bool enable);
	void OnMenuClearAllBreaks(void);
	void OnMenuCPUView(void);
	void OnMenuAPUView(void);
	void OnMenuMemoryView(void);
	void OnMenuHardwareView(void);
	void OnMenuTraceView(void);
	void OnMenuResizeDefault(void);
	void OnMenuResizeDefaultDouble(void);
	void OnMenuResizeDefaultHalf(void);
	void OnMenuCloseAllView(void);
	void OnMenuHelpAbout(void);
	void goToCPUAddress(int addr);
	void goToAPUAddress(int addr);

signals:
	void emuStateChanged(int);

private:
	AdViEmulator avemu;
	QString openROM;
	SoundOut sndOut;
	QTimer *emuTickTimer;
	QElapsedTimer *emuElapseTimer;
	double CPUCycles2MS;
	QLabel statusBarIcon;

	Ui::MainWindow *ui;
};

#endif
