/*
  AdViEmulator - AdventureVision emulator
  Copyright (C) 2012-2013  JustBurn

  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <QSettings>
#include "settings.h"

Settings::To Settings::def;
Settings::To Settings::o;

QString Settings::fileName;

void Settings::SetDefault(void)
{
	def.winX = o.winX;
	def.winY = o.winY;
	def.winWidth = o.winWidth;
	def.winHeight = o.winHeight;
	def.WIPwarning = true;
	def.autostart = true;
	def.customcpu_file = "";
	def.customcpu_enable = false;
	def.customapu_file = "";
	def.customapu_enable = false;
	def.colorRed = 255.0f;
	def.colorGreen = 50.0f;
	def.colorBlue = 50.0f;
	def.analogDisplay = true;
	def.analogDecay = 85;
	def.columnMode = false;
	def.pixelBar = true;
	def.soundEnabled = true;
	def.volume = 64;
	def.soundSamples = 8192;
	def.apuFreq = 56410;
	def.keyButton1 = Qt::Key_W;
	def.keyButton2 = Qt::Key_D;
	def.keyButton3 = Qt::Key_S;
	def.keyButton4 = Qt::Key_A;
	def.keyStickDown = Qt::Key_Down;
	def.keyStickUp = Qt::Key_Up;
	def.keyStickRight = Qt::Key_Right;
	def.keyStickLeft = Qt::Key_Left;
	for (int i=0; i<8; i++) def.recentFile[i] = o.recentFile[i];
	o = def;
}

void Settings::LoadSettings(void)
{
	SetDefault();

	//fileName
	QSettings settings(fileName, QSettings::IniFormat);
	settings.beginGroup("mainwin");
	{
		o.winX = settings.value("x", o.winX).toInt();
		o.winY = settings.value("y", o.winY).toInt();
		o.winWidth = settings.value("width", o.winWidth).toInt();
		o.winHeight = settings.value("height", o.winHeight).toInt();
	}
	settings.endGroup();
	settings.beginGroup("wip");
	{
		o.WIPwarning = settings.value("warning", o.WIPwarning).toBool();
	}
	settings.endGroup();
	settings.beginGroup("emulation");
	{
		o.autostart = settings.value("autostart", o.autostart).toBool();
		o.customcpu_file = settings.value("customcpu_file", o.customcpu_file).toString();
		o.customcpu_enable = settings.value("customcpu_enable", o.customcpu_enable).toBool();
		o.customapu_file = settings.value("customapu_file", o.customapu_file).toString();
		o.customapu_enable = settings.value("customapu_enable", o.customapu_enable).toBool();

	}
	settings.endGroup();
	settings.beginGroup("graphics");
	{
		o.colorRed = qBound(0.0f, settings.value("red", o.colorRed).toFloat(), 255.0f);
		o.colorGreen = qBound(0.0f, settings.value("green", o.colorGreen).toFloat(), 255.0f);
		o.colorBlue = qBound(0.0f, settings.value("blue", o.colorBlue).toFloat(), 255.0f);
		o.analogDisplay = settings.value("analogdisplay", o.analogDisplay).toBool();
		o.analogDecay = qBound(2, settings.value("analogdecay", o.analogDecay).toInt(), 128);
		o.columnMode = settings.value("columnmode", o.columnMode).toBool();
		o.pixelBar = settings.value("pixelbar", o.pixelBar).toBool();
	}
	settings.endGroup();
	settings.beginGroup("sound");
	{
		o.soundEnabled = settings.value("enabled", o.soundEnabled).toBool();
		o.volume = qBound(0, settings.value("volume", o.volume).toInt(), 127);
		o.soundSamples = qBound(1024, settings.value("buffsize", o.soundSamples).toInt(), 32768);
		o.apuFreq = qBound(45833, settings.value("apufreq", o.apuFreq).toInt(), 73333);
	}
	settings.endGroup();
	settings.beginGroup("controls");
	{
		o.keyButton1 = settings.value("button1", o.keyButton1).toInt();
		o.keyButton2 = settings.value("button2", o.keyButton2).toInt();
		o.keyButton3 = settings.value("button3", o.keyButton3).toInt();
		o.keyButton4 = settings.value("button4", o.keyButton4).toInt();
		o.keyStickDown = settings.value("stickdown", o.keyStickDown).toInt();
		o.keyStickUp = settings.value("stickup", o.keyStickUp).toInt();
		o.keyStickRight = settings.value("stickright", o.keyStickRight).toInt();
		o.keyStickLeft = settings.value("stickleft", o.keyStickLeft).toInt();
	}
	settings.endGroup();
	settings.beginGroup("recent");
	{
		o.recentFile[0] = settings.value("file1", "").toString();
		o.recentFile[1] = settings.value("file2", "").toString();
		o.recentFile[2] = settings.value("file3", "").toString();
		o.recentFile[3] = settings.value("file4", "").toString();
		o.recentFile[4] = settings.value("file5", "").toString();
		o.recentFile[5] = settings.value("file6", "").toString();
		o.recentFile[6] = settings.value("file7", "").toString();
		o.recentFile[7] = settings.value("file8", "").toString();
	}
	settings.endGroup();
}

void Settings::SaveSettings(void)
{
	QSettings settings(fileName, QSettings::IniFormat);
	settings.beginGroup("mainwin");
	{
		settings.setValue("x", o.winX);
		settings.setValue("y", o.winY);
		settings.setValue("width", o.winWidth);
		settings.setValue("height", o.winHeight);
	}
	settings.endGroup();
	settings.beginGroup("wip");
	{
		settings.setValue("warning", o.WIPwarning);
	}
	settings.endGroup();
	settings.beginGroup("emulation");
	{
		settings.setValue("autostart", o.autostart);
		settings.setValue("customcpu_file", o.customcpu_file);
		settings.setValue("customcpu_enable", o.customcpu_enable);
		settings.setValue("customapu_file", o.customapu_file);
		settings.setValue("customapu_enable", o.customapu_enable);
	}
	settings.endGroup();
	settings.beginGroup("graphics");
	{
		settings.setValue("red", (int)o.colorRed);
		settings.setValue("green", (int)o.colorGreen);
		settings.setValue("blue", (int)o.colorBlue);
		settings.setValue("analogdisplay", o.analogDisplay);
		settings.setValue("analogdecay", o.analogDecay);
		settings.setValue("columnmode", o.columnMode);
		settings.setValue("pixelbar", o.pixelBar);
	}
	settings.endGroup();
	settings.beginGroup("sound");
	{
		settings.setValue("enabled", o.soundEnabled);
		settings.setValue("volume", o.volume);
		settings.setValue("buffsize", o.soundSamples);
		settings.setValue("apufreq", o.apuFreq);
		settings.remove("buffer");
		settings.remove("blocks");
	}
	settings.endGroup();
	settings.beginGroup("controls");
	{
		settings.setValue("button1", o.keyButton1);
		settings.setValue("button2", o.keyButton2);
		settings.setValue("button3", o.keyButton3);
		settings.setValue("button4", o.keyButton4);
		settings.setValue("stickdown", o.keyStickDown);
		settings.setValue("stickup", o.keyStickUp);
		settings.setValue("stickright", o.keyStickRight);
		settings.setValue("stickleft", o.keyStickLeft);
	}
	settings.endGroup();
	settings.beginGroup("recent");
	{
		settings.setValue("file1", o.recentFile[0]);
		settings.setValue("file2", o.recentFile[1]);
		settings.setValue("file3", o.recentFile[2]);
		settings.setValue("file4", o.recentFile[3]);
		settings.setValue("file5", o.recentFile[4]);
		settings.setValue("file6", o.recentFile[5]);
		settings.setValue("file7", o.recentFile[6]);
		settings.setValue("file8", o.recentFile[7]);
	}
}
