/*
  AdViEmulator - AdventureVision emulator
  Copyright (C) 2012-2013  JustBurn

  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include "tracewindow.h"
#include "ui_tracewindow.h"

TraceWindow::TraceWindow(QWidget *parent, AdViEmulator *emu)
	: BaseViewWindow(parent)
	, refreshTmr(new QTimer(this))
	, ui(new Ui::TraceWindow)
{
	ui->setupUi(this);
	avemu = emu;
	connect(refreshTmr, SIGNAL(timeout()), this, SLOT(refreshWindow()));
	connect(parent, SIGNAL(emuStateChanged(int)), this, SLOT(emuStateChanged(int)));
	connect(ui->boxCPUView, SIGNAL(goToCPUAddress(int)), parent, SLOT(goToCPUAddress(int)));
	connect(ui->boxAPUView, SIGNAL(goToAPUAddress(int)), parent, SLOT(goToAPUAddress(int)));
	refreshTmr->start(500);
	ui->boxCPUView->attachEmu(emu, ui->scrollCPUView);
	ui->boxAPUView->attachEmu(emu, ui->scrollAPUView);
}

TraceWindow::~TraceWindow()
{
	refreshTmr->stop();
	delete refreshTmr;
	delete ui;
}

void TraceWindow::refreshWindow(void)
{
	ui->boxCPUView->update();
	ui->boxAPUView->update();
}

void TraceWindow::emuStateChanged(int)
{
	refreshWindow();
}
