#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <conio.h>
#include <allegro.h>
#include "Z80.h"

void main(int argc, char *argv[]);
byte LoadRoms(byte bWhichGame);
byte LoadRom(char *pszFilename, word wOffset, word wLength);
void Nmi(void);
void Error(char *pszText);

byte bGame;
reg z80reg;
byte *pbROM;
byte *pbRAM;
byte bShiftValue = 0;
byte bBitmap = 0;
byte bBitmapPrevious = 0;
DATAFILE *audio;

void Nmi()
{
	IFlag=1;
}
END_OF_FUNCTION(Nmi);

void main(int argc, char *argv[])
{
	clrscr();
	printf("Space Invader Emulator Version 1.00 (20-FEB-1997)\n");
	printf("Written by Michael Strutt (mstrutt@pixie.co.za)\n\n");
	printf("PLEASE DO NOT DISTRIBUTE THE SOURCE FILES OR THE EXECUTABLE WITH ROM IMAGES.\n"
		   "DOING SO WILL HARM FURTHER EMULATOR DEVELOPMENT AND WILL CONSIDERABLY ANNOY\n"
		   "THE RIGHTFUL COPYRIGHT HOLDERS OF THOSE ROM IMAGES AND CAN RESULT IN LEGAL\n"
		   "ACTION UNDERTAKEN BY EARLIER MENTIONED COPYRIGHT HOLDERS.\n\n");
	printf("Controls are: 1 - Player 1 Start\n"
		   "              2 - Player 2 Start\n"
		   "              3 - Insert Coin\n"
		   "              T - Activate Tilt Switch\n"
		   "              P - Activate Preset Mode (Deluxe Only)\n"
		   "     LEFT ARROW - Move Base Left\n"
		   "    RIGHT ARROW - Move Base Right\n"
		   "        CONTROL - Fire\n"
		   "            ESC - Exit Emulator\n\n");
	printf("Press ENTER to continue\n");

	if(!getch()) getch();

	bGame=0;
	if(argc>1) bGame=atoi(argv[1]);
	if(bGame>6) bGame=0;

	allegro_init();
	install_keyboard();
	install_sound(DIGI_AUTODETECT,MIDI_NONE,0);
	install_timer();

	pbRAM=(byte *)malloc(0x2000);
	if(!pbRAM) Error("could not allocate memory for RAM");

	if(!LoadRoms(bGame)) Error("could not load ROM images");

	audio=load_datafile("audio.dat");
	if(!audio) Error("could not load audio data");

	LOCK_VARIABLE(IFlag);
	LOCK_FUNCTION(Nmi);
	install_int(Nmi,8);

	set_gfx_mode(GFX_MODEX,256,256,0,0);

	ResetZ80(&z80reg);
	Z80(z80reg);

	free(pbRAM);
	free(pbROM);
}

byte LoadRoms(byte bWhichGame)
{
	pbROM=(byte *)malloc(0x5000);
	if(!pbROM) return(0);

	switch(bWhichGame) {
		case 0:	// space invaders
			if(!LoadRom("invaders.h",0x0000,0x0800)) return(0);
			if(!LoadRom("invaders.g",0x0800,0x0800)) return(0);
			if(!LoadRom("invaders.f",0x1000,0x0800)) return(0);
			if(!LoadRom("invaders.e",0x1800,0x0800)) return(0);
			return(1);
		case 1:	// space invaders deluxe
			if(!LoadRom("invdelux.h",0x0000,0x0800)) return(0);
			if(!LoadRom("invdelux.g",0x0800,0x0800)) return(0);
			if(!LoadRom("invdelux.f",0x1000,0x0800)) return(0);
			if(!LoadRom("invdelux.e",0x1800,0x0800)) return(0);
			if(!LoadRom("invdelux.d",0x4000,0x0800)) return(0);
			return(1);
		case 2:	// galaxy wars
			if(!LoadRom("galxwars.0",0x0000,0x0400)) return(0);
			if(!LoadRom("galxwars.1",0x0400,0x0400)) return(0);
			if(!LoadRom("galxwars.2",0x0800,0x0400)) return(0);
			if(!LoadRom("galxwars.3",0x0c00,0x0400)) return(0);
			if(!LoadRom("galxwars.4",0x4000,0x0400)) return(0);
			if(!LoadRom("galxwars.5",0x4400,0x0400)) return(0);
			return(1);
		case 3:	// lunar rescue
			if(!LoadRom("lrescue.1",0x0000,0x0800)) return(0);
			if(!LoadRom("lrescue.2",0x0800,0x0800)) return(0);
			if(!LoadRom("lrescue.3",0x1000,0x0800)) return(0);
			if(!LoadRom("lrescue.4",0x1800,0x0800)) return(0);
			if(!LoadRom("lrescue.5",0x4000,0x0800)) return(0);
			if(!LoadRom("lrescue.6",0x4800,0x0800)) return(0);
			return(1);
		case 4:	// earth invasion
			if(!LoadRom("earthinv.h",0x0000,0x0800)) return(0);
			if(!LoadRom("earthinv.g",0x0800,0x0800)) return(0);
			if(!LoadRom("earthinv.f",0x1000,0x0800)) return(0);
			if(!LoadRom("earthinv.e",0x1800,0x0800)) return(0);
			return(1);
		case 5:	// space attack 2
			if(!LoadRom("spaceatt.h",0x0000,0x0800)) return(0);
			if(!LoadRom("spaceatt.g",0x0800,0x0800)) return(0);
			if(!LoadRom("spaceatt.f",0x1000,0x0800)) return(0);
			if(!LoadRom("spaceatt.e",0x1800,0x0800)) return(0);
			return(1);
		case 6:	// invaders revenge
			if(!LoadRom("invrvnge.h",0x0000,0x0800)) return(0);
			if(!LoadRom("invrvnge.g",0x0800,0x0800)) return(0);
			if(!LoadRom("invrvnge.f",0x1000,0x0800)) return(0);
			if(!LoadRom("invrvnge.e",0x1800,0x0800)) return(0);
			return(1);
	}
	return(0);
}

byte LoadRom(char *pszFilename, word wOffset, word wLength)
{
	FILE *fp;

	fp=fopen(pszFilename,"rb");
	if(!fp) return(0);

	fread(pbROM+wOffset,wLength,1,fp);

	fclose(fp);
	return(1);
}

void Error(char *pszText)
{
	printf("error: %s\n",pszText);
	exit(1);
}

void M_WRMEM(word A,byte V)
{
	int b, c, x, y;

	if(A<0x2000 || A>0x3fff) return;	// invalid memory address (W)
	pbRAM[A-0x2000]=V;					// valid work or video RAM
	if(A>0x23ff) {						// video RAM
		x=(A-0x2400)>>5;
		y=(A-0x2400)&0x1f;
		c=15;
		if(y<8) c=2;
		if(y>23 && y<28) c=4;
		for(b=0;b<8;b++) {
			if(V&0x01) putpixel(screen,x,256-((y<<3)+b),c); else putpixel(screen,x,256-((y<<3)+b),0);
			V=V>>1;
		}
	}
}

byte M_RDMEM(word A)
{
	if(A>0x4fff) return(0);						// invalid memory address (R)
	if(A<0x2000 || A>0x3fff) return(pbROM[A]);	// reading ROM
	return(pbRAM[A-0x2000]);					// reading RAM
}

byte DoIn(byte Port)
{
	word wValue;
	byte bValue;

	switch(Port) {
		case 1:
			bValue=0x81;
			if(key[KEY_ESC]) CPURunning=0;
			if(key[KEY_1]) bValue|=0x04;
			if(key[KEY_2]) bValue|=0x02;
			if(key[KEY_3]) bValue&=~0x01;
			if(key[KEY_LEFT]) bValue|=0x20;
			if(key[KEY_RIGHT]) bValue|=0x40;
			if(key[KEY_CONTROL]) bValue|=0x10;
			return(bValue);
		case 2:
			bValue=0;
			if(key[KEY_T]) bValue=0x04;
			if(key[KEY_P]) bValue=0x08;
			if(bGame!=1) {
				if(key[KEY_LEFT]) bValue|=0x20;
				if(key[KEY_RIGHT]) bValue|=0x40;
				if(key[KEY_CONTROL]) bValue|=0x10;
			}
			return(bValue);
		case 3:
			wValue=(bBitmap<<8)|bBitmapPrevious;
			wValue=wValue<<bShiftValue;
			bValue=(byte)(wValue>>8);
			return(bValue);
		default:
			return(0x00);
	}
}

void DoOut(byte Port,byte Value)
{
	static byte bSound1 = 0;
	static byte bSound2 = 0;

	switch(Port) {
		case 2:
			bShiftValue=Value;
			break;
		case 3:
			if(Value&0x01 && ~bSound1&0x01) play_sample(audio[0].dat,128,128,1000,1);
			if(~Value&0x01 && bSound1&0x01) stop_sample(audio[0].dat);
			if(Value&0x02 && ~bSound1&0x02) play_sample(audio[1].dat,100,128,1000,0);
			if(~Value&0x02 && bSound1&0x02) stop_sample(audio[1].dat);
			if(Value&0x04 && ~bSound1&0x04) play_sample(audio[2].dat,128,128,1000,0);
			if(~Value&0x04 && bSound1&0x04) stop_sample(audio[2].dat);
			if(Value&0x08 && ~bSound1&0x08) play_sample(audio[3].dat,100,128,1000,0);
			if(~Value&0x08 && bSound1&0x08) stop_sample(audio[3].dat);
			bSound1=Value;
			break;
		case 4:
			bBitmapPrevious=bBitmap;
			bBitmap=Value;
			break;
		case 5:
			if(Value&0x01 && ~bSound2&0x01) play_sample(audio[4].dat,255,128,1000,0);
			if(Value&0x02 && ~bSound2&0x02) play_sample(audio[5].dat,255,128,1000,0);
			if(Value&0x04 && ~bSound2&0x04) play_sample(audio[6].dat,255,128,1000,0);
			if(Value&0x08 && ~bSound2&0x08) play_sample(audio[7].dat,255,128,1000,0);
			if(Value&0x10 && ~bSound2&0x10) play_sample(audio[8].dat,128,128,1000,0);
			if(~Value&0x10 && bSound2&0x10) stop_sample(audio[8].dat);
			bSound2=Value;
			break;
	}
}

void Patch(reg *R)
{
}

word Interrupt()
{
	static byte bNMI = 0;

	if(bNMI++&0x01) return(0x0010);
	return(0x0008);
}
