#version 150

////////////////////////////////////////////////////////
//	GTU version 0.50	
//	Author: aliaspider - aliaspider@gmail.com
//	License: GPLv3      
////////////////////////////////////////////////////////

#define RGB_to_YIQ 	mat3x3( 0.299 , 0.595716 , 0.211456 ,	0.587    , -0.274453 , -0.522591 ,		0.114    , -0.321263 , 0.311135 )


uniform sampler2D	source[];
uniform vec4		sourceSize[];

in Vertex {
	vec2 texCoord;
};
out vec4 fragColor;

#define TO_INT2(X) int(floor(((X)*3.0)+0.5))
#define TO_INT3(X) int(floor(((X)*7.0)+0.5))
#define TO_INT4(X) int(floor(((X)*15.0)+0.5))
bool wave (int p, int color) { 
  return ((color + p + 8) % 12 < 6); 
}

vec3 generate_color(int emphasis, int luma, int chroma) {
  
  float saturation=2.0;
  float hue=0.0;
  float contrast=1.0;
  float brightness=1.0;
  float gamma=1.8;
  
  int color = chroma;
  int level = (color < 0xE)? luma : 1;

  float black = 0.518, white = 1.962, attenuation = 0.746;
  float levels[8] = float [](
    0.350, 0.518, 0.962, 1.550,
    1.094, 1.506, 1.962, 1.962
  );

  float lo_and_hi[2] = float[](
    levels[level + 4 * int(color == 0x0)],
    levels[level + 4 * int(color <  0xd)]
  );

  float y = 0.0, i = 0.0, q = 0.0;
  
  int p;
  for(p = 0; p < 12; p++) {
    float spot = lo_and_hi[int(wave(p, color))];

    if((bool(emphasis & 0x1) && wave(p, 12))
    || (bool(emphasis & 0x2) && wave(p,  4))
    || (bool(emphasis & 0x4) && wave(p,  8))
    ) spot *= attenuation;

    float v = (spot - black) / (white - black);

    v = (v - 0.5) * contrast + 0.5;
    v *= brightness / 12.0;

    y += v;
    i += v * cos((3.141592653 / 6.0) * (p + hue));
    q += v * sin((3.141592653 / 6.0) * (p + hue));
  }

  i *= saturation;
  q *= saturation;

  return vec3(y,i,q);
}
void main() {
	vec4 c=texture2D(source[0], texCoord.xy);
	int emphasis = TO_INT3(c.x);
	int luma     = TO_INT2(c.y);
	int chroma   = TO_INT4(c.z);
	
	c.xyz=generate_color(emphasis,luma,chroma);		
	
	fragColor = vec4(c.xyz, 1.0);	
}
