#version 150

////////////////////////////////////////////////////////
//	GTU-Famicom version 0.50	
//	Author: aliaspider - aliaspider@gmail.com
//	License: GPLv3      
////////////////////////////////////////////////////////


#in signalResolutionY
#in signalResolutionI
#in signalResolutionQ


#define YIQ_to_RGB 	mat3x3( 1.0   , 1.0      , 1.0      ,	0.9563   , -0.2721   , -1.1070   ,		0.6210   , -0.6474   , 1.7046   )


#define pi			3.14159265358
float STU0 (float x, float b){	
	x = x*b*pi;
	return clamp((x+sin(x))/(2.0*pi)+0.5,0.0,1.0);
}
float STU(float x, float b){
	return STU0(x+0.5,b)-STU0(x-0.5,b);
}



uniform sampler2D	source[];
uniform vec4		sourceSize[];

in Vertex {
	vec2 texCoord;
};
out vec4 fragColor;

void main() {
	float	offset	= fract((texCoord.x * sourceSize[0].x) - 0.5);
	vec3	tempColor = vec3(0.0);	
	
	
	float range=ceil(0.5+sourceSize[0].x/min(min(signalResolutionY,signalResolutionI),signalResolutionQ));
	range = min ( range, 255.0);
	float X,i;
	vec3 	c;
	for (i=1.0-range;i<1.0+range;i++){
		X=(offset-(i));
		c=texture(source[0], vec2(texCoord.x - X*sourceSize[0].z,texCoord.y)).xyz;
		tempColor+=vec3((c.x*STU(X,(signalResolutionY*sourceSize[0].z))),(c.y*STU(X,(signalResolutionI*sourceSize[0].z))),(c.z*STU(X,(signalResolutionQ*sourceSize[0].z))));
	}	

	
	
	tempColor=clamp(YIQ_to_RGB*tempColor,0.0,1.0);
	fragColor = vec4(tempColor,1.0);
}
