/* COMPATIBILITY 
   - HLSL compilers
   - Cg   compilers
*/


/*

   Hyllian's xBR MultiLevel4 Shader 
   
   Copyright (C) 2011/2013 Hyllian/Jararaca - sergiogdb@gmail.com

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either version 2
   of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

#version 150

in vec4 position;
in vec2 texCoord;
 
out Vertex {
   vec2 texCoord;
   vec4 t1;
   vec4 t2;
   vec4 t3;
   vec4 t4;
   vec4 t5;
   vec4 t6;
   vec4 t7;
   vec4 t8;
   vec4 t9;
} vertexOut;
 
uniform vec4 targetSize;
uniform vec4 sourceSize[];


void main(void)
{
	gl_Position=position;	

	
	float dx = sourceSize[0].z;
	float dy = sourceSize[0].w;

	//      A3 B3 C3
	//      A1 B1 C1
	//A2 A0  A  B  C C4 C6
	//D2 D0  D  E  F F4 F6
	//G2 G0  G  H  I I4 I6
	//      G5 H5 I5
	//      G7 H7 I7

	vertexOut.texCoord = texCoord;
	vertexOut.t1 = texCoord.xxyy + vec4(-2.0*dx, 2.0*dx,     -dy,      dy); // A0 C4 G0 I4
	vertexOut.t2 = texCoord.xxyy + vec4(    -dx,     dx, -2.0*dy,  2.0*dy); // A1 C1 G5 I5
	vertexOut.t3 = texCoord.xxyy + vec4(-3.0*dx, 3.0*dx,     -dy,      dy); // A2 C6 G2 I6
	vertexOut.t4 = texCoord.xxyy + vec4(    -dx,     dx, -3.0*dy,  3.0*dy); // A3 C3 G7 I7
	vertexOut.t5 = texCoord.xxyy + vec4(    -dx,     dx,     -dy,      dy); // A  C  G  I
	vertexOut.t6 = texCoord.xyyy + vec4(      0,    -dy, -2.0*dy, -3.0*dy); // B  B1 B3
	vertexOut.t7 = texCoord.xxxy + vec4(-3.0*dx,-2.0*dx,     -dx,       0); // D  D0 D2
	vertexOut.t8 = texCoord.xyyy + vec4(      0,     dy,  2.0*dy,  3.0*dy); // H  H5 H7
	vertexOut.t9 = texCoord.xxxy + vec4( 3.0*dx, 2.0*dx,      dx,       0); // F  F4 F6
}

