/* COMPATIBILITY 
   - HLSL compilers
   - Cg   compilers
*/


/*

   Hyllian's xBR MultiLevel4 Shader - Pass2
   
   Copyright (C) 2011/2013 Hyllian/Jararaca - sergiogdb@gmail.com

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either version 2
   of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/
#version 150
#define round(X) floor((X)+0.5)
#define cf2				2.0
#define cf3				4.0
#define cf4 			4.0
#define eq_threshold	vec4(15.0, 15.0, 15.0, 15.0)
#define eq_threshold2	vec4( 5.0,  5.0,  5.0,  5.0)
#define eq_threshold3	vec4(25.0, 25.0, 25.0, 25.0)
#define y_weight		48.0
#define u_weight		7.0
#define v_weight		6.0
#define yuv				(mat3x3(0.299, 0.587, 0.114, -0.169, -0.331, 0.499, 0.499, -0.418, -0.0813))
#define yuv_weighted	(mat3x3(y_weight*yuv[0], u_weight*yuv[1], v_weight*yuv[2]))
#define maximo			vec4(255.0, 255.0, 255.0, 255.0)


uniform sampler2D source[4];
uniform vec4 sourceSize[4];
uniform vec4 targetSize;
uniform int sourceLength;
in Vertex {
   vec2 texCoord;
   vec4 t1;
   vec4 t2;
   vec4 t3;
   vec4 t4;
   vec4 t5;
   vec4 t6;
   vec4 t7;
   vec4 t8;
   vec4 t9;
};

out vec4 fragColor;

vec4 df(vec4 A, vec4 B)
{
	return vec4(abs(A-B));
}

bvec4 rd(vec4 A, vec4 B, vec4 C, vec4 D)
{
    return greaterThan((df(C,D)/(df(A,B)+0.000000001)) , vec4(2.0));
}

bvec4 id(vec4 A, vec4 B, vec4 C, vec4 D)
{
    return greaterThan(df(C,D) , df(A,B));
}


vec4 remapTo01(vec4 v, vec4 high)
{
	return (v/high);
}

vec4 remapFrom01(vec4 v, vec4 high)
{
	return round(high*v);
}


bvec4 eq(vec4 A, vec4 B)
{
	return lessThan(df(A, B) , eq_threshold);
}

bvec4 eq2(vec4 A, vec4 B)
{
	return lessThan(df(A, B) , eq_threshold2);
}

bvec4 eq3(vec4 A, vec4 B)
{
	return lessThan(df(A, B) , eq_threshold3);
}

vec4 weighted_distance(vec4 a, vec4 b, vec4 c, vec4 d, vec4 e, vec4 f, vec4 g, vec4 h)
{
	return (df(a,b) + df(a,c) + df(d,e) + df(d,f) + 4.0*df(g,h));
}



void main(void){
	vec4 PA  = texture(source[0], t2.xw);
	vec4 PB  = texture(source[0], t2.yw);
	vec4 PC  = texture(source[0], t2.zw);

	vec4 PD  = texture(source[0], t3.xw);
	vec4 PE  = texture(source[0], t3.yw);
	vec4 PF  = texture(source[0], t3.zw);

	vec4 PG  = texture(source[0], t4.xw);
	vec4 PH  = texture(source[0], t4.yw);
	vec4 PI  = texture(source[0], t4.zw);

	vec3 A1 = texture(source[sourceLength-1], t1.xw).rgb;
	vec3 B1 = texture(source[sourceLength-1], t1.yw).rgb;
	vec3 C1 = texture(source[sourceLength-1], t1.zw).rgb;

	vec3 A  = texture(source[sourceLength-1], t2.xw).rgb;
	vec3 B  = texture(source[sourceLength-1], t2.yw).rgb;
	vec3 C  = texture(source[sourceLength-1], t2.zw).rgb;

	vec3 D  = texture(source[sourceLength-1], t3.xw).rgb;
	vec3 E  = texture(source[sourceLength-1], t3.yw).rgb;
	vec3 F  = texture(source[sourceLength-1], t3.zw).rgb;

	vec3 G  = texture(source[sourceLength-1], t4.xw).rgb;
	vec3 H  = texture(source[sourceLength-1], t4.yw).rgb;
	vec3 I  = texture(source[sourceLength-1], t4.zw).rgb;

	vec3 G5 = texture(source[sourceLength-1], t5.xw).rgb;
	vec3 H5 = texture(source[sourceLength-1], t5.yw).rgb;
	vec3 I5 = texture(source[sourceLength-1], t5.zw).rgb;

	vec3 A0 = texture(source[sourceLength-1], t6.xy).rgb;
	vec3 D0 = texture(source[sourceLength-1], t6.xz).rgb;
	vec3 G0 = texture(source[sourceLength-1], t6.xw).rgb;

	vec3 C4 = texture(source[sourceLength-1], t7.xy).rgb;
	vec3 F4 = texture(source[sourceLength-1], t7.xz).rgb;
	vec3 I4 = texture(source[sourceLength-1], t7.xw).rgb;

	vec4 b = (transpose(mat4x3(B, D, H, F))* yuv_weighted[0] );
	vec4 c = (transpose( mat4x3(C, A, G, I))* yuv_weighted[0] );
	vec4 e = (transpose( mat4x3(E, E, E, E))* yuv_weighted[0] );
	vec4 d = b.yzwx;
	vec4 f = b.wxyz;
	vec4 g = c.zwxy;
	vec4 h = b.zwxy;
	vec4 i = c.wxyz;

	vec4 i4 = (transpose(mat4x3(I4, C1, A0, G5))* yuv_weighted[0] );
	vec4 i5 = (transpose(mat4x3(I5, C4, A1, G0))* yuv_weighted[0] );
	vec4 h5 = (transpose(mat4x3(H5, F4, B1, D0))* yuv_weighted[0] );
	vec4 f4 = h5.yzwx;


	vec4 pe = remapFrom01(PE, maximo);
	vec4 pf = remapFrom01(PF, maximo);
	vec4 ph = remapFrom01(PH, maximo);
	vec4 pb = remapFrom01(PB, maximo);
	vec4 pd = remapFrom01(PD, maximo);

	vec4 f2 = vec4(pf.z, pb.w, pd.x, ph.y);
	vec4 h2 = vec4(ph.z, pf.w, pb.x, pd.y);
	vec4 f1 = vec4(pf.y, pb.z, pd.w, ph.x);
	vec4 h3 = vec4(ph.w, pf.x, pb.y, pd.z);

	bvec4 nbrs = (greaterThan(pe.yzwx 	, vec4(1.0)) 	|| greaterThan(pe.wxyz 	, vec4(1.0)));
	bvec4 jag1 = (greaterThan(f2 		, vec4(1.0)) 	|| greaterThan(h2 		, vec4(1.0)));
	bvec4 jag2 = (greaterThan(f2 		, vec4(2.0)) 	|| greaterThan(h2 		, vec4(2.0)));
	bvec4 jag3 = (greaterThan(f2 		, vec4(4.0)) 	|| greaterThan(h2 		, vec4(4.0)));

	bvec4 cond1=(equal(pe,vec4(7.0)) || equal(pe,vec4(8.0)));
	
	pe.x=cond1.x?jag3.x?pe.x: (pe.x-2.0) : pe.x;
	pe.y=cond1.y?jag3.y?pe.y: (pe.y-2.0) : pe.y;
	pe.z=cond1.z?jag3.z?pe.z: (pe.z-2.0) : pe.z;
	pe.w=cond1.w?jag3.w?pe.w: (pe.w-2.0) : pe.w;
	
	bvec4 cond2=(equal(pe,vec4(5.0)) || equal(pe,vec4(6.0)));
	pe.x=cond2.x?jag2.x?pe.x: (pe.x-2.0) : pe.x;
	pe.y=cond2.y?jag2.y?pe.y: (pe.y-2.0) : pe.y;
	pe.z=cond2.z?jag2.z?pe.z: (pe.z-2.0) : pe.z;
	pe.w=cond2.w?jag2.w?pe.w: (pe.w-2.0) : pe.w;
	
	
	bvec4 jag91 = ((id(h,i,e,h) || id(i4,i,f4,i4)) && greaterThan(f2 ,vec4(1.0)) && greaterThan(f1 ,vec4(1.0)));
	bvec4 jag92 = ((id(f,i,e,f) || id(i5,i,h5,i5)) && greaterThan(h2 ,vec4(1.0)) && greaterThan(h3 ,vec4(1.0)));
	bvec4 jag93 = ( rd(h,g,e,g));
	bvec4 jag94 = ( rd(f,c,e,c));
	bvec4 jag9  = (not(jag91 && jag93 || jag92 && jag94));
	
	bvec4 cond3=(equal(pe ,vec4(0.0)) || (not(nbrs) || jag1) && jag9);
	
	pe.x=cond3.x?pe.x:1.0;
	pe.y=cond3.y?pe.y:1.0;
	pe.z=cond3.z?pe.z:1.0;
	pe.w=cond3.w?pe.w:1.0;
	

	fragColor=vec4(remapTo01(pe, maximo));

}