#version 150

////////////////////////////////////////////////////////
//	GPU-plot	
//	Author: aliaspider - aliaspider@gmail.com
//	License: GPLv3      
////////////////////////////////////////////////////////

#define GREEN_L	vec3(0.8,0.8,0.0)
#define RED		vec3(0.8,0.0,0.0)
#define GREEN	vec3(0.0,0.8,0.0)
#define BLUE	vec3(0.0,0.0,0.8)
#define WHITE	vec3(0.8,0.8,0.8)
#define GRAY	vec3(0.4,0.4,0.4)
#define PURPLE	vec3(0.8,0.0,0.8)
#define YELLOW	vec3(1.0,1.0,0.0)

uniform sampler2D source[];
uniform vec4 sourceSize[];
uniform vec4 targetSize;
uniform vec2 mousePos;
uniform float PARAM1;
uniform float PARAM2;
uniform float PARAM3;

in Vertex {
	vec2 texCoord;
	vec2 pixelSize;
	vec2 coord;
};

out vec4 fragColor;
#define pi 3.14159265358979323846264338327950288
#ifdef HIGH_PRECISION
#define RANGE 1.5
#define STEP (2.0*RANGE/SAMPLES)
#define PLOT(fName,color)\
	dist=1000;\
	y0=(fName(coord.x+(-RANGE)*pixelSize.x) - coord.y)/pixelSize.y;\
	V0=vec2(-RANGE,y0);\
	for (i=(-RANGE+STEP);i<RANGE;i+=STEP){\
		y1=(fName(coord.x+(i)*pixelSize.x) - coord.y)/pixelSize.y;\
		segment		= vec2(-STEP ,y0-y1);\
		projection=((dot(V0, segment)/dot(segment,segment) ) * segment);\
		if ((dot (projection,projection-segment)<0.1)){\
			dist=min(dist, length(V0 - projection));\
		}\
		V0=vec2(i,y1);\
		y0=y1;\
	}\
	blend = exp(-dist*dist*pi/2.0)/sqrt(2.0);\
	if ((blend)>0.1){lineColor=vec3(0.0,0.0,0.0);}\
	lineColor=color*blend + lineColor*(1.0-blend);\
	blendFactor = blendFactor+blend;
#else
#define PLOT(fName,color)\
	dist=100;\
	y0=(fName(coord.x+(-1.0)*pixelSize.x) - coord.y)/pixelSize.y;\
	V0=vec2(-1.0,y0);\
	y1=(fName(coord.x+(1.0)*pixelSize.x) - coord.y)/pixelSize.y;\
	segment		= vec2(-2.0 ,y0-y1);\
	projection=((dot(V0, segment)/dot(segment,segment) ) * segment);\
	if ((dot (projection,projection-segment)<0.1)){\
		dist=min(100, length(V0 - projection));\
	}\
	blend = exp(-dist*dist*pi/2.0)/sqrt(2.0);\
	if ((blend)>0.1){lineColor=vec3(0.0,0.0,0.0);}\
	lineColor=color*blend + lineColor*(1.0-blend);\
	blendFactor = blendFactor+blend;
#endif

////////////////////////////////////////////////////////
// FUNCTION :
////////////////////////////////////////////////////////
float f1 (float x){
	return sin(2*pi*x*PARAM1*10);

}
float f2 (float x){
	return cos(2*pi*x*PARAM1*10);
}
float f3 (float x){
	return sin(2*pi*x*PARAM1*100)+sin(2*pi*x*(PARAM1*100-1))+sin(2*pi*x*(PARAM1*100+1));
}
float f4(float x){
	x=x*PARAM1*10;	
	return sin(x*x*x)*sin(x);
}

////////////////////////////////////////////////////////
// 
////////////////////////////////////////////////////////


void main() {
	vec2 screenPos=floor(texCoord*targetSize.xy);// -0.5 ?
	float i,y0,y1,dist,blend,blendFactor;
	vec2  V0,projection,segment;
	vec3  lineColor=vec3(0.0,0.0,0.0);
	blendFactor=0.0;  

////////////////////////////////////////////////////////
// CONFIG
////////////////////////////////////////////////////////


#ifdef PLOT_F4
	PLOT(f4,RED);
#endif	
#ifdef PLOT_F3
	PLOT(f3,PURPLE);
#endif		
#ifdef PLOT_F2
	PLOT(f2,BLUE);
#endif	
#ifdef PLOT_F1
	PLOT(f1,GREEN_L);
#endif


////////////////////////////////////////////////////////
// 
////////////////////////////////////////////////////////



	
	vec3	backgroundColor = vec3(0.0, 0.0, 0.0);
	if ((1.5 * abs(coord.x) < pixelSize.x) ||
		(1.5 * abs(coord.y) < pixelSize.y)) {
		backgroundColor = vec3(1.0, 1.0, 1.0);
	} else if ((1.0 * abs(coord.x - floor(coord.x)) < pixelSize.x)||

		(1.0*abs(coord.y- floor(coord.y))<pixelSize.y)) {
		if ((abs(coord.x) < 6.0 * pixelSize.x)||
			(abs(coord.y) < 6.0 * pixelSize.y)) {
			backgroundColor = vec3(1.0, 1.0, 1.0);
		} else {
			backgroundColor = vec3(0.03f, 0.03f, 0.03f);
		}
	}
	vec2 mousePos2=mousePos;
	if ((screenPos.x==mousePos2.x)||(screenPos.y==mousePos2.y)){
		backgroundColor = vec3(0.0, 0.05, 0.1);		
	}
	if ((blendFactor)>0.10){backgroundColor=vec3(0.0,0.0,0.0);}
	blendFactor = clamp(blendFactor, 0.0, 1.0);
	
	fragColor	= vec4((lineColor * blendFactor) + (backgroundColor * (1.0 - blendFactor)), 1.0);
	fragColor	= pow(fragColor, vec4(1.0 / 2.2));

}