void OpenGLSurface::allocate() {
  glGenVertexArrays(1, &vao);
  glBindVertexArray(vao);
  glGenBuffers(3, &vbo[0]);
}

void OpenGLSurface::size(unsigned w, unsigned h) {
  if(width == w && height == h) return;
  width = w, height = h;
  w = glrSize(w), h = glrSize(h);

  if(texture) { glDeleteTextures(1, &texture); texture = 0; }
  if(buffer) { delete[] buffer; buffer = nullptr; }

  buffer = new uint32_t[w * h]();
  glGenTextures(1, &texture);
  glBindTexture(GL_TEXTURE_2D, texture);
  glTexImage2D(GL_TEXTURE_2D, 0, format, w, h, 0, GL_BGRA, GL_UNSIGNED_INT_8_8_8_8_REV, buffer);

  if(framebuffer) {
    glBindFramebuffer(GL_DRAW_FRAMEBUFFER, framebuffer);
    glFramebufferTexture2D(GL_FRAMEBUFFER, GL_COLOR_ATTACHMENT0, GL_TEXTURE_2D, texture, 0);
    delete[] buffer;
    buffer = nullptr;
  }
}

void OpenGLSurface::release() {
  if(vbo[0]) { glDeleteBuffers(3, &vbo[0]); for(auto &o : vbo) o = 0; }
  if(vao) { glDeleteVertexArrays(1, &vao); vao = 0; }
  if(vertex) { glDetachShader(program, vertex); glDeleteShader(vertex); vertex = 0; }
  if(geometry) { glDetachShader(program, geometry); glDeleteShader(geometry); geometry = 0; }
  if(fragment) { glDetachShader(program, fragment); glDeleteShader(fragment); fragment = 0; }
  if(texture) { glDeleteTextures(1, &texture); texture = 0; }
  if(framebuffer) { glDeleteFramebuffers(1, &framebuffer); framebuffer = 0; }
  if(program) { glDeleteProgram(program); program = 0; }
  width = 0, height = 0;
}

void OpenGLSurface::render(unsigned sourceWidth, unsigned sourceHeight, unsigned targetWidth, unsigned targetHeight,float zoomX,float zoomY,int offsetX,int offsetY) {
//  glViewport(offsetX, offsetY, targetWidth*zoomX, targetHeight*zoomY);
  glViewport(0, 0, targetWidth, targetHeight);

  GLfloat positions[] = {
	-1.0, -1.0, 0.0, 1.0,
	1.0, -1.0, 0.0, 1.0,
	-1.0, 1.0, 0.0, 1.0,
	1.0, 1.0, 0.0, 1.0,
  };
  for (int i=0;i<4;i++){
	  positions[4*i]+=offsetX*2.0/(targetWidth*zoomX);
	  positions[4*i]*=zoomX;
	  positions[4*i+1]+=offsetY*2.0/(targetHeight*zoomY);
	  positions[4*i+1]*=zoomY;
  }

  GLfloat texCoords[] = {
	0.0, 0.0,
	1.0, 0.0,
	0.0, 1.0,
	1.0, 1.0,
  };

  glBindVertexArray(vao);

  glBindBuffer(GL_ARRAY_BUFFER, vbo[0]);
  glBufferData(GL_ARRAY_BUFFER, 16 * sizeof(GLfloat), positions, GL_STATIC_DRAW);
  GLuint locationPosition = glGetAttribLocation(program, "position");
  glEnableVertexAttribArray(locationPosition);
  glVertexAttribPointer(locationPosition, 4, GL_FLOAT, GL_FALSE, 0, 0);

  glBindBuffer(GL_ARRAY_BUFFER, vbo[1]);
  glBufferData(GL_ARRAY_BUFFER, 8 * sizeof(GLfloat), texCoords, GL_STATIC_DRAW);
  GLuint locationTexCoord = glGetAttribLocation(program, "texCoord");
  glEnableVertexAttribArray(locationTexCoord);
  glVertexAttribPointer(locationTexCoord, 2, GL_FLOAT, GL_FALSE, 0, 0);

  glBindFragDataLocation(program, 0, "fragColor");
  glDrawArrays(GL_TRIANGLE_STRIP, 0, 4);

  glDisableVertexAttribArray(locationPosition);
  glDisableVertexAttribArray(locationTexCoord);
}
