#version 150

////////////////////////////////////////////////////////
//	GPU-plot	
//	Author: aliaspider - aliaspider@gmail.com
//	License: GPLv3      
////////////////////////////////////////////////////////

// #define MAX_X 10
// #define MAX_Y 10
in vec4 position;
in vec2 texCoord;

uniform vec4 sourceSize[];
uniform vec4 targetSize;
uniform float MAX_X;
uniform float MAX_Y;
out Vertex{
	vec2 texCoord;
	vec2 pixelSize;
	vec2 coord;
}vertexOut;

void main(void){
	gl_Position=position;
	vertexOut.texCoord=texCoord;
	
	vertexOut.pixelSize.x	= 1.0 / (targetSize.x / (MAX_X*2.0));
#ifdef ORTHONORMAL
	vertexOut.pixelSize.y	=vertexOut.pixelSize.x	;		
#else
	vertexOut.pixelSize.y	= 1.0 / (targetSize.y / (MAX_Y*2.0));
#endif
	

	vertexOut.coord.x		= position.x * MAX_X;
#ifdef ORTHONORMAL	
	vertexOut.coord.y		= -position.y * (vertexOut.pixelSize.x*targetSize.y)/2.0;
#else
	vertexOut.coord.y		= -position.y * MAX_Y;
#endif
	
	

	
}
