#include <nall/nall.hpp>
using namespace nall;

#include <ruby/ruby.hpp>
using namespace ruby;

#include <phoenix/phoenix.hpp>
using namespace phoenix;


struct SettingsStruct{
	nall::string name;
	float min=0;
	float max=0;
	float val=0;
	float step=1.0;
	bool isToggle=false;
	bool hasValue=false;
	bool isUniform=false;
	bool active=false;	  
};
struct CheckButton_tagged :CheckButton{
	SettingsStruct* tag;
};
struct HorizontalSlider_tagged :HorizontalSlider{
	SettingsStruct* tag;
	Label*			label;
};
struct FILEINFO{
	string fileName;
	time_t timeStamp;
};
struct MainWindow : phoenix::Window {
  HorizontalLayout layout;
    Viewport viewport;
	VerticalLayout marginLayoutMain;
    VerticalLayout listLayout;
	  VerticalLayout   marginLayout;
	  Button   screenShotButton;
	  HorizontalLayout widthHeightEditLayout;
	  LineEdit textEditWidth;
	  Label	   xLabel;
	  LineEdit textEditHeight;
	  Button   setSizeButton;
	  CheckButton dockCheckButton;
	  HorizontalLayout scaleButtonsLayout;
	  Button	scale1xButton;
	  Button	scale2xButton;
	  Button	scale3xButton;
	  Button	scale4xButton;
	  Button	scale5xButton;
	  CheckButton aspectRatioCheckButton;
	  HorizontalLayout optionsLayout;
	  CheckButton renderOnUpdateCheckButton;
	  CheckButton WatchFilesCheckButton;
      ListView listShaders;
      ListView listImages;
	  VerticalLayout settingsLayout;
	  //VerticalScroller settingsLayoutScroll;
	  vector<Label*> settingsLabels;
	  vector<CheckButton_tagged*> settingsCheckButtons;
	  vector<HorizontalSlider_tagged*> settingsHorizontalSlider;
	  vector<HorizontalLayout*> settingsHorizontalLayout;
	  
	Label myLabel;		
  image buffer;
  string screenShotFileName;
  vector<FILEINFO>	shaderFilesInfo;
  bool screenShotRequested=false;
  int updateViewport=1;
  lstring shaders;
  lstring images;
  string messageBuffer;
  int messageDisplayDuration=0;
  MainWindow();
  void main();
  void displayMessage(const char* message,int duration=1);
  void scaleButtonOnActivate(int scale);
  phoenix::Window controlWindow;
  HorizontalLayout controlWindowLayout;
  VerticalLayout controlWindowMarginLayout;
  void fillListLayout(void);
};
void MainWindow::fillListLayout(void){
	

}
void MainWindow::scaleButtonOnActivate(int scale){	  
	textEditHeight.setText(buffer.height*scale);
	if (aspectRatioCheckButton.checked()){
		textEditWidth.setText((int)(((float)(buffer.height*scale)*4.0)/3.0));
	}else{
		textEditWidth.setText(buffer.width*scale);
	}
	setSizeButton.onActivate();	  
}

MainWindow::MainWindow() {
  
  setTitle("GLSLdev");
  setSmartGeometry({800, 128, 230 + 640, 480});
  
  shaders = directory::folders(".", "*.shader");
  shaders.prepend("None");
  for(auto& shader : shaders) listShaders.append(string{shader}.rtrim<1>(".shader/"));
  listShaders.setSelection(0);

  images = directory::files(".", "*.png");
  for(auto& image : images) listImages.append(string{image}.rtrim<1>(".png"));
  listImages.setSelection(0);

  append(layout);  
  layout.append(viewport, {~0, ~0}, 0);
  layout.append(marginLayoutMain, {5, ~0}, 0);
  layout.append(listLayout, {220, ~0},5);
  listLayout.append(marginLayout,{~0,0},5);
  listLayout.append(screenShotButton,{~0,25},5);	
  listLayout.append(widthHeightEditLayout,{~0,25},5);
  widthHeightEditLayout.append(textEditWidth,{40,~0},3);
  widthHeightEditLayout.append(xLabel,{10,~0},0);
  widthHeightEditLayout.append(textEditHeight,{40,~0},5);
  widthHeightEditLayout.append(setSizeButton,{48,~0},0);
  widthHeightEditLayout.append(dockCheckButton,{~0,~0},0);
  listLayout.append(scaleButtonsLayout,{~0,25},5);
  scaleButtonsLayout.append(scale1xButton,{30,~0},3);
  scaleButtonsLayout.append(scale2xButton,{30,~0},3);
  scaleButtonsLayout.append(scale3xButton,{30,~0},3);
  scaleButtonsLayout.append(scale4xButton,{30,~0},3);
  scaleButtonsLayout.append(scale5xButton,{30,~0},5);
  scaleButtonsLayout.append(aspectRatioCheckButton,{~0,~0},5);
  listLayout.append(optionsLayout,{~0,25},5);
  optionsLayout.append(renderOnUpdateCheckButton,{85,~0},15);
  optionsLayout.append(WatchFilesCheckButton,{~0,~0},0);
  listLayout.append(listShaders, {~0, 100},5);
  listLayout.append(listImages, {~0, 100},5);
  listLayout.append(settingsLayout, {~0, ~0});


  dockCheckButton.setText("Dock");
  dockCheckButton.setChecked();
  renderOnUpdateCheckButton.setText("limit FPS");
  renderOnUpdateCheckButton.setChecked();
  renderOnUpdateCheckButton.onToggle=[this]{
	  updateViewport=0;
  };
  WatchFilesCheckButton.setText("Watch Files");
  WatchFilesCheckButton.setChecked(false);
  xLabel.setText("x");
  //textEditWidth.setText("640");
  //textEditHeight.setText("480");
  setSizeButton.setText("Set");
  setSizeButton.onActivate=[&]{
	  int newWidth,newHeight,oldX,oldY;
	  newWidth=atoi(textEditWidth.text().data());
	  newHeight=atoi(textEditHeight.text().data());
	  if (newHeight<60){
		  newHeight=60;
		  textEditHeight.setText("60");
	  }
	  if (newWidth<1){
		  newWidth=1;
		  textEditHeight.setText("1");
	  }
	  oldX=geometry().x;
	  oldY=geometry().y;

	  
	  //setGeometry({oldX,oldY,newWidth+230+geometry().width-frameGeometry().width,newHeight+geometry().height-frameGeometry().height});
	  int offsetX=viewport.geometry().width;
	  offsetX-=newWidth;	  
	  if(dockCheckButton.checked()){
	  setGeometry({oldX+offsetX,oldY,newWidth+230,newHeight});
	  }else{
		  setGeometry({oldX,oldY,newWidth,newHeight});
	  }
	  
  };

  dockCheckButton.onToggle=[this]{
	  Geometry vp=viewport.geometry();
	  
	  
	  if (dockCheckButton.checked())
	  {
		  
			//if (controlWindow.visible())  return;		  
		    setGeometry({geometry().x,geometry().y,geometry().width+230,geometry().height});
			controlWindowLayout.remove(listLayout);
			//controlWindow.synchronizeLayout();
			//listLayout.synchronizeLayout();
			layout.append(marginLayoutMain,{5,~0},0);
			layout.append(listLayout,{220,~0},5);
			controlWindow.setVisible(false);
	  }else{
			
			//if (!controlWindow.visible())  return;
			controlWindow.setGeometry({geometry().x+vp.width+2,geometry().y,230,listLayout.minimumSize().height+10});
			setGeometry({geometry().x,geometry().y,(geometry().width>230)?geometry().width-230:60,geometry().height});			
			layout.remove(listLayout);	
			layout.remove(marginLayoutMain);			
			synchronizeLayout();
			
			controlWindowLayout.append(listLayout, {~0, ~0},5);
			controlWindow.setVisible();
	  }

  };


  scale1xButton.setText("1x");
  scale2xButton.setText("2x");
  scale3xButton.setText("3x");
  scale4xButton.setText("4x");
  scale5xButton.setText("5x");
  aspectRatioCheckButton.setText("4:3");
  aspectRatioCheckButton.setChecked();
  textEditWidth.setText("hi");
  
  scale1xButton.onActivate=[&]{scaleButtonOnActivate(1); };
  scale2xButton.onActivate=[&]{scaleButtonOnActivate(2); };
  scale3xButton.onActivate=[&]{scaleButtonOnActivate(3); };
  scale4xButton.onActivate=[&]{scaleButtonOnActivate(4); };
  scale5xButton.onActivate=[&]{scaleButtonOnActivate(5); };
  

  
  screenShotButton.setText("ScreenShot");


  screenShotButton.onActivate=[&]{
	  updateViewport++;
	  screenShotFileName="./screenShots";	  
	  if (!nall::directory::exists(screenShotFileName)){
		  directory::create(screenShotFileName,0777);
	  }
	  screenShotFileName.append("/");
	  screenShotFileName.append(string(images(listImages.selection())).rtrim<1>(".png"));
	  screenShotFileName.append(".");
	  screenShotFileName.append(string(shaders(listShaders.selection())).rtrim<1>(".shader/"));
	  string tempName=screenShotFileName;
	  int tempCounter=1;
	  while ((file::exists({tempName,".bmp"}))||(file::exists({tempName,".settings"}))){
		  tempName=string({screenShotFileName,"(",tempCounter++,")"});
	  }
	  screenShotFileName=tempName;
	  video.set(Video::ScreenShotFileName,(const char*)screenShotFileName);
	  
	  screenShotRequested=true;	  
  };
  listShaders.onChange = [&] {	
	
	updateViewport++;
    unsigned selection = 0;
    if(listShaders.selected()) selection = listShaders.selection();
    string pathname = shaders(selection);
    if(pathname == "None") pathname = "";
    video.set(Video::Shader, (const char*)pathname);
	shaderFilesInfo.reset();
	if ((!pathname.empty())&&(file::exists({pathname,"manifest.bml"})))
	{
		time_t currentTime=time(0);
		shaderFilesInfo.append({"manifest.bml",currentTime});
		auto document = Markup::Document(file::read({ pathname, "manifest.bml" }));
		for (auto& node : document.find("program")) {
			if (node["vertex"].exists()){
				shaderFilesInfo.append({node["vertex"].text(),currentTime});
			}
			if (node["fragment"].exists()){
				shaderFilesInfo.append({node["fragment"].text(),currentTime});
			}
		}

	}
	

	vector<SettingsStruct>& settings = *((vector<SettingsStruct>*)any_cast<uintptr_t>(video.get(Video::ShaderSettings)));
	//printf("\nHello , first setting is : %s",settings(0).name.data());


	for (auto pHly:settingsHorizontalLayout){
		settingsLayout.remove(*pHly);
		delete pHly;
	}
	settingsHorizontalLayout.reset();

	for (auto pLbl:settingsLabels){
		settingsLayout.remove(*pLbl);		
		delete pLbl;
	}
	settingsLabels.reset();
	for (auto pCBtn:settingsCheckButtons){
		settingsLayout.remove(*pCBtn);
		delete pCBtn;
	}
	settingsCheckButtons.reset();
	for (auto pHSld:settingsHorizontalSlider){
		//settingsLayout.remove(*pHSld);
		delete pHSld;
	}
	settingsHorizontalSlider.reset();

	for(SettingsStruct& setting : settings){
		//printf("\n%s",setting.name.data());


		
		if (setting.isToggle)
		{
			settingsCheckButtons.append(new CheckButton_tagged);
			settingsCheckButtons.last()->tag=&setting;
			settingsCheckButtons.last()->setChecked(setting.active);
			settingsCheckButtons.last()->setText(setting.name);
			settingsLayout.append(*(settingsCheckButtons.last()),{~0,20});
			CheckButton_tagged& lastCBtn = *(settingsCheckButtons.last());
			lastCBtn.onToggle=[&]{			
				updateViewport++;
				lastCBtn.tag->active=lastCBtn.checked();
				video.set(Video::Shader, (const char*)shaders(listShaders.selection()));
				//printf("\n%s",lastCBtn.tag->name.data());
			};

		}else{
			settingsLabels.append(new Label);
			settingsLabels.last()->setText(setting.name);
			settingsLayout.append(*(settingsLabels.last()),{~0,20});
		}
		if (setting.hasValue){
			settingsHorizontalLayout.append(new HorizontalLayout);
			settingsLayout.append(*(settingsHorizontalLayout.last()),{~0,20});



			settingsLabels.append(new Label);
			settingsLabels.last()->setText(setting.val);
			settingsHorizontalLayout.last()->append(*(settingsLabels.last()),{50,~0},0);

			settingsHorizontalSlider.append(new HorizontalSlider_tagged);
			settingsHorizontalSlider.last()->tag=&setting;
			settingsHorizontalSlider.last()->label=settingsLabels.last();			
			settingsHorizontalSlider.last()->setLength(1.0+floor((setting.max-setting.min)/setting.step) );
			settingsHorizontalSlider.last()->setPosition((setting.val-setting.min)/setting.step);
			settingsHorizontalLayout.last()->append(*(settingsHorizontalSlider.last()), {~0, ~0},0);
			HorizontalSlider_tagged& lastHzSld= *(settingsHorizontalSlider.last());
			lastHzSld.onChange=[&]{				
				updateViewport++;
				lastHzSld.tag->val=lastHzSld.tag->min+lastHzSld.position()*setting.step;
				lastHzSld.label->setText(setting.val);
				if (!(lastHzSld.tag->isUniform)){
					video.set(Video::Shader, (const char*)shaders(listShaders.selection()));				
				}
			};

		}
	}
	if (!dockCheckButton.checked())
	{
		controlWindow.setGeometry({controlWindow.geometry().x,controlWindow.geometry().y,controlWindow.geometry().width,listLayout.minimumSize().height+10});
	}
	
	
  };

  listImages.onChange = [&] {	
	updateViewport++;
    unsigned selection = 0;
    if(listImages.selected()) selection = listImages.selection();

    buffer.free();
    buffer.load(images(selection));
    buffer.transform(0, 32, 255u << 24, 255u << 16, 255u << 8, 255u << 0);

    uint32_t* data;
    unsigned pitch;
    if(video.lock(data, pitch, buffer.width, buffer.height)) {
      pitch >>= 2;
      for(unsigned y = 0; y < buffer.height; y++) {
        memcpy(data + y * pitch, buffer.data + y * buffer.pitch, buffer.width * sizeof(uint32_t));
      }
      video.unlock();
    }
  };
  viewport.onMouseMove=[this](Position pos){
	  Position& savedPos=*((Position*)any_cast<uintptr_t>(video.get(Video::MousePos)));
	  if ((savedPos.x!=pos.x)||(savedPos.y!=pos.y))
	  {
		  updateViewport++;
	  }
	  savedPos=pos;
  };
  viewport.onMouseLeave=[this]{
	  *((Position*)any_cast<uintptr_t>(video.get(Video::MousePos)))={-1,-1};
	  updateViewport++;
  };

  //onClose = &Application::quit;
  onClose=[&]{	  
	  Application::quit();
  };
  
  setVisible();
  Application::processEvents();

  video.driver("OpenGL");
  video.set(Video::Handle, viewport.handle());
  if(video.init() == false) exit(0);
  video.set(Video::Filter, Video::FilterLinear);
  
  listImages.onChange();
  if (shaders.size()>1)
  {
	  listShaders.setSelection(1);
  }
  listShaders.setFocused();
  listShaders.onChange();

  
  controlWindow.append(controlWindowLayout); 
  controlWindowLayout.append(controlWindowMarginLayout,{5,0},0);
  controlWindow.setResizable(false);
  controlWindow.setVisible(false);
  controlWindow.onClose=[this]{
	  dockCheckButton.setChecked();
	  dockCheckButton.onToggle();
  };
  

}
void MainWindow::displayMessage(const char* message,int duration){
	messageDisplayDuration=duration;
	messageBuffer=message;
}

void MainWindow::main() {
	static int oldWidth=0;
	static int oldHeight=0;
	static unsigned frameCounter = 0;
	static int remainingSeconds = 0;


	static time_t cachedTime = time(0);
	time_t currentTime = time(0);

	if (oldWidth!=viewport.geometry().width)
	{
		oldWidth=viewport.geometry().width;
		textEditWidth.setText(oldWidth);
		updateViewport=10;
	}
	if (oldHeight!=viewport.geometry().height)
	{
		oldHeight=viewport.geometry().height;
		textEditHeight.setText(oldHeight);
		updateViewport=10;
	}

	if (renderOnUpdateCheckButton.checked())
	{
		if (updateViewport)
		{
			video.refresh();
			frameCounter++;
			updateViewport--;			

		}else{
			usleep(10000);
		}

		
	}else{
		video.refresh();
		frameCounter++;
	}
	
  
  //usleep(100000);

  if (screenShotRequested){
	  
	  if (*((string*)any_cast<uintptr_t>(video.get(Video::LastError)))=="screenShotError"){
		  displayMessage("cannot save ScreenShot");
	  }else{
		  if (settingsLabels.empty())
		  {
			  displayMessage(string{"ScreenShot Saved to ",screenShotFileName,".bmp"},2);
		  }else{
			  displayMessage(string{"ScreenShot and Settings Saved to ",screenShotFileName,".bmp   +   .settings"},2);
		  }
	  }	  
	  screenShotRequested=false;
  }





  if (messageDisplayDuration>0){
	  remainingSeconds=messageDisplayDuration;
	  messageDisplayDuration=0;
	  setTitle(messageBuffer);
  }


  Position* pMousePos=((Position*)any_cast<uintptr_t>(video.get(Video::MousePos)));
  if (currentTime > cachedTime){  	 
	  if (WatchFilesCheckButton.checked())
	  {
		  unsigned selection = 0;
		  if(listShaders.selected()) selection = listShaders.selection();
		  string pathname = shaders(selection);
		  if(pathname != "None"){
			  bool reloadShader=false;
			  for (FILEINFO fileInfo: shaderFilesInfo){
				  time_t timeStamp=file::timestamp({pathname,fileInfo.fileName},file::time::modify);
				  if (timeStamp>fileInfo.timeStamp)
				  {
					  reloadShader=true;
					  fileInfo.timeStamp=timeStamp;
					  if (fileInfo.fileName=="manifest.bml")
					  {
						  video.set(Video::Shader, "");
					  }
					  
				  }		  
			  }
			  if (reloadShader)
			  {				  
				  listShaders.onChange();
			  }
		  }
	  }
	  
	  
	  if (remainingSeconds>0){
		  remainingSeconds-=(currentTime-cachedTime);	  
	  }else{		  
		  setTitle({"GLSLdev - ", viewport.geometry().width, "x", viewport.geometry().height, " - ", (frameCounter/(currentTime-cachedTime)), " FPS","  X:",pMousePos->x,"  Y:",pMousePos->y});		  	  
	  }
	  frameCounter = 0;
	  cachedTime = currentTime;
  }

  
}

int main() {
  auto mainWindow = new MainWindow();
  Application::main = {&MainWindow::main, mainWindow};
  setlocale(LC_NUMERIC,"C");
  Application::run();
   
  return 0;
}
