#version 150

////////////////////////////////////////////////////////
//	GTU-Famicom version 0.50	
//	Author: aliaspider - aliaspider@gmail.com
//	License: GPLv3      
////////////////////////////////////////////////////////


uniform sampler2D	source[];
uniform vec4 		targetSize;

in Vertex {
	vec2 texCoord;
	float colorPhase;
};
out vec4 fragColor;
#define pi			3.14159265358

#in combFilter
const float wave[12]=float[](
2.0, 1.7320508, 1.0, 0.0, -1.0, -1.7320508,
-2.0, -1.7320508, -1.0, 0.0, 1.0, 1.732050807551);


void main() {

	float current=texture(source[0],texCoord.xy).r;	
	
	
#ifdef combFilter
	float prev6=texture(source[0],texCoord.xy-vec2(6.0*targetSize.z,0.0));
	float signal=(current+prev6)/2.0;
	float chromaSignal=current-signal;

#ifdef perfTest3
	int cosPhase=int(colorPhase+0.5)%12;
	int sinPhase=(currentPhase+9)%12;
	float I = chromaSignal * wave[cosPhase];
	float I = chromaSignal * wave[sinPhase];
#else
	float I = chromaSignal * cos (colorPhase * (2.0 * pi / 12.0))*2.0;
	float Q = chromaSignal * sin (colorPhase * (2.0 * pi / 12.0))*2.0;	
#endif
	
#else //combFilter

	float signal=current;
	
#ifdef perfTest3
	int cosPhase=int(colorPhase+0.5)%12;
	int sinPhase=(currentPhase+9)%12;
	float I = signal * wave[cosPhase];
	float I = signal * wave[sinPhase];
#else
	
	float I = signal * cos (colorPhase * (2.0 * pi / 12.0))*2.0;
	float Q = signal * sin (colorPhase * (2.0 * pi / 12.0))*2.0;
#endif

#endif //combFilter
	
	fragColor = vec4(signal,I,Q,1.0);	
}
