#version 150

////////////////////////////////////////////////////////
//	GTU-Famicom version 0.50	
//	Author: aliaspider - aliaspider@gmail.com
//	License: GPLv3      
////////////////////////////////////////////////////////


uniform sampler2D	source[];
uniform vec4		sourceSize[];
uniform int 		phase;

#in signalResolution
#in addNoise
#in noiseStrengh

in Vertex {
	vec2 texCoord;
};
out vec4 fragColor;
#define pi			3.14159265358
float STU0 (float x, float b){	
	x = x*b*pi;
	return clamp((x+sin(x))/(2.0*pi)+0.5,0.0,1.0);
}
float STU(float x, float b){
	return STU0(x+0.5,b)-STU0(x-0.5,b);
}


float rand(vec2 co){
    return fract(sin(dot(co.xy ,vec2(12.9898,78.233))) * 43758.5453);
}

void main() {
	
	float offset	= fract((texCoord.x * sourceSize[0].x) - 0.5);

	
	float range=ceil(0.5+sourceSize[0].x/signalResolution);
	range = min ( range, 255.0);
	float X,i,c;
	float signal = 0.0;
	for (i=1-range;i<1+range;i++){		
		X=offset-i;
		c=texture(source[0], vec2(texCoord.x - X*sourceSize[0].z,texCoord.y)).x;
		signal+=c*STU(X,(signalResolution*sourceSize[0].z));
	}
	
	float black=.518f, white=1.962f;
    signal = (signal-black) / (white-black);
#ifdef addNoise
	vec2 pos =(texCoord.xy * sourceSize[0].xy);
	signal -=0.5;
	signal +=(rand(vec2(pos.x*pos.y,phase))-0.5)*noiseStrengh;
	signal +=0.5;
#endif
	
	fragColor = vec4(signal);	

}
