#version 150

////////////////////////////////////////////////////////
//	GTU version 0.50	
//	Author: aliaspider - aliaspider@gmail.com
//	License: GPLv3      
////////////////////////////////////////////////////////


#in tvVerticalResolution
#in noScanlines
#in blackLevel
#in contrast
#in gamma


uniform sampler2D	source[];
uniform vec4		sourceSize[];
uniform vec4		targetSize;

in Vertex {
	vec2 texCoord;
	float range;
};
out vec4 fragColor;

#define pi			3.14159265358
float STU0 (float x, float b){	
	x = x*b*pi;
	return clamp((x+sin(x))/(2.0*pi)+0.5,0.0,1.0);
}
float STU(float x, float b){
	return STU0(x+0.5,b)-STU0(x-0.5,b);
}
float STUR(float x, float b,float r){
	return (STU0(x+r,b)-STU0(x-r,b));
}
#define normalGauss(x) ((exp(-(x)*(x)*0.5))/sqrt(2.0*pi))
float normalGaussIntegral(float x)
{
	x*=sqrt(pi*2.0)*tvVerticalResolution*sourceSize[0].w;
	float a1 = 0.4361836;
	float a2 = -0.1201676;
	float a3 = 0.9372980;
	float p = 0.3326700;
	float t = 1.0 / (1.0 + p*abs(x));
	return (0.5-normalGauss(x) * (t*(a1 + t*(a2 + a3*t))))*sign(x);
}


#in perfTest2
void main() {
	
	float	offset	= fract(texCoord.y * sourceSize[0].y - 0.5);
	vec3	tempColor = vec3(0.0);	

	float range=ceil(0.5+sourceSize[0].y/tvVerticalResolution);
	range = min ( range, 255.0);
	float Y,i;
	vec3 	c;
	
	for (i=1.0-range;i<1.0+range;i++){
		Y=offset-i;
		c=texture(source[0], vec2(texCoord.x,texCoord.y - Y*sourceSize[0].w)).xyz;
#ifdef noScanlines		
		tempColor+=c*STU(Y,(tvVerticalResolution*sourceSize[0].w));
#else		

#ifdef perfTest2
		tempColor+=c*(STU0(Y+0.5*(sourceSize[0].y*targetSize.w),tvVerticalResolution*sourceSize[0].w)-STU0(Y-0.5*(sourceSize[0].y*targetSize.w),tvVerticalResolution*sourceSize[0].w));
#else
		tempColor+=c*(normalGaussIntegral((Y+0.5*(sourceSize[0].y*targetSize.w))*tvVerticalResolution*sourceSize[0].w)-normalGaussIntegral((Y-0.5*(sourceSize[0].y*targetSize.w))*tvVerticalResolution*sourceSize[0].w));
#endif
		
		
#endif
	}	
#ifndef noScanlines		
	tempColor*=(sourceSize[0].w*targetSize.y);
#endif

	tempColor-=vec3(blackLevel);
	tempColor*=(contrast/vec3(1.0-blackLevel));
	tempColor=pow(tempColor,vec3(gamma));
	fragColor = vec4(tempColor, 1.0);
}