#version 150

uniform sampler2D	source[];
uniform vec4		sourceSize[];
uniform vec4 		targetSize;
uniform vec4 		outputSize;
uniform vec2		outputOffset;

in Vertex {
	vec2 texCoord;
};
out vec4 fragColor;
// #ifdef QUARK_TEST_MODE
#in phosphorCount
#in sharpnessX
#in sharpnessY
#in spacingX
#in spacingY
#in pWidth
#in phosphorAspectRatio
#in alignPhosphors
#in gaussPhosphors

#define pi			3.14159265358
#define a(x) abs(x)
#define d(x,b,l) (pi*b*min(a(x)+l,1.0/b))
#define e(x,b,l) (pi*b*min(max(a(x)-l,-1.0/b),1.0/b))
#define STU(x,b,l) ((d(x,b,l)+sin(d(x,b,l))-e(x,b,l)-sin(e(x,b,l)))/(2.0*pi))
#define X(i) (offset-(i))
#define S(i) (texture(source[0], vec2(texCoord.x - X(i)*sourceSize[0].z,texCoord.y)).x)
#define VAL(i) (S(i)*STU(X(i),(signalResolution*sourceSize[0].z)))
#define normalGauss(x) ((exp(-(x)*(x)*0.5))/sqrt(2.0*pi))
float normalGaussIntegral(float x)
{
	float a1 = 0.4361836;
	float a2 = -0.1201676;
	float a3 = 0.9372980;
	float p = 0.3326700;
	float t = 1.0 / (1.0 + p*abs(x));
	return (0.5-normalGauss(x) * (t*(a1 + t*(a2 + a3*t))))*sign(x);
}
// a=width
// b=sharpness
// c=outputPixelSize/inputPixelSize
float intIntGauss(float x, float a, float b){
	float temp=sqrt(2.0/pi)*(exp(-(b*b*(a+2.0*x)*(a+2.0*x))/8.0)-exp(-(b*b*(a-2.0*x)*(a-2.0*x))/8.0))/b;
	temp+=a*(normalGaussIntegral(b*(2.0*x+a)/2.0)+normalGaussIntegral(b*(2.0*x-a)/2.0));
	temp+=2*x*(normalGaussIntegral(b*(2.0*x+a)/2.0)-normalGaussIntegral(b*(2.0*x-a)/2.0));
	return temp/2.0;
}
float GTU (float x,float a, float b, float c){	
	float d=(x+c/2);
	float e=(x-c/2);
	return (intIntGauss(d,a,b)-intIntGauss(e,a,b))/c;
}
float area(float offset, float width, float range){
	float absX = abs(offset);
	float d = min(absX+range,width);
	float e = min(max(absX-range,-width),width);
	return (d-e)/(2.0*range);
	// d*=pi/width;
	// e*=pi/width;
	// return (d+sin(d)-e-sin(e)/(2.0*pi))*(2.0*range);
}


void main() {
	vec4 c=texture2D(source[0], texCoord.xy);
	
	vec3 pos;
	float tex=(texCoord.x-0.5)*targetSize.x*outputSize.z-1.0*((targetSize.x==outputSize.x)?0.0:(1.00*outputOffset.x))+0.5;
	// tex=texCoord.x;
	pos.g=fract(tex*phosphorCount)-0.5;
	pos.r=fract(tex*phosphorCount+1.0/(3.0*(1.0+spacingX)))-0.5;
	pos.b=fract(tex*phosphorCount-1.0/(3.0*(1.0+spacingX)))-0.5;
	
	pos*=3.0;
	vec4 phosphor=vec4(0.0,0.0,0.0,1.0);
	float i;
	
	float amountX=(phosphorCount*3.0)*outputSize.z;
	// amountX=1.0;
	float amountY=(phosphorCount/phosphorAspectRatio)*outputSize.w;
	// amountY=1.0;

// #ifdef gaussPhosphors	
	// float rangeX=ceil(0.5+max(amountX,3.0/sharpnessX));
	// float rangeY=ceil(0.5+max(amountY,3.0/sharpnessY));
// #else
	float rangeX=ceil(0.5+amountX);
	float rangeY=ceil(0.5+amountY);
// #endif
	rangeX = min ( rangeX, 255.0);
	rangeY = min ( rangeY, 255.0);
	// for (i=-1;i<2;i++){
		// phosphor.r+=STU((pos.r-3.0*i),sharpnessX,(pWidth*(1.0-spacingX/2.0)/2.0));
		// phosphor.r+=STU((pos.r-3.0*i),sharpnessX,(pWidth/(2.0*(1.0+spacingX))));
		// phosphor.g+=STU((pos.g-3.0*i),sharpnessX,(pWidth/(2.0*(1.0+spacingX))));
		// phosphor.b+=STU((pos.b-3.0*i),sharpnessX,(pWidth/(2.0*(1.0+spacingX))));	
	// }
#ifdef gaussPhosphors		
	for (i=-rangeX+1;i<(rangeX+1.0);i++){
	
		phosphor.r+=GTU((pos.r-3.0*i),(pWidth/((1.0+spacingX))),sharpnessX,amountX);
		phosphor.g+=GTU((pos.g-3.0*i),(pWidth/((1.0+spacingX))),sharpnessX,amountX);
		phosphor.b+=GTU((pos.b-3.0*i),(pWidth/((1.0+spacingX))),sharpnessX,amountX);	
	}	
#else
	for (i=-rangeX;i<(rangeX+1.0);i++){
		phosphor.r+=area((pos.r-3.0*i),(pWidth/(2.0*(1.0+spacingX))),amountX);
		phosphor.g+=area((pos.g-3.0*i),(pWidth/(2.0*(1.0+spacingX))),amountX);
		phosphor.b+=area((pos.b-3.0*i),(pWidth/(2.0*(1.0+spacingX))),amountX);	
	}
#endif

	float texY=(texCoord.y-0.5)*targetSize.y*outputSize.w-1.0*((targetSize.y==outputSize.y)?0.0:(1.00*outputOffset.y))+0.5;
	// tex=texCoord.x;
	float offsetY=texY*phosphorCount*outputSize.z*outputSize.y*phosphorAspectRatio-0.5;
#ifndef alignPhosphors
	if (mod(tex*phosphorCount,2.0)<1.0){
		offsetY+=0.5;
	}
#endif
	offsetY=fract(offsetY);
	float mask=0.0;
	// mask+=STU(offsetY,sharpnessY,(1.0/(2.0*(1.0+spacingY))));	
	// mask+=STU(offsetY-1.0,sharpnessY,(1.0/(2.0*(1.0+spacingY))));	

#ifdef gaussPhosphors		
	for (i=-rangeY+1;i<(rangeY+1.0);i++){
	mask+=GTU(offsetY-i,(1.0/((1.0+spacingY))),sharpnessY,amountY);
	}
#else
	for (i=-rangeY+1;i<(rangeY+1.0);i++){
	mask+=area(offsetY-i,(1.0/(2.0*(1.0+spacingY))),amountY);
	}	
#endif

	phosphor*=mask;
	// phosphor=vec4(mask);
	// phosphor=pow(phosphor,vec4(1.0/2.2));
	// fragColor=vec4(abs(pos.r))/3.0;
	// fragColor=vec4(tex);
	// phosphor.r=0.0;
	// phosphor.g=0.0;
	// phosphor.b=0.0;
	// phosphor.b-=2.0/3.0;
	// phosphor.b+=0.005;
	// phosphor.b*=500000;
	fragColor=clamp(phosphor*1.0,0.0,1.0);
	
	// fragColor=vec4(1.0/3.0);
	// fragColor=vec4(pos.r);
	// fragColor=vec4(c.r,c.g,c.b,1.0);
}
