//******************************************************
//
//  The Emulator Of SAA1099 Sound Chip
//  copyright (c) Aley Keprt, 1996-2002
//  this is C/C++ version
//
//  version 0.70
//
//******************************************************


#ifndef __SAAEMU_H
#define __SAAEMU_H


#ifndef BYTE
 typedef unsigned char BYTE;
 typedef unsigned short WORD;
 typedef unsigned long DWORD;
#endif


#ifdef WIN32
 #ifdef SAAEMU_EXPORTS
  #define SAAEMU_API __declspec(dllexport)
 #else
  #define SAAEMU_API __declspec(dllimport)
 #endif
#else
 #define SAAEMU_API
#endif


#ifdef __cplusplus


class SAAEMU_API SaaEmul {

public:

 SaaEmul();
 ~SaaEmul();
 
 int Init(const char *exepath=""); //entry: full exe path, returns: 0=ok, else error

 void Reset(); //reset sound device
 
 void Close(); //close sound device (call this on exit)

 const char* GetName()const; //get player name

 const char* DeviceName()const; //get current audio driver name

 int SetMode(int mode); //set audio mode, return: mode

 int GetMode()const; //set audio mode, return: mode

 int GetVolume(); //get volume (always 0..31)

 void SetVolume(int vol); //set volume (0..31)

 void DirectOut(int reg,int val); //out 511,reg; out 255,val

 bool UpdateSound(); //called 50 times per second to get some output
 //return: 1=immediately ready for next frame

 int GetVersion()const; //returns version info (1.23 is 0x0123)

 int GetNumModes()const; //returns number of modes

 void SetChMask(int); //sets channel mask (bits 0..5 masks voices, 6..7 masks noise)
 
 int GetChMask()const; //retuns active channel mask

 bool IsBuffered()const; //return: 1=digital buffered device, 0=unbuffered device
};


#else


#ifndef WIN32
 //C interface
 void saa_UpdateSound(); //called 50 times per second
 int saa_Init(); //0=ok, else error
 void saa_Reset(); //reset sound device
 void saa_Close(); //close sound device (call this on exit)
 const char* saa_GetName(); //get player name
 const char* saa_DeviceName(); //get current audio driver name
 int saa_SetMode(int mode); //set audio mode
 int saa_GetVolume(); //get volume (always 0..31)
 void saa_SetVolume(int vol); //set volume (0..31)
 void saa_DirectOut(int reg,int val);
 int saa_IsBuffered();
#endif


#endif

#endif
