Attribute VB_Name = "pacmanhw"
Option Explicit

'***********************************************
'** Use Global Declarations for greater speed **
'***********************************************
Dim VideoRam As Long                  'Holds the offsetted video RAM address
Dim ChosenBit As Integer              'Indicates bit currently being drawn on p_Screen
Dim BitNum As Integer                 'Selects each bit in turn
Global PacNMIEnable As Boolean
Global PacIRQEnable As Byte
Global PacInterrupt As Byte
Dim Watch As Integer

Public Static Function fn_ReadPacmanHW(ByVal i_Addr As Integer) As Byte
  '******************************************************************
  '** This function is called from the cpu emulation library (dll) **
  '** Returns data from the specified memory location              **
  '** Either ROM, RAM or hardware inputs (buttons etc)             **
  '******************************************************************
  Dim b_Byte As Byte
  Dim l_Addr As Long
  '*******************************************************
  '** Convert Signed Integer Address to (Un)signed Long **
  '*******************************************************
  If i_Addr >= 0 Then
    l_Addr = i_Addr
  Else
    l_Addr = 65536 + i_Addr
    'l_Addr = (32767 - CLng(-i_Addr)) + 32767
  End If
  
  Select Case l_Addr
    Case &H4000& To &H4FFF&
      '*************************
      '** Read Video Memory   **
      '*************************
      'Debug.Print "Reading Video " & Hex(l_Addr)
      fn_ReadPacmanHW = Mem_Map(MEM_RAM + l_Addr)
      Exit Function
    
    Case &H5000& To &H5100&
      '*************************
      '** Read SW0 Memory   **
      '*************************
      'Debug.Print "Reading Port " & Hex(l_Addr)
      'MsgBox "Read Port"
      b_Byte = 0
      Select Case (l_Addr And &HFFC0)
        Case &H5000&
          If KEY_UP Then b_Byte = b_Byte Or &H1 'Bit 0 is Up
          If KEY_LEFT Then b_Byte = b_Byte Or &H2 'Bit 1 is Left
          If KEY_RIGHT Then b_Byte = b_Byte Or &H4 'Bit 2 is Right
          If KEY_DOWN Then b_Byte = b_Byte Or &H8 'Bit 3 is Down
          'Bit 4 is ?
          If KEY_3 Then b_Byte = b_Byte Or &H20 'Bit 5 Coin
          'Bit 6 is ?
          'Bit 7 is ?
          'Debug.Print "Reading IN0 " & Hex(l_Addr) & " = " & Hex(b_Byte)
          fn_ReadPacmanHW = &HFF& - b_Byte
          Exit Function
    
        Case &H5040&
          If KEY_UP Then b_Byte = b_Byte Or &H1 'Bit 0 is Up
          If KEY_LEFT Then b_Byte = b_Byte Or &H2 'Bit 1 is Left
          If KEY_RIGHT Then b_Byte = b_Byte Or &H4 'Bit 2 is Right
          If KEY_DOWN Then b_Byte = b_Byte Or &H8 'Bit 3 is Down
          'Bit 4 is ?
          If KEY_1 Then b_Byte = b_Byte Or &H20 'Bit 5 P1 Start
          If KEY_2 Then b_Byte = b_Byte Or &H40 'Bit 5 P2 Start
          'Bit 7 is ?
          'Debug.Print "Reading IN1 " & Hex(l_Addr) & " = " & Hex(b_Byte)
          fn_ReadPacmanHW = &HFF& - b_Byte
          Exit Function
    
        Case &H5080&
          b_Byte = &HC9&
          '1 Coin/ 1 Play
          '3 Lives
          'Bonus Life 10000
          'Difficulty Normal
          'Normal Ghost Names
          'Debug.Print "Reading DW1 " & Hex(l_Addr) & " = " & Hex(b_Byte)
          fn_ReadPacmanHW = b_Byte
          Exit Function
      
        Case Else
          Debug.Print "Reading Unknown Port** " & Hex(l_Addr)
          Exit Function
      
      End Select
      
    Case Else
      Debug.Print "Reading Unknown " & Hex(l_Addr)
      MsgBox "?"
      fn_ReadPacmanHW = Mem_Map(MEM_RAM + l_Addr)
      Exit Function
    
  End Select
End Function

Public Static Sub fn_WritePacmanHW(ByVal i_Addr As Integer, ByVal b_Byte As Byte)
  '******************************************************************
  '** This function is called from the cpu emulation library (dll) **
  '** Writes specified data into specified memory location         **
  '** Either RAM, Video RAM or hardware outputs (sound etc)        **
  '******************************************************************
  
  If i_Addr >= 0 Then
    l_Addr = i_Addr
  Else
    l_Addr = 65536 + i_Addr
  End If
  l_Addr = l_Addr And &H7FFF 'High bit of address bus is not connected, ignore it.
  
  Select Case l_Addr
    Case &H0& To &H2&:
      'Debug.Print "Writing PacInterrupt " & Hex(b_Byte) & " Address " & Hex(l_Addr)
      PacInterrupt = b_Byte
      Exit Sub

    Case &H4000& To &H43FF&:
      Mem_Map(MEM_RAM + l_Addr) = b_Byte 'Update normal hardware memory
      ' ** Mark Character as needing redrawn **
      l_Addr = l_Addr - &H4000& 'Remove the offset
      CharScreen(l_Addr) = True
      Exit Sub
    
    Case &H4400& To &H47FF&:
      Mem_Map(MEM_RAM + l_Addr) = b_Byte 'Update normal hardware memory
      ' ** Mark Character as needing redrawn **
      l_Addr = l_Addr - &H4400& 'Remove the offset
      CharScreen(l_Addr) = True
      Exit Sub
    
    Case &H4C00& To &H4FEF&:
      'Debug.Print "Writing to RAM " & Hex(b_Byte) & " Address " & Hex(l_Addr)
      Mem_Map(MEM_RAM + l_Addr) = b_Byte 'Update normal hardware memory
      Exit Sub
    
    Case &H4FF0& To &H4FFF&:
      'Debug.Print "Writing to sprite " & Hex(b_Byte) & " Address " & Hex(l_Addr)
      '** If sprite characteristics have changed, mark sprites for redraw
      If Mem_Map(MEM_RAM + l_Addr) <> b_Byte Then
        SpriteScreen(Int((l_Addr - &H4FF0&) / 2)) = True
        SpriteScreen(0) = True
        Mem_Map(MEM_RAM + l_Addr) = b_Byte 'Update normal hardware memory
      End If
      Exit Sub
    
    Case &H5000&:
      'Debug.Print "Writing IRQ " & Hex(b_Byte)
      Mem_Map(MEM_RAM + l_Addr) = b_Byte 'Update normal hardware memory
      PacIRQEnable = b_Byte
      Exit Sub
    
    Case &H5060& To &H507F&:
      'Debug.Print "Writing to sprite " & Hex(b_Byte) & " Address " & Hex(l_Addr)
      '** If sprite position has changed, mark sprites for redraw
      If Mem_Map(MEM_RAM + l_Addr) <> b_Byte Then
        SpriteScreen(Int((l_Addr - &H5060&) / 2)) = True
        SpriteScreen(0) = True
        Mem_Map(MEM_RAM + l_Addr) = b_Byte 'Update normal hardware memory
      End If
      Exit Sub
    
    Case Else
      Debug.Print "** Writing Unknown ** " & Hex(b_Byte) & " Address " & Hex(l_Addr)
      Mem_Map(MEM_RAM + l_Addr) = b_Byte 'Update normal hardware memory
      Exit Sub
  End Select
    
End Sub

Public Static Sub fn_DrawPacmanHW()
  '****************************************************
  '** Update the visible Screen as quickly as we can **
  '****************************************************
  
  If Not (bo_EnableScreenUpdate) Then Exit Sub

  For i_n = 0 To 1023
    If CharScreen(i_n) Then
      i_x1 = i_CharX(i_n) * 8
      i_y1 = i_CharY(i_n) * 8
      For i_BitX = 0 To 7
        For i_BitY = 0 To 7
          If (CurVScrn(i_x1 + i_BitX, i_y1 + i_BitY) <> NewVScrn(i_x1 + i_BitX, i_y1 + i_BitY)) Then
            ScrnImage(i_FullScreen).PSet (i_x1 + i_BitX, i_y1 + i_BitY), NewVScrn(i_x1 + i_BitX, i_y1 + i_BitY)
            CurVScrn(i_x1 + i_BitX, i_y1 + i_BitY) = NewVScrn(i_x1 + i_BitX, i_y1 + i_BitY)
          End If
        Next
      Next
      CharScreen(i_n) = False
    End If
  Next
  
  fn_PlotSprites

End Sub

Public Static Sub fn_ReDrawPacmanHW()
  '**********************************************************************
  '** We must update the whole screen when we go to full screen & back **
  '**********************************************************************
  For i_n = 0 To 1023
    CharScreen(i_n) = True
  Next
  For i_x1 = 0 To 223
    For i_y1 = 0 To 287
      CurVScrn(i_x1, i_y1) = 0
    Next
  Next
End Sub

Public Static Sub fn_ClrScrPacmanHW()
  '***************************
  '** Clear all Screen data **
  '***************************
  Exit Sub
  For i_x1 = 0 To SCREEN_HEIGHT - 1
    For i_y1 = 0 To SCREEN_WIDTH - 1
      NewVScrn(i_x1, i_y1) = 0
      CurVScrn(i_x1, i_y1) = 0
    Next
  Next
End Sub

Public Static Sub fn_DecodePacmanCharSet()
  ReDim CharSet(0, 255, 7, 7) As Integer
  Dim m As Long
  Dim i_char As Integer
  Dim xPlus As Integer
  For i_char = 0 To 255
    For i_x1 = 0 To 7
      For i_y1 = 0 To 3
        If (Mem_Map(&H4000& + (i_char * 16) + i_x1) And (2 ^ i_y1)) <> 0 Then
          If (Mem_Map(&H4000& + (i_char * 16) + i_x1) And (2 ^ (i_y1 + 4))) <> 0 Then
            CharSet(0, i_char, 7 - i_x1, 7 - i_y1) = 3
          Else
            CharSet(0, i_char, 7 - i_x1, 7 - i_y1) = 2
          End If
        Else
          If (Mem_Map(&H4000& + (i_char * 16) + i_x1) And (2 ^ (i_y1 + 4))) <> 0 Then
            CharSet(0, i_char, 7 - i_x1, 7 - i_y1) = 1
          Else
            CharSet(0, i_char, 7 - i_x1, 7 - i_y1) = 0
          End If
        End If
      Next
    Next
  
    For i_x1 = 0 To 7
      For i_y1 = 0 To 3
        If (Mem_Map(&H4008& + (i_char * 16) + i_x1) And (2 ^ i_y1)) <> 0 Then
          If (Mem_Map(&H4008& + (i_char * 16) + i_x1) And (2 ^ (i_y1 + 4))) <> 0 Then
            CharSet(0, i_char, 7 - i_x1, 7 - i_y1 - 4) = 3
          Else
            CharSet(0, i_char, 7 - i_x1, 7 - i_y1 - 4) = 2
          End If
        Else
          If (Mem_Map(&H4008& + (i_char * 16) + i_x1) And (2 ^ (i_y1 + 4))) <> 0 Then
            CharSet(0, i_char, 7 - i_x1, 7 - i_y1 - 4) = 1
          Else
            CharSet(0, i_char, 7 - i_x1, 7 - i_y1 - 4) = 0
          End If
        End If
      Next
    Next
  
  Next

End Sub

Public Static Sub fn_DrawPacmanCharSet()
  Dim i_n As Integer
  Dim i_BitX As Integer
  Dim i_BitY As Integer
  Dim i_char As Integer
  For i_n = 0 To 255
    For i_BitX = 0 To 7
      For i_BitY = 0 To 7
        Select Case CharSet(0, i_n, i_BitX, i_BitY)
        Case 0:
          VBPac01.p_Screen.PSet (i_x1 + i_BitX, i_y1 + i_BitY), &H0&
        Case 1:
          VBPac01.p_Screen.PSet (i_x1 + i_BitX, i_y1 + i_BitY), &HFFFF00
        Case 2:
          VBPac01.p_Screen.PSet (i_x1 + i_BitX, i_y1 + i_BitY), &HFF00FF
        Case 3:
          VBPac01.p_Screen.PSet (i_x1 + i_BitX, i_y1 + i_BitY), &HFFFF
        End Select
      Next
    Next
    i_x1 = i_x1 + 8
    If i_x1 > 223 Then
      i_x1 = 0
      i_y1 = i_y1 + 8
    End If
  Next
End Sub

Public Static Sub fn_DecodePacmanSprites()
  ReDim SpriteSet(0, 64, 15, 15) As Integer
  Dim m As Long
  Dim i_char As Integer
  Dim xPlus As Integer
  For i_char = 0 To 63
        
    'Top Right 5-8
    For i_x1 = 0 To 7
      For i_y1 = 0 To 3
        If (Mem_Map(&H5000& + (i_char * 64) + i_x1) And (2 ^ i_y1)) <> 0 Then
          If (Mem_Map(&H5000& + (i_char * 64) + i_x1) And (2 ^ (i_y1 + 4))) <> 0 Then
            SpriteSet(0, i_char, 15 - i_x1, 15 - i_y1) = 3
          Else
            SpriteSet(0, i_char, 15 - i_x1, 15 - i_y1) = 2
          End If
        Else
          If (Mem_Map(&H5000& + (i_char * 64) + i_x1) And (2 ^ (i_y1 + 4))) <> 0 Then
            SpriteSet(0, i_char, 15 - i_x1, 15 - i_y1) = 1
          Else
            SpriteSet(0, i_char, 15 - i_x1, 15 - i_y1) = 0
          End If
        End If
      Next
    Next

    'Top Right 1-4
    For i_x1 = 0 To 7
      For i_y1 = 0 To 3
        If (Mem_Map(&H5008& + (i_char * 64) + i_x1) And (2 ^ i_y1)) <> 0 Then
          If (Mem_Map(&H5008& + (i_char * 64) + i_x1) And (2 ^ (i_y1 + 4))) <> 0 Then
            SpriteSet(0, i_char, 15 - i_x1, 15 - i_y1 - 12) = 3
          Else
            SpriteSet(0, i_char, 15 - i_x1, 15 - i_y1 - 12) = 2
          End If
        Else
          If (Mem_Map(&H5008& + (i_char * 64) + i_x1) And (2 ^ (i_y1 + 4))) <> 0 Then
            SpriteSet(0, i_char, 15 - i_x1, 15 - i_y1 - 12) = 1
          Else
            SpriteSet(0, i_char, 15 - i_x1, 15 - i_y1 - 12) = 0
          End If
        End If
      Next
    Next

    'Top Right 5-8
    For i_x1 = 0 To 7
      For i_y1 = 0 To 3
        If (Mem_Map(&H5010& + (i_char * 64) + i_x1) And (2 ^ i_y1)) <> 0 Then
          If (Mem_Map(&H5010& + (i_char * 64) + i_x1) And (2 ^ (i_y1 + 4))) <> 0 Then
            SpriteSet(0, i_char, 15 - i_x1, 15 - i_y1 - 8) = 3
          Else
            SpriteSet(0, i_char, 15 - i_x1, 15 - i_y1 - 8) = 2
          End If
        Else
          If (Mem_Map(&H5010& + (i_char * 64) + i_x1) And (2 ^ (i_y1 + 4))) <> 0 Then
            SpriteSet(0, i_char, 15 - i_x1, 15 - i_y1 - 8) = 1
          Else
            SpriteSet(0, i_char, 15 - i_x1, 15 - i_y1 - 8) = 0
          End If
        End If
      Next
    Next
  
    'Bottom Right 1-4
    For i_x1 = 0 To 7
      For i_y1 = 0 To 3
        If (Mem_Map(&H5018& + (i_char * 64) + i_x1) And (2 ^ i_y1)) <> 0 Then
          If (Mem_Map(&H5018& + (i_char * 64) + i_x1) And (2 ^ (i_y1 + 4))) <> 0 Then
            SpriteSet(0, i_char, 15 - i_x1, 15 - i_y1 - 4) = 3
          Else
            SpriteSet(0, i_char, 15 - i_x1, 15 - i_y1 - 4) = 2
          End If
        Else
          If (Mem_Map(&H5018& + (i_char * 64) + i_x1) And (2 ^ (i_y1 + 4))) <> 0 Then
            SpriteSet(0, i_char, 15 - i_x1, 15 - i_y1 - 4) = 1
          Else
            SpriteSet(0, i_char, 15 - i_x1, 15 - i_y1 - 4) = 0
          End If
        End If
      Next
    Next
  
  
  
  
    'Top Left 5-8
    For i_x1 = 0 To 7
      For i_y1 = 0 To 3
        If (Mem_Map(&H5020& + (i_char * 64) + i_x1) And (2 ^ i_y1)) <> 0 Then
          If (Mem_Map(&H5020& + (i_char * 64) + i_x1) And (2 ^ (i_y1 + 4))) <> 0 Then
            SpriteSet(0, i_char, 15 - i_x1 - 8, 15 - i_y1) = 3
          Else
            SpriteSet(0, i_char, 15 - i_x1 - 8, 15 - i_y1) = 2
          End If
        Else
          If (Mem_Map(&H5020& + (i_char * 64) + i_x1) And (2 ^ (i_y1 + 4))) <> 0 Then
            SpriteSet(0, i_char, 15 - i_x1 - 8, 15 - i_y1) = 1
          Else
            SpriteSet(0, i_char, 15 - i_x1 - 8, 15 - i_y1) = 0
          End If
        End If
      Next
    Next

    'Top Left 1-4
    For i_x1 = 0 To 7
      For i_y1 = 0 To 3
        If (Mem_Map(&H5028& + (i_char * 64) + i_x1) And (2 ^ i_y1)) <> 0 Then
          If (Mem_Map(&H5028& + (i_char * 64) + i_x1) And (2 ^ (i_y1 + 4))) <> 0 Then
            SpriteSet(0, i_char, 15 - i_x1 - 8, 15 - i_y1 - 12) = 3
          Else
            SpriteSet(0, i_char, 15 - i_x1 - 8, 15 - i_y1 - 12) = 2
          End If
        Else
          If (Mem_Map(&H5028& + (i_char * 64) + i_x1) And (2 ^ (i_y1 + 4))) <> 0 Then
            SpriteSet(0, i_char, 15 - i_x1 - 8, 15 - i_y1 - 12) = 1
          Else
            SpriteSet(0, i_char, 15 - i_x1 - 8, 15 - i_y1 - 12) = 0
          End If
        End If
      Next
    Next

'    'Top Left 5-8
    For i_x1 = 0 To 7
      For i_y1 = 0 To 3
        If (Mem_Map(&H5030& + (i_char * 64) + i_x1) And (2 ^ i_y1)) <> 0 Then
          If (Mem_Map(&H5030& + (i_char * 64) + i_x1) And (2 ^ (i_y1 + 4))) <> 0 Then
            SpriteSet(0, i_char, 15 - i_x1 - 8, 15 - i_y1 - 8) = 3
          Else
            SpriteSet(0, i_char, 15 - i_x1 - 8, 15 - i_y1 - 8) = 2
          End If
        Else
          If (Mem_Map(&H5030& + (i_char * 64) + i_x1) And (2 ^ (i_y1 + 4))) <> 0 Then
            SpriteSet(0, i_char, 15 - i_x1 - 8, 15 - i_y1 - 8) = 1
          Else
            SpriteSet(0, i_char, 15 - i_x1 - 8, 15 - i_y1 - 8) = 0
          End If
        End If
      Next
    Next

    'Bottom Left 1-4
    For i_x1 = 0 To 7
      For i_y1 = 0 To 3
        If (Mem_Map(&H5038& + (i_char * 64) + i_x1) And (2 ^ i_y1)) <> 0 Then
          If (Mem_Map(&H5038& + (i_char * 64) + i_x1) And (2 ^ (i_y1 + 4))) <> 0 Then
            SpriteSet(0, i_char, 15 - i_x1 - 8, 15 - i_y1 - 4) = 3
          Else
            SpriteSet(0, i_char, 15 - i_x1 - 8, 15 - i_y1 - 4) = 2
          End If
        Else
          If (Mem_Map(&H5038& + (i_char * 64) + i_x1) And (2 ^ (i_y1 + 4))) <> 0 Then
            SpriteSet(0, i_char, 15 - i_x1 - 8, 15 - i_y1 - 4) = 1
          Else
            SpriteSet(0, i_char, 15 - i_x1 - 8, 15 - i_y1 - 4) = 0
          End If
        End If
      Next
    Next
  Next

End Sub

Public Static Sub fn_DrawPacmanSpriteSet()
  Dim i_n As Integer
  Dim i_BitX As Integer
  Dim i_BitY As Integer
  Dim i_char As Integer
  For i_n = 0 To 64
    For i_BitX = 0 To 15
      For i_BitY = 0 To 15
        Select Case SpriteSet(0, i_n, i_BitX, i_BitY)
        Case 0:
          VBPac01.p_Screen.PSet (i_x1 + i_BitX, i_y1 + i_BitY), &H0& 'Black
        Case 1:
          VBPac01.p_Screen.PSet (i_x1 + i_BitX, i_y1 + i_BitY), &HFF0000  'Blue
        Case 2:
          VBPac01.p_Screen.PSet (i_x1 + i_BitX, i_y1 + i_BitY), &HFFFFFF  'White
        Case 3:
          VBPac01.p_Screen.PSet (i_x1 + i_BitX, i_y1 + i_BitY), &HFF& 'Red
        End Select
      Next
    Next
    i_x1 = i_x1 + 16
    If i_x1 > 223 Then
      i_x1 = 0
      i_y1 = i_y1 + 16
    End If
  Next

End Sub

Public Static Sub fn_PlotSprites()
  '** Draw Sprites 1 - 6 **
  
  'If SpriteScreen(0) Then
    For i_n = 6 To 1 Step -1
    If SpriteScreen(i_n) Then
      i_SpriteNum = Int(Mem_Map(MEM_RAM + &H4FF0& + (2 * i_n)) / 4) '>> 2
      i_SpriteColour = Mem_Map(MEM_RAM + &H4FF0& + (2 * i_n) + 1) And &H1F&
      i_SpriteFlip = Mem_Map(MEM_RAM + &H4FF0& + (2 * i_n)) And &H3&
    
      i_xPixelPos = 239 - Mem_Map(MEM_RAM + &H5060& + (2 * i_n))
      i_yPixelPos = 272 - Mem_Map(MEM_RAM + &H5060& + (2 * i_n) + 1)
                    
      Select Case i_SpriteFlip
        Case 0:  'No flip
          For i_x1 = 0 To 15
            For i_y1 = 0 To 15
              i_x2 = i_xPixelPos + i_x1
              i_y2 = i_yPixelPos + i_y1
              If (i_x2 < 224) And (i_y2 < 288) And (i_x2 > 0) And (i_y2 > 0) Then
                l_Colour = ColourProm(i_SpriteColour, SpriteSet(0, i_SpriteNum, i_x1, i_y1))
                If (l_Colour <> &H0&) And CurVScrn(i_x2, i_y2) <> l_Colour Then
                  ScrnImage(i_FullScreen).PSet (i_x2, i_y2), l_Colour
                  CurVScrn(i_x2, i_y2) = l_Colour
                End If
              End If
            Next
          Next
        Case 1:  'No flip
          For i_x1 = 0 To 15
            For i_y1 = 0 To 15
              i_x2 = i_xPixelPos + i_x1
              i_y2 = i_yPixelPos + (15 - i_y1)
              If (i_x2 < 224) And (i_y2 < 288) And (i_x2 > 0) And (i_y2 > 0) Then
                l_Colour = ColourProm(i_SpriteColour, SpriteSet(0, i_SpriteNum, i_x1, i_y1))
                If (l_Colour <> &H0&) And CurVScrn(i_x2, i_y2) <> l_Colour Then
                  ScrnImage(i_FullScreen).PSet (i_x2, i_y2), l_Colour
                  CurVScrn(i_x2, i_y2) = l_Colour
                End If
              End If
            Next
          Next
        Case 2:  'No flip
          For i_x1 = 0 To 15
            For i_y1 = 0 To 15
              i_x2 = i_xPixelPos + (15 - i_x1)
              i_y2 = i_yPixelPos + i_y1
              If (i_x2 < 224) And (i_y2 < 288) And (i_x2 > 0) And (i_y2 > 0) Then
                l_Colour = ColourProm(i_SpriteColour, SpriteSet(0, i_SpriteNum, i_x1, i_y1))
                If (l_Colour <> &H0&) And CurVScrn(i_x2, i_y2) <> l_Colour Then
                  ScrnImage(i_FullScreen).PSet (i_x2, i_y2), l_Colour
                  CurVScrn(i_x2, i_y2) = l_Colour
                End If
              End If
            Next
          Next
        Case 3:  'No flip
          For i_x1 = 0 To 15
            For i_y1 = 0 To 15
              i_x2 = i_xPixelPos + (15 - i_x1)
              i_y2 = i_yPixelPos + (15 - i_y1)
              If (i_x2 < 224) And (i_y2 < 288) And (i_x2 > 0) And (i_y2 > 0) Then
                l_Colour = ColourProm(i_SpriteColour, SpriteSet(0, i_SpriteNum, i_x1, i_y1))
                If (l_Colour <> &H0&) And CurVScrn(i_x2, i_y2) <> l_Colour Then
                  ScrnImage(i_FullScreen).PSet (i_x2, i_y2), l_Colour
                  CurVScrn(i_x2, i_y2) = l_Colour
                End If
              End If
            Next
          Next
      End Select
        
      i_xCharPos = Int(i_xPixelPos / 8)
      If (i_xCharPos < 0) Then i_xCharPos = 0
      If (i_xCharPos > 28) Then i_xCharPos = 28
      i_yCharPos = Int(i_yPixelPos / 8)
      If (i_yCharPos < 0) Then i_xCharPos = 0
      If (i_yCharPos > 36) Then i_xCharPos = 36
        
      'Mark Characters beneath sprite as needing redrawn next time
      For i_x1 = 0 To 2
        For i_y1 = 0 To 2
          CharScreen(i_CharXY(i_xCharPos + i_x1, i_yCharPos + i_y1)) = True
        Next
      Next
      SpriteScreen(i_n) = False
    End If
    Next
  'End If
  SpriteScreen(0) = False
End Sub

Public Static Sub fn_CreateNewVScrn()
  If Not (bo_EnableScreenUpdate) Then Exit Sub
  
  For i_x1 = 0 To 1023
    If CharScreen(i_x1) Then
      '** Character has changed, Redraw it **
      l_CharAddr = MEM_RAM + &H4000& + i_x1
      l_ColourAddr = l_CharAddr + &H400&
      b_Char = Mem_Map(l_CharAddr)
      i_x2 = i_CharX(i_x1) * 8 '28 Bytes per line
      i_y2 = i_CharY(i_x1) * 8
      For i_BitX = 0 To 7
        For i_BitY = 0 To 7
          NewVScrn((i_x2 + i_BitX), (i_y2 + i_BitY)) = ColourProm(Mem_Map(l_ColourAddr) And &H1F&, CharSet(0, b_Char, i_BitX, i_BitY))
        Next
      Next
    End If
  Next
End Sub

Public Sub fn_ShowHiScore(i_Ram As Integer, i_Video As Integer, i_Len As Integer)
  Dim l_Score As Long
  Dim s_Score As String
  Dim l_Ram As Long

  l_Ram = MEM_RAM + i_Ram
  l_Score = (Mem_Map(l_Ram) And &HF) + (Int(Mem_Map(l_Ram) / 8) * 10)
  l_Score = l_Score + ((Mem_Map(l_Ram + 1) And &HF) * 100) + (Int(Mem_Map(l_Ram + 1) / 8) * 1000)
  l_Score = l_Score + ((Mem_Map(l_Ram + 2) And &HF) * 10000) + (Int(Mem_Map(l_Ram + 2) / 8) * 100000)
  MsgBox l_Score
  s_Score = Trim(CStr(l_Score))
  s_Score = Space(8 - Len(s_Score)) & s_Score
  For i_n = 1 To 8
    If Mid(s_Score, i_n, 1) <> " " Then
      MsgBox "Writing " & Hex(i_Video - i_n - 1) & " to " & Asc(Mid(s_Score, i_n, 1) - 48)
      fn_WritePacmanHW i_Video - i_n - 1, Asc(Mid(s_Score, i_n, 1)) - 48
    End If
  Next
'   p = &mem_map[MEM_RAM + usRAM];
'   /* Convert BCD to ASCII */
'   i = (p[0] & 0xf) + (p[0] >> 4) * 10 + (p[1] & 0xf) * 100 + (p[1] >> 4) * 1000;
'   i += (p[2] & 0xf) * 10000 + (p[2] >> 4) * 100000;
'   if (iLen == 4)
'      i += (p[3] & 0xf) * 1000000 + (p[3] >> 4) * 10000000;
'   wsprintf(pszTemp, "%8d",i);
'   for (i=0; i<8; i++)
'      if (pszTemp[i] != ' ')
'         PacVideoWrite((unsigned short)(usScreen-i),(char)(pszTemp[i]-48));

'} /* PacShowHiscore() */
'void PacShowHiscore(unsigned short usRAM, unsigned short usScreen, int iLen)
'{
'char *p, pszTemp[16];
'int i;

'   p = &mem_map[MEM_RAM + usRAM];
'   /* Convert BCD to ASCII */
'   i = (p[0] & 0xf) + (p[0] >> 4) * 10 + (p[1] & 0xf) * 100 + (p[1] >> 4) * 1000;
'   i += (p[2] & 0xf) * 10000 + (p[2] >> 4) * 100000;
'   if (iLen == 4)
'      i += (p[3] & 0xf) * 1000000 + (p[3] >> 4) * 10000000;
'   wsprintf(pszTemp, "%8d",i);
'   for (i=0; i<8; i++)
'      if (pszTemp[i] != ' ')
'         PacVideoWrite((unsigned short)(usScreen-i),(char)(pszTemp[i]-48));

'} /* PacShowHiscore() */

End Sub
