Attribute VB_Name = "emu"
Option Explicit

'***************************************************************
'** External Funtion & Constants to Access Windows Help files **
'** No need for the Common Dialog OCX                         **
'***************************************************************
Declare Function WinHelp Lib "User32" Alias "WinHelpA" (ByVal hwnd As Long, ByVal lpHelpFile As String, ByVal wCommand As Long, ByVal dwData As Long) As Long
Global Const HELP_PARTIALKEY = &H105
Global Const HELP_KEY = &H101
Global Const HELP_CONTEXT = &H1
Global Const HELP_CONTENTS = &H3

'*********************************************************************
'** We need to use API timers 'cause VB ones are crap at high speed **
'*********************************************************************
Declare Function QueryPerformanceCounter Lib "Kernel32" (X As Currency) As Boolean
Declare Function QueryPerformanceFrequency Lib "Kernel32" (X As Currency) As Boolean

'*************************
'** Delcalre Structures **
'*************************
Type type_EmuHandlers
  pfn_read As Long
  pfn_write As Long
End Type

Type type_RomInfo
  FileName As String
  Start As Long
  Length As Long
End Type
  
Type type_MemInfo
  Start As Long
  Length As Long
  Type As Byte
End Type

Type type_HiScoreInfo
  Start As Long
  Length As Long
End Type


'*****************
'** Define Keys **
'*****************
Global KEY_ESC As Boolean
Global KEY_4 As Boolean
Global KEY_3 As Boolean
Global KEY_2 As Boolean
Global KEY_1 As Boolean
Global KEY_CTRL As Boolean
Global KEY_UP As Boolean
Global KEY_DOWN As Boolean
Global KEY_LEFT As Boolean
Global KEY_RIGHT As Boolean
Global KEY_T As Boolean

Global SCREEN_WIDTH As Integer
Global SCREEN_HEIGHT As Integer
        
Global RomInfo() As type_RomInfo       'Holds ROM info
Global MemInfo() As type_MemInfo       'Holds hardware memory type info
Global Mem_Map(0 To &H30000) As Byte
Global HiScore() As type_HiScoreInfo   'Allocates block for hi-score saving
Global EmuHandlers As type_EmuHandlers 'Holds memory locations of read/write functions
Global FrameSkip As Integer            'Counts the number of frames that have been skipped
Global l_ClockTicks As Long            'Holds No. of clock cycles to execute

Global DirtyLine(255) As Boolean       'Indicates that line need re-drawing

Global NewVScrn() As Long              'Virtual p_Screen for new p_Screen data
Global CurVScrn() As Long              'Virtual p_Screen for current p_Screen data

Global bo_PauseEmu As Boolean   'Emulation running/paused
Global b_Throttle As Byte       'Trottling disabled/enabled
Global b_SkipFrame As Byte      'Frame skipping off/on
Global b_ScanLines As Byte      'Doubles screen size
Global i_FullScreen As Integer  'Indicates current screen mode
Global bo_Running As Long       'Is Emulation Running?
Global bo_QueryValid As Boolean 'Performance Timers Available
Global cu_QueryFreq As Currency 'Performance Timer Frequency
Global cu_TimeNow As Currency   'Performance Time 1
Global cu_TimeThen As Currency  'Performance Time 2
Global l_Frame As Long
Global bo_EnableScreenUpdate As Boolean
Global bo_HiScoreLoaded As Boolean

Global l_Addr As Long
Global b_Char As Byte
Global b_Byte As Byte
Global l_CharAddr As Long
Global l_ColourAddr As Long

Global i_x1 As Integer
Global i_y1 As Integer
Global i_x2 As Integer
Global i_y2 As Integer
Global i As Integer
Global i_n As Integer
Global i_m As Integer
Global l_n As Long

Global i_BitX As Integer
Global i_BitY As Integer

Global i_SpriteNum As Integer
Global i_SpriteColour As Integer
Global i_SpriteFlip As Integer
Global l_Colour As Long
Global i_xPixelPos As Integer
Global i_yPixelPos As Integer
Global i_xCharPos As Integer
Global i_yCharPos As Integer

Global CharSet() As Integer
Global SpriteSet() As Integer
Global ColourProm() As Long
Global CharScreen() As Boolean
Global SpriteScreen() As Boolean
Global i_CharX() As Integer
Global i_CharY() As Integer
Global i_CharXY() As Integer

Global dip2 As Boolean

'*************************
'** Define memory types **
'*************************
Global Const FLAG_RAM = &H0
Global Const FLAG_ROM = &H1
Global Const FLAG_SPECIAL = &H2

'********************************************
'** Define offsets for emulated ROM/RAM/IO **
'********************************************
Global Const MEM_ROM = &H0        'Offset to first bank (ROM)
Global Const MEM_RAM = &H10000    'Offset to second bank (RAM)
Global Const MEM_FLAGS = &H20000  'Offset to flags in memory map

Global ScrnImage(1) As PictureBox

Global Const cBLACK = &H0&
Global Const cRED = &HFF&
Global Const cWHITE = &HFFFFFF
Global Const cBLUE = &HFF0000
Global Const cPINK = &HC0C0FF
Global Const cCYAN = &HFFFF00
Global Const cORANGE = &H80FF&
Global Const cYELLOW = &HFFFF&
Global Const cBROWN = &H404080
Global Const cBEIGE = &H80C0FF
Global Const cGREEN = &HFF00&
Global Const cLORANG = &H80C0FF
Global Const cDCYAN = &HC0C000
Global Const cGREY = &H404040

Public Static Function fn_LoadEmuRoms()
'********************************************
'** Loads rom sets into pre-defined memory **
'********************************************
Dim RetVal As Long
  '***************************************
  '** Load Combined ROM file if present **
  '***************************************
  If Dir(RomInfo(0).FileName) <> "" Then
    RetVal = fn_LoadRom(RomInfo(0).FileName, RomInfo(0).Start, RomInfo(0).Length)
    fn_LoadEmuRoms = 0
    Exit Function
  End If
  '*************************************
  '** Load Standards ROM files if not **
  '*************************************
  For l_n = 1 To UBound(RomInfo)
    If fn_LoadRom(RomInfo(l_n).FileName, RomInfo(l_n).Start, RomInfo(l_n).Length) Then
      MsgBox "Could not open file '" & RomInfo(0).FileName & "' or '" & RomInfo(l_n).FileName & "'", vbExclamation, "VBPac Error"
      fn_LoadEmuRoms = 1
      Exit Function
    End If
  Next
  fn_LoadEmuRoms = 0
End Function

Public Function fn_LoadRom(s_FileName As String, l_Start As Long, l_Length As Long)
'********************************************************
'** Loads a single ROM into memory with error checking **
'********************************************************
  If Dir(s_FileName) = "" Then
    fn_LoadRom = 1
    Exit Function
  End If
  Open s_FileName For Binary Access Read As #1
    For l_Addr = l_Start To l_Start + l_Length
      Get #1, , Mem_Map(l_Addr)
    Next
  Close #1
  fn_LoadRom = 0
End Function

Public Sub fn_MemSet(l_Start As Long, l_Length As Long, c_Byte As Byte)
  '**********************************************************
  '** Fills the specified memory addresses with given Byte **
  '**********************************************************
  Dim n As Long
  For n = l_Start To l_Start + l_Length
    Mem_Map(n) = c_Byte
  Next
End Sub

Public Sub Main()
  '****************************
  '** Entry point of program **
  '****************************
  '********************************************************
  '** Check if high performance timer is available to OS **
  '********************************************************
  If QueryPerformanceCounter(cu_TimeNow) Then
    QueryPerformanceFrequency cu_QueryFreq
    cu_QueryFreq = cu_QueryFreq / 50 '50Hz
    bo_QueryValid = True
  End If
  fn_LoadDefaults
  Load VBPac01 'Windowed Display
  Load VBPac04 'Full Screen Display
  Set ScrnImage(0) = VBPac01.p_Screen
  Set ScrnImage(1) = VBPac04.p_Screen
  VBPac01.Show 'Show the screen
End Sub

Public Sub fn_PauseEmu()
  '**************************************************
  '** Pauses emulation & displays 'paused' message **
  '**************************************************
  With VBPac01.pic_Paused
    .Left = (VBPac01.p_ScreenBack.Width - VBPac01.pic_Paused.Width) / 2
    .Top = (VBPac01.p_ScreenBack.Height - VBPac01.pic_Paused.Height) / 2
    .Visible = True
  End With
  With VBPac04.pic_Paused
    .Left = ((VBPac04.Width / Screen.TwipsPerPixelX) - VBPac04.pic_Paused.Width) / 2
    .Top = ((VBPac04.Height / Screen.TwipsPerPixelY) - VBPac04.pic_Paused.Height) / 2
    .Visible = True
  End With
  Do While bo_PauseEmu
    DoEvents
  Loop
  With VBPac01.pic_Paused
    .Visible = False
  End With
  With VBPac04.pic_Paused
    .Visible = False
  End With
End Sub

Public Function fn_GetFunctionPointer(l_FuncPtr As Long)
  '**********************************************************
  '** This function returns a pointer to the function      **
  '** passed to it as a AddressOf parameter.               **
  '** This is used to call the memory read/write functions **
  '** from the processor emulation DLL                     **
  '**********************************************************
  fn_GetFunctionPointer = l_FuncPtr
End Function

Public Sub fn_EmuKeyDown(Keycode As Integer, Shift As Integer)
  Select Case Keycode
    Case vbKeyEscape
      KEY_ESC = True
      bo_PauseEmu = False
      For i_n = 0 To VBPac01.mnu_Play.Count - 1
        VBPac01.mnu_Play(i_n).Enabled = True
      Next
      VBPac01.mnu_StopEmulation.Enabled = False
    Case vbKey4: KEY_4 = True
    Case vbKey3: KEY_3 = True
    Case vbKey2: KEY_2 = True
    Case vbKey1: KEY_1 = True
    Case vbKeyControl: KEY_CTRL = True
    Case vbKeyUp: KEY_UP = True
    Case vbKeyDown: KEY_DOWN = True
    Case vbKeyLeft: KEY_LEFT = True
    Case vbKeyRight: KEY_RIGHT = True
    Case vbKeyT: KEY_T = True
    Case vbKeyP: bo_PauseEmu = Not (bo_PauseEmu)
    Case vbKeyF4: If Shift = 0 And bo_Running Then fn_FullScrn
    Case vbKeyReturn: If ScrnImage(i_FullScreen).Visible = False Then fn_PlayGame 0
  End Select
End Sub

Public Sub fn_EmuKeyUp(Keycode As Integer, Shift As Integer)
  Select Case Keycode
    Case vbKey4: KEY_4 = False
    Case vbKey3: KEY_3 = False
    Case vbKey2: KEY_2 = False
    Case vbKey1: KEY_1 = False
    Case vbKeyControl: KEY_CTRL = False
    Case vbKeyUp: KEY_UP = False
    Case vbKeyDown: KEY_DOWN = False
    Case vbKeyLeft: KEY_LEFT = False
    Case vbKeyRight: KEY_RIGHT = False
    Case vbKeyT: KEY_T = False
  End Select
End Sub

Public Sub fn_FullScrn()
  If i_FullScreen Then
    '**********************************
    '** Make windowed display active **
    '**********************************
    i_FullScreen = 0
    fn_SizeScreens
  Else
    '*************************************
    '** Make full screen display active **
    '*************************************
    i_FullScreen = 1
    fn_SizeScreens
  End If
  fn_ReDrawPacmanHW 'Redraw the whole screen
End Sub

Public Sub fn_PlayGame(index As Integer)
  For i_n = 0 To VBPac01.mnu_Play.Count - 1
    VBPac01.mnu_Play(i_n).Enabled = False
  Next
  VBPac01.mnu_StopEmulation.Enabled = True
  Select Case index
    Case 0:
      fn_PlayPacman
    Case 1:
      fn_PlayMsPacman
  End Select

End Sub

Public Sub fn_SizeScreens()
  '*****************************************************
  '** Resize forms & screens to suit scan line option **
  '*****************************************************
  If i_FullScreen Then
    VBPac01.Visible = False
    With VBPac04
      .p_Screen.Cls
      .Visible = True
      DoEvents
      .Left = 0
      .Top = 0
      .Width = Screen.Width * Screen.TwipsPerPixelX
      .Height = Screen.Width * Screen.TwipsPerPixelY
      With ScrnImage(1)
        .Cls
        .Width = SCREEN_WIDTH * (b_ScanLines + 1)
        .Height = SCREEN_HEIGHT * (b_ScanLines + 1)
        .Left = ((Screen.Width / Screen.TwipsPerPixelX) - .Width) / 2
        .Top = ((Screen.Height / Screen.TwipsPerPixelY) - .Height) / 2
        If bo_Running Then .Visible = True
      End With
      .Visible = True
    End With
  Else
    VBPac04.Visible = False
    With VBPac01
      .p_Screen.Cls
      .Visible = True
      DoEvents
      With ScrnImage(0)
        .Cls
        .Width = SCREEN_WIDTH
        .Height = SCREEN_HEIGHT
        If bo_Running Then .Visible = True
      End With
      .Visible = True
    End With
  End If
End Sub

Public Sub fn_SaveDefaults()
  SaveSetting "VBPac", "General", "FrameSkip", b_SkipFrame
  If bo_QueryValid Then
    SaveSetting "VBPac", "General", "Throttle", b_Throttle
  Else
    SaveSetting "VBPac", "General", "Throttle", 0
  End If
  SaveSetting "VBPac", "General", "ScanLines", b_ScanLines
End Sub

Public Sub fn_LoadDefaults()
  b_SkipFrame = GetSetting("VBPac", "General", "FrameSkip", 0)
  If bo_QueryValid Then
    b_Throttle = GetSetting("VBPac", "General", "Throttle", 1)
  Else
    b_Throttle = 0
  End If
  b_ScanLines = GetSetting("VBPac", "General", "ScanLines", 1)
End Sub

Public Sub fn_QueryPerformance()
  If bo_QueryValid Then
    Do
      DoEvents
      QueryPerformanceCounter cu_TimeNow
    Loop While (cu_TimeThen + cu_QueryFreq > cu_TimeNow) Or (cu_TimeNow < cu_TimeThen)
    cu_TimeThen = cu_TimeNow
  End If
End Sub
