Attribute VB_Name = "mspacman"
Option Explicit

Public Static Sub fn_PlayMsPacman()
  '**************************************************
  '** Start to Emulate the Space Invaders hardware **
  '**************************************************
  Dim RetVal As Long
  
  fn_MemSet &H0, &H30000, &H0              'Clear all memory regions
  bo_Running = True                       'Set flag to indication emulation running
  fn_DefineMsPacman                       'Define Hardware, ROMs etc.
  fn_InitMsPacman                         'Setup Hardware
  
  If fn_LoadEmuRoms Then                  'Load the Invaders ROMs into Memory
    VBPac01.p_Screen.Visible = False      'An Error has Occured
    RetVal = WinHelp(0, App.Path + "\VBPac.hlp", HELP_CONTEXT, 20)
    Exit Sub
  End If
  
  fn_DecodePacmanCharSet
  fn_DecodePacmanSprites
  fn_MemSet &H4000&, &H2000&, &H0&

  EmuHandlers.pfn_read = fn_GetFunctionPointer(AddressOf fn_ReadPacmanHW)   'Setup the hardware emulation handlers addresses
  EmuHandlers.pfn_write = fn_GetFunctionPointer(AddressOf fn_WritePacmanHW) 'These allow the DLL to call VB functions fn_read & fn_write
  
  bo_EnableScreenUpdate = False
  bo_HiScoreLoaded = False
  PacInterrupt = 0
  l_IRQs = 0
  l_Frame = 0
  
  RESETZ80 RegsZ80
  
  l_ClockTicks = 3072000 / 60
  QueryPerformanceCounter cu_TimeThen     'Store Current Performance counter value for throttling control

  '***********************************************
  '** This is the main program loop, speed is a **
  '** major concern here so we'll do things as  **
  '** fast as visual basically possible         **
  '***********************************************
  
  Do While Not (KEY_ESC)
    If bo_PauseEmu Then fn_PauseEmu 'Check for pause key
    
    If PacIRQEnable <> 0 Then l_IRQs = l_IRQs Or INT_IRQ ' Cause an irq every vblank
    
    l_Clocks = l_ClockTicks         'Execute z80
    EXECZ80 Mem_Map(0), RegsZ80, EmuHandlers, l_Clocks, l_IRQs, PacInterrupt
    
    'Check for Power Up Test Complettion
    If Not (bo_EnableScreenUpdate) Then
      If Mem_Map(MEM_RAM + &H4040) = &H3C& Then
        bo_EnableScreenUpdate = True
      End If
    End If
        
    If Not (bo_HiScoreLoaded) Then
      If l_Frame = &H130 Then
        'Load the Hi-score table from the Registry
        For i_n = 0 To UBound(HiScore)
          For i_m = HiScore(i_n).Start To HiScore(i_n).Start + (HiScore(i_n).Length - 1)
            RetVal = GetSetting("VBPac", "MsPacmanHiScore", CStr(i_m), 9999)
            If RetVal <> 9999 Then Mem_Map(MEM_RAM + i_m) = RetVal
          Next
        Next
        bo_HiScoreLoaded = True
        fn_ShowHiScore &H4E88&, &H43F4&, 3
      End If
    End If
        
    
    FrameSkip = FrameSkip + 1       'Update the screen image if neccesary
    If FrameSkip > b_SkipFrame Then
      If b_ScanLines And VBPac04.Visible Then
        fn_CreateNewVScrn
        fn_DrawPacmanHWx2
      Else
        fn_CreateNewVScrn
        fn_DrawPacmanHW
      End If
      FrameSkip = 0
    End If
    If Not (b_Throttle) Then DoEvents
    
    If b_Throttle Then fn_QueryPerformance 'Throttle the speed if required
    If l_Frame < &H220 Then l_Frame = l_Frame + 1
  Loop
  
  'Save the hi-score table to the registry
  For i_n = 0 To UBound(HiScore)
    For i_m = HiScore(i_n).Start To HiScore(i_n).Start + (HiScore(i_n).Length - 1)
      SaveSetting "VBPac", "MsPacmanHiScore", CStr(i_m), Mem_Map(MEM_RAM + i_m)
    Next
  Next
  
  bo_Running = False
  For i_n = 0 To 1
    ScrnImage(i_n).Cls
    ScrnImage(i_n).Visible = False
  Next
  fn_ClrScrPacmanHW
  If i_FullScreen Then fn_FullScrn
End Sub

Private Sub fn_InitMsPacman()
  Dim i As Integer
  ReDim NewVScrn(223 + 8, 287 + 8) As Long 'Virtual p_Screen for new p_Screen data
  ReDim CurVScrn(223 + 8, 287 + 8) As Long 'Virtual p_Screen for current p_Screen data
  Dim i_n As Integer 'Set-up the flags area of memory to define the type of hardware memory i.e ROM, RAM, Video, I/O
  For i_n = 1 To UBound(MemInfo)
    fn_MemSet MEM_FLAGS + MemInfo(i_n).Start, MemInfo(i_n).Length, MemInfo(i_n).Type
  Next
  
  fn_SizeScreens 'Resize the Screen to suit selected game
  
  KEY_ESC = False 'Clear out any pressed keys before beginning
  bo_PauseEmu = False
  
  '** Create a lookup table for character positions from addresses
  '** And a lookup table for addresses from character positions
  For i = 0 To 1023
    i_y2 = i Mod 32
    i_x2 = Int(i / 32)
      If i_x2 <= 1 Then
         i_x1 = 29 - i_y2
         i_y1 = i_x2 + 34
      ElseIf i_x2 >= 30 Then
         i_x1 = 29 - i_y2
         i_y1 = i_x2 - 30
      Else
         i_x1 = 29 - i_x2
         i_y1 = i_y2 + 2
      End If
      If i_x1 < 0 Or i_x1 > 27 Then
        i_x1 = 28 'Off Screen
        i_y1 = 36
      End If
      i_CharX(i) = i_x1
      i_CharY(i) = i_y1
      i_CharXY(i_x1, i_y1) = i
    Next
End Sub

Private Sub fn_DefineMsPacman()
  
  ReDim CharScreen(1023) As Boolean
  ReDim SpriteScreen(7) As Boolean
  ReDim i_CharX(1023) As Integer
  ReDim i_CharY(1023) As Integer
  ReDim i_CharXY(27 + 4, 35 + 4) As Integer
  
  ReDim RomInfo(8) 'Define Rom Information
  RomInfo(0).FileName = "mspacman.rom": RomInfo(0).Start = &H0&: RomInfo(0).Length = &HA000&
  RomInfo(1).FileName = "mspacman\boot1": RomInfo(1).Start = &H0&: RomInfo(1).Length = &H1000&
  RomInfo(2).FileName = "mspacman\boot2": RomInfo(2).Start = &H1000&: RomInfo(2).Length = &H1000&
  RomInfo(3).FileName = "mspacman\boot3": RomInfo(3).Start = &H2000&: RomInfo(3).Length = &H1000&
  RomInfo(4).FileName = "mspacman\boot4": RomInfo(4).Start = &H3000&: RomInfo(4).Length = &H1000&
  RomInfo(5).FileName = "mspacman\boot5": RomInfo(5).Start = &H8000&: RomInfo(5).Length = &H1000&
  RomInfo(6).FileName = "mspacman\boot6": RomInfo(6).Start = &H9000&: RomInfo(6).Length = &H1000&
  'Following graphics roms are disposed of after conversion
  RomInfo(7).FileName = "mspacman\5e": RomInfo(7).Start = &H4000&: RomInfo(7).Length = &H1000&
  RomInfo(8).FileName = "mspacman\5f": RomInfo(8).Start = &H5000&: RomInfo(8).Length = &H1000&
  
  ReDim MemInfo(9) 'Define Memory Map Information
  MemInfo(1).Start = &H0&: MemInfo(1).Length = &H4000&: MemInfo(1).Type = FLAG_ROM
  MemInfo(2).Start = &H4000&: MemInfo(2).Length = &H1000&: MemInfo(2).Type = FLAG_SPECIAL 'Video RAM
  MemInfo(3).Start = &H4FF0&: MemInfo(3).Length = &H10&: MemInfo(3).Type = FLAG_SPECIAL  'Video RAM
  MemInfo(4).Start = &H5000&: MemInfo(4).Length = &H40&: MemInfo(4).Type = FLAG_SPECIAL 'I/O Ports
  MemInfo(5).Start = &H5050&: MemInfo(5).Length = &H10&: MemInfo(5).Type = FLAG_SPECIAL 'I/O Ports
  MemInfo(6).Start = &H5060&: MemInfo(6).Length = &H10&: MemInfo(6).Type = FLAG_SPECIAL 'I/O Ports
  MemInfo(7).Start = &H5080&: MemInfo(7).Length = &H3F&: MemInfo(7).Type = FLAG_SPECIAL 'I/O Ports
  MemInfo(8).Start = &HC000&: MemInfo(8).Length = &H800&: MemInfo(8).Type = FLAG_SPECIAL 'I/O Ports
  MemInfo(9).Start = &H8000&: MemInfo(9).Length = &H2000&: MemInfo(9).Type = FLAG_ROM
  
  ReDim ColourProm(31, 3)
  ColourProm(0, 0) = cBLACK:   ColourProm(0, 1) = cBLACK:   ColourProm(0, 2) = cBLACK:   ColourProm(0, 3) = cBLACK
  ColourProm(1, 0) = cBLACK:   ColourProm(1, 1) = cBLUE:    ColourProm(1, 2) = cWHITE:   ColourProm(1, 3) = cRED
  ColourProm(2, 0) = cBLACK:   ColourProm(2, 1) = cBLACK:   ColourProm(2, 2) = cBLACK:   ColourProm(2, 3) = cBLACK
  ColourProm(3, 0) = cBLACK:   ColourProm(3, 1) = cBLUE:    ColourProm(3, 2) = cWHITE:   ColourProm(3, 3) = cPINK
  ColourProm(4, 0) = cBLACK:   ColourProm(4, 1) = cBLACK:   ColourProm(4, 2) = cBLACK:   ColourProm(4, 3) = cBLACK
  ColourProm(5, 0) = cBLACK:   ColourProm(5, 1) = cBLUE:    ColourProm(5, 2) = cWHITE:   ColourProm(5, 3) = cCYAN
  ColourProm(6, 0) = cBLACK:   ColourProm(6, 1) = cBLACK:   ColourProm(6, 2) = cBLACK:   ColourProm(6, 3) = cBLACK
  ColourProm(7, 0) = cBLACK:   ColourProm(7, 1) = cBLUE:    ColourProm(7, 2) = cWHITE:   ColourProm(7, 3) = cORANGE
  ColourProm(8, 0) = cBLACK:   ColourProm(8, 1) = cBLACK:   ColourProm(8, 2) = cBLACK:   ColourProm(8, 3) = cBLACK
  ColourProm(9, 0) = cBLACK:   ColourProm(9, 1) = cRED:     ColourProm(9, 2) = cBLUE:    ColourProm(9, 3) = cYELLOW
  ColourProm(10, 0) = cBLACK:   ColourProm(10, 1) = cBLACK:   ColourProm(10, 2) = cBLACK:   ColourProm(10, 3) = cBLACK
  ColourProm(11, 0) = cBLACK:   ColourProm(11, 1) = cBLACK:   ColourProm(11, 2) = cBLACK:   ColourProm(11, 3) = cBLACK
  ColourProm(12, 0) = cBLACK:   ColourProm(12, 1) = cBLACK:   ColourProm(12, 2) = cBLACK:   ColourProm(12, 3) = cBLACK
  ColourProm(13, 0) = cBLACK:   ColourProm(13, 1) = cBLACK:   ColourProm(13, 2) = cBLACK:   ColourProm(13, 3) = cBLACK
  ColourProm(14, 0) = cBLACK:   ColourProm(14, 1) = cBLACK:   ColourProm(14, 2) = cWHITE:   ColourProm(14, 3) = cLORANG
  'ColourProm(15, 0) = cBLACK:   ColourProm(15, 1) = cWHITE:   ColourProm(15, 2) = cGREEN:   ColourProm(15, 3) = cRED
  ColourProm(15, 0) = cBLACK:   ColourProm(15, 1) = cWHITE:   ColourProm(15, 2) = cGREEN:   ColourProm(15, 3) = cWHITE
  ColourProm(16, 0) = cBLACK:   ColourProm(16, 1) = cBLACK:   ColourProm(16, 2) = cBEIGE:   ColourProm(16, 3) = cBLUE
  ColourProm(17, 0) = cBLACK:   ColourProm(17, 1) = cBLUE:    ColourProm(17, 2) = cGREEN:   ColourProm(17, 3) = cLORANG
  ColourProm(18, 0) = cBLACK:   ColourProm(18, 1) = cWHITE:   ColourProm(18, 2) = cGREEN:   ColourProm(18, 3) = cRED
  ColourProm(19, 0) = cBLACK:   ColourProm(19, 1) = cBLACK:   ColourProm(19, 2) = cBLACK:   ColourProm(19, 3) = cBLACK
  ColourProm(20, 0) = cBLACK:   ColourProm(20, 1) = cBROWN:   ColourProm(20, 2) = cRED:     ColourProm(20, 3) = cWHITE
  ColourProm(21, 0) = cBLACK:   ColourProm(21, 1) = cGREEN:   ColourProm(21, 2) = cBEIGE:   ColourProm(21, 3) = cBROWN
  ColourProm(22, 0) = cBLACK:   ColourProm(22, 1) = cCYAN:    ColourProm(22, 2) = cYELLOW:  ColourProm(22, 3) = cWHITE
  ColourProm(23, 0) = cBLACK:   ColourProm(23, 1) = cGREEN:   ColourProm(23, 2) = cDCYAN:   ColourProm(23, 3) = cWHITE
  ColourProm(24, 0) = cBLACK:   ColourProm(24, 1) = cPINK:    ColourProm(24, 2) = cCYAN:    ColourProm(24, 3) = cYELLOW
  ColourProm(25, 0) = cBLACK:   ColourProm(25, 1) = cBLUE:    ColourProm(25, 2) = cWHITE:   ColourProm(25, 3) = cBLACK
  ColourProm(26, 0) = cBLACK:   ColourProm(26, 1) = cBLACK:   ColourProm(26, 2) = cBEIGE:   ColourProm(26, 3) = cBLUE
  ColourProm(27, 0) = cBLACK:   ColourProm(27, 1) = cBLACK:   ColourProm(27, 2) = cBEIGE:   ColourProm(27, 3) = cBLUE
  ColourProm(28, 0) = cBLACK:   ColourProm(28, 1) = cBLACK:   ColourProm(28, 2) = cBLACK:   ColourProm(28, 3) = cBLACK
  ColourProm(29, 0) = cBLACK:   ColourProm(29, 1) = cBEIGE:   ColourProm(29, 2) = cWHITE:   ColourProm(29, 3) = cRED
  ColourProm(30, 0) = cBLACK:   ColourProm(30, 1) = cBLUE:    ColourProm(30, 2) = cWHITE:   ColourProm(30, 3) = cBEIGE
  ColourProm(31, 0) = cBLACK:   ColourProm(31, 1) = cBLACK:   ColourProm(31, 2) = cBEIGE:   ColourProm(31, 3) = cWHITE
  
  ReDim HiScore(0) 'Define Hi-Score Save Information
  HiScore(0).Start = &H4E88&: HiScore(0).Length = &H4&
  
  SCREEN_WIDTH = 224 'Define Screen Size
  SCREEN_HEIGHT = 288
End Sub


