
#include <vector>
#include <cstdint>
#include "xbrz.h"
#include <ppl.h>

extern "C" void ScaleXBRZ(int factor, const void* src, const void* trg, int srcWidth, int srcHeight)
{
	concurrency::parallel_for(0, srcHeight, 8, [&](const int& i)
	{
		xbrz::scale(factor, (uint32_t*)src, (uint32_t*)trg, srcWidth, srcHeight, xbrz::ColorFormat::ARGB, xbrz::ScalerCfg(), i, i + 8);
	});
}

extern "C" void ScaleNearest(int factor, const void* src, const void* trg, int srcWidth, int srcHeight)
{
	concurrency::parallel_for(0, srcHeight, 8, [&](const int& i)
	{
		xbrz::nearestNeighborScale((uint32_t*)src, srcWidth, srcHeight, srcWidth * 4, (uint32_t*)trg,
			srcWidth * factor, srcHeight * factor, srcWidth * factor * 4, xbrz::SliceType::NN_SCALE_SLICE_SOURCE, i, i + 8);
	});
}