/* small util to view other palette?
 * not sure what this palette is for yet
 * needs RAM dump from Virtua to exist
 */

#include <stdio.h>
#include <allegro.h>

unsigned char ROM[0xc000];

int main()
{
   int r,g,b, x,y, pos, offset;
   FILE *file;

   file = fopen("ram181.bin", "rb");
   fread(&ROM[0], 1, 0xc000, file);
   fclose(file);

   allegro_init();
   set_color_depth(24);
   set_gfx_mode(GFX_AUTODETECT, 320,200,0,0);
   install_keyboard();

   pos = 0;
   while(!key[KEY_ESC])
   {
      vsync();
      for (y=0;y<16;y++)
      {
         for (x=0;x<128;x++)
         {
            offset = pos + y*256 + x;
            r = ROM[offset * 2];
            g = ROM[0x4000 + offset * 2];
            b = ROM[0x8000 + offset * 2];

            rectfill(screen, x*2,y*8, x*2+1, y*8+7, makecol(r,g,b));
         }
         textprintf(screen, font, 270, y*8, makecol(255,255,255), "0x%.3x", pos/256+y);
      }
      if (key[KEY_DOWN]) pos += 256;
      if (key[KEY_UP]) pos -= 256;
      if (pos < 0) pos = 0;
      if (pos > (32-16)*256) pos = (32-16)*256;
   }
   return 0;
}
