/* Intel i960 CPU emulator
 *
 * CPU emulator header file.
 *
 * Copyright (c) 1999 Richard Mitton
 */

#ifndef __I960CPU_H_INCLUDED__
#define __I960CPU_H_INCLUDED__

#ifdef __cplusplus
extern "C" {
#endif

#include "i960sys.h"

enum {
   I_REG, I_MEM, I_COBR, I_CTRL
};

#define O_NONE      0
#define O_SRC1      1
#define O_SRC2      2
#define O_SRCDST    4
#define O_ADDR      8
#define O_KEEPSRC1 16
#define O_KEEPSRC2 32

typedef struct {
   void (*func)(void);
   //void (*asm_start)(void);
   //void (*asm_end)(void);
   char *desc;

   int type;
   int opcode;
   int cycles;
   int fp;
   int block_end;
   int dasm_gap;
   int operands;
} opcode_t;

#define REG_PFP 0x00
#define REG_SP  0x01
#define REG_RIP 0x02
#define REG_FP  0x1f

typedef struct {
   iWORD IP, regs[0x20];
   iFLOAT80 fp[4];
   unsigned int flags;
   iWORD AC, PC, SAT, PRCB, ICR;
   iWORD IAC[16];
} i960_context;

extern opcode_t i960_opcode_table[];

/* Functions */
void   i960_Init(int rom_size);
void   i960_Shutdown(void);
void   i960_Reset(void);
iWORD  i960_GetIP(void);
int    i960_Emulate(int cycles);
void   i960_Interrupt(int pin);
void   i960_SendIAC(iWORD addr, iWORD value);
void   i960_GetContext(i960_context *context);
void   i960_SetContext(i960_context *context);
int    i960_CyclesLeft(void);

#ifdef __I960_DEBUGGER__
int    i960_SingleStep(void);
void   i960_SetBreakPoint(iWORD bp);
iWORD  i960_TraceIP(int trace_num);
#endif

/* Supply these yourself */
iBYTE  i960_ReadMem8(iWORD addr);
iSHORT i960_ReadMem16(iWORD addr);
iWORD  i960_ReadMem32(iWORD addr);
void   i960_WriteMem8(iWORD addr, iBYTE value);
void   i960_WriteMem16(iWORD addr, iSHORT value);
void   i960_WriteMem32(iWORD addr, iWORD value);
void   i960_Message(int fatal, char *msg);

#ifdef __cplusplus
}
#endif

#endif /*__I960CPU_H_INCLUDED__ */
