/* Instruction definitions.
 * Note: All timings are estimates for the average time for that instruction.
 *
 * Instruction format:
 *    name,    type, opcode, cycles,    fp, block_end, dasm_gap, operands
 */
INSTR(ldob,     MEM,     80,      4, FALSE,     FALSE,    FALSE, O_SRCDST|O_ADDR)
INSTR(stob,     MEM,     82,      2, FALSE,     FALSE,    FALSE, O_SRCDST|O_ADDR)
INSTR(bx,       MEM,     84,      3, FALSE,      TRUE,     TRUE, O_ADDR)
INSTR(balx,     MEM,     85,      5, FALSE,      TRUE,     TRUE, O_SRCDST|O_ADDR)
INSTR(callx,    MEM,     86,     14, FALSE,      TRUE,     TRUE, O_ADDR)
INSTR(ldos,     MEM,     88,      4, FALSE,     FALSE,    FALSE, O_SRCDST|O_ADDR)
INSTR(stos,     MEM,     8a,      2, FALSE,     FALSE,    FALSE, O_SRCDST|O_ADDR)
INSTR(lda,      MEM,     8c,      1, FALSE,     FALSE,    FALSE, O_SRCDST|O_ADDR)
INSTR(ld,       MEM,     90,      4, FALSE,     FALSE,    FALSE, O_SRCDST|O_ADDR)
INSTR(st,       MEM,     92,      2, FALSE,     FALSE,    FALSE, O_SRCDST|O_ADDR)
INSTR(ldl,      MEM,     98,      5, FALSE,     FALSE,    FALSE, O_SRCDST|O_ADDR)
INSTR(stl,      MEM,     9a,      3, FALSE,     FALSE,    FALSE, O_SRCDST|O_ADDR)
INSTR(ldt,      MEM,     a0,      6, FALSE,     FALSE,    FALSE, O_SRCDST|O_ADDR)
INSTR(stt,      MEM,     a2,      4, FALSE,     FALSE,    FALSE, O_SRCDST|O_ADDR)
INSTR(ldq,      MEM,     b0,      7, FALSE,     FALSE,    FALSE, O_SRCDST|O_ADDR)
INSTR(stq,      MEM,     b2,      5, FALSE,     FALSE,    FALSE, O_SRCDST|O_ADDR)
INSTR(ldib,     MEM,     c0,      4, FALSE,     FALSE,    FALSE, O_SRCDST|O_ADDR)
INSTR(stib,     MEM,     c2,      2, FALSE,     FALSE,    FALSE, O_SRCDST|O_ADDR)
INSTR(ldis,     MEM,     c8,      4, FALSE,     FALSE,    FALSE, O_SRCDST|O_ADDR)
INSTR(stis,     MEM,     ca,      2, FALSE,     FALSE,    FALSE, O_SRCDST|O_ADDR)

INSTR(notbit,   REG,    580,      2, FALSE,     FALSE,    FALSE, O_SRC1|O_SRC2|O_SRCDST)
INSTR(setbit,   REG,    583,      2, FALSE,     FALSE,    FALSE, O_SRC1|O_SRC2|O_SRCDST)
INSTR(clrbit,   REG,    58c,      2, FALSE,     FALSE,    FALSE, O_SRC1|O_SRC2|O_SRCDST)
INSTR(and,      REG,    581,      1, FALSE,     FALSE,    FALSE, O_SRC1|O_SRC2|O_SRCDST)
INSTR(andnot,   REG,    582,      1, FALSE,     FALSE,    FALSE, O_SRC1|O_SRC2|O_SRCDST)
INSTR(notand,   REG,    584,      1, FALSE,     FALSE,    FALSE, O_SRC1|O_SRC2|O_SRCDST)
INSTR(xor,      REG,    586,      1, FALSE,     FALSE,    FALSE, O_SRC1|O_SRC2|O_SRCDST)
INSTR(or,       REG,    587,      1, FALSE,     FALSE,    FALSE, O_SRC1|O_SRC2|O_SRCDST)
INSTR(ornot,    REG,    58b,      1, FALSE,     FALSE,    FALSE, O_SRC1|O_SRC2|O_SRCDST)
INSTR(alterbit, REG,    58f,      2, FALSE,     FALSE,    FALSE, O_SRC1|O_SRC2|O_SRCDST)
INSTR(not,      REG,    58a,      1, FALSE,     FALSE,    FALSE, O_SRC1|O_SRCDST)
INSTR(addo,     REG,    590,      1, FALSE,     FALSE,    FALSE, O_SRC1|O_SRC2|O_SRCDST)
INSTR(addi,     REG,    591,      1, FALSE,     FALSE,    FALSE, O_SRC1|O_SRC2|O_SRCDST)
INSTR(subo,     REG,    592,      1, FALSE,     FALSE,    FALSE, O_SRC1|O_SRC2|O_SRCDST)
INSTR(subi,     REG,    593,      1, FALSE,     FALSE,    FALSE, O_SRC1|O_SRC2|O_SRCDST)
INSTR(shro,     REG,    598,      1, FALSE,     FALSE,    FALSE, O_SRC1|O_SRC2|O_SRCDST)
INSTR(shrdi,    REG,    59a,      1, FALSE,     FALSE,    FALSE, O_SRC1|O_SRC2|O_SRCDST)
INSTR(shri,     REG,    59b,      1, FALSE,     FALSE,    FALSE, O_SRC1|O_SRC2|O_SRCDST)
INSTR(shlo,     REG,    59c,      1, FALSE,     FALSE,    FALSE, O_SRC1|O_SRC2|O_SRCDST)
INSTR(rotate,   REG,    59d,      1, FALSE,     FALSE,    FALSE, O_SRC1|O_SRC2|O_SRCDST)
INSTR(shli,     REG,    59e,      1, FALSE,     FALSE,    FALSE, O_SRC1|O_SRC2|O_SRCDST)
INSTR(cmpo,     REG,    5a0,      1, FALSE,     FALSE,    FALSE, O_SRC1|O_SRC2)
INSTR(cmpi,     REG,    5a1,      1, FALSE,     FALSE,    FALSE, O_SRC1|O_SRC2)
INSTR(concmpo,  REG,    5a2,      1, FALSE,     FALSE,    FALSE, O_SRC1|O_SRC2)
INSTR(concmpi,  REG,    5a3,      1, FALSE,     FALSE,    FALSE, O_SRC1|O_SRC2)
INSTR(cmpinco,  REG,    5a4,      2, FALSE,     FALSE,    FALSE, O_SRC1|O_SRC2|O_SRCDST)
INSTR(cmpinci,  REG,    5a5,      2, FALSE,     FALSE,    FALSE, O_SRC1|O_SRC2|O_SRCDST)
INSTR(cmpdeco,  REG,    5a6,      2, FALSE,     FALSE,    FALSE, O_SRC1|O_SRC2|O_SRCDST)
INSTR(cmpdeci,  REG,    5a7,      2, FALSE,     FALSE,    FALSE, O_SRC1|O_SRC2|O_SRCDST)
INSTR(chkbit,   REG,    5ae,      2, FALSE,     FALSE,    FALSE, O_SRC1|O_SRC2)
INSTR(addc,     REG,    5b0,      1, FALSE,     FALSE,    FALSE, O_SRC1|O_SRC2|O_SRCDST)
INSTR(subc,     REG,    5b2,      1, FALSE,     FALSE,    FALSE, O_SRC1|O_SRC2|O_SRCDST)
INSTR(mov,      REG,    5cc,      1, FALSE,     FALSE,    FALSE, O_SRC1|O_SRCDST)
INSTR(movl,     REG,    5dc,      2, FALSE,     FALSE,    FALSE, O_SRC1|O_SRCDST|O_KEEPSRC1)
INSTR(movt,     REG,    5ec,      3, FALSE,     FALSE,    FALSE, O_SRC1|O_SRCDST|O_KEEPSRC1)
INSTR(movq,     REG,    5fc,      4, FALSE,     FALSE,    FALSE, O_SRC1|O_SRCDST|O_KEEPSRC1)
INSTR(synmov,   REG,    600,      6, FALSE,     FALSE,     TRUE, O_SRC1|O_SRC2)
INSTR(synmovq,  REG,    602,     12, FALSE,     FALSE,     TRUE, O_SRC1|O_SRC2)
INSTR(spanbit,  REG,    640,     11, FALSE,     FALSE,    FALSE, O_SRC1|O_SRCDST)
INSTR(scanbit,  REG,    641,     11, FALSE,     FALSE,    FALSE, O_SRC1|O_SRCDST)
INSTR(modac,    REG,    645,     10, FALSE,     FALSE,     TRUE, O_SRC1|O_SRC2|O_SRCDST)
INSTR(modpc,    REG,    655,     10, FALSE,     FALSE,     TRUE, O_SRC1|O_SRC2|O_SRCDST)
INSTR(flushreg, REG,    66d,     24, FALSE,     FALSE,     TRUE, O_NONE)
INSTR(ediv,     REG,    671,     40, FALSE,     FALSE,    FALSE, O_SRC1|O_SRC2|O_SRCDST|O_KEEPSRC2)
INSTR(cvtir,    REG,    674,     30, TRUE,      FALSE,    FALSE, O_SRC1|O_SRCDST)
INSTR(atanr,    REG,    680,    267, TRUE,      FALSE,    FALSE, O_SRC1|O_SRC2|O_SRCDST)
INSTR(cmpr,     REG,    685,     10, TRUE,      FALSE,    FALSE, O_SRC1|O_SRC2)
INSTR(sqrtr,    REG,    688,    104, TRUE,      FALSE,    FALSE, O_SRC1|O_SRCDST)
INSTR(logbnr,   REG,    68a,     37, TRUE,      FALSE,    FALSE, O_SRC1|O_SRCDST)
INSTR(cmprl,    REG,    695,     12, TRUE,      FALSE,    FALSE, O_SRC1|O_SRC2)
INSTR(cvtri,    REG,    6c0,     30, TRUE,      FALSE,    FALSE, O_SRC1|O_SRCDST)
INSTR(cvtzri,   REG,    6c2,     43, TRUE,      FALSE,    FALSE, O_SRC1|O_SRCDST)
INSTR(cvtzril,  REG,    6c3,     44, TRUE,      FALSE,    FALSE, O_SRC1|O_SRCDST)
INSTR(movr,     REG,    6c9,     5,  TRUE,      FALSE,    FALSE, O_SRC1|O_SRCDST)
INSTR(movrl,    REG,    6d9,     6,  TRUE,      FALSE,    FALSE, O_SRC1|O_SRCDST)
INSTR(movre,    REG,    6e1,     7,  TRUE,      FALSE,    FALSE, O_SRC1|O_SRCDST)
INSTR(mulo,     REG,    701,     18, FALSE,     FALSE,    FALSE, O_SRC1|O_SRC2|O_SRCDST)
INSTR(remo,     REG,    708,     37, FALSE,     FALSE,    FALSE, O_SRC1|O_SRC2|O_SRCDST)
INSTR(divo,     REG,    70b,     37, FALSE,     FALSE,    FALSE, O_SRC1|O_SRC2|O_SRCDST)
INSTR(muli,     REG,    741,     18, FALSE,     FALSE,    FALSE, O_SRC1|O_SRC2|O_SRCDST)
INSTR(remi,     REG,    748,     37, FALSE,     FALSE,    FALSE, O_SRC1|O_SRC2|O_SRCDST)
INSTR(divi,     REG,    74b,     37, FALSE,     FALSE,    FALSE, O_SRC1|O_SRC2|O_SRCDST)
INSTR(divr,     REG,    78b,     35, TRUE,      FALSE,    FALSE, O_SRC1|O_SRC2|O_SRCDST)
INSTR(mulr,     REG,    78c,     18, TRUE,      FALSE,    FALSE, O_SRC1|O_SRC2|O_SRCDST)
INSTR(subr,     REG,    78d,     10, TRUE,      FALSE,    FALSE, O_SRC1|O_SRC2|O_SRCDST)
INSTR(addr,     REG,    78f,     10, TRUE,      FALSE,    FALSE, O_SRC1|O_SRC2|O_SRCDST)
INSTR(divrl,    REG,    79b,     77, TRUE,      FALSE,    FALSE, O_SRC1|O_SRC2|O_SRCDST)
INSTR(mulrl,    REG,    79c,     36, TRUE,      FALSE,    FALSE, O_SRC1|O_SRC2|O_SRCDST)
INSTR(addrl,    REG,    79f,     13, TRUE,      FALSE,    FALSE, O_SRC1|O_SRC2|O_SRCDST)

INSTR(b,       CTRL,     08,      1, FALSE,      TRUE,    TRUE, O_ADDR)
INSTR(call,    CTRL,     09,     14, FALSE,      TRUE,    TRUE, O_ADDR)
INSTR(ret,     CTRL,     0a,     12, FALSE,      TRUE,    TRUE, O_NONE)
INSTR(bal,     CTRL,     0b,      5, FALSE,      TRUE,    TRUE, O_ADDR)
INSTR(bno,     CTRL,     10,      1, FALSE,     FALSE,    TRUE, O_ADDR)
INSTR(bg,      CTRL,     11,      1, FALSE,     FALSE,    TRUE, O_ADDR)
INSTR(be,      CTRL,     12,      1, FALSE,     FALSE,    TRUE, O_ADDR)
INSTR(bge,     CTRL,     13,      1, FALSE,     FALSE,    TRUE, O_ADDR)
INSTR(bl,      CTRL,     14,      1, FALSE,     FALSE,    TRUE, O_ADDR)
INSTR(bne,     CTRL,     15,      1, FALSE,     FALSE,    TRUE, O_ADDR)
INSTR(ble,     CTRL,     16,      1, FALSE,     FALSE,    TRUE, O_ADDR)

INSTR(testno,  COBR,     20,      3, FALSE,     FALSE,   FALSE, O_SRC1|O_KEEPSRC1)
INSTR(testg,   COBR,     21,      3, FALSE,     FALSE,   FALSE, O_SRC1|O_KEEPSRC1)
INSTR(teste,   COBR,     22,      3, FALSE,     FALSE,   FALSE, O_SRC1|O_KEEPSRC1)
INSTR(testl,   COBR,     24,      3, FALSE,     FALSE,   FALSE, O_SRC1|O_KEEPSRC1)
INSTR(testne,  COBR,     25,      3, FALSE,     FALSE,   FALSE, O_SRC1|O_KEEPSRC1)
INSTR(testle,  COBR,     26,      3, FALSE,     FALSE,   FALSE, O_SRC1|O_KEEPSRC1)
INSTR(bbc,     COBR,     30,      4, FALSE,     FALSE,    TRUE, O_SRC1|O_SRC2|O_ADDR)
INSTR(cmpobg,  COBR,     31,      4, FALSE,     FALSE,    TRUE, O_SRC1|O_SRC2|O_ADDR)
INSTR(cmpobe,  COBR,     32,      4, FALSE,     FALSE,    TRUE, O_SRC1|O_SRC2|O_ADDR)
INSTR(cmpobge, COBR,     33,      4, FALSE,     FALSE,    TRUE, O_SRC1|O_SRC2|O_ADDR)
INSTR(cmpobl,  COBR,     34,      4, FALSE,     FALSE,    TRUE, O_SRC1|O_SRC2|O_ADDR)
INSTR(cmpobne, COBR,     35,      4, FALSE,     FALSE,    TRUE, O_SRC1|O_SRC2|O_ADDR)
INSTR(cmpoble, COBR,     36,      4, FALSE,     FALSE,    TRUE, O_SRC1|O_SRC2|O_ADDR)
INSTR(bbs,     COBR,     37,      4, FALSE,     FALSE,    TRUE, O_SRC1|O_SRC2|O_ADDR)
INSTR(cmpibg,  COBR,     39,      4, FALSE,     FALSE,    TRUE, O_SRC1|O_SRC2|O_ADDR)
INSTR(cmpibe,  COBR,     3a,      4, FALSE,     FALSE,    TRUE, O_SRC1|O_SRC2|O_ADDR)
INSTR(cmpibge, COBR,     3b,      4, FALSE,     FALSE,    TRUE, O_SRC1|O_SRC2|O_ADDR)
INSTR(cmpibl,  COBR,     3c,      4, FALSE,     FALSE,    TRUE, O_SRC1|O_SRC2|O_ADDR)
INSTR(cmpibne, COBR,     3d,      4, FALSE,     FALSE,    TRUE, O_SRC1|O_SRC2|O_ADDR)
INSTR(cmpible, COBR,     3e,      4, FALSE,     FALSE,    TRUE, O_SRC1|O_SRC2|O_ADDR)
