/* Intel i960 CPU emulator
 *
 * Copyright (c) 1999 Richard Mitton
 *
 * Customise this file to your needs.
 */

#ifndef __I960_SYS_H_INCLUDED__
#define __I960_SYS_H_INCLUDED__

/* define this if we should output a message on each call/ret */
//#define __I960_CALL_TRACE__

/* define this for debugging support */
#define __I960_DEBUGGER__

/* use this to set the size of the IP tracing (debug mode only) */
#define I960_IP_TRACE_SIZE 100

/* define this if you want MS-DOS arrows , don't for Unix etc */
#define __I960_FANCY_ARROWS__

/* TRUE and FALSE should be defined, if not already */
#ifndef TRUE
#define TRUE 1
#endif
#ifndef FALSE
#define FALSE 0
#endif

/* NULL should be defined */
#ifndef NULL
#define NULL ((void *)0)
#endif

/* iBYTE should be 8-bit unsigned */
typedef unsigned char iBYTE;

/* iSHORT should be 16-bit unsigned */
typedef unsigned short iSHORT;

/* iWORD should be 32-bit unsigned */
typedef unsigned int iWORD;

/* iDWORD should be 64-bit unsigned */
typedef unsigned long long iDWORD;

/* iBYTEs should be 8-bit signed */
typedef char iBYTEs;

/* iSHORTs should be 16-bit signed */
typedef short iSHORTs;

/* iWORDs should be 32-bit signed */
typedef int iWORDs;

/* iFLOAT32 should be 32-bit IEEE floating-point */
typedef float iFLOAT32;

/* iFLOAT64 should be 64-bit IEEE floating-point */
typedef double iFLOAT64;

/* iFLOAT80 should be 80-bit IEEE floating-point */
typedef long double iFLOAT80;

#endif /* __I960_SYS_H_INCLUDED__ */
