#include "virtua.h"

Registers::Registers(Model2 *emu)
 : Window("Registers", W_CLOSE, 260, 170)
{
   log->Print("Registers: started.");
   SetTitle("Registers");
   this->emu = emu;
}

Registers::~Registers()
{
   log->Print("Registers: ended.");
   emu->registers = NULL;
}

void Registers::Draw(BITMAP *bmp)
{
   int n,h,y;
   char txt[4];
   i960_context context;

   i960_GetContext(&context);
   clear_to_color(bmp, GUI::c_inactive[2]);
   text_mode(-1);
   h = text_height(bios_font);
   y = 1;
   for (n=0;n<16;n++)
   {
      switch(n) {
      case 0: strcpy(txt, "PFP"); break;
      case 1: strcpy(txt, " SP"); break;
      case 2: strcpy(txt, "RIP"); break;
      default: sprintf(txt, "r%.2i", n); break;
      }
      textprintf(bmp, bios_font, 3, y, GUI::c_text, "%s: 0x%.8x", txt, context.regs[n]);
      if (n == 15)
         strcpy(txt, " FP");
      else
         sprintf(txt, "g%.2i", n);
      textprintf(bmp, bios_font, 3+bmp->w/2, y, GUI::c_text, "%s: 0x%.8x", txt, context.regs[n+0x10]);
      y += h;
   }

   hline(bmp, 1, y + h/2, bmp->w - 2, GUI::c_disabled);
   y += h;
   textprintf(bmp, bios_font, 3, y, GUI::c_text, " IP: 0x%.8x", context.IP);
   textprintf(bmp, bios_font, 3+bmp->w/2, y, GUI::c_text, " AC: 0x%.8x", context.AC);
   y += h;
   hline(bmp, 1, y+h/2, bmp->w - 2, GUI::c_disabled);
   y += h;
   textprintf(bmp, bios_font, 3, y, GUI::c_text, "IntEna: 0x%.8x", emu->intena);
   y += h;
   textprintf(bmp, bios_font, 3, y, GUI::c_text, "IntReq: 0x%.8x", emu->intreq);
}


