/* small util to view texture RAM
 * not sure where the palette is yet
 * needs RAM dump from Virtua to exist
 */

#include <stdio.h>
#include <allegro.h>

unsigned short ROM[0x400000];
unsigned short PAL[0x6000];
int palcode;

int Pal(int col)
{
   int r,g,b;
   r = PAL[palcode*256+48+col];
   g = PAL[0x2000+palcode*256+48+col];
   b = PAL[0x4000+palcode*256+48+col];
   return makecol(r, g, b);
}

void Draw(int x, int y, unsigned short c)
{
   _putpixel24(screen, x,   y,   Pal((c >> 12) & 0x0f));
   _putpixel24(screen, x+1, y,   Pal((c >> 8) & 0x0f));
   _putpixel24(screen, x,   y+1, Pal((c >> 4) & 0x0f));
   _putpixel24(screen, x+1, y+1, Pal(c & 0x0f));
}

int main()
{
   FILE *f;
   unsigned short c, c2;
   int x,y, offset,width,pos;

   allegro_init();
   install_keyboard();
   set_color_depth(24);
   set_gfx_mode(GFX_AUTODETECT, 640,480, 0,0);
   f = fopen("ram1200.bin", "rb");
   fread(&ROM[0], 1, 0x800000, f);
   fclose(f);
   f = fopen("ram181.bin", "rb");
   fread(&PAL[0], 1, 0xc000, f);
   fclose(f);

   offset = 0;
   width = 2048;
   palcode = 0;
   while(!key[KEY_ESC])
   {
      //vsync();
      for (y=0;y<SCREEN_H/2;y++)
      {
         for (x=0;x<SCREEN_W/2;x++)
         {
            pos = offset + y*width+x*2;
            if (pos < 0x100000) c = ROM[pos];
            else c = 0;
            Draw(x*2, y*2, c);
         }
      }
      textprintf(screen, font, 0, SCREEN_H-8, makecol(255,255,255),
                 "palcode=%i ", palcode);
      if (key[KEY_LEFT]) offset -= 2;
      if (key[KEY_RIGHT]) offset += 2;
      if (key[KEY_UP]) offset -= width;
      if (key[KEY_DOWN]) offset += width;
      if (key[KEY_PGUP]) palcode--;
      if (key[KEY_PGDN]) palcode++;
   }
   return 0;
}
