/* small util to view graphics RAM contents
 * needs RAM dump from Virtua to exist
 */

#include <stdio.h>
#include <allegro.h>

void Draw(int x, int y, unsigned short c, unsigned short c2)
{
   int col;
   col = c ^ c2;
   //rectfill(screen, x*8, y*8, x*8+7,y*8+7, c);
   textprintf(screen, font, x*8, y*8, makecol(255,255,255), "%c", c&255);
}

unsigned short ROM[32768];

int main()
{
   FILE *f;
   unsigned short c, c2;
   int x,y, offset;

   allegro_init();
   install_keyboard();
   set_gfx_mode(GFX_AUTODETECT, 640,480, 0,0);
   f = fopen("ram100.bin", "rb");
   fread(&ROM[0], 1, 65536, f);
   fclose(f);

   offset = 0;
   while(!key[KEY_ESC])
   {
      vsync();
      for (y=0;y<48;y++)
      {
         for (x=0;x<64;x++)
         {
            c = ROM[offset + y*64+x];
            c2 = ROM[offset + 0x2000 + y*64+x];
            Draw(x, y, c, c2);
         }
      }
      if (key[KEY_DOWN]) offset += 64;
      if (key[KEY_UP]) offset -= 64;
   }
   return 0;
}
