/*
 * bitmap.cc - BitmapWindow class
 */

#include "gui.h"

BitmapWindow::BitmapWindow(char *section, int flags, int w, int h)
 : Window(section, flags, w, h)
{
   log->Print("BitmapWindow: created %s, %ix%i.", section, w, h);
   image = NULL;
}

BitmapWindow::~BitmapWindow()
{
   log->Print("BitmapWindow: destroyed %s.", section);
}

void BitmapWindow::Draw(BITMAP *bmp)
{
   int x, y, c;
   if (image)
   {
      blit(image, bmp, 0,0,0,0, image->w, image->h);
   } else {
      for (y=0;y<bmp->h;y++)
      {
         for (x=0;x<bmp->w;x++)
         {
            c = rand() & 255;
            putpixel(bmp, x, y, makecol(c, c, c));
         }
      }
      RequestRedraw();
   }
}
